/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.binding.UsedTypeBinding;
import org.eclipse.edt.compiler.core.ast.CallStatement;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.ExitStatement;
import org.eclipse.edt.compiler.core.ast.ExternalType;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Interface;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.Service;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.ShowStatement;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.core.ast.TransferStatement;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion.EGLAbstractReferenceCompletion;
import org.eclipse.jface.text.ITextViewer;

public abstract class EGLAbstractPropertyReferenceCompletion
extends EGLAbstractReferenceCompletion {
    protected ITextViewer viewer;
    protected int documentOffset;
    protected int partLocation;
    protected ITypeBinding newTypeBinding;
    protected List settingsBlockList;

    protected int getLocation() {
        return this.getLocation(new EGLAbstractReferenceCompletion.IBoundNodeProcessor(){

            @Override
            public void processBoundNode(Node node) {
            }
        });
    }

    protected int getLocation(final EGLAbstractReferenceCompletion.IBoundNodeProcessor additionalProcessor) {
        this.settingsBlockList = new ArrayList();
        final int[] result = new int[]{-1};
        this.getBoundASTNode(this.viewer, this.documentOffset, new String[]{"", "a};", "a", "}};"}, new EGLAbstractReferenceCompletion.CompletedNodeVerifier(){

            @Override
            public boolean nodeIsValid(Node astNode) {
                boolean result = false;
                while (astNode != null && !result) {
                    if (astNode instanceof SettingsBlock) {
                        result = true;
                    }
                    astNode = astNode.getParent();
                }
                return result;
            }
        }, new EGLAbstractReferenceCompletion.IBoundNodeProcessor(){

            @Override
            public void processBoundNode(Node boundNode) {
                if (boundNode instanceof Name && boundNode.getParent() instanceof SetValuesExpression) {
                    boundNode = boundNode.getParent().getParent();
                }
                while (boundNode != null) {
                    boundNode.accept((IASTVisitor)new DefaultASTVisitor(){

                        public void endVisit(TopLevelFunction function) {
                            result[0] = 10;
                            EGLAbstractPropertyReferenceCompletion.this.addAllSettingsBlocks(function.getContents(), (this).EGLAbstractPropertyReferenceCompletion.this.settingsBlockList);
                        }

                        public void endVisit(Library library) {
                            this.setNewTypeBindingFromPart((Part)library);
                            result[0] = library.getName().resolveBinding().getAnnotation(EGLCORE, "NativeLibrary") != null ? 29 : 12;
                            EGLAbstractPropertyReferenceCompletion.this.addAllSettingsBlocks(library.getContents(), (this).EGLAbstractPropertyReferenceCompletion.this.settingsBlockList);
                        }

                        public void endVisit(Handler handler) {
                            result[0] = 121;
                            EGLAbstractPropertyReferenceCompletion.this.addAllSettingsBlocks(handler.getContents(), (this).EGLAbstractPropertyReferenceCompletion.this.settingsBlockList);
                            this.setNewTypeBindingFromPart((Part)handler);
                        }

                        public void endVisit(Program program) {
                            result[0] = EGLAbstractPropertyReferenceCompletion.this.getProgramLocation(program);
                            EGLAbstractPropertyReferenceCompletion.this.addAllSettingsBlocks(program.getContents(), (this).EGLAbstractPropertyReferenceCompletion.this.settingsBlockList);
                        }

                        public void endVisit(Record record) {
                            result[0] = EGLAbstractPropertyReferenceCompletion.this.getRecordLocation(record);
                            EGLAbstractPropertyReferenceCompletion.this.addAllSettingsBlocks(record.getContents(), (this).EGLAbstractPropertyReferenceCompletion.this.settingsBlockList);
                        }

                        public void endVisit(Service service) {
                            result[0] = 98;
                            EGLAbstractPropertyReferenceCompletion.this.addAllSettingsBlocks(service.getContents(), (this).EGLAbstractPropertyReferenceCompletion.this.settingsBlockList);
                            this.setNewTypeBindingFromPart((Part)service);
                        }

                        public void endVisit(Interface iFace) {
                            result[0] = 101;
                            EGLAbstractPropertyReferenceCompletion.this.addAllSettingsBlocks(iFace.getContents(), (this).EGLAbstractPropertyReferenceCompletion.this.settingsBlockList);
                            this.setNewTypeBindingFromPart((Part)iFace);
                        }

                        public void endVisit(NestedFunction func) {
                            result[0] = EGLAbstractPropertyReferenceCompletion.this.getNestedFunctionLocation(func);
                            EGLAbstractPropertyReferenceCompletion.this.addAllSettingsBlocks(func.getStmts(), (this).EGLAbstractPropertyReferenceCompletion.this.settingsBlockList);
                        }

                        public void endVisit(StructureItem structureItem) {
                            result[0] = structureItem.isFiller() ? EGLAbstractPropertyReferenceCompletion.this.getFillerStructureItemLocation((IDataBinding)structureItem.resolveBinding()) : EGLAbstractPropertyReferenceCompletion.this.getStructureItemLocation((IDataBinding)structureItem.resolveBinding());
                            (this).EGLAbstractPropertyReferenceCompletion.this.settingsBlockList.add(structureItem.getSettingsBlock());
                            Type type = structureItem.getType();
                            if (type != null) {
                                (this).EGLAbstractPropertyReferenceCompletion.this.newTypeBinding = type.resolveTypeBinding();
                            }
                        }

                        public void endVisit(ClassDataDeclaration classDataDeclaration) {
                            result[0] = EGLAbstractPropertyReferenceCompletion.this.getVariableLocation(((Name)classDataDeclaration.getNames().get(0)).resolveDataBinding());
                            (this).EGLAbstractPropertyReferenceCompletion.this.settingsBlockList.add(classDataDeclaration.getSettingsBlockOpt());
                        }

                        public void endVisit(SetValuesExpression setValuesExpression) {
                            result[0] = 0;
                            (this).EGLAbstractPropertyReferenceCompletion.this.newTypeBinding = setValuesExpression.resolveTypeBinding();
                            (this).EGLAbstractPropertyReferenceCompletion.this.settingsBlockList.add(setValuesExpression.getSettingsBlock());
                        }

                        public void endVisit(FunctionDataDeclaration dataDeclaration) {
                            result[0] = EGLAbstractPropertyReferenceCompletion.this.getVariableLocation(((Name)dataDeclaration.getNames().get(0)).resolveDataBinding());
                            (this).EGLAbstractPropertyReferenceCompletion.this.settingsBlockList.add(dataDeclaration.getSettingsBlockOpt());
                        }

                        public void endVisit(CallStatement stmt) {
                            result[0] = 128;
                            (this).EGLAbstractPropertyReferenceCompletion.this.settingsBlockList.add(stmt.getSettingsBlock());
                        }

                        public void endVisit(ExitStatement stmt) {
                            result[0] = 141;
                            (this).EGLAbstractPropertyReferenceCompletion.this.settingsBlockList.add(stmt.getSettingsBlock());
                        }

                        public void endVisit(TransferStatement stmt) {
                            result[0] = 129;
                            (this).EGLAbstractPropertyReferenceCompletion.this.settingsBlockList.add(stmt.getSettingsBlock());
                        }

                        public void endVisit(ShowStatement stmt) {
                            result[0] = 130;
                            (this).EGLAbstractPropertyReferenceCompletion.this.settingsBlockList.add(stmt.getSettingsBlock());
                        }

                        public void endVisit(UseStatement useStatement) {
                            result[0] = EGLAbstractPropertyReferenceCompletion.this.getUseStatementLocation(useStatement);
                            (this).EGLAbstractPropertyReferenceCompletion.this.settingsBlockList.add(useStatement.getSettingsBlock());
                        }

                        public void endVisit(NewExpression newExpression) {
                            result[0] = 123;
                            (this).EGLAbstractPropertyReferenceCompletion.this.settingsBlockList.add(newExpression.getSettingsBlock());
                        }

                        public void endVisit(ExternalType externalType) {
                            result[0] = EGLAbstractPropertyReferenceCompletion.this.getExternalTypeLocation(externalType);
                            EGLAbstractPropertyReferenceCompletion.this.addAllSettingsBlocks(externalType.getContents(), (this).EGLAbstractPropertyReferenceCompletion.this.settingsBlockList);
                        }

                        private void setNewTypeBindingFromPart(Part part) {
                            (this).EGLAbstractPropertyReferenceCompletion.this.newTypeBinding = (ITypeBinding)part.getName().resolveBinding();
                        }
                    });
                    if (result[0] != -1) {
                        EGLAbstractPropertyReferenceCompletion.this.partLocation = result[0];
                        additionalProcessor.processBoundNode(boundNode);
                        return;
                    }
                    boundNode = boundNode.getParent();
                }
                if (result[0] != -1) {
                    EGLAbstractPropertyReferenceCompletion.this.partLocation = result[0];
                    additionalProcessor.processBoundNode(boundNode);
                }
            }
        });
        if (result[0] != -1) {
            return result[0];
        }
        return 0;
    }

    private void addAllSettingsBlocks(List nodes, final List settingsBlockList) {
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            ((Node)iter.next()).accept((IASTVisitor)new DefaultASTVisitor(){

                public boolean visit(SettingsBlock settingsBlock) {
                    settingsBlockList.add(settingsBlock);
                    return false;
                }
            });
        }
    }

    private int getNestedFunctionLocation(NestedFunction func) {
        final int[] result = new int[1];
        func.getParent().accept((IASTVisitor)new DefaultASTVisitor(){

            public void endVisit(Library library) {
                boolean isNative;
                boolean bl = isNative = library.getName().resolveBinding().getAnnotation(EGLCORE, "NativeLibrary") != null;
                if (isNative) {
                    result[0] = 30;
                }
            }

            public void endVisit(Service service) {
                result[0] = 100;
            }

            public void endVisit(Interface interfaceNode) {
                result[0] = 104;
            }

            public void endVisit(ExternalType externalType) {
                result[0] = 126;
            }
        });
        return result[0];
    }

    private int getProgramLocation(Program program) {
        this.newTypeBinding = (ITypeBinding)program.getName().resolveBinding();
        if (program.isCallable()) {
            return 26;
        }
        return 25;
    }

    private int getRecordLocation(Record record) {
        this.newTypeBinding = (ITypeBinding)record.getName().resolveBinding();
        if (this.newTypeBinding.getAnnotation(EGLIOFILE, "IndexedRecord") != null) {
            return 42;
        }
        if (this.newTypeBinding.getAnnotation(EGLIOFILE, "RelativeRecord") != null) {
            return 43;
        }
        if (this.newTypeBinding.getAnnotation(EGLIOFILE, "SerialRecord") != null) {
            return 44;
        }
        if (this.newTypeBinding.getAnnotation(EGLIOSQL, "SQLRecord") != null) {
            return 46;
        }
        if (this.newTypeBinding.getAnnotation(EGLIOFILE, "CSVRecord") != null) {
            return 48;
        }
        return 41;
    }

    private int getStructureItemLocation(IDataBinding structureItemBinding) {
        ITypeBinding enclosingType = this.getEnclosingType(structureItemBinding);
        if (enclosingType != null && enclosingType.getAnnotation(EGLIOSQL, "SQLRecord") != null) {
            return 69;
        }
        return 40;
    }

    private int getExternalTypeLocation(ExternalType externalType) {
        IBinding binding = externalType.getName().resolveBinding();
        if (binding.getAnnotation(EGLIDLJAVA, "JavaObject") != null) {
            return 102;
        }
        if (binding.getAnnotation(EGLJAVASCRIPT, "JavaScriptObject") != null) {
            return 139;
        }
        if (binding.getAnnotation(EGLPLATFORM, "HostProgram") != null) {
            return 140;
        }
        return 0;
    }

    private int getFillerStructureItemLocation(IDataBinding structureItemBinding) {
        return 50;
    }

    private ITypeBinding getEnclosingType(IDataBinding dBinding) {
        return 5 == dBinding.getKind() ? ((StructureItemBinding)dBinding).getEnclosingStructureBinding() : dBinding.getDeclaringPart();
    }

    private int getUseStatementLocation(UseStatement useStatement) {
        if (useStatement.getNames().size() == 1) {
            UsedTypeBinding uBinding = useStatement.getUsedTypeBinding();
            switch (uBinding.getType().getKind()) {
                case 9: {
                    return 14;
                }
                case 5: {
                    return 15;
                }
                case 8: {
                    return 16;
                }
                case 11: {
                    return 17;
                }
            }
        } else {
            return 0;
        }
        return 13;
    }

    private int getVariableLocation(IDataBinding dataBinding) {
        if (dataBinding != null && IBinding.NOT_FOUND_BINDING != dataBinding) {
            this.newTypeBinding = dataBinding.getType();
            if (this.newTypeBinding != null && IBinding.NOT_FOUND_BINDING != this.newTypeBinding) {
                switch (this.newTypeBinding.getKind()) {
                    case 6: 
                    case 7: {
                        return this.getRecordtypeStaticLocation(this.newTypeBinding);
                    }
                    case 14: {
                        return 99;
                    }
                    case 15: {
                        return 103;
                    }
                    case 2: {
                        return this.getStaticDynamicVariableLocation(dataBinding, this.newTypeBinding);
                    }
                    case 21: {
                        return 77;
                    }
                    case 28: {
                        return 123;
                    }
                    case 3: {
                        if (dataBinding.getDeclaringPart().getKind() == 14) {
                            return 122;
                        }
                        if (dataBinding.getDeclaringPart().getKind() == 28) {
                            return 124;
                        }
                        return 18;
                    }
                }
            }
        }
        return 0;
    }

    private int getStaticDynamicVariableLocation(IDataBinding dBinding, ITypeBinding typeBinding) {
        ITypeBinding elementType = ((ArrayTypeBinding)typeBinding).getElementType();
        switch (elementType.getBaseType().getKind()) {
            case 3: {
                return 19;
            }
            case 6: 
            case 7: {
                return this.getRecordtypeDynamicLocation(elementType);
            }
            case 10: {
                return 125;
            }
        }
        return 0;
    }

    private int getRecordtypeDynamicLocation(ITypeBinding recordType) {
        if (recordType != null) {
            if (recordType.getAnnotation(EGLIOFILE, "IndexedRecord") != null) {
                return 62;
            }
            if (recordType.getAnnotation(EGLIOFILE, "RelativeRecord") != null) {
                return 63;
            }
            if (recordType.getAnnotation(EGLIOFILE, "SerialRecord") != null) {
                return 64;
            }
            if (recordType.getAnnotation(EGLIOSQL, "SQLRecord") != null) {
                return 66;
            }
            return 61;
        }
        return 49;
    }

    private int getRecordtypeStaticLocation(ITypeBinding recordType) {
        if (recordType != null) {
            if (recordType.getAnnotation(EGLIOFILE, "IndexedRecord") != null) {
                return 52;
            }
            if (recordType.getAnnotation(EGLIOFILE, "RelativeRecord") != null) {
                return 53;
            }
            if (recordType.getAnnotation(EGLIOFILE, "SerialRecord") != null) {
                return 54;
            }
            if (recordType.getAnnotation(EGLIOSQL, "SQLRecord") != null) {
                return 56;
            }
            return 51;
        }
        return 49;
    }

    public void setViewer(ITextViewer viewer) {
        this.viewer = viewer;
    }

    public void setDocumentOffset(int documentOffset) {
        this.documentOffset = documentOffset;
    }
}

