/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.record.conversion.sqldb;

import java.util.Locale;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.edt.compiler.core.EGLKeywordHandler;
import org.eclipse.edt.compiler.internal.sql.StringToken;
import org.eclipse.edt.gen.generator.eglsource.EglSourceContext;
import org.eclipse.edt.ide.internal.sql.util.EGLSQLRetrieveUtility;
import org.eclipse.edt.ide.internal.sql.util.EGLSQLStructureItem;
import org.eclipse.edt.ide.ui.internal.record.conversion.IMessageHandler;
import org.eclipse.edt.ide.ui.internal.record.conversion.sqldb.DataToolsSqlTemplate;
import org.eclipse.edt.ide.ui.internal.util.CoreUtility;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;

public class DataToolsSqlColumnTemplate
extends DataToolsSqlTemplate {
    private static String[] unsupportedColumnType = new String[]{"blob", "clob", "graphic", "time", "vargraphic"};

    public void genColumn(Column column, EglSourceContext ctx, TabbedWriter out) {
        IMessageHandler messageHandler = (IMessageHandler)ctx.get((Object)"dbMessageHandler");
        if (column.getContainedType() == null) {
            messageHandler.addMessage("Cannot get valid message from column metadata.");
        } else if (this.isUnsupportedColumnTpe(column.getContainedType().getName())) {
            StringBuilder builder = new StringBuilder();
            builder.append("Column Type: ");
            builder.append(column.getContainedType().getName());
            builder.append(" for ");
            builder.append(column.getTable().getSchema().getName());
            builder.append(".");
            builder.append(column.getTable().getName());
            builder.append(".");
            builder.append(column.getName());
            builder.append(" is not supported yet and will be skipped for its generation");
            messageHandler.addMessage(builder.toString());
        } else {
            boolean isPartOfPK;
            EGLSQLStructureItem item = new EGLSQLStructureItem();
            String colNameAlias = null;
            DatabaseDefinition def = (DatabaseDefinition)ctx.get((Object)"dataDefinition");
            EGLSQLRetrieveUtility.getInstance().populateStructureItem(def, column, item);
            StringBuilder builder = new StringBuilder();
            builder.append("    ");
            colNameAlias = this.getAliasName(item.getName().trim(), ctx);
            if (colNameAlias != null) {
                builder.append(StringToken.trim((String)colNameAlias));
            } else {
                builder.append(StringToken.trim((String)item.getName()));
            }
            builder.append(" ");
            builder.append(item.getPrimitiveType());
            if (item.getPrimitiveType().equals("char") || item.getPrimitiveType().equals("mbChar") || item.getPrimitiveType().equals("unicode") || item.getPrimitiveType().equals("limited string")) {
                builder.append("(");
                builder.append(item.getLength());
                builder.append(")");
            } else if (item.getPrimitiveType().equals("decimal")) {
                builder.append("(");
                builder.append(item.getLength());
                if (item.getDecimals() != null) {
                    builder.append(",");
                    builder.append(item.getDecimals());
                }
                builder.append(")");
            }
            if (item.isNullable()) {
                builder.append("?");
            }
            if (isPartOfPK = column.isPartOfPrimaryKey()) {
                builder.append("{");
            }
            if (column.isPartOfPrimaryKey()) {
                builder.append(" @id ");
            }
            if (colNameAlias != null) {
                if (column.isPartOfPrimaryKey()) {
                    builder.append(", ");
                    builder.append("@column{ name =");
                } else {
                    builder.append("{@column{ name =");
                }
                builder.append("\"");
                builder.append(StringToken.trim((String)item.getColumnName()));
                builder.append("\"");
                if (column.isPartOfPrimaryKey()) {
                    builder.append("}");
                } else {
                    builder.append("}");
                    builder.append("}");
                }
            }
            if (isPartOfPK) {
                builder.append("}");
            }
            builder.append(";");
            out.println(builder.toString());
        }
    }

    private String getAliasName(String itemName, EglSourceContext ctx) {
        String alias = null;
        alias = EGLKeywordHandler.getKeywordHashSet().contains(itemName.toLowerCase(Locale.ENGLISH)) ? String.valueOf(itemName) + ctx.nextTempIndex() : CoreUtility.getCamelCaseString(itemName);
        return alias;
    }

    private boolean isUnsupportedColumnTpe(String columnTypeName) {
        boolean isUnSupported = false;
        String[] stringArray = unsupportedColumnType;
        int n = unsupportedColumnType.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (type.equals(columnTypeName.toLowerCase())) {
                isUnSupported = true;
                break;
            }
            ++n2;
        }
        return isUnSupported;
    }
}

