/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.deployment.ui.SOAMessages;
import org.eclipse.edt.ide.ui.internal.wizards.EGLDDBindingWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPartWizard;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.edt.ide.ui.wizards.BindingBaseConfiguration;
import org.eclipse.edt.ide.ui.wizards.BindingRestConfiguration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class RestBindingWizardPage
extends EGLDDBindingWizardPage {
    public static final String WIZPAGENAME_RestBindingWizardPage = "WIZPAGENAME_RestBindingWizardPage";
    private StringDialogField fBaseUriField;
    private StringDialogField fSessionCookieId;

    public RestBindingWizardPage(String pageName) {
        super(pageName);
        this.setTitle(NewWizardMessages.TitleAddRestBinding);
        this.setDescription(NewWizardMessages.DescAddRestBinding);
        this.nColumns = 4;
    }

    @Override
    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IUIHelpConstants.MODULE_RESTBINDING);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = this.nColumns;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createComponentNameControl(composite, NewWizardMessages.LabelRestBindingName, this.getEGLDDBindingConfiguration().getBindingRestConfiguration());
        this.createBaseUriControl(composite);
        this.createSessionCookieId(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)parent);
        this.determinePageCompletion();
    }

    private BindingRestConfiguration getConfiguration() {
        return (BindingRestConfiguration)((EGLPartWizard)this.getWizard()).getConfiguration(this.getName());
    }

    protected BindingRestConfiguration getBindingRestConfiguration() {
        return (BindingRestConfiguration)((EGLPartWizard)this.getWizard()).getConfiguration(WIZPAGENAME_RestBindingWizardPage);
    }

    private void createBaseUriControl(Composite composite) {
        Label spacer = new Label(composite, 64);
        GridData gd = new GridData(768);
        gd.horizontalSpan = this.nColumns;
        spacer.setLayoutData((Object)gd);
        Label desc = new Label(composite, 64);
        desc.setText(SOAMessages.BaseURIDesc);
        gd = new GridData(768);
        gd.horizontalSpan = this.nColumns;
        gd.widthHint = 550;
        desc.setLayoutData((Object)gd);
        spacer = new Label(composite, 64);
        gd = new GridData(768);
        gd.horizontalSpan = this.nColumns;
        spacer.setLayoutData((Object)gd);
        this.fBaseUriField = new StringDialogField();
        this.fBaseUriField.setLabelText(NewWizardMessages.LabelRestBaseURI);
        this.fBaseUriField.setText(this.getConfiguration().getBaseUri());
        this.createStringDialogField(composite, this.fBaseUriField, new IDialogFieldListener(){

            @Override
            public void dialogFieldChanged(DialogField field) {
                if (field == RestBindingWizardPage.this.fBaseUriField) {
                    RestBindingWizardPage.this.HandleBaseUriFieldChanged();
                }
            }
        });
        new Label(composite, 64).setText(SOAMessages.ExampleDeployedURI);
        Text example = new Text(composite, 72);
        example.setText("http://myhostname:8080/myTargetWebProject/restservices/myService");
        example.setBackground(composite.getBackground());
        gd = new GridData(768);
        gd.horizontalSpan = this.nColumns - 1;
        example.setLayoutData((Object)gd);
        new Label(composite, 64).setText(SOAMessages.ExampleWorkspaceURI);
        example = new Text(composite, 72);
        example.setText("workspace://myServiceProject/myPackage.myService");
        example.setBackground(composite.getBackground());
        gd = new GridData(768);
        gd.horizontalSpan = this.nColumns - 1;
        example.setLayoutData((Object)gd);
    }

    protected void HandleBaseUriFieldChanged() {
        this.getConfiguration().setBaseUri(this.fBaseUriField.getText());
        this.determinePageCompletion();
    }

    private void createSessionCookieId(Composite composite) {
        Label spacer = new Label(composite, 64);
        GridData gd = new GridData(768);
        gd.horizontalSpan = this.nColumns;
        spacer.setLayoutData((Object)gd);
        this.fSessionCookieId = new StringDialogField();
        this.fSessionCookieId.setLabelText(NewWizardMessages.LabelSessionCookieId);
        this.fSessionCookieId.setText(this.getConfiguration().getSessionCookieId());
        this.createStringDialogField(composite, this.fSessionCookieId, new IDialogFieldListener(){

            @Override
            public void dialogFieldChanged(DialogField field) {
                if (field == RestBindingWizardPage.this.fSessionCookieId) {
                    RestBindingWizardPage.this.HandleSessionCookieIdChanged();
                }
            }
        });
    }

    protected void HandleSessionCookieIdChanged() {
        this.getConfiguration().setSessionCookieId(this.fSessionCookieId.getText());
        this.determinePageCompletion();
    }

    @Override
    protected void createComponentNameControl(Composite parent, String labelName, final BindingBaseConfiguration esConfig) {
        this.fNameField = new StringDialogField();
        this.fNameField.setLabelText(labelName);
        this.fNameField.setText(esConfig.getBindingName());
        this.createStringDialogField(parent, this.fNameField, new IDialogFieldListener(){

            @Override
            public void dialogFieldChanged(DialogField field) {
                if (field == RestBindingWizardPage.this.fNameField) {
                    RestBindingWizardPage.this.HandleBindingNameChanged(esConfig);
                }
            }
        });
    }

    @Override
    protected void HandleBindingNameChanged(BindingBaseConfiguration esConfig) {
        super.HandleBindingNameChanged(esConfig);
        this.determinePageCompletion();
    }

    protected boolean determinePageCompletion() {
        this.setErrorMessage(null);
        boolean result = true;
        String name = this.fNameField.getText();
        if (name == null || name.trim().length() == 0) {
            this.setErrorMessage(NewWizardMessages.RestBindingBlankError);
            result = false;
        }
        this.setPageComplete(result);
        return result;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.determinePageCompletion();
        }
    }
}

