/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.eclipse.edt.gen.GenerationException;
import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.Assignment;
import org.eclipse.edt.mof.egl.AssignmentStatement;
import org.eclipse.edt.mof.egl.BinaryExpression;
import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.ExternalType;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.FixedPrecisionType;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.Library;
import org.eclipse.edt.mof.egl.LocalVariableDeclarationStatement;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.MemberAccess;
import org.eclipse.edt.mof.egl.MemberName;
import org.eclipse.edt.mof.egl.Name;
import org.eclipse.edt.mof.egl.NamedElement;
import org.eclipse.edt.mof.egl.Operation;
import org.eclipse.edt.mof.egl.ParameterizableType;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.QualifiedFunctionInvocation;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.StereotypeType;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.ThisExpression;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.TypeName;
import org.eclipse.edt.mof.egl.utils.InternUtil;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.MofObjectNotFoundException;

public class CommonUtilities {
    public static String getEglNameForType(Type type) {
        switch (TypeUtils.getTypeKind((Type)type)) {
            case 1: {
                return "any";
            }
            case 27: {
                return "boolean";
            }
            case 9: {
                return "bigint";
            }
            case 18: {
                return "date";
            }
            case 16: {
                return "float";
            }
            case 10: {
                return "decimal";
            }
            case 8: {
                return "int";
            }
            case 13: {
                return "num";
            }
            case 17: {
                return "smallfloat";
            }
            case 7: {
                return "smallint";
            }
            case 5: {
                return "string";
            }
            case 19: {
                return "time";
            }
            case 20: {
                return "timeStamp";
            }
        }
        return "undefined";
    }

    public static String getEglNameForTypeCamelCase(Type type) {
        String name = CommonUtilities.getEglNameForType(type);
        StringBuilder b = new StringBuilder(name);
        b.setCharAt(0, Character.toUpperCase(name.charAt(0)));
        return b.toString();
    }

    public static String getNativeRuntimeOperationName(BinaryExpression expr) throws GenerationException {
        if (expr.getOperation() == null || expr.getOperation().getName() == null) {
            throw new GenerationException();
        }
        String op = expr.getOperator();
        if (op.equals("+")) {
            return "plus";
        }
        if (op.equals("-")) {
            return "minus";
        }
        if (op.equals("/")) {
            return "divide";
        }
        if (op.equals("*")) {
            return "multiply";
        }
        if (op.equals("%")) {
            return "modulo";
        }
        if (op.equals("==")) {
            return "equals";
        }
        if (op.equals("!=")) {
            return "notEquals";
        }
        if (op.equals("<")) {
            return "compareTo";
        }
        if (op.equals(">")) {
            return "compareTo";
        }
        if (op.equals("<=")) {
            return "compareTo";
        }
        if (op.equals(">=")) {
            return "compareTo";
        }
        if (op.equals("&&")) {
            return "and";
        }
        if (op.equals("||")) {
            return "or";
        }
        if (op.equals("xor")) {
            return "xor";
        }
        if (op.equals("::")) {
            return "concat";
        }
        if (op.equals("?:")) {
            return "nullconcat";
        }
        if (op.equals("&")) {
            return "bitand";
        }
        if (op.equals("|")) {
            return "bitor";
        }
        if (op.equals("**")) {
            return "power";
        }
        if (op.equals("in")) {
            return "in";
        }
        if (op.equals("matches")) {
            return "matches";
        }
        if (op.equals("like")) {
            return "like";
        }
        return "UnknownOp";
    }

    public static String getNativeRuntimeComparisionOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("<")) {
            return " < 0";
        }
        if (op.equals(">")) {
            return " > 0";
        }
        if (op.equals("<=")) {
            return " <= 0";
        }
        if (op.equals(">=")) {
            return " >= 0";
        }
        return "";
    }

    public static String getNativeJavaScriptOperation(BinaryExpression expr, Context ctx) {
        String op = expr.getOperator();
        if (expr.isNullable() || ((Boolean)ctx.getParameter("checkOverflow")).booleanValue()) {
            if (op.equals("==")) {
                return " == ";
            }
            if (op.equals("!=")) {
                return " != ";
            }
            if (op.equals("<")) {
                return " < ";
            }
            if (op.equals(">")) {
                return " > ";
            }
            if (op.equals("<=")) {
                return " <= ";
            }
            if (op.equals(">=")) {
                return " >= ";
            }
            if (op.equals("&&")) {
                return " && ";
            }
            if (op.equals("||")) {
                return " || ";
            }
            if (op.equals("xor")) {
                return " ^ ";
            }
            if (op.equals("::")) {
                return " + ";
            }
            if (op.equals("&")) {
                return " & ";
            }
            if (op.equals("|")) {
                return " | ";
            }
            return "";
        }
        if (op.equals("+")) {
            return " + ";
        }
        if (op.equals("-")) {
            return " - ";
        }
        if (op.equals("*")) {
            return " * ";
        }
        if (op.equals("%")) {
            return " % ";
        }
        if (op.equals("==")) {
            return " == ";
        }
        if (op.equals("!=")) {
            return " != ";
        }
        if (op.equals("<")) {
            return " < ";
        }
        if (op.equals(">")) {
            return " > ";
        }
        if (op.equals("<=")) {
            return " <= ";
        }
        if (op.equals(">=")) {
            return " >= ";
        }
        if (op.equals("&&")) {
            return " && ";
        }
        if (op.equals("||")) {
            return " || ";
        }
        if (op.equals("xor")) {
            return " ^ ";
        }
        if (op.equals("::")) {
            return " + ";
        }
        if (op.equals("&")) {
            return " & ";
        }
        if (op.equals("|")) {
            return " | ";
        }
        return "";
    }

    public static String getNativeJavaScriptAssignment(String op) {
        if (op.equals("xor=")) {
            return "^=";
        }
        if (op.equals("::=")) {
            return "+=";
        }
        return op;
    }

    public static String createNamespaceFromPackage(Part part) {
        String ePackage = part.getPackageName();
        if (ePackage == null || ePackage.length() == 0) {
            return "http://default";
        }
        return "http://" + ePackage;
    }

    public static boolean needsConversion(Type fromType, Type toType) {
        boolean result = true;
        if (fromType instanceof FixedPrecisionType && toType instanceof FixedPrecisionType) {
            FixedPrecisionType fpExpr = (FixedPrecisionType)fromType;
            FixedPrecisionType fpType = (FixedPrecisionType)toType;
            result = fpExpr.getLength() > fpType.getLength() || fpExpr.getDecimals() > fpType.getDecimals();
        }
        return result;
    }

    public static boolean proceedWithConversion(Context ctx, Operation conOp) {
        boolean result = true;
        Type fromType = ((FunctionParameter)conOp.getParameters().get(0)).getType();
        Type toType = conOp.getReturnType();
        if (!(conOp.isNarrowConversion() || fromType instanceof ParameterizableType || toType instanceof ParameterizableType)) {
            String fromType_RT = ctx.getPrimitiveMapping(fromType);
            String toType_RT = ctx.getPrimitiveMapping(toType);
            if (fromType_RT != null && toType_RT != null) {
                result = !fromType_RT.equals(toType_RT);
            }
        }
        return result;
    }

    public static boolean isJavaScriptNumber(Type type) {
        return TypeUtils.Type_INT.equals(type) != false || TypeUtils.Type_SMALLINT.equals(type) != false || TypeUtils.Type_FLOAT.equals(type) != false || TypeUtils.Type_SMALLFLOAT.equals(type) != false;
    }

    public static boolean isJavaScriptBigDecimal(Type type) {
        return TypeUtils.Type_BIGINT.equals(type) != false || TypeUtils.Type_NUM.equals(type) != false || TypeUtils.Type_DECIMAL.equals(type) != false || TypeUtils.Type_MONEY.equals(type) != false;
    }

    public static boolean isRUIHandler(Object obj) {
        if (obj instanceof EGLClass) {
            return ((EGLClass)obj).getAnnotation("eglx.ui.rui.RUIHandler") != null;
        }
        return false;
    }

    public static boolean isRUIWidget(Object obj) {
        EGLClass eglClass;
        if (obj instanceof ExternalType) {
            return CommonUtilities.isWidget((ExternalType)obj);
        }
        return obj instanceof EGLClass && ((eglClass = (EGLClass)obj).getAnnotation("eglx.ui.rui.RUIWidget") != null || eglClass.getAnnotation("eglx.ui.rui.VEWidget") != null);
    }

    public static boolean isWidget(ExternalType et) {
        if (et.getName().equalsIgnoreCase("Widget") && et.getPackageName().equalsIgnoreCase("eglx.ui.rui")) {
            return true;
        }
        for (StructPart struct : et.getSuperTypes()) {
            if (!(struct instanceof ExternalType) || !CommonUtilities.isWidget((ExternalType)struct)) continue;
            return true;
        }
        return false;
    }

    public static boolean isException(Object obj) {
        if (obj instanceof EGLClass) {
            return ((EGLClass)obj).getAnnotation("eglx.lang.Exception") != null;
        }
        return false;
    }

    public static void genEzeCopyTo(Expression expr, Context ctx, TabbedWriter out) {
        out.print("egl.eglx.lang.AnyValue.ezeCopyTo(");
    }

    public static boolean isRUIPropertiesLibrary(Object obj) {
        if (obj instanceof Element) {
            return ((Element)obj).getAnnotation("eglx.ui.rui.RUIPropertiesLibrary") != null;
        }
        return false;
    }

    public static String getPropertiesFile(Library ruiPropertiesLibrary) {
        String value;
        String result = null;
        Annotation annotation = ruiPropertiesLibrary.getAnnotation(InternUtil.intern((String)"eglx.ui.rui.RUIPropertiesLibrary"));
        if (annotation != null && (value = (String)annotation.getValue(InternUtil.intern((String)"propertiesFile"))) != null && value.length() > 0) {
            result = value;
        }
        if (result == null) {
            result = ruiPropertiesLibrary.getId();
        }
        return result;
    }

    public static Annotation getPropertyAnnotation(Element element) {
        Annotation result = element.getAnnotation("eglx.lang.Property");
        if (result == null) {
            result = element.getAnnotation("eglx.lang.EGLProperty");
        }
        return result;
    }

    public static String getPropertyFunction(Object property) {
        String result = null;
        if (property != null) {
            result = property instanceof MemberName ? ((MemberName)property).getNamedElement().getName() : (String)property;
        }
        return result;
    }

    public static Annotation getAnnotation(Context ctx, String key) throws MofObjectNotFoundException, DeserializationException {
        EObject eObject = Environment.getCurrentEnv().find(key);
        if (eObject instanceof StereotypeType && (eObject = ((StereotypeType)eObject).newInstance()) instanceof Annotation) {
            return (Annotation)eObject;
        }
        if (eObject instanceof AnnotationType && (eObject = ((AnnotationType)eObject).newInstance()) instanceof Annotation) {
            return (Annotation)eObject;
        }
        return null;
    }

    public static String getPropertyFunction(NamedElement field, boolean setter, Context context) {
        String result = null;
        boolean isEGLProperty = true;
        Annotation annotation = field.getAnnotation("eglx.lang.EGLProperty");
        if (annotation == null) {
            annotation = field.getAnnotation("eglx.lang.Property");
            isEGLProperty = false;
        }
        if (annotation != null) {
            boolean bothUnspecified;
            String propertyFunction = setter ? "setMethod" : "getMethod";
            String otherPropertyFunction = setter ? "getMethod" : "setMethod";
            Object propFn = annotation.getValue(propertyFunction);
            Object otherPropFn = annotation.getValue(otherPropertyFunction);
            boolean bl = bothUnspecified = (propFn == null || propFn instanceof String && ((String)propFn).length() == 0) && (otherPropFn == null || otherPropFn instanceof String && ((String)otherPropFn).length() == 0);
            if (bothUnspecified) {
                String fieldName = field.getName();
                result = String.valueOf(setter ? "set" : "get") + fieldName.substring(0, 1).toUpperCase();
                if (fieldName.length() > 1) {
                    result = String.valueOf(result) + fieldName.substring(1);
                }
                if (isEGLProperty) {
                    QualifiedFunctionInvocation qfi = context.getFactory().createQualifiedFunctionInvocation();
                    qfi.setId(result);
                    qfi.setQualifier(CommonUtilities.expressionForContainer(((Field)field).getContainer(), context));
                    if (setter) {
                        MemberName argName = context.getFactory().createMemberName();
                        argName.setId(field.getName());
                        argName.setMember((Member)field);
                        qfi.getArguments().add(argName);
                    }
                    result = qfi.getTarget().getName();
                }
            } else {
                result = propFn instanceof Name ? ((Name)propFn).getId() : (String)propFn;
            }
        }
        return result;
    }

    public static boolean isCurrentFunction(Context ctx, String functionName, NamedElement element) {
        Function currentFunction = ctx.getCurrentFunction();
        if (currentFunction != null && element instanceof Field && !currentFunction.getContainer().equals(((Field)element).getContainer())) {
            return false;
        }
        return currentFunction != null && currentFunction.getName().equals(functionName);
    }

    public static QualifiedFunctionInvocation getFunctionInvocation(Context context, Field field, String fnName, boolean isSetter) {
        QualifiedFunctionInvocation qfi = context.getFactory().createQualifiedFunctionInvocation();
        qfi.setId(fnName);
        qfi.setQualifier(CommonUtilities.expressionForContainer(field.getContainer(), context));
        if (isSetter) {
            MemberName argName = context.getFactory().createMemberName();
            argName.setId(field.getName());
            argName.setMember((Member)field);
            qfi.getArguments().add(argName);
        }
        return qfi;
    }

    private static Expression expressionForContainer(Container container, Context ctx) {
        ThisExpression result = null;
        Object pbg = ctx.getAttribute(((Object)((Object)ctx)).getClass(), "partBeingGenerated");
        if (container instanceof Function || container instanceof Part && pbg instanceof Part && ((Part)container).getFullyQualifiedName().equalsIgnoreCase(((Part)pbg).getFullyQualifiedName())) {
            ThisExpression thisExpr = ctx.getFactory().createThisExpression();
            thisExpr.setThisObject((Element)container);
            result = thisExpr;
        } else {
            TypeName typeExpr = ctx.getFactory().createTypeName();
            typeExpr.setType((Type)container);
            result = typeExpr;
        }
        return result;
    }

    public static String getOpName(Context ctx, Operation op) {
        String result = op.getName();
        if (result.startsWith("as") && !"asNumber".equalsIgnoreCase(result)) {
            StringBuffer alias = new StringBuffer("from");
            String delim = "";
            List args = op.getParameters();
            alias.append(delim);
            String sep = "";
            for (FunctionParameter arg : args) {
                Type type = arg.getType();
                alias.append(sep);
                alias.append(ctx.getNativeTypeName(type));
                sep = delim;
            }
            result = alias.toString();
        }
        return result;
    }

    public static String isOverloaded(Context ctx, Function fn) {
        String result = null;
        EGLClass part = (EGLClass)fn.getContainer();
        if (!(part instanceof ExternalType) && !part.isNativeType()) {
            String fnName = fn.getName();
            for (Function f1 : part.getFunctions()) {
                String f1Name = f1.getName();
                if (!fnName.equals(f1Name)) continue;
                for (Function f2 : part.getFunctions()) {
                    if (f1 == f2 || !f1Name.equals(f2.getName())) continue;
                    result = CommonUtilities.getOverloadedFunctionAlias(ctx, fn);
                    break;
                }
                if (result != null) break;
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String getOverloadedFunctionAlias(Context ctx, Function fn) {
        String delim = "_";
        StringBuffer result = new StringBuffer(fn.getName());
        List args = fn.getParameters();
        result.append(delim);
        result.append(args.size());
        String sep = delim;
        for (FunctionParameter arg : args) {
            Type type = arg.getType();
            StringWriter sw = new StringWriter();
            TabbedWriter tw = new TabbedWriter((Writer)sw);
            ctx.invoke("genSignature", type, new Object[]{ctx, tw});
            String sig = tw.getCurrentLine();
            StringBuffer sanitizedSig = new StringBuffer();
            int length = sig.length();
            boolean skip = false;
            int i = 0;
            while (i < length) {
                block8: {
                    char c = sig.charAt(i);
                    switch (c) {
                        case '?': {
                            c = '$';
                            break;
                        }
                        case ';': {
                            break block8;
                        }
                        case '\'': {
                            skip = !skip;
                            break block8;
                        }
                    }
                    if (!skip) {
                        sanitizedSig.append(c);
                    }
                }
                ++i;
            }
            result.append(sep);
            result.append(sanitizedSig.toString());
        }
        return result.toString();
    }

    public static boolean isWidgetPropertyArrayAssignment(Statement stmt) {
        if (stmt instanceof AssignmentStatement) {
            Assignment object = (Assignment)((AssignmentStatement)stmt).getExpr();
            if (object.getLHS() instanceof MemberAccess && CommonUtilities.isRUIWidget(object.getLHS().getQualifier().getType())) {
                return true;
            }
        } else if (stmt instanceof LocalVariableDeclarationStatement) {
            List fieldList = ((LocalVariableDeclarationStatement)stmt).getExpression().getFields();
            for (Field field : fieldList) {
                if (!CommonUtilities.isRUIWidget(field.getType())) continue;
                return true;
            }
        }
        return false;
    }
}

