/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.javascript.internal.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.IDebugEditorPresentation;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.edt.debug.javascript.internal.model.RUIVariable;
import org.eclipse.edt.ide.debug.javascript.internal.utils.RUIDebugUtil;
import org.eclipse.edt.ide.rui.utils.Util;
import org.eclipse.edt.ide.ui.internal.editor.IEvEditor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class RUIModelPresentation
extends LabelProvider
implements IDebugModelPresentation,
IDebugEditorPresentation {
    protected boolean fShowTypes = false;

    public void setAttribute(String attribute, Object value) {
        if (value == null) {
            return;
        }
        if (attribute.equals("org.eclipse.debug.ui.displayVariableTypeNames")) {
            this.fShowTypes = (Boolean)value;
        }
    }

    public Image getImage(Object element) {
        if (element instanceof RUIVariable) {
            return RUIDebugUtil.getImage("RUI_ICON_VARIABLE");
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof RUIVariable) {
            return ((RUIVariable)((Object)element)).getLabel(this.fShowTypes);
        }
        return null;
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        String valueString = null;
        try {
            valueString = value.getValueString();
        }
        catch (DebugException debugException) {}
        listener.detailComputed(value, valueString);
    }

    public IEditorInput getEditorInput(Object element) {
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        if (element instanceof ILineBreakpoint) {
            return new FileEditorInput((IFile)((ILineBreakpoint)element).getMarker().getResource());
        }
        return null;
    }

    public String getEditorId(IEditorInput input, Object inputObject) {
        if (input instanceof IFileEditorInput) {
            IResource resource;
            if (inputObject instanceof IFile) {
                IFile file = (IFile)inputObject;
                if (Util.isVESupportType((IFile)file)) {
                    return "org.eclipse.edt.ide.rui.visualeditor.EvEditor";
                }
                IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
                if (desc != null) {
                    return desc.getId();
                }
            } else if (inputObject instanceof IBreakpoint && (resource = ((IBreakpoint)inputObject).getMarker().getResource()) instanceof IFile) {
                IFile file = (IFile)resource;
                if (Util.isVESupportType((IFile)file)) {
                    return "org.eclipse.edt.ide.rui.visualeditor.EvEditor";
                }
                IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
                if (desc != null) {
                    return desc.getId();
                }
            }
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }

    public boolean addAnnotations(IEditorPart editor, IStackFrame frame) {
        if (editor instanceof IEvEditor) {
            ((IEvEditor)editor).showSourcePage();
        }
        return false;
    }

    public void removeAnnotations(IEditorPart editor, IThread thread) {
    }
}

