/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.document.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.core.ast.ArrayLiteral;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.rui.document.utils.AssignmentLocator;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.mof.egl.utils.InternUtil;
import org.eclipse.jface.text.BadLocationException;

public class EGLContainerDeleteStrategy {
    private static final String CHILDREN_PROPERTY_NAME = InternUtil.intern((String)"children");
    private Node containerNode;
    private IEGLDocument currentDocument;
    private int totalCharactersRemoved;
    private String deletedChildName;

    public EGLContainerDeleteStrategy(Node containerNode, IEGLDocument document) {
        this.containerNode = containerNode;
        this.currentDocument = document;
    }

    public int deleteFromContainer(final int containerIndex) {
        if (this.containerNode != null) {
            this.containerNode.accept((IASTVisitor)new DefaultASTVisitor(){

                public boolean visit(NewExpression newExpression) {
                    if (newExpression.hasSettingsBlock()) {
                        SettingsBlock settingsBlockOpt = newExpression.getSettingsBlock();
                        AssignmentLocator assignmentLocator = new AssignmentLocator(InternUtil.intern((String)CHILDREN_PROPERTY_NAME));
                        settingsBlockOpt.accept((IASTVisitor)assignmentLocator);
                        Assignment setting = assignmentLocator.getAssignment();
                        if (setting != null) {
                            ChildrenArrayVisitor visitor = new ChildrenArrayVisitor(containerIndex);
                            setting.accept((IASTVisitor)visitor);
                            EGLContainerDeleteStrategy.this.totalCharactersRemoved = visitor.theCharactersRemoved;
                            EGLContainerDeleteStrategy.this.deletedChildName = visitor.deletedChildName;
                        }
                    }
                    return false;
                }

                public boolean visit(SimpleName simpleName) {
                    Node parentNode = simpleName.getParent();
                    if (parentNode != null) {
                        parentNode.accept((IASTVisitor)new DefaultASTVisitor(){

                            public boolean visit(ClassDataDeclaration classDataDeclaration) {
                                if (classDataDeclaration.hasSettingsBlock()) {
                                    SettingsBlock settingsBlockOpt = classDataDeclaration.getSettingsBlockOpt();
                                    AssignmentLocator assignmentLocator = new AssignmentLocator(CHILDREN_PROPERTY_NAME);
                                    settingsBlockOpt.accept((IASTVisitor)assignmentLocator);
                                    Assignment setting = assignmentLocator.getAssignment();
                                    if (setting != null) {
                                        ChildrenArrayVisitor visitor = new ChildrenArrayVisitor(containerIndex);
                                        setting.accept((IASTVisitor)visitor);
                                        EGLContainerDeleteStrategy.this.totalCharactersRemoved = visitor.theCharactersRemoved;
                                        EGLContainerDeleteStrategy.this.deletedChildName = visitor.deletedChildName;
                                    }
                                }
                                return false;
                            }

                            public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
                                if (functionDataDeclaration.hasSettingsBlock()) {
                                    SettingsBlock settingsBlockOpt = functionDataDeclaration.getSettingsBlockOpt();
                                    AssignmentLocator assignmentLocator = new AssignmentLocator(CHILDREN_PROPERTY_NAME);
                                    settingsBlockOpt.accept((IASTVisitor)assignmentLocator);
                                    Assignment setting = assignmentLocator.getAssignment();
                                    if (setting != null) {
                                        ChildrenArrayVisitor visitor = new ChildrenArrayVisitor(containerIndex);
                                        setting.accept((IASTVisitor)visitor);
                                        EGLContainerDeleteStrategy.this.totalCharactersRemoved = visitor.theCharactersRemoved;
                                        EGLContainerDeleteStrategy.this.deletedChildName = visitor.deletedChildName;
                                    }
                                }
                                return false;
                            }
                        });
                    }
                    return false;
                }
            });
        }
        return this.totalCharactersRemoved;
    }

    public String getDeletedWidgetName() {
        return this.deletedChildName;
    }

    private class ChildrenArrayVisitor
    extends DefaultASTVisitor {
        private int index;
        private int theCharactersRemoved;
        private String deletedChildName;
        private List<String> deletedChildNames;
        private ChildrenRecursiveVisitor childrenRecursiveVisitor;

        public ChildrenArrayVisitor(int index) {
            this.index = index;
            this.deletedChildNames = new ArrayList<String>();
        }

        public boolean visit(Assignment assignment) {
            assignment.getRightHandSide().accept((IASTVisitor)new DefaultASTVisitor(){

                public boolean visit(ArrayLiteral arrayLiteral) {
                    NewExpression newExpression;
                    List expressions = arrayLiteral.getExpressions();
                    Node referenceNode = (Node)expressions.get(ChildrenArrayVisitor.this.index);
                    int referenceOffset = referenceNode.getOffset();
                    int referenceLength = referenceNode.getLength();
                    if (referenceNode instanceof SimpleName) {
                        ChildrenArrayVisitor.this.deletedChildName = ((SimpleName)referenceNode).getCanonicalName();
                    } else if (referenceNode instanceof NewExpression && (newExpression = (NewExpression)referenceNode).hasSettingsBlock()) {
                        SettingsBlock settingsBlockOpt = newExpression.getSettingsBlock();
                        AssignmentLocator assignmentLocator = new AssignmentLocator(InternUtil.intern((String)CHILDREN_PROPERTY_NAME));
                        settingsBlockOpt.accept((IASTVisitor)assignmentLocator);
                        Assignment assignment = assignmentLocator.getAssignment();
                        if (assignment != null) {
                            ChildrenArrayVisitor.this.childrenRecursiveVisitor = new ChildrenRecursiveVisitor();
                            assignment.getRightHandSide().accept((IASTVisitor)ChildrenArrayVisitor.this.childrenRecursiveVisitor);
                            StringBuffer sbDeletedChildNames = new StringBuffer();
                            int i = 0;
                            while (i < ChildrenArrayVisitor.this.deletedChildNames.size()) {
                                sbDeletedChildNames.append((String)ChildrenArrayVisitor.this.deletedChildNames.get(i)).append(":");
                                ++i;
                            }
                            ChildrenArrayVisitor.this.deletedChildName = sbDeletedChildNames.toString();
                        }
                    }
                    if (expressions.size() > 1) {
                        if (ChildrenArrayVisitor.this.index == expressions.size() - 1) {
                            Node previousWidget = (Node)expressions.get(ChildrenArrayVisitor.this.index - 1);
                            try {
                                ChildrenArrayVisitor.this.theCharactersRemoved = referenceOffset + referenceLength - (previousWidget.getOffset() + previousWidget.getLength());
                                EGLContainerDeleteStrategy.this.currentDocument.replace(previousWidget.getOffset() + previousWidget.getLength(), ChildrenArrayVisitor.this.theCharactersRemoved, "");
                            }
                            catch (BadLocationException e) {
                                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Error deleting last widget reference", (Throwable)e));
                            }
                        } else {
                            Node nextWidget = (Node)expressions.get(ChildrenArrayVisitor.this.index + 1);
                            try {
                                String nextWidgetText = EGLContainerDeleteStrategy.this.currentDocument.get(referenceOffset, nextWidget.getOffset() + nextWidget.getLength() - referenceOffset);
                                nextWidgetText = nextWidgetText.substring(nextWidgetText.indexOf(",", referenceLength) + 1, nextWidgetText.length()).trim();
                                ChildrenArrayVisitor.this.theCharactersRemoved = nextWidget.getOffset() + nextWidget.getLength() - referenceOffset - nextWidgetText.length();
                                EGLContainerDeleteStrategy.this.currentDocument.replace(referenceOffset, nextWidget.getOffset() + nextWidget.getLength() - referenceOffset, nextWidgetText);
                            }
                            catch (BadLocationException e) {
                                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Error Deleting item from Container", (Throwable)e));
                            }
                        }
                    } else {
                        try {
                            ChildrenArrayVisitor.this.theCharactersRemoved = referenceLength;
                            EGLContainerDeleteStrategy.this.currentDocument.replace(referenceOffset, referenceLength, "");
                        }
                        catch (BadLocationException e) {
                            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Error Deleting item from Container", (Throwable)e));
                        }
                    }
                    return false;
                }
            });
            return false;
        }

        private class ChildrenRecursiveVisitor
        extends DefaultASTVisitor {
            private ChildrenRecursiveVisitor() {
            }

            public boolean visit(ArrayLiteral arrayLiteral) {
                List expressions = arrayLiteral.getExpressions();
                int i = 0;
                while (i < expressions.size()) {
                    NewExpression newExpression;
                    Node childWidget = (Node)expressions.get(i);
                    if (childWidget instanceof SimpleName) {
                        ChildrenArrayVisitor.this.deletedChildNames.add(((SimpleName)childWidget).getCanonicalName());
                    } else if (childWidget instanceof NewExpression && (newExpression = (NewExpression)childWidget).hasSettingsBlock()) {
                        SettingsBlock settingsBlockOpt = newExpression.getSettingsBlock();
                        AssignmentLocator assignmentLocator = new AssignmentLocator(InternUtil.intern((String)CHILDREN_PROPERTY_NAME));
                        settingsBlockOpt.accept((IASTVisitor)assignmentLocator);
                        Assignment assignment = assignmentLocator.getAssignment();
                        if (assignment != null) {
                            assignment.getRightHandSide().accept((IASTVisitor)ChildrenArrayVisitor.this.childrenRecursiveVisitor);
                        }
                    }
                    ++i;
                }
                return false;
            }
        }
    }
}

