/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.document.utils;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.ide.core.ast.rewrite.ASTRewrite;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.mof.egl.utils.InternUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;

public class InsertEventHandlingFunctionOperation {
    private IEGLDocument currentDocument;
    private IFile currentFile;

    public InsertEventHandlingFunctionOperation(IEGLDocument currentDocument, IFile currentFile) {
        this.currentDocument = currentDocument;
        this.currentFile = currentFile;
    }

    public void insertFunction(String eventType) {
        try {
            IEGLFile modelFile = (IEGLFile)EGLCore.create((IFile)this.currentFile);
            IEGLFile sharedWorkingCopy = (IEGLFile)modelFile.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
            sharedWorkingCopy.open(null);
            sharedWorkingCopy.reconcile(false, null);
            try {
                try {
                    File fileAST = this.currentDocument.getNewModelEGLFile();
                    String partName = new Path(this.currentFile.getName()).removeFileExtension().toString();
                    Part part = this.getPart(fileAST, partName);
                    this.addFunction(eventType, fileAST, part);
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Insert Event Handler: Error inserting function", (Throwable)e));
                    sharedWorkingCopy.destroy();
                }
            }
            finally {
                sharedWorkingCopy.destroy();
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Insert Event Handler: Error creating working copy", (Throwable)e));
        }
    }

    private Part getPart(File fileAST, String partName) {
        Part part = null;
        List parts = fileAST.getParts();
        for (Part nextPart : parts) {
            if (nextPart.getIdentifier() != InternUtil.intern((String)partName)) continue;
            part = nextPart;
            break;
        }
        return part;
    }

    private void addFunction(String functionName, File fileAST, Part part) throws EGLModelException, MalformedTreeException, BadLocationException {
        ASTRewrite rewrite = ASTRewrite.create((File)fileAST);
        String functionText = "function " + functionName + "(event Event in)" + InsertEventHandlingFunctionOperation.getLineDelimiter((IDocument)this.currentDocument) + "\t" + InsertEventHandlingFunctionOperation.getLineDelimiter((IDocument)this.currentDocument) + "end";
        rewrite.addFunction(part, functionText);
        rewrite.rewriteAST((IDocument)this.currentDocument).apply((IDocument)this.currentDocument);
    }

    private static String getLineDelimiter(IDocument document) throws BadLocationException {
        String lineDelimiter = document.getLineDelimiter(0);
        return lineDelimiter == null ? System.getProperty("line.separator") : lineDelimiter;
    }
}

