/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.document.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.ide.core.ast.rewrite.ASTRewrite;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.rui.document.utils.AssignmentLocator;
import org.eclipse.edt.ide.rui.document.utils.DocumentUtil;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.mof.egl.utils.InternUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class RemoveLayoutPropertyValueOperation {
    private IEGLDocument currentDocument;
    private IFile currentFile;
    private int charactersChanged;
    private String layoutPropertyName = "layoutData";
    private Expression layoutData;

    public RemoveLayoutPropertyValueOperation(IEGLDocument currentDocument, IFile currentFile) {
        this.currentDocument = currentDocument;
        this.currentFile = currentFile;
    }

    public int removePropertyValue(final String propertyName, int widgetOffset, int widgetLength) {
        try {
            IEGLFile modelFile = (IEGLFile)EGLCore.create((IFile)this.currentFile);
            IEGLFile sharedWorkingCopy = (IEGLFile)modelFile.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
            sharedWorkingCopy.open(null);
            sharedWorkingCopy.reconcile(false, null);
            try {
                try {
                    final File fileAST = this.currentDocument.getNewModelEGLFile();
                    Node widgetReference = DocumentUtil.getWidgetNode(this.currentDocument, widgetOffset, widgetLength);
                    if (widgetReference != null) {
                        widgetReference.accept((IASTVisitor)new DefaultASTVisitor(){

                            public boolean visit(NewExpression newExpression) {
                                if (newExpression.hasSettingsBlock()) {
                                    AssignmentLocator locator = new AssignmentLocator(InternUtil.intern((String)RemoveLayoutPropertyValueOperation.this.layoutPropertyName));
                                    newExpression.getSettingsBlock().accept((IASTVisitor)locator);
                                    if (locator.getAssignment() != null) {
                                        RemoveLayoutPropertyValueOperation.this.layoutData = locator.getAssignment().getRightHandSide();
                                    }
                                }
                                return false;
                            }

                            public boolean visit(SimpleName simpleName) {
                                Node parentNode = simpleName.getParent();
                                if (parentNode != null) {
                                    parentNode.accept((IASTVisitor)new DefaultASTVisitor(){

                                        public boolean visit(ClassDataDeclaration classDataDeclaration) {
                                            if (classDataDeclaration.hasSettingsBlock()) {
                                                AssignmentLocator locator = new AssignmentLocator(InternUtil.intern((String)RemoveLayoutPropertyValueOperation.this.layoutPropertyName));
                                                classDataDeclaration.getSettingsBlockOpt().accept((IASTVisitor)locator);
                                                if (locator.getAssignment() != null) {
                                                    RemoveLayoutPropertyValueOperation.this.layoutData = locator.getAssignment().getRightHandSide();
                                                }
                                            }
                                            return false;
                                        }
                                    });
                                }
                                return false;
                            }
                        });
                    }
                    if (this.layoutData != null) {
                        this.layoutData.accept((IASTVisitor)new DefaultASTVisitor(){

                            public boolean visit(NewExpression newExpression) {
                                try {
                                    if (newExpression.hasSettingsBlock()) {
                                        SettingsBlock settingsBlockOpt = newExpression.getSettingsBlock();
                                        AssignmentLocator assignmentLocator = new AssignmentLocator(InternUtil.intern((String)propertyName));
                                        settingsBlockOpt.accept((IASTVisitor)assignmentLocator);
                                        Assignment setting = assignmentLocator.getAssignment();
                                        if (setting != null) {
                                            ASTRewrite rewrite = ASTRewrite.create((File)fileAST);
                                            rewrite.removeSetting(newExpression, (Node)setting);
                                            rewrite.rewriteAST((IDocument)RemoveLayoutPropertyValueOperation.this.currentDocument).apply((IDocument)RemoveLayoutPropertyValueOperation.this.currentDocument);
                                            RemoveLayoutPropertyValueOperation.this.charactersChanged = 0 - setting.getLength();
                                        }
                                    }
                                }
                                catch (BadLocationException e) {
                                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Remove Property: Error processing new expression", (Throwable)e));
                                }
                                return false;
                            }
                        });
                    }
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Remove Property: Error removing property", (Throwable)e));
                    sharedWorkingCopy.destroy();
                }
            }
            finally {
                sharedWorkingCopy.destroy();
            }
        }
        catch (EGLModelException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Remove Property: Error creating working copy", (Throwable)e));
        }
        return this.charactersChanged;
    }
}

