/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.internal.testserver;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.edt.compiler.internal.PartWrapper;
import org.eclipse.edt.compiler.tools.IRUtils;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.utils.DefaultDeploymentDescriptorUtility;
import org.eclipse.edt.ide.deployment.core.model.DeploymentDesc;
import org.eclipse.edt.ide.internal.sql.util.EGLSQLUtility;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.ide.rui.internal.testserver.TestServerMessages;
import org.eclipse.edt.javart.resources.egldd.SQLDatabaseBinding;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class ClasspathUtil {
    public static final char[] SUFFIX_egldd = ".egldd".toCharArray();
    public static final char[] SUFFIX_EGLDD = ".EGLDD".toCharArray();

    private ClasspathUtil() {
    }

    public static void buildClasspath(IProject project, List<String> classpath) throws CoreException {
        String entry = ClasspathUtil.getClasspathEntry("org.mortbay.jetty.server");
        if (entry != null) {
            classpath.add(entry);
        }
        if ((entry = ClasspathUtil.getClasspathEntry("org.mortbay.jetty.util")) != null) {
            classpath.add(entry);
        }
        if ((entry = ClasspathUtil.getClasspathEntry("org.eclipse.equinox.http.jetty")) != null) {
            classpath.add(entry);
        }
        if ((entry = ClasspathUtil.getClasspathEntry("javax.servlet")) != null) {
            classpath.add(entry);
        }
        if ((entry = ClasspathUtil.getClasspathEntry("org.eclipse.edt.ide.rui")) != null) {
            classpath.add(entry);
        }
        if ((entry = ClasspathUtil.getClasspathEntry("org.eclipse.edt.runtime.java")) != null) {
            classpath.add(entry);
        }
        if ((entry = ClasspathUtil.getClasspathEntry("com.ibm.icu")) != null) {
            classpath.add(entry);
        }
        classpath.add(ClasspathUtil.getWorkspaceProjectClasspathEntry(project.getName()));
        ClasspathUtil.addEGLPathToJavaPathIfNecessary(JavaCore.create((IProject)project), project, new HashSet<IProject>(), classpath);
        ClasspathUtil.addJDBCJars(project, new HashSet<IProject>(), new HashSet<IResource>(), classpath);
    }

    public static void addEGLPathToJavaPathIfNecessary(IJavaProject javaProject, IProject currProject, Set<IProject> seen, List<String> classpath) {
        block9: {
            if (seen.contains(currProject)) {
                return;
            }
            seen.add(currProject);
            try {
                if (!currProject.hasNature("org.eclipse.edt.ide.core.eglnature")) break block9;
                IEGLProject eglProject = EGLCore.create((IProject)currProject);
                IEGLPathEntry[] iEGLPathEntryArray = eglProject.getResolvedEGLPath(true);
                int n = iEGLPathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IEGLPathEntry pathEntry = iEGLPathEntryArray[n2];
                    if (pathEntry.getEntryKind() == 2) {
                        IPath path = pathEntry.getPath();
                        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                        try {
                            if (resource != null && resource.getType() == 4 && !seen.contains(resource) && ((IProject)resource).hasNature("org.eclipse.jdt.core.javanature") && !javaProject.isOnClasspath(resource)) {
                                classpath.add(ClasspathUtil.getWorkspaceProjectClasspathEntry(resource.getName()));
                                ClasspathUtil.addEGLPathToJavaPathIfNecessary(javaProject, (IProject)resource, seen, classpath);
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                    ++n2;
                }
            }
            catch (EGLModelException eGLModelException) {
            }
            catch (CoreException coreException) {}
        }
    }

    public static String getClasspathEntry(String pluginName) {
        Bundle bundle = Platform.getBundle((String)pluginName);
        if (bundle != null) {
            try {
                File file = FileLocator.getBundleFile((Bundle)bundle);
                String path = file.getAbsolutePath();
                if (file.isDirectory()) {
                    if (!path.endsWith(File.separator)) {
                        path = String.valueOf(path) + File.separator;
                    }
                    path = String.valueOf(path) + "bin";
                }
                return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><runtimeClasspathEntry externalArchive=\"" + path + "\" path=\"3\" type=\"2\"/>";
            }
            catch (IOException e) {
                Activator.getDefault().log(e.getMessage(), e);
            }
        }
        Activator.getDefault().log(NLS.bind((String)TestServerMessages.CouldNotGetPluginPath, (Object)pluginName), null);
        return null;
    }

    public static String getWorkspaceProjectClasspathEntry(String projectName) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><runtimeClasspathEntry id=\"org.eclipse.jdt.launching.classpathentry.defaultClasspath\"><memento exportedEntriesOnly=\"false\" project=\"" + projectName + "\"/></runtimeClasspathEntry>";
    }

    public static void addJDBCJars(IProject project, Set<IProject> seenProjects, final Set<IResource> seenDDs, final List<String> classpath) {
        IFile ddFile;
        if (seenProjects.contains(project)) {
            return;
        }
        seenProjects.add(project);
        PartWrapper defaultDD = DefaultDeploymentDescriptorUtility.getDefaultDeploymentDescriptor((IResource)project);
        if (defaultDD.getPartPath() != null && defaultDD.getPartPath().length() > 0 && !seenDDs.contains(ddFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(defaultDD.getPartPath()))) && ddFile.exists()) {
            seenDDs.add((IResource)ddFile);
            ClasspathUtil.parseDD((IResource)ddFile, classpath, seenDDs);
        }
        try {
            IWorkspaceRoot root;
            if (!project.hasNature("org.eclipse.edt.ide.core.eglnature")) {
                return;
            }
            IEGLProject eglProject = EGLCore.create((IProject)project);
            if (eglProject == null) {
                return;
            }
            IPackageFragmentRoot[] iPackageFragmentRootArray = eglProject.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                root = iPackageFragmentRootArray[n2];
                root.getResource().accept(new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy proxy) throws CoreException {
                        if (proxy.getType() == 1) {
                            if (IRUtils.matchesFileName((String)proxy.getName(), (char[])SUFFIX_egldd, (char[])SUFFIX_EGLDD) && !seenDDs.contains(proxy.requestResource())) {
                                IResource ddFile = proxy.requestResource();
                                seenDDs.add(ddFile);
                                ClasspathUtil.parseDD(ddFile, classpath, seenDDs);
                            }
                            return false;
                        }
                        return true;
                    }
                }, 0);
                ++n2;
            }
            root = ResourcesPlugin.getWorkspace().getRoot();
            IEGLPathEntry[] iEGLPathEntryArray = eglProject.getResolvedEGLPath(true);
            int n3 = iEGLPathEntryArray.length;
            n = 0;
            while (n < n3) {
                IResource resource;
                IEGLPathEntry entry = iEGLPathEntryArray[n];
                if (entry.getEntryKind() == 2 && (resource = root.findMember(entry.getPath())) != null && resource.getType() == 4 && resource.isAccessible()) {
                    ClasspathUtil.addJDBCJars((IProject)resource, seenProjects, seenDDs, classpath);
                }
                ++n;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().log(e.getMessage(), (Exception)((Object)e));
        }
    }

    private static void parseDD(IResource file, List<String> classpath, Set<IResource> seenDDs) {
        try {
            DeploymentDesc dd = DeploymentDesc.createDeploymentDescriptor((String)file.getLocation().toOSString());
            List bindings = dd.getSqlDatabaseBindings();
            if (bindings.size() > 0) {
                for (SQLDatabaseBinding binding : bindings) {
                    String jars = null;
                    if (binding.isUseURI()) {
                        IConnectionProfile profile;
                        String uri = binding.getUri();
                        if (uri == null) continue;
                        if ((uri = uri.trim()).startsWith("workspace://") && (profile = EGLSQLUtility.getConnectionProfile((String)uri.substring(12))) != null) {
                            jars = EGLSQLUtility.getLoadingPath((IConnectionProfile)profile);
                        }
                    } else {
                        jars = binding.getJarList();
                    }
                    if (jars == null || (jars = jars.trim()).length() <= 0) continue;
                    StringTokenizer tok = new StringTokenizer(jars, File.pathSeparator);
                    while (tok.hasMoreTokens()) {
                        String next = tok.nextToken();
                        String entry = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><runtimeClasspathEntry externalArchive=\"" + next + "\" path=\"3\" type=\"2\"/>";
                        if (classpath.contains(entry)) continue;
                        classpath.add(entry);
                    }
                }
            }
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            for (String include : dd.getIncludes()) {
                IResource resource = root.findMember(include);
                if (resource == null || !resource.isAccessible() || seenDDs.contains(resource)) continue;
                seenDDs.add(resource);
                ClasspathUtil.parseDD(resource, classpath, seenDDs);
            }
        }
        catch (Exception e) {
            Activator.getDefault().log(e.getMessage(), e);
        }
    }

    public static boolean canAffectClasspath(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            return false;
        }
        return ".classpath".equals(fileName) || ".eglPath".equals(fileName) || IRUtils.matchesFileName((String)fileName, (char[])SUFFIX_egldd, (char[])SUFFIX_EGLDD);
    }
}

