/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.internal.testserver;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.internal.PartWrapper;
import org.eclipse.edt.compiler.tools.IRUtils;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.utils.DefaultDeploymentDescriptorUtility;
import org.eclipse.edt.ide.deployment.core.model.DeploymentDesc;
import org.eclipse.edt.ide.deployment.core.model.Restservice;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.ide.rui.internal.testserver.ClasspathUtil;

public class ServiceFinder {
    private ServiceFinder() {
    }

    public static String toArgumentString(Collection<RestServiceMapping> mappings) {
        if (mappings.size() == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        boolean needSeparator = false;
        for (RestServiceMapping mapping : mappings) {
            if (needSeparator) {
                buf.append("|");
            } else {
                needSeparator = true;
            }
            buf.append(mapping.toString());
        }
        return buf.toString();
    }

    public static Map<String, RestServiceMapping> findRestServices(IProject project) {
        HashMap<String, RestServiceMapping> services = new HashMap<String, RestServiceMapping>();
        ServiceFinder.addDDServiceBindings(project, new HashSet<IProject>(), services);
        return services;
    }

    private static void addDDServiceBindings(IProject project, Set<IProject> seenProjects, final Map<String, RestServiceMapping> services) {
        List<RestServiceMapping> parsed;
        IFile ddFile;
        if (seenProjects.contains(project)) {
            return;
        }
        seenProjects.add(project);
        PartWrapper defaultDD = DefaultDeploymentDescriptorUtility.getDefaultDeploymentDescriptor((IResource)project);
        if (defaultDD.getPartPath() != null && defaultDD.getPartPath().length() > 0 && (ddFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(defaultDD.getPartPath()))).exists() && (parsed = ServiceFinder.parseDD((IResource)ddFile)) != null) {
            for (RestServiceMapping mapping : parsed) {
                if (services.containsKey(mapping.uri)) continue;
                services.put(mapping.uri, mapping);
            }
        }
        try {
            IWorkspaceRoot root;
            if (!project.hasNature("org.eclipse.edt.ide.core.eglnature")) {
                return;
            }
            IEGLProject eglProject = EGLCore.create((IProject)project);
            if (eglProject == null) {
                return;
            }
            IPackageFragmentRoot[] iPackageFragmentRootArray = eglProject.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int mapping = 0;
            while (mapping < n) {
                root = iPackageFragmentRootArray[mapping];
                root.getResource().accept(new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy proxy) throws CoreException {
                        if (proxy.getType() == 1) {
                            List parsed;
                            if (IRUtils.matchesFileName((String)proxy.getName(), (char[])ClasspathUtil.SUFFIX_egldd, (char[])ClasspathUtil.SUFFIX_EGLDD) && (parsed = ServiceFinder.parseDD(proxy.requestResource())) != null) {
                                for (RestServiceMapping mapping : parsed) {
                                    if (services.containsKey(mapping.uri)) continue;
                                    services.put(mapping.uri, mapping);
                                }
                            }
                            return false;
                        }
                        return true;
                    }
                }, 0);
                ++mapping;
            }
            root = ResourcesPlugin.getWorkspace().getRoot();
            IEGLPathEntry[] iEGLPathEntryArray = eglProject.getResolvedEGLPath(true);
            int n2 = iEGLPathEntryArray.length;
            n = 0;
            while (n < n2) {
                IResource resource;
                IEGLPathEntry entry = iEGLPathEntryArray[n];
                if (entry.getEntryKind() == 2 && (resource = root.findMember(entry.getPath())) != null && resource.getType() == 4 && resource.isAccessible()) {
                    ServiceFinder.addDDServiceBindings((IProject)resource, seenProjects, services);
                }
                ++n;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().log(e.getMessage(), (Exception)((Object)e));
        }
    }

    private static List<RestServiceMapping> parseDD(IResource file) {
        ArrayList<RestServiceMapping> parsed = null;
        try {
            DeploymentDesc dd = DeploymentDesc.createDeploymentDescriptor((String)file.getLocation().toOSString());
            List services = dd.getRestservices();
            if (services.size() > 0) {
                parsed = new ArrayList<RestServiceMapping>(services.size());
                for (Restservice service : services) {
                    parsed.add(new RestServiceMapping(service.getImplementation(), service.isStateful()));
                }
            }
        }
        catch (Exception e) {
            Activator.getDefault().log(e.getMessage(), e);
        }
        return parsed;
    }

    public static class RestServiceMapping {
        String uri;
        String className;
        boolean stateful;

        RestServiceMapping(String className, boolean stateful) {
            this.className = className;
            this.stateful = stateful;
            this.uri = className.length() > 0 && className.charAt(0) != '/' ? String.valueOf('/') + className : className;
        }

        public int hashCode() {
            return this.uri.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof RestServiceMapping) {
                RestServiceMapping mapping = (RestServiceMapping)o;
                return this.stateful == mapping.stateful && this.className.equals(mapping.className) && this.uri.equals(mapping.uri);
            }
            return false;
        }

        public String toString() {
            try {
                return String.valueOf(URLEncoder.encode(this.uri, "UTF-8")) + ";" + URLEncoder.encode(this.className, "UTF-8") + ";" + String.valueOf(this.stateful);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return String.valueOf(this.uri.replaceAll("%", "%25").replace(";", "%3B").replaceAll("|", "%7C")) + ";" + this.className + ";" + this.stateful;
            }
        }
    }
}

