/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.internal.testserver;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.ide.rui.internal.testserver.ClasspathUtil;
import org.eclipse.edt.ide.rui.internal.testserver.DeploymentDescriptorFinder;
import org.eclipse.edt.ide.rui.internal.testserver.ServiceFinder;
import org.eclipse.edt.ide.rui.internal.testserver.SocketUtil;
import org.eclipse.edt.ide.rui.internal.testserver.TestServer;
import org.eclipse.edt.ide.rui.internal.testserver.TestServerHotCodeReplaceListener;
import org.eclipse.edt.ide.rui.internal.testserver.TestServerMessages;
import org.eclipse.edt.ide.rui.server.EvServer;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaHotCodeReplaceListener;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaLaunchDelegate;
import org.eclipse.osgi.util.NLS;

public class TestServerConfiguration
implements IDebugEventSetListener,
IResourceChangeListener {
    public static final int DEFAULT_PORT = 9701;
    public static final String TEST_SERVER_CONFIG_TYPE_ID = "org.eclipse.edt.ide.rui.testServerLaunchType";
    private static final JavaLaunchDelegate delegate = new JavaLaunchDelegate();
    private IProject project;
    private boolean debugMode;
    private int port;
    private boolean started;
    private ILaunch launch;
    private List<TerminationListener> terminationListeners;
    private String[] latestCheckedClasspath;
    private String currentDefaultDDName;
    private Map<String, ServiceFinder.RestServiceMapping> currentServiceMappings;
    private Map<String, DeploymentDescriptorFinder.DDFile> currentDDFiles;

    public TestServerConfiguration(IProject project, boolean debugMode) {
        this(project, debugMode, -1);
    }

    public TestServerConfiguration(IProject project, boolean debugMode, int port) {
        this.project = project;
        this.debugMode = debugMode;
        this.port = port;
    }

    public synchronized void start(IProgressMonitor monitor, boolean waitForServerToStart) throws CoreException {
        if (this.started) {
            return;
        }
        try {
            if (!this.project.hasNature("org.eclipse.jdt.core.javanature")) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.edt.ide.rui", NLS.bind((String)TestServerMessages.ProjectMissingJavaNature, (Object)this.project.getName())));
            }
            if (this.port < 0) {
                this.port = SocketUtil.findOpenPort(9701, 5, 100);
            }
            ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(TEST_SERVER_CONFIG_TYPE_ID);
            ILaunchConfigurationWorkingCopy copy = type.newInstance(null, NLS.bind((String)TestServerMessages.TestServerProcessName, (Object[])new Object[]{this.project.getName(), this.port}));
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.project.getName());
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, TestServer.class.getCanonicalName());
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
            List classpath = copy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, new ArrayList(10));
            ClasspathUtil.buildClasspath(this.project, classpath);
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, classpath);
            StringBuilder args = new StringBuilder(100);
            args.append(copy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, ""));
            args.append(" -p ");
            args.append(this.port);
            args.append(" -i ");
            args.append(EvServer.getInstance().getPortNumber());
            args.append(" -c \"/");
            args.append(this.project.getName());
            args.append("\" -s \"");
            this.currentServiceMappings = ServiceFinder.findRestServices(this.project);
            args.append(ServiceFinder.toArgumentString(this.currentServiceMappings.values()));
            args.append("\" -dd \"");
            this.currentDDFiles = DeploymentDescriptorFinder.findDeploymentDescriptors(this.project);
            args.append(DeploymentDescriptorFinder.toArgumentString(this.currentDDFiles.values()));
            args.append("\" -ddd \"");
            this.currentDefaultDDName = DeploymentDescriptorFinder.getDefaultDDName(this.project);
            args.append(this.currentDefaultDDName);
            args.append("\"");
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, args.toString());
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
            this.launch = copy.launch(this.debugMode ? "debug" : "run", monitor);
            this.latestCheckedClasspath = delegate.getClasspath(this.launch.getLaunchConfiguration());
            if (waitForServerToStart) {
                int i = 0;
                while (i < 40) {
                    try {
                        if (this.invokeConfigServlet("") == 200) {
                            this.started = true;
                            break;
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {}
                    ++i;
                }
            }
            IDebugTarget[] iDebugTargetArray = this.launch.getDebugTargets();
            int n = iDebugTargetArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDebugTarget target = iDebugTargetArray[n2];
                IJavaDebugTarget javaTarget = (IJavaDebugTarget)target.getAdapter(IJavaDebugTarget.class);
                if (javaTarget != null) {
                    javaTarget.addHotCodeReplaceListener((IJavaHotCodeReplaceListener)new TestServerHotCodeReplaceListener(this));
                }
                ++n2;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.edt.ide.rui", e.getMessage(), (Throwable)e));
        }
    }

    public boolean isRunning() {
        return this.started;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public IProject getProject() {
        return this.project;
    }

    public int getPort() {
        return this.port;
    }

    public void terminate() throws DebugException {
        if (this.launch != null) {
            this.launch.terminate();
        }
    }

    public void addTerminationListener(TerminationListener listener) {
        if (this.terminationListeners == null) {
            this.terminationListeners = new ArrayList<TerminationListener>();
        }
        this.terminationListeners.add(listener);
    }

    public void removeTerminationListener(TerminationListener listener) {
        if (this.terminationListeners != null) {
            this.terminationListeners.remove(listener);
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        if (this.terminationListeners != null) {
            for (TerminationListener listener : this.terminationListeners) {
                listener.terminated(this);
            }
        }
        this.project = null;
        this.launch = null;
        this.started = false;
        this.terminationListeners = null;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        if (!this.started) {
            return;
        }
        if (events == null || events.length == 0) {
            return;
        }
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch;
            DebugEvent event = debugEventArray[n2];
            if (event.getKind() == 8 && event.getSource() instanceof IAdaptable && (launch = (ILaunch)((IAdaptable)event.getSource()).getAdapter(ILaunch.class)) == this.launch) {
                IProcess[] iProcessArray = launch.getProcesses();
                int n3 = iProcessArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IProcess process = iProcessArray[n4];
                    if (process.isTerminated()) {
                        this.dispose();
                        return;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (!this.started) {
            return;
        }
        try {
            class RecomputeSettings
            extends RuntimeException {
                private static final long serialVersionUID = 1L;

                RecomputeSettings() {
                }
            }
            try {
                if (event.getDelta() != null) {
                    event.getDelta().accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            if (delta == null) {
                                return false;
                            }
                            switch (delta.getKind()) {
                                case 4: {
                                    if ((delta.getFlags() & 0x100) == 0 && (delta.getFlags() & 0x100000) == 0) {
                                        return true;
                                    }
                                }
                                case 1: 
                                case 2: {
                                    if (!"egldd".equalsIgnoreCase(delta.getFullPath().getFileExtension()) || !TestServerConfiguration.this.isOnEGLPath(TestServerConfiguration.this.project, delta.getResource().getProject(), new HashSet())) break;
                                    throw new RecomputeSettings();
                                }
                            }
                            return true;
                        }
                    });
                }
            }
            catch (RecomputeSettings recomputeSettings) {
                this.updateDDSettingsOnServer();
            }
        }
        catch (CoreException e) {
            Activator.getDefault().log((Exception)((Object)e));
        }
    }

    public void updateDDSettingsOnServer() {
        if (!this.started) {
            return;
        }
        String defaultDD = DeploymentDescriptorFinder.getDefaultDDName(this.project);
        boolean defaultDDChanged = !this.currentDefaultDDName.equals(defaultDD);
        Map<String, ServiceFinder.RestServiceMapping> newMappings = ServiceFinder.findRestServices(this.project);
        ArrayList<ServiceFinder.RestServiceMapping> addedOrChangedMappings = new ArrayList<ServiceFinder.RestServiceMapping>();
        HashMap<String, ServiceFinder.RestServiceMapping> copyOfCurrentMappings = new HashMap<String, ServiceFinder.RestServiceMapping>(this.currentServiceMappings);
        for (ServiceFinder.RestServiceMapping next : newMappings.values()) {
            ServiceFinder.RestServiceMapping old = (ServiceFinder.RestServiceMapping)copyOfCurrentMappings.remove(next.uri);
            if (old != null && old.equals(next)) continue;
            addedOrChangedMappings.add(next);
        }
        Map<String, DeploymentDescriptorFinder.DDFile> newDDFiles = DeploymentDescriptorFinder.findDeploymentDescriptors(this.project);
        ArrayList<DeploymentDescriptorFinder.DDFile> addedOrChangedDDFiles = new ArrayList<DeploymentDescriptorFinder.DDFile>();
        HashMap<String, DeploymentDescriptorFinder.DDFile> copyOfCurrentDDFiles = new HashMap<String, DeploymentDescriptorFinder.DDFile>(this.currentDDFiles);
        for (DeploymentDescriptorFinder.DDFile next : newDDFiles.values()) {
            DeploymentDescriptorFinder.DDFile old = (DeploymentDescriptorFinder.DDFile)copyOfCurrentDDFiles.remove(next.name);
            if (old != null && old.equals(next)) continue;
            addedOrChangedDDFiles.add(next);
        }
        if (defaultDDChanged || addedOrChangedMappings.size() > 0 || copyOfCurrentMappings.size() > 0 || addedOrChangedDDFiles.size() > 0 || copyOfCurrentDDFiles.size() > 0) {
            String addedMappingArg = ServiceFinder.toArgumentString(addedOrChangedMappings);
            String removedMappingArg = ServiceFinder.toArgumentString(copyOfCurrentMappings.values());
            String addedDDArg = DeploymentDescriptorFinder.toArgumentString(addedOrChangedDDFiles);
            String removedDDArg = DeploymentDescriptorFinder.toArgumentString(copyOfCurrentDDFiles.values());
            StringBuilder args = new StringBuilder(addedMappingArg.length() + removedMappingArg.length() + addedDDArg.length() + removedDDArg.length() + defaultDD.length() + 50);
            if (addedMappingArg.length() > 0) {
                args.append("mappingAdded");
                args.append('=');
                args.append(addedMappingArg);
            }
            if (removedMappingArg.length() > 0) {
                if (args.length() > 0) {
                    args.append('&');
                }
                args.append("mappingRemoved");
                args.append('=');
                args.append(removedMappingArg);
            }
            if (addedDDArg.length() > 0) {
                if (args.length() > 0) {
                    args.append('&');
                }
                args.append("ddAdded");
                args.append('=');
                args.append(addedDDArg);
            }
            if (removedDDArg.length() > 0) {
                if (args.length() > 0) {
                    args.append('&');
                }
                args.append("ddRemoved");
                args.append('=');
                args.append(removedDDArg);
            }
            if (defaultDDChanged) {
                if (args.length() > 0) {
                    args.append('&');
                }
                args.append("defaultDD");
                args.append('=');
                try {
                    args.append(URLEncoder.encode(defaultDD, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    args.append(defaultDD);
                }
            }
            try {
                int status = this.invokeConfigServlet(args.toString());
                if (status != 200) {
                    Activator.getDefault().log(NLS.bind((String)TestServerMessages.ConfigServletBadStatus, (Object)status));
                }
            }
            catch (IOException e) {
                Activator.getDefault().log(e);
            }
        }
        this.currentServiceMappings = newMappings;
        this.currentDDFiles = newDDFiles;
        this.currentDefaultDDName = defaultDD;
    }

    private int invokeConfigServlet(String args) throws IOException {
        String projectName = this.project.getName();
        try {
            projectName = URLEncoder.encode(projectName, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        URLConnection conn = new URL("http://localhost:" + this.port + "/" + projectName + "/config").openConnection();
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept-Charset", "UTF-8");
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        OutputStream output = null;
        try {
            output = conn.getOutputStream();
            output.write(args.getBytes("UTF-8"));
        }
        catch (Throwable throwable) {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (output != null) {
            try {
                output.close();
            }
            catch (IOException iOException) {}
        }
        return ((HttpURLConnection)conn).getResponseCode();
    }

    public boolean isOnEGLPath(IProject project) {
        return this.isOnEGLPath(this.project, project, new HashSet<IProject>());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isOnEGLPath(IProject currProject, IProject deltaProject, Set<IProject> seen) {
        if (seen.contains(currProject)) {
            return false;
        }
        seen.add(currProject);
        if (currProject.equals((Object)deltaProject)) {
            return true;
        }
        try {
            if (!currProject.hasNature("org.eclipse.edt.ide.core.eglnature")) return false;
            IEGLProject eglProject = EGLCore.create((IProject)currProject);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IEGLPathEntry[] iEGLPathEntryArray = eglProject.getResolvedEGLPath(true);
            int n = iEGLPathEntryArray.length;
            int n2 = 0;
            while (true) {
                IResource resource;
                if (n2 >= n) {
                    return false;
                }
                IEGLPathEntry entry = iEGLPathEntryArray[n2];
                if (entry.getEntryKind() == 2 && (resource = root.findMember(entry.getPath())) != null && resource.getType() == 4 && resource.isAccessible() && this.isOnEGLPath((IProject)resource, deltaProject, seen)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (EGLModelException e) {
            Activator.getDefault().log((Exception)((Object)e));
            return false;
        }
        catch (CoreException e) {
            Activator.getDefault().log((Exception)((Object)e));
        }
        return false;
    }

    public boolean hasClasspathChanged() {
        if (!this.started || this.launch == null || this.launch.getLaunchConfiguration() == null) {
            return false;
        }
        boolean result = false;
        try {
            ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
            ILaunchConfigurationWorkingCopy copy = type.newInstance(null, "ezeTemp");
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.project.getName());
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
            List newClasspath = copy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, new ArrayList(10));
            ClasspathUtil.buildClasspath(this.project, newClasspath);
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, newClasspath);
            Object[] newResolvedClasspath = delegate.getClasspath((ILaunchConfiguration)copy);
            result = !Arrays.equals(this.latestCheckedClasspath, newResolvedClasspath);
            this.latestCheckedClasspath = newResolvedClasspath;
        }
        catch (CoreException coreException) {}
        return result;
    }

    public static interface TerminationListener {
        public void terminated(TestServerConfiguration var1);
    }
}

