/*******************************************************************************
 * Copyright © 2008, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
package org.eclipse.edt.ide.core.internal.model.document;

import java.util.*;

public class EGLNodeNameUtility {

	private static Map terminalIntToStringMap = new HashMap();
	private static Map nonterminalIntToStringMap = new HashMap();
	private static Map terminalStringToIntMap = new HashMap();
	private static Map nonterminalStringToIntMap = new HashMap();

	static {
		terminalIntToStringMap.put(new Integer(105), "DISPLAY");
		terminalStringToIntMap.put("DISPLAY", new Integer(105));
		terminalIntToStringMap.put(new Integer(138), "FREESQL");
		terminalStringToIntMap.put("FREESQL", new Integer(138));
		terminalIntToStringMap.put(new Integer(65), "DATATABLE");
		terminalStringToIntMap.put("DATATABLE", new Integer(65));
		terminalIntToStringMap.put(new Integer(149), "IMPLEMENTS");
		terminalStringToIntMap.put("IMPLEMENTS", new Integer(149));
		terminalIntToStringMap.put(new Integer(83), "EXIT");
		terminalStringToIntMap.put("EXIT", new Integer(83));
		terminalIntToStringMap.put(new Integer(28), "FLOAT");
		terminalStringToIntMap.put("FLOAT", new Integer(28));
		terminalIntToStringMap.put(new Integer(167), "GT");
		terminalStringToIntMap.put("GT", new Integer(167));
		terminalIntToStringMap.put(new Integer(26), "BLOB");
		terminalStringToIntMap.put("BLOB", new Integer(26));
		terminalIntToStringMap.put(new Integer(114), "GET");
		terminalStringToIntMap.put("GET", new Integer(114));
		terminalIntToStringMap.put(new Integer(179), "LIKE");
		terminalStringToIntMap.put("LIKE", new Integer(179));
		terminalIntToStringMap.put(new Integer(134), "HOLD");
		terminalStringToIntMap.put("HOLD", new Integer(134));
		terminalIntToStringMap.put(new Integer(7), "ERRORSQLSTMTLIT");
		terminalStringToIntMap.put("ERRORSQLSTMTLIT", new Integer(7));
		terminalIntToStringMap.put(new Integer(169), "GE");
		terminalStringToIntMap.put("GE", new Integer(169));
		terminalIntToStringMap.put(new Integer(77), "CALL");
		terminalStringToIntMap.put("CALL", new Integer(77));
		terminalIntToStringMap.put(new Integer(96), "STACK");
		terminalStringToIntMap.put("STACK", new Integer(96));
		terminalIntToStringMap.put(new Integer(6), "ERRORBLOCKCOMMENT");
		terminalStringToIntMap.put("ERRORBLOCKCOMMENT", new Integer(6));
		terminalIntToStringMap.put(new Integer(158), "RPAREN");
		terminalStringToIntMap.put("RPAREN", new Integer(158));
		terminalIntToStringMap.put(new Integer(79), "NOREFRESH");
		terminalStringToIntMap.put("NOREFRESH", new Integer(79));
		terminalIntToStringMap.put(new Integer(119), "INTO");
		terminalStringToIntMap.put("INTO", new Integer(119));
		terminalIntToStringMap.put(new Integer(98), "BYPOSITION");
		terminalStringToIntMap.put("BYPOSITION", new Integer(98));
		terminalIntToStringMap.put(new Integer(64), "FORM");
		terminalStringToIntMap.put("FORM", new Integer(64));
		terminalIntToStringMap.put(new Integer(137), "DECREMENT");
		terminalStringToIntMap.put("DECREMENT", new Integer(137));
		terminalIntToStringMap.put(new Integer(37), "WHERE");
		terminalStringToIntMap.put("WHERE", new Integer(37));
		terminalIntToStringMap.put(new Integer(171), "TIMES");
		terminalStringToIntMap.put("TIMES", new Integer(171));
		terminalIntToStringMap.put(new Integer(62), "RECORD");
		terminalStringToIntMap.put("RECORD", new Integer(62));
		terminalIntToStringMap.put(new Integer(85), "GOTO");
		terminalStringToIntMap.put("GOTO", new Integer(85));
		terminalIntToStringMap.put(new Integer(49), "INLINE_DLI");
		terminalStringToIntMap.put("INLINE_DLI", new Integer(49));
		terminalIntToStringMap.put(new Integer(10), "BIGINT");
		terminalStringToIntMap.put("BIGINT", new Integer(10));
		terminalIntToStringMap.put(new Integer(146), "NIL");
		terminalStringToIntMap.put("NIL", new Integer(146));
		terminalIntToStringMap.put(new Integer(187), "UMINUS");
		terminalStringToIntMap.put("UMINUS", new Integer(187));
		terminalIntToStringMap.put(new Integer(115), "REPLACE");
		terminalStringToIntMap.put("REPLACE", new Integer(115));
		terminalIntToStringMap.put(new Integer(24), "UNICODE");
		terminalStringToIntMap.put("UNICODE", new Integer(24));
		terminalIntToStringMap.put(new Integer(181), "ESCAPE");
		terminalStringToIntMap.put("ESCAPE", new Integer(181));
		terminalIntToStringMap.put(new Integer(164), "EQ");
		terminalStringToIntMap.put("EQ", new Integer(164));
		terminalIntToStringMap.put(new Integer(20), "NUM");
		terminalStringToIntMap.put("NUM", new Integer(20));
		terminalIntToStringMap.put(new Integer(66), "PROGRAM");
		terminalStringToIntMap.put("PROGRAM", new Integer(66));
		terminalIntToStringMap.put(new Integer(172), "TIMESTIMES");
		terminalStringToIntMap.put("TIMESTIMES", new Integer(172));
		terminalIntToStringMap.put(new Integer(21), "NUMC");
		terminalStringToIntMap.put("NUMC", new Integer(21));
		terminalIntToStringMap.put(new Integer(112), "ADD");
		terminalStringToIntMap.put("ADD", new Integer(112));
		terminalIntToStringMap.put(new Integer(68), "TYPE");
		terminalStringToIntMap.put("TYPE", new Integer(68));
		terminalIntToStringMap.put(new Integer(130), "RELATIVE");
		terminalStringToIntMap.put("RELATIVE", new Integer(130));
		terminalIntToStringMap.put(new Integer(173), "DIV");
		terminalStringToIntMap.put("DIV", new Integer(173));
		terminalIntToStringMap.put(new Integer(45), "PRIMITIVE");
		terminalStringToIntMap.put("PRIMITIVE", new Integer(45));
		terminalIntToStringMap.put(new Integer(3), "EOS");
		terminalStringToIntMap.put("EOS", new Integer(3));
		terminalIntToStringMap.put(new Integer(27), "CLOB");
		terminalStringToIntMap.put("CLOB", new Integer(27));
		terminalIntToStringMap.put(new Integer(162), "ASSIGN");
		terminalStringToIntMap.put("ASSIGN", new Integer(162));
		terminalIntToStringMap.put(new Integer(107), "LABEL");
		terminalStringToIntMap.put("LABEL", new Integer(107));
		terminalIntToStringMap.put(new Integer(132), "PREPARE");
		terminalStringToIntMap.put("PREPARE", new Integer(132));
		terminalIntToStringMap.put(new Integer(11), "BIN");
		terminalStringToIntMap.put("BIN", new Integer(11));
		terminalIntToStringMap.put(new Integer(125), "PREVIOUS");
		terminalStringToIntMap.put("PREVIOUS", new Integer(125));
		terminalIntToStringMap.put(new Integer(54), "PRIVATE");
		terminalStringToIntMap.put("PRIVATE", new Integer(54));
		terminalIntToStringMap.put(new Integer(25), "STRINGPRIMITIVE");
		terminalStringToIntMap.put("STRINGPRIMITIVE", new Integer(25));
		terminalIntToStringMap.put(new Integer(0), "EOF");
		terminalStringToIntMap.put("EOF", new Integer(0));
		terminalIntToStringMap.put(new Integer(170), "MINUS");
		terminalStringToIntMap.put("MINUS", new Integer(170));
		terminalIntToStringMap.put(new Integer(60), "LIBRARY");
		terminalStringToIntMap.put("LIBRARY", new Integer(60));
		terminalIntToStringMap.put(new Integer(17), "INT");
		terminalStringToIntMap.put("INT", new Integer(17));
		terminalIntToStringMap.put(new Integer(34), "LANGUAGEBUNDLE");
		terminalStringToIntMap.put("LANGUAGEBUNDLE", new Integer(34));
		terminalIntToStringMap.put(new Integer(23), "SMALLINT");
		terminalStringToIntMap.put("SMALLINT", new Integer(23));
		terminalIntToStringMap.put(new Integer(88), "MOVE");
		terminalStringToIntMap.put("MOVE", new Integer(88));
		terminalIntToStringMap.put(new Integer(57), "IMPORT");
		terminalStringToIntMap.put("IMPORT", new Integer(57));
		terminalIntToStringMap.put(new Integer(56), "PACKAGE");
		terminalStringToIntMap.put("PACKAGE", new Integer(56));
		terminalIntToStringMap.put(new Integer(120), "USING");
		terminalStringToIntMap.put("USING", new Integer(120));
		terminalIntToStringMap.put(new Integer(14), "DBCHAR");
		terminalStringToIntMap.put("DBCHAR", new Integer(14));
		terminalIntToStringMap.put(new Integer(9), "ANY");
		terminalStringToIntMap.put("ANY", new Integer(9));
		terminalIntToStringMap.put(new Integer(97), "BYNAME");
		terminalStringToIntMap.put("BYNAME", new Integer(97));
		terminalIntToStringMap.put(new Integer(87), "ELSE");
		terminalStringToIntMap.put("ELSE", new Integer(87));
		terminalIntToStringMap.put(new Integer(102), "TRY");
		terminalStringToIntMap.put("TRY", new Integer(102));
		terminalIntToStringMap.put(new Integer(129), "ABSOLUTE");
		terminalStringToIntMap.put("ABSOLUTE", new Integer(129));
		terminalIntToStringMap.put(new Integer(58), "END");
		terminalStringToIntMap.put("END", new Integer(58));
		terminalIntToStringMap.put(new Integer(13), "CHAR");
		terminalStringToIntMap.put("CHAR", new Integer(13));
		terminalIntToStringMap.put(new Integer(183), "OR");
		terminalStringToIntMap.put("OR", new Integer(183));
		terminalIntToStringMap.put(new Integer(19), "NUMBER");
		terminalStringToIntMap.put("NUMBER", new Integer(19));
		terminalIntToStringMap.put(new Integer(122), "FIRST");
		terminalStringToIntMap.put("FIRST", new Integer(122));
		terminalIntToStringMap.put(new Integer(139), "HANDLER");
		terminalStringToIntMap.put("HANDLER", new Integer(139));
		terminalIntToStringMap.put(new Integer(81), "WHEN");
		terminalStringToIntMap.put("WHEN", new Integer(81));
		terminalIntToStringMap.put(new Integer(182), "AND");
		terminalStringToIntMap.put("AND", new Integer(182));
		terminalIntToStringMap.put(new Integer(128), "CURRENT");
		terminalStringToIntMap.put("CURRENT", new Integer(128));
		terminalIntToStringMap.put(new Integer(144), "THIS");
		terminalStringToIntMap.put("THIS", new Integer(144));
		terminalIntToStringMap.put(new Integer(8), "ERROR_INLINE_DLI");
		terminalStringToIntMap.put("ERROR_INLINE_DLI", new Integer(8));
		terminalIntToStringMap.put(new Integer(180), "MATCHES");
		terminalStringToIntMap.put("MATCHES", new Integer(180));
		terminalIntToStringMap.put(new Integer(35), "OF");
		terminalStringToIntMap.put("OF", new Integer(35));
		terminalIntToStringMap.put(new Integer(136), "BY");
		terminalStringToIntMap.put("BY", new Integer(136));
		terminalIntToStringMap.put(new Integer(71), "RETURNS");
		terminalStringToIntMap.put("RETURNS", new Integer(71));
		terminalIntToStringMap.put(new Integer(124), "NEXT");
		terminalStringToIntMap.put("NEXT", new Integer(124));
		terminalIntToStringMap.put(new Integer(154), "SEMI");
		terminalStringToIntMap.put("SEMI", new Integer(154));
		terminalIntToStringMap.put(new Integer(33), "GROUP");
		terminalStringToIntMap.put("GROUP", new Integer(33));
		terminalIntToStringMap.put(new Integer(123), "LAST");
		terminalStringToIntMap.put("LAST", new Integer(123));
		terminalIntToStringMap.put(new Integer(109), "CLOSE");
		terminalStringToIntMap.put("CLOSE", new Integer(109));
		terminalIntToStringMap.put(new Integer(12), "BOOLEAN");
		terminalStringToIntMap.put("BOOLEAN", new Integer(12));
		terminalIntToStringMap.put(new Integer(143), "NEW");
		terminalStringToIntMap.put("NEW", new Integer(143));
		terminalIntToStringMap.put(new Integer(113), "DELETE");
		terminalStringToIntMap.put("DELETE", new Integer(113));
		terminalIntToStringMap.put(new Integer(36), "REF");
		terminalStringToIntMap.put("REF", new Integer(36));
		terminalIntToStringMap.put(new Integer(15), "DECIMAL");
		terminalStringToIntMap.put("DECIMAL", new Integer(15));
		terminalIntToStringMap.put(new Integer(150), "INTERFACE");
		terminalStringToIntMap.put("INTERFACE", new Integer(150));
		terminalIntToStringMap.put(new Integer(185), "RCURLY");
		terminalStringToIntMap.put("RCURLY", new Integer(185));
		terminalIntToStringMap.put(new Integer(165), "NE");
		terminalStringToIntMap.put("NE", new Integer(165));
		terminalIntToStringMap.put(new Integer(110), "CONVERSE");
		terminalStringToIntMap.put("CONVERSE", new Integer(110));
		terminalIntToStringMap.put(new Integer(116), "PRINT");
		terminalStringToIntMap.put("PRINT", new Integer(116));
		terminalIntToStringMap.put(new Integer(147), "AT");
		terminalStringToIntMap.put("AT", new Integer(147));
		terminalIntToStringMap.put(new Integer(39), "AS");
		terminalStringToIntMap.put("AS", new Integer(39));
		terminalIntToStringMap.put(new Integer(32), "DLICALL");
		terminalStringToIntMap.put("DLICALL", new Integer(32));
		terminalIntToStringMap.put(new Integer(80), "CASE");
		terminalStringToIntMap.put("CASE", new Integer(80));
		terminalIntToStringMap.put(new Integer(16), "HEX");
		terminalStringToIntMap.put("HEX", new Integer(16));
		terminalIntToStringMap.put(new Integer(78), "EXTERNALLYDEFINED");
		terminalStringToIntMap.put("EXTERNALLYDEFINED", new Integer(78));
		terminalIntToStringMap.put(new Integer(163), "PLUS");
		terminalStringToIntMap.put("PLUS", new Integer(163));
		terminalIntToStringMap.put(new Integer(157), "LPAREN");
		terminalStringToIntMap.put("LPAREN", new Integer(157));
		terminalIntToStringMap.put(new Integer(99), "ALL");
		terminalStringToIntMap.put("ALL", new Integer(99));
		terminalIntToStringMap.put(new Integer(59), "DATAITEM");
		terminalStringToIntMap.put("DATAITEM", new Integer(59));
		terminalIntToStringMap.put(new Integer(156), "RBRACKET");
		terminalStringToIntMap.put("RBRACKET", new Integer(156));
		terminalIntToStringMap.put(new Integer(152), "USINGPCB");
		terminalStringToIntMap.put("USINGPCB", new Integer(152));
		terminalIntToStringMap.put(new Integer(111), "FORWARD");
		terminalStringToIntMap.put("FORWARD", new Integer(111));
		terminalIntToStringMap.put(new Integer(95), "WHILE");
		terminalStringToIntMap.put("WHILE", new Integer(95));
		terminalIntToStringMap.put(new Integer(188), "UPLUS");
		terminalStringToIntMap.put("UPLUS", new Integer(188));
		terminalIntToStringMap.put(new Integer(145), "CONST");
		terminalStringToIntMap.put("CONST", new Integer(145));
		terminalIntToStringMap.put(new Integer(18), "MBCHAR");
		terminalStringToIntMap.put("MBCHAR", new Integer(18));
		terminalIntToStringMap.put(new Integer(131), "OPEN");
		terminalStringToIntMap.put("OPEN", new Integer(131));
		terminalIntToStringMap.put(new Integer(153), "INPARENT");
		terminalStringToIntMap.put("INPARENT", new Integer(153));
		terminalIntToStringMap.put(new Integer(159), "COMMA");
		terminalStringToIntMap.put("COMMA", new Integer(159));
		terminalIntToStringMap.put(new Integer(70), "FIELD");
		terminalStringToIntMap.put("FIELD", new Integer(70));
		terminalIntToStringMap.put(new Integer(51), "TIME");
		terminalStringToIntMap.put("TIME", new Integer(51));
		terminalIntToStringMap.put(new Integer(166), "LT");
		terminalStringToIntMap.put("LT", new Integer(166));
		terminalIntToStringMap.put(new Integer(38), "WRAP");
		terminalStringToIntMap.put("WRAP", new Integer(38));
		terminalIntToStringMap.put(new Integer(52), "TIMESTAMP");
		terminalStringToIntMap.put("TIMESTAMP", new Integer(52));
		terminalIntToStringMap.put(new Integer(22), "PACF");
		terminalStringToIntMap.put("PACF", new Integer(22));
		terminalIntToStringMap.put(new Integer(91), "RETURNING");
		terminalStringToIntMap.put("RETURNING", new Integer(91));
		terminalIntToStringMap.put(new Integer(174), "MODULO");
		terminalStringToIntMap.put("MODULO", new Integer(174));
		terminalIntToStringMap.put(new Integer(142), "BIND");
		terminalStringToIntMap.put("BIND", new Integer(142));
		terminalIntToStringMap.put(new Integer(148), "SERVICE");
		terminalStringToIntMap.put("SERVICE", new Integer(148));
		terminalIntToStringMap.put(new Integer(50), "DATE");
		terminalStringToIntMap.put("DATE", new Integer(50));
		terminalIntToStringMap.put(new Integer(168), "LE");
		terminalStringToIntMap.put("LE", new Integer(168));
		terminalIntToStringMap.put(new Integer(176), "NOT");
		terminalStringToIntMap.put("NOT", new Integer(176));
		terminalIntToStringMap.put(new Integer(135), "SCROLL");
		terminalStringToIntMap.put("SCROLL", new Integer(135));
		terminalIntToStringMap.put(new Integer(75), "OUT");
		terminalStringToIntMap.put("OUT", new Integer(75));
		terminalIntToStringMap.put(new Integer(155), "LBRACKET");
		terminalStringToIntMap.put("LBRACKET", new Integer(155));
		terminalIntToStringMap.put(new Integer(106), "WITH");
		terminalStringToIntMap.put("WITH", new Integer(106));
		terminalIntToStringMap.put(new Integer(104), "SHOW");
		terminalStringToIntMap.put("SHOW", new Integer(104));
		terminalIntToStringMap.put(new Integer(178), "BANG");
		terminalStringToIntMap.put("BANG", new Integer(178));
		terminalIntToStringMap.put(new Integer(126), "SINGLEROW");
		terminalStringToIntMap.put("SINGLEROW", new Integer(126));
		terminalIntToStringMap.put(new Integer(127), "FORUPDATE");
		terminalStringToIntMap.put("FORUPDATE", new Integer(127));
		terminalIntToStringMap.put(new Integer(90), "RETURN");
		terminalStringToIntMap.put("RETURN", new Integer(90));
		terminalIntToStringMap.put(new Integer(46), "LOB");
		terminalStringToIntMap.put("LOB", new Integer(46));
		terminalIntToStringMap.put(new Integer(4), "WS");
		terminalStringToIntMap.put("WS", new Integer(4));
		terminalIntToStringMap.put(new Integer(41), "FLOATLIT");
		terminalStringToIntMap.put("FLOATLIT", new Integer(41));
		terminalIntToStringMap.put(new Integer(100), "FOR");
		terminalStringToIntMap.put("FOR", new Integer(100));
		terminalIntToStringMap.put(new Integer(67), "FUNCTION");
		terminalStringToIntMap.put("FUNCTION", new Integer(67));
		terminalIntToStringMap.put(new Integer(94), "TRANSACTION");
		terminalStringToIntMap.put("TRANSACTION", new Integer(94));
		terminalIntToStringMap.put(new Integer(44), "INTEGER");
		terminalStringToIntMap.put("INTEGER", new Integer(44));
		terminalIntToStringMap.put(new Integer(160), "DOT");
		terminalStringToIntMap.put("DOT", new Integer(160));
		terminalIntToStringMap.put(new Integer(121), "USINGKEYS");
		terminalStringToIntMap.put("USINGKEYS", new Integer(121));
		terminalIntToStringMap.put(new Integer(93), "TRANSFER");
		terminalStringToIntMap.put("TRANSFER", new Integer(93));
		terminalIntToStringMap.put(new Integer(43), "STRING");
		terminalStringToIntMap.put("STRING", new Integer(43));
		terminalIntToStringMap.put(new Integer(2), "BOS");
		terminalStringToIntMap.put("BOS", new Integer(2));
		terminalIntToStringMap.put(new Integer(133), "INSERT");
		terminalStringToIntMap.put("INSERT", new Integer(133));
		terminalIntToStringMap.put(new Integer(189), "CONTINUE");
		terminalStringToIntMap.put("CONTINUE", new Integer(189));
		terminalIntToStringMap.put(new Integer(29), "SMALLFLOAT");
		terminalStringToIntMap.put("SMALLFLOAT", new Integer(29));
		terminalIntToStringMap.put(new Integer(72), "USE");
		terminalStringToIntMap.put("USE", new Integer(72));
		terminalIntToStringMap.put(new Integer(73), "FROM");
		terminalStringToIntMap.put("FROM", new Integer(73));
		terminalIntToStringMap.put(new Integer(82), "OTHERWISE");
		terminalStringToIntMap.put("OTHERWISE", new Integer(82));
		terminalIntToStringMap.put(new Integer(69), "NULLABLE");
		terminalStringToIntMap.put("NULLABLE", new Integer(69));
		terminalIntToStringMap.put(new Integer(74), "EMBED");
		terminalStringToIntMap.put("EMBED", new Integer(74));
		terminalIntToStringMap.put(new Integer(141), "ONEVENT");
		terminalStringToIntMap.put("ONEVENT", new Integer(141));
		terminalIntToStringMap.put(new Integer(175), "IS");
		terminalStringToIntMap.put("IS", new Integer(175));
		terminalIntToStringMap.put(new Integer(84), "FOREACH");
		terminalStringToIntMap.put("FOREACH", new Integer(84));
		terminalIntToStringMap.put(new Integer(61), "PAGEHANDLER");
		terminalStringToIntMap.put("PAGEHANDLER", new Integer(61));
		terminalIntToStringMap.put(new Integer(30), "MONEY");
		terminalStringToIntMap.put("MONEY", new Integer(30));
		terminalIntToStringMap.put(new Integer(177), "IN");
		terminalStringToIntMap.put("IN", new Integer(177));
		terminalIntToStringMap.put(new Integer(108), "URL");
		terminalStringToIntMap.put("URL", new Integer(108));
		terminalIntToStringMap.put(new Integer(42), "DECIMALLIT");
		terminalStringToIntMap.put("DECIMALLIT", new Integer(42));
		terminalIntToStringMap.put(new Integer(1), "error");
		terminalStringToIntMap.put("error", new Integer(1));
		terminalIntToStringMap.put(new Integer(86), "IF");
		terminalStringToIntMap.put("IF", new Integer(86));
		terminalIntToStringMap.put(new Integer(40), "ID");
		terminalStringToIntMap.put("ID", new Integer(40));
		terminalIntToStringMap.put(new Integer(55), "STATIC");
		terminalStringToIntMap.put("STATIC", new Integer(55));
		terminalIntToStringMap.put(new Integer(101), "PASSING");
		terminalStringToIntMap.put("PASSING", new Integer(101));
		terminalIntToStringMap.put(new Integer(47), "SQLSTMTLIT");
		terminalStringToIntMap.put("SQLSTMTLIT", new Integer(47));
		terminalIntToStringMap.put(new Integer(161), "COLON");
		terminalStringToIntMap.put("COLON", new Integer(161));
		terminalIntToStringMap.put(new Integer(53), "INTERVAL");
		terminalStringToIntMap.put("INTERVAL", new Integer(53));
		terminalIntToStringMap.put(new Integer(92), "SET");
		terminalStringToIntMap.put("SET", new Integer(92));
		terminalIntToStringMap.put(new Integer(186), "ISA");
		terminalStringToIntMap.put("ISA", new Integer(186));
		terminalIntToStringMap.put(new Integer(140), "OPENUI");
		terminalStringToIntMap.put("OPENUI", new Integer(140));
		terminalIntToStringMap.put(new Integer(48), "SQLCONDITION");
		terminalStringToIntMap.put("SQLCONDITION", new Integer(48));
		terminalIntToStringMap.put(new Integer(184), "LCURLY");
		terminalStringToIntMap.put("LCURLY", new Integer(184));
		terminalIntToStringMap.put(new Integer(117), "EXECUTE");
		terminalStringToIntMap.put("EXECUTE", new Integer(117));
		terminalIntToStringMap.put(new Integer(5), "ERRORSTRING");
		terminalStringToIntMap.put("ERRORSTRING", new Integer(5));
		terminalIntToStringMap.put(new Integer(151), "EXTENDS");
		terminalStringToIntMap.put("EXTENDS", new Integer(151));
		terminalIntToStringMap.put(new Integer(63), "FORMGROUP");
		terminalStringToIntMap.put("FORMGROUP", new Integer(63));
		terminalIntToStringMap.put(new Integer(31), "SQL");
		terminalStringToIntMap.put("SQL", new Integer(31));
		terminalIntToStringMap.put(new Integer(118), "UPDATE");
		terminalStringToIntMap.put("UPDATE", new Integer(118));
		terminalIntToStringMap.put(new Integer(103), "ONEXCEPTION");
		terminalStringToIntMap.put("ONEXCEPTION", new Integer(103));
		terminalIntToStringMap.put(new Integer(89), "TO");
		terminalStringToIntMap.put("TO", new Integer(89));
		terminalIntToStringMap.put(new Integer(76), "INOUT");
		terminalStringToIntMap.put("INOUT", new Integer(76));
		nonterminalIntToStringMap.put(new Integer(83), "getByPositionSource");
		nonterminalStringToIntMap.put("getByPositionSource", new Integer(83));
		nonterminalIntToStringMap.put(new Integer(116), "programParameter_star");
		nonterminalStringToIntMap.put("programParameter_star", new Integer(116));
		nonterminalIntToStringMap.put(new Integer(74), "BoolExpr");
		nonterminalStringToIntMap.put("BoolExpr", new Integer(74));
		nonterminalIntToStringMap.put(new Integer(104), "structureContent_star");
		nonterminalStringToIntMap.put("structureContent_star", new Integer(104));
		nonterminalIntToStringMap.put(new Integer(71), "forwardTargetOpt");
		nonterminalStringToIntMap.put("forwardTargetOpt", new Integer(71));
		nonterminalIntToStringMap.put(new Integer(41), "occursOpt");
		nonterminalStringToIntMap.put("occursOpt", new Integer(41));
		nonterminalIntToStringMap.put(new Integer(84), "getByPositionOption");
		nonterminalStringToIntMap.put("getByPositionOption", new Integer(84));
		nonterminalIntToStringMap.put(new Integer(80), "inlineSQLStatementOpt");
		nonterminalStringToIntMap.put("inlineSQLStatementOpt", new Integer(80));
		nonterminalIntToStringMap.put(new Integer(15), "foreachTarget");
		nonterminalStringToIntMap.put("foreachTarget", new Integer(15));
		nonterminalIntToStringMap.put(new Integer(81), "ShowOptions");
		nonterminalStringToIntMap.put("ShowOptions", new Integer(81));
		nonterminalIntToStringMap.put(new Integer(46), "attrTypeOpt");
		nonterminalStringToIntMap.put("attrTypeOpt", new Integer(46));
		nonterminalIntToStringMap.put(new Integer(118), "callOpts_star");
		nonterminalStringToIntMap.put("callOpts_star", new Integer(118));
		nonterminalIntToStringMap.put(new Integer(45), "functionParameter");
		nonterminalStringToIntMap.put("functionParameter", new Integer(45));
		nonterminalIntToStringMap.put(new Integer(91), "resultSetIDOpt");
		nonterminalStringToIntMap.put("resultSetIDOpt", new Integer(91));
		nonterminalIntToStringMap.put(new Integer(82), "direction");
		nonterminalStringToIntMap.put("direction", new Integer(82));
		nonterminalIntToStringMap.put(new Integer(135), "propertyBlock_plus");
		nonterminalStringToIntMap.put("propertyBlock_plus", new Integer(135));
		nonterminalIntToStringMap.put(new Integer(38), "StructureContent");
		nonterminalStringToIntMap.put("StructureContent", new Integer(38));
		nonterminalIntToStringMap.put(new Integer(86), "getByKeyOptions");
		nonterminalStringToIntMap.put("getByKeyOptions", new Integer(86));
		nonterminalIntToStringMap.put(new Integer(69), "externallyDefinedOpt");
		nonterminalStringToIntMap.put("externallyDefinedOpt", new Integer(69));
		nonterminalIntToStringMap.put(new Integer(133), "showOptions_plus");
		nonterminalStringToIntMap.put("showOptions_plus", new Integer(133));
		nonterminalIntToStringMap.put(new Integer(77), "Condit");
		nonterminalStringToIntMap.put("Condit", new Integer(77));
		nonterminalIntToStringMap.put(new Integer(28), "staticAccessModifierOpt");
		nonterminalStringToIntMap.put("staticAccessModifierOpt", new Integer(28));
		nonterminalIntToStringMap.put(new Integer(144), "executeOption_star");
		nonterminalStringToIntMap.put("executeOption_star", new Integer(144));
		nonterminalIntToStringMap.put(new Integer(0), "$START");
		nonterminalStringToIntMap.put("$START", new Integer(0));
		nonterminalIntToStringMap.put(new Integer(2), "connector");
		nonterminalStringToIntMap.put("connector", new Integer(2));
		nonterminalIntToStringMap.put(new Integer(57), "criterionOpt");
		nonterminalStringToIntMap.put("criterionOpt", new Integer(57));
		nonterminalIntToStringMap.put(new Integer(48), "returnsOpt");
		nonterminalStringToIntMap.put("returnsOpt", new Integer(48));
		nonterminalIntToStringMap.put(new Integer(140), "addOption_star");
		nonterminalStringToIntMap.put("addOption_star", new Integer(140));
		nonterminalIntToStringMap.put(new Integer(120), "whenClause_star");
		nonterminalStringToIntMap.put("whenClause_star", new Integer(120));
		nonterminalIntToStringMap.put(new Integer(21), "extendsOpt");
		nonterminalStringToIntMap.put("extendsOpt", new Integer(21));
		nonterminalIntToStringMap.put(new Integer(130), "getByKeyOptions_star");
		nonterminalStringToIntMap.put("getByKeyOptions_star", new Integer(130));
		nonterminalIntToStringMap.put(new Integer(96), "ExecuteOption");
		nonterminalStringToIntMap.put("ExecuteOption", new Integer(96));
		nonterminalIntToStringMap.put(new Integer(55), "callArgument");
		nonterminalStringToIntMap.put("callArgument", new Integer(55));
		nonterminalIntToStringMap.put(new Integer(17), "packageDeclarationOpt");
		nonterminalStringToIntMap.put("packageDeclarationOpt", new Integer(17));
		nonterminalIntToStringMap.put(new Integer(162), "interfaceContent_plus");
		nonterminalStringToIntMap.put("interfaceContent_plus", new Integer(162));
		nonterminalIntToStringMap.put(new Integer(31), "ClassContent");
		nonterminalStringToIntMap.put("ClassContent", new Integer(31));
		nonterminalIntToStringMap.put(new Integer(44), "programParameter");
		nonterminalStringToIntMap.put("programParameter", new Integer(44));
		nonterminalIntToStringMap.put(new Integer(101), "importStatement_plus");
		nonterminalStringToIntMap.put("importStatement_plus", new Integer(101));
		nonterminalIntToStringMap.put(new Integer(93), "AddOption");
		nonterminalStringToIntMap.put("AddOption", new Integer(93));
		nonterminalIntToStringMap.put(new Integer(37), "programParametersOpt");
		nonterminalStringToIntMap.put("programParametersOpt", new Integer(37));
		nonterminalIntToStringMap.put(new Integer(94), "converseWithClauseOpt");
		nonterminalStringToIntMap.put("converseWithClauseOpt", new Integer(94));
		nonterminalIntToStringMap.put(new Integer(9), "eventBlock");
		nonterminalStringToIntMap.put("eventBlock", new Integer(9));
		nonterminalIntToStringMap.put(new Integer(92), "DeleteOption");
		nonterminalStringToIntMap.put("DeleteOption", new Integer(92));
		nonterminalIntToStringMap.put(new Integer(35), "Type");
		nonterminalStringToIntMap.put("Type", new Integer(35));
		nonterminalIntToStringMap.put(new Integer(160), "eventBlock_plus");
		nonterminalStringToIntMap.put("eventBlock_plus", new Integer(160));
		nonterminalIntToStringMap.put(new Integer(88), "OpenTarget");
		nonterminalStringToIntMap.put("OpenTarget", new Integer(88));
		nonterminalIntToStringMap.put(new Integer(53), "functionInvocation");
		nonterminalStringToIntMap.put("functionInvocation", new Integer(53));
		nonterminalIntToStringMap.put(new Integer(60), "MatchExpr");
		nonterminalStringToIntMap.put("MatchExpr", new Integer(60));
		nonterminalIntToStringMap.put(new Integer(107), "formGroupContent_plus");
		nonterminalStringToIntMap.put("formGroupContent_plus", new Integer(107));
		nonterminalIntToStringMap.put(new Integer(113), "functionParameter_plus");
		nonterminalStringToIntMap.put("functionParameter_plus", new Integer(113));
		nonterminalIntToStringMap.put(new Integer(33), "DataAccess");
		nonterminalStringToIntMap.put("DataAccess", new Integer(33));
		nonterminalIntToStringMap.put(new Integer(155), "name_plus");
		nonterminalStringToIntMap.put("name_plus", new Integer(155));
		nonterminalIntToStringMap.put(new Integer(134), "propertyBlock_star");
		nonterminalStringToIntMap.put("propertyBlock_star", new Integer(134));
		nonterminalIntToStringMap.put(new Integer(132), "showOptions_star");
		nonterminalStringToIntMap.put("showOptions_star", new Integer(132));
		nonterminalIntToStringMap.put(new Integer(66), "programOpt");
		nonterminalStringToIntMap.put("programOpt", new Integer(66));
		nonterminalIntToStringMap.put(new Integer(58), "whenClause");
		nonterminalStringToIntMap.put("whenClause", new Integer(58));
		nonterminalIntToStringMap.put(new Integer(139), "replaceOption_plus");
		nonterminalStringToIntMap.put("replaceOption_plus", new Integer(139));
		nonterminalIntToStringMap.put(new Integer(67), "TransferTarget");
		nonterminalStringToIntMap.put("TransferTarget", new Integer(67));
		nonterminalIntToStringMap.put(new Integer(76), "ArgExpr");
		nonterminalStringToIntMap.put("ArgExpr", new Integer(76));
		nonterminalIntToStringMap.put(new Integer(89), "PrepareOption");
		nonterminalStringToIntMap.put("PrepareOption", new Integer(89));
		nonterminalIntToStringMap.put(new Integer(149), "forwardOption_plus");
		nonterminalStringToIntMap.put("forwardOption_plus", new Integer(149));
		nonterminalIntToStringMap.put(new Integer(23), "importSpec");
		nonterminalStringToIntMap.put("importSpec", new Integer(23));
		nonterminalIntToStringMap.put(new Integer(127), "propertyDecl_plus");
		nonterminalStringToIntMap.put("propertyDecl_plus", new Integer(127));
		nonterminalIntToStringMap.put(new Integer(61), "ExitModifierOpt");
		nonterminalStringToIntMap.put("ExitModifierOpt", new Integer(61));
		nonterminalIntToStringMap.put(new Integer(64), "elseOpt");
		nonterminalStringToIntMap.put("elseOpt", new Integer(64));
		nonterminalIntToStringMap.put(new Integer(4), "wsPair");
		nonterminalStringToIntMap.put("wsPair", new Integer(4));
		nonterminalIntToStringMap.put(new Integer(161), "interfaceContent_star");
		nonterminalStringToIntMap.put("interfaceContent_star", new Integer(161));
		nonterminalIntToStringMap.put(new Integer(18), "Part");
		nonterminalStringToIntMap.put("Part", new Integer(18));
		nonterminalIntToStringMap.put(new Integer(129), "dataAccess_plus");
		nonterminalStringToIntMap.put("dataAccess_plus", new Integer(129));
		nonterminalIntToStringMap.put(new Integer(100), "importStatement_star");
		nonterminalStringToIntMap.put("importStatement_star", new Integer(100));
		nonterminalIntToStringMap.put(new Integer(29), "Name");
		nonterminalStringToIntMap.put("Name", new Integer(29));
		nonterminalIntToStringMap.put(new Integer(147), "moveModifier_plus");
		nonterminalStringToIntMap.put("moveModifier_plus", new Integer(147));
		nonterminalIntToStringMap.put(new Integer(123), "openTarget_plus");
		nonterminalStringToIntMap.put("openTarget_plus", new Integer(123));
		nonterminalIntToStringMap.put(new Integer(99), "stepOpt");
		nonterminalStringToIntMap.put("stepOpt", new Integer(99));
		nonterminalIntToStringMap.put(new Integer(11), "literalArray");
		nonterminalStringToIntMap.put("literalArray", new Integer(11));
		nonterminalIntToStringMap.put(new Integer(159), "eventBlock_star");
		nonterminalStringToIntMap.put("eventBlock_star", new Integer(159));
		nonterminalIntToStringMap.put(new Integer(47), "useTypeOpt");
		nonterminalStringToIntMap.put("useTypeOpt", new Integer(47));
		nonterminalIntToStringMap.put(new Integer(75), "Expr");
		nonterminalStringToIntMap.put("Expr", new Integer(75));
		nonterminalIntToStringMap.put(new Integer(106), "formGroupContent_star");
		nonterminalStringToIntMap.put("formGroupContent_star", new Integer(106));
		nonterminalIntToStringMap.put(new Integer(112), "functionParameter_star");
		nonterminalStringToIntMap.put("functionParameter_star", new Integer(112));
		nonterminalIntToStringMap.put(new Integer(12), "fieldsOpt");
		nonterminalStringToIntMap.put("fieldsOpt", new Integer(12));
		nonterminalIntToStringMap.put(new Integer(7), "initializerOpt");
		nonterminalStringToIntMap.put("initializerOpt", new Integer(7));
		nonterminalIntToStringMap.put(new Integer(138), "replaceOption_star");
		nonterminalStringToIntMap.put("replaceOption_star", new Integer(138));
		nonterminalIntToStringMap.put(new Integer(125), "expr_plus");
		nonterminalStringToIntMap.put("expr_plus", new Integer(125));
		nonterminalIntToStringMap.put(new Integer(148), "forwardOption_star");
		nonterminalStringToIntMap.put("forwardOption_star", new Integer(148));
		nonterminalIntToStringMap.put(new Integer(115), "stmt_plus");
		nonterminalStringToIntMap.put("stmt_plus", new Integer(115));
		nonterminalIntToStringMap.put(new Integer(1), "UltraRoot");
		nonterminalStringToIntMap.put("UltraRoot", new Integer(1));
		nonterminalIntToStringMap.put(new Integer(126), "propertyDecl_star");
		nonterminalStringToIntMap.put("propertyDecl_star", new Integer(126));
		nonterminalIntToStringMap.put(new Integer(109), "formContent_plus");
		nonterminalStringToIntMap.put("formContent_plus", new Integer(109));
		nonterminalIntToStringMap.put(new Integer(52), "precisionOpt");
		nonterminalStringToIntMap.put("precisionOpt", new Integer(52));
		nonterminalIntToStringMap.put(new Integer(51), "literal");
		nonterminalStringToIntMap.put("literal", new Integer(51));
		nonterminalIntToStringMap.put(new Integer(111), "classContent_plus");
		nonterminalStringToIntMap.put("classContent_plus", new Integer(111));
		nonterminalIntToStringMap.put(new Integer(151), "dimension_plus");
		nonterminalStringToIntMap.put("dimension_plus", new Integer(151));
		nonterminalIntToStringMap.put(new Integer(128), "dataAccess_star");
		nonterminalStringToIntMap.put("dataAccess_star", new Integer(128));
		nonterminalIntToStringMap.put(new Integer(59), "defaultClauseOpt");
		nonterminalStringToIntMap.put("defaultClauseOpt", new Integer(59));
		nonterminalIntToStringMap.put(new Integer(14), "continueModifierOpt");
		nonterminalStringToIntMap.put("continueModifierOpt", new Integer(14));
		nonterminalIntToStringMap.put(new Integer(63), "ifWhileCondition");
		nonterminalStringToIntMap.put("ifWhileCondition", new Integer(63));
		nonterminalIntToStringMap.put(new Integer(27), "privateAccessModifierOpt");
		nonterminalStringToIntMap.put("privateAccessModifierOpt", new Integer(27));
		nonterminalIntToStringMap.put(new Integer(146), "moveModifier_star");
		nonterminalStringToIntMap.put("moveModifier_star", new Integer(146));
		nonterminalIntToStringMap.put(new Integer(13), "inparentOpt");
		nonterminalStringToIntMap.put("inparentOpt", new Integer(13));
		nonterminalIntToStringMap.put(new Integer(3), "ErrorNode");
		nonterminalStringToIntMap.put("ErrorNode", new Integer(3));
		nonterminalIntToStringMap.put(new Integer(30), "simpleName");
		nonterminalStringToIntMap.put("simpleName", new Integer(30));
		nonterminalIntToStringMap.put(new Integer(164), "getByPositionOption_plus");
		nonterminalStringToIntMap.put("getByPositionOption_plus", new Integer(164));
		nonterminalIntToStringMap.put(new Integer(25), "propertyBlockOpt");
		nonterminalStringToIntMap.put("propertyBlockOpt", new Integer(25));
		nonterminalIntToStringMap.put(new Integer(153), "functionArgument_plus");
		nonterminalStringToIntMap.put("functionArgument_plus", new Integer(153));
		nonterminalIntToStringMap.put(new Integer(122), "openTarget_star");
		nonterminalStringToIntMap.put("openTarget_star", new Integer(122));
		nonterminalIntToStringMap.put(new Integer(5), "DateTimeType");
		nonterminalStringToIntMap.put("DateTimeType", new Integer(5));
		nonterminalIntToStringMap.put(new Integer(103), "part_plus");
		nonterminalStringToIntMap.put("part_plus", new Integer(103));
		nonterminalIntToStringMap.put(new Integer(26), "PropertyDecl");
		nonterminalStringToIntMap.put("PropertyDecl", new Integer(26));
		nonterminalIntToStringMap.put(new Integer(19), "partSubTypeOpt");
		nonterminalStringToIntMap.put("partSubTypeOpt", new Integer(19));
		nonterminalIntToStringMap.put(new Integer(49), "nullableOpt");
		nonterminalStringToIntMap.put("nullableOpt", new Integer(49));
		nonterminalIntToStringMap.put(new Integer(62), "exitReturnOpt");
		nonterminalStringToIntMap.put("exitReturnOpt", new Integer(62));
		nonterminalIntToStringMap.put(new Integer(143), "deleteOption_plus");
		nonterminalStringToIntMap.put("deleteOption_plus", new Integer(143));
		nonterminalIntToStringMap.put(new Integer(40), "StrItemDecl");
		nonterminalStringToIntMap.put("StrItemDecl", new Integer(40));
		nonterminalIntToStringMap.put(new Integer(90), "ReplaceOption");
		nonterminalStringToIntMap.put("ReplaceOption", new Integer(90));
		nonterminalIntToStringMap.put(new Integer(154), "simpleName_plus");
		nonterminalStringToIntMap.put("simpleName_plus", new Integer(154));
		nonterminalIntToStringMap.put(new Integer(124), "expr_star");
		nonterminalStringToIntMap.put("expr_star", new Integer(124));
		nonterminalIntToStringMap.put(new Integer(114), "stmt_star");
		nonterminalStringToIntMap.put("stmt_star", new Integer(114));
		nonterminalIntToStringMap.put(new Integer(24), "propertyBlock");
		nonterminalStringToIntMap.put("propertyBlock", new Integer(24));
		nonterminalIntToStringMap.put(new Integer(108), "formContent_star");
		nonterminalStringToIntMap.put("formContent_star", new Integer(108));
		nonterminalIntToStringMap.put(new Integer(137), "prepareOption_plus");
		nonterminalStringToIntMap.put("prepareOption_plus", new Integer(137));
		nonterminalIntToStringMap.put(new Integer(65), "MoveModifier");
		nonterminalStringToIntMap.put("MoveModifier", new Integer(65));
		nonterminalIntToStringMap.put(new Integer(85), "intoClauseOpt");
		nonterminalStringToIntMap.put("intoClauseOpt", new Integer(85));
		nonterminalIntToStringMap.put(new Integer(157), "callArgument_plus");
		nonterminalStringToIntMap.put("callArgument_plus", new Integer(157));
		nonterminalIntToStringMap.put(new Integer(72), "ForwardOption");
		nonterminalStringToIntMap.put("ForwardOption", new Integer(72));
		nonterminalIntToStringMap.put(new Integer(56), "CallOpts");
		nonterminalStringToIntMap.put("CallOpts", new Integer(56));
		nonterminalIntToStringMap.put(new Integer(110), "classContent_star");
		nonterminalStringToIntMap.put("classContent_star", new Integer(110));
		nonterminalIntToStringMap.put(new Integer(50), "Stmt");
		nonterminalStringToIntMap.put("Stmt", new Integer(50));
		nonterminalIntToStringMap.put(new Integer(150), "dimension_star");
		nonterminalStringToIntMap.put("dimension_star", new Integer(150));
		nonterminalIntToStringMap.put(new Integer(95), "executeTarget");
		nonterminalStringToIntMap.put("executeTarget", new Integer(95));
		nonterminalIntToStringMap.put(new Integer(22), "importStatement");
		nonterminalStringToIntMap.put("importStatement", new Integer(22));
		nonterminalIntToStringMap.put(new Integer(79), "inlineSQLStatement");
		nonterminalStringToIntMap.put("inlineSQLStatement", new Integer(79));
		nonterminalIntToStringMap.put(new Integer(32), "InterfaceContent");
		nonterminalStringToIntMap.put("InterfaceContent", new Integer(32));
		nonterminalIntToStringMap.put(new Integer(98), "fromOpt");
		nonterminalStringToIntMap.put("fromOpt", new Integer(98));
		nonterminalIntToStringMap.put(new Integer(117), "programParameter_plus");
		nonterminalStringToIntMap.put("programParameter_plus", new Integer(117));
		nonterminalIntToStringMap.put(new Integer(105), "structureContent_plus");
		nonterminalStringToIntMap.put("structureContent_plus", new Integer(105));
		nonterminalIntToStringMap.put(new Integer(68), "passingRecordOpt");
		nonterminalStringToIntMap.put("passingRecordOpt", new Integer(68));
		nonterminalIntToStringMap.put(new Integer(34), "returnValueOpt");
		nonterminalStringToIntMap.put("returnValueOpt", new Integer(34));
		nonterminalIntToStringMap.put(new Integer(163), "getByPositionOption_star");
		nonterminalStringToIntMap.put("getByPositionOption_star", new Integer(163));
		nonterminalIntToStringMap.put(new Integer(97), "labelOpt");
		nonterminalStringToIntMap.put("labelOpt", new Integer(97));
		nonterminalIntToStringMap.put(new Integer(87), "openModifiersOpt");
		nonterminalStringToIntMap.put("openModifiersOpt", new Integer(87));
		nonterminalIntToStringMap.put(new Integer(70), "onExceptOpt");
		nonterminalStringToIntMap.put("onExceptOpt", new Integer(70));
		nonterminalIntToStringMap.put(new Integer(152), "functionArgument_star");
		nonterminalStringToIntMap.put("functionArgument_star", new Integer(152));
		nonterminalIntToStringMap.put(new Integer(102), "part_star");
		nonterminalStringToIntMap.put("part_star", new Integer(102));
		nonterminalIntToStringMap.put(new Integer(73), "labelKeywordOpt");
		nonterminalStringToIntMap.put("labelKeywordOpt", new Integer(73));
		nonterminalIntToStringMap.put(new Integer(119), "callOpts_plus");
		nonterminalStringToIntMap.put("callOpts_plus", new Integer(119));
		nonterminalIntToStringMap.put(new Integer(36), "dimension");
		nonterminalStringToIntMap.put("dimension", new Integer(36));
		nonterminalIntToStringMap.put(new Integer(39), "levelOpt");
		nonterminalStringToIntMap.put("levelOpt", new Integer(39));
		nonterminalIntToStringMap.put(new Integer(158), "setMnemonic_plus");
		nonterminalStringToIntMap.put("setMnemonic_plus", new Integer(158));
		nonterminalIntToStringMap.put(new Integer(43), "FormGroupContent");
		nonterminalStringToIntMap.put("FormGroupContent", new Integer(43));
		nonterminalIntToStringMap.put(new Integer(142), "deleteOption_star");
		nonterminalStringToIntMap.put("deleteOption_star", new Integer(142));
		nonterminalIntToStringMap.put(new Integer(54), "functionArgument");
		nonterminalStringToIntMap.put("functionArgument", new Integer(54));
		nonterminalIntToStringMap.put(new Integer(145), "executeOption_plus");
		nonterminalStringToIntMap.put("executeOption_plus", new Integer(145));
		nonterminalIntToStringMap.put(new Integer(6), "dateTimeSpecOpt");
		nonterminalStringToIntMap.put("dateTimeSpecOpt", new Integer(6));
		nonterminalIntToStringMap.put(new Integer(8), "bindOpt");
		nonterminalStringToIntMap.put("bindOpt", new Integer(8));
		nonterminalIntToStringMap.put(new Integer(20), "implementsOpt");
		nonterminalStringToIntMap.put("implementsOpt", new Integer(20));
		nonterminalIntToStringMap.put(new Integer(10), "setMnemonic");
		nonterminalStringToIntMap.put("setMnemonic", new Integer(10));
		nonterminalIntToStringMap.put(new Integer(16), "egl");
		nonterminalStringToIntMap.put("egl", new Integer(16));
		nonterminalIntToStringMap.put(new Integer(136), "prepareOption_star");
		nonterminalStringToIntMap.put("prepareOption_star", new Integer(136));
		nonterminalIntToStringMap.put(new Integer(156), "callArgument_star");
		nonterminalStringToIntMap.put("callArgument_star", new Integer(156));
		nonterminalIntToStringMap.put(new Integer(141), "addOption_plus");
		nonterminalStringToIntMap.put("addOption_plus", new Integer(141));
		nonterminalIntToStringMap.put(new Integer(42), "FormContent");
		nonterminalStringToIntMap.put("FormContent", new Integer(42));
		nonterminalIntToStringMap.put(new Integer(121), "whenClause_plus");
		nonterminalStringToIntMap.put("whenClause_plus", new Integer(121));
		nonterminalIntToStringMap.put(new Integer(78), "escapeOpt");
		nonterminalStringToIntMap.put("escapeOpt", new Integer(78));
		nonterminalIntToStringMap.put(new Integer(131), "getByKeyOptions_plus");
		nonterminalStringToIntMap.put("getByKeyOptions_plus", new Integer(131));
	}

	private EGLNodeNameUtility() {
	}

	public static int getNonterminalCount() {
		return nonterminalStringToIntMap.size();
	}

	public static String getTerminalName(int terminalType) {
		return (String) (terminalIntToStringMap.get(new Integer(terminalType)));
	}

	public static String getNonterminalName(int nonterminalType) {
		return (String) (nonterminalIntToStringMap.get(new Integer(nonterminalType)));
	}

	public static int getTerminalType(String terminalName) {
		return ((Integer) (terminalStringToIntMap.get(terminalName))).intValue();
	}

	public static int getNonterminalType(String nonterminalName) {
		return ((Integer) (nonterminalStringToIntMap.get(nonterminalName))).intValue();
	}

}
