/*******************************************************************************
 * Copyright © 2008, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
// NLS_ENCODING=UTF-8
// NLS_MESSAGEFORMAT_VAR
//
// Guidelines for defining Rich UI messages:  
// (1) DO NOT change the variable, "egl.eze$$rscBundles["RuiMessages"]"
// (2) The general format of a message is:
//          'MessageId'  :   'Message Text: {n}'
// (3) 'MessageId' (eg: CRRUI2007E) is composed of 4 parts:
//        - the first 5 characters is product identification, must be 'CRRUI'  
//        - the sixth character is a digit which identifies the component:
//                '0' -  Others       ( used to be 'E' )
//                '1' -  Widget       ( used to be 'I' )
//                '2' -  Runtime      ( used to be 'R' )
//                '3' -  Service      ( used to be 'S' )
//        - the 7th to 9th characters identifies message number, eg: '001'
//        - the 10th character identifies the message type:
//                'E' - error message
//                'I' - informational message
//                'W' - warning message
// (5)The message text may contain 1 or more message inserts, 
//         eg: {n},  where n is a 0 based number
// (6)Insert the message in alphabetical and numeric sort order  
//    against the MessageId to avoid conflicts which can be 
//    difficult to track at runtime            
//
egl.eze$$rscBundles["RuiMessages"] =
{
		'CRRUI0001E' : 'InitalUI[{0}]InitialUI \uc774\ub984\uc774 \ube44\uc5b4 \uc788\uc2b5\ub2c8\ub2e4. \ud568\uc218 \ud638\ucd9c\uc744 \uc0ac\uc6a9\ud558\uc5ec \uc774\ub984\uc744 \ucd08\uae30\ud654\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.',		
		'CRRUI0006E' : '{0} RadioGroup \uadf8\ub8f9\uc5d0 \uc798\ubabb\ub41c \uc778\uc218\uac00 \uc788\uc2b5\ub2c8\ub2e4.',
					
		'CRRUI1001E' : '{0} \ubcc0\uc218\ub294 {1}\uc744(\ub97c) {2}(\uc73c)\ub85c \uc124\uc815\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.',
		'CRRUI1010E' : '\ub04c\uc5b4\uc11c \ub193\uae30 \uae30\ub2a5\uc740 \uae30\ub2a5 \ucc38\uc870\uc785\ub2c8\ub2e4. \ubc30\uc5f4\uc774 \uc544\ub2d9\ub2c8\ub2e4: {0}',
		'CRRUI1020E' : 'Runtime.asDictionary: \ud578\ub4e4\ub7ec \ub610\ub294 \ub808\ucf54\ub4dc\ub9cc {0}\uc774(\uac00) \uc544\ub2cc \uc0ac\uc804\uc73c\ub85c \ubcc0\ud658\ud560 \uc218 \uc788\uc2b5\ub2c8\ub2e4.',
		'CRRUI1030E' : '{0}.{1}\uc5d0 \ub300\ud55c \uc815\uc758\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.',
		'CRRUI1050E' : '{0} \ubcc0\uc218\uc5d0 \"null\"\uc774 \ud3ec\ud568\ub418\uc5b4\uc57c \ud569\ub2c8\ub2e4.',
		'CRRUI1051E' : '\uc704\uc82f\uc744 {0} \ubcc0\uc218\uc5d0 \ucd94\uac00\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.',
		'CRRUI1055E' : '{1} \ud558\uc704\ub97c {2} \ubcc0\uc218\uc5d0 \ucd94\uac00\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.',		
		'CRRUI1057E' : '{0} \uc704\uc82f\uc744 \uc790\uccb4\uc5d0 \ucd94\uac00\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.',	
		'CRRUI1058E' : '{1} \uc0c1\uc704\ub97c {0} \ubcc0\uc218\uc5d0 \ucd94\uac00\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. {2}\uc740(\ub294) \ud604\uc7ac \uc0c1\uc704\uc785\ub2c8\ub2e4.',
		'CRRUI1060E' : '\uc704\uc82f \"{0}\"\uc758 \uc0c1\uc704\ub97c {1}:{2}\uc5d0 \uc124\uc815\ud558\ub824\uace0 \ud569\ub2c8\ub2e4. \uc0c1\uc704\ub294 \uc704\uc82f\uc774\uc5b4\uc57c \ud569\ub2c8\ub2e4.',
		'CRRUI1070E' : '\ucf5c\ubc31 \ud568\uc218\ub97c \ucc98\ub9ac\ud558\ub294 \uc911\uc5d0 {0} \uc608\uc678\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. try...OnException\uc744 \uc0ac\uc6a9\ud558\uc2ed\uc2dc\uc624.',
		'CRRUI1071E' : '\uc11c\ube44\uc2a4 \ud638\ucd9c\uc758 \uc608\uc678 \ud578\ub4e4\ub7ec\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc11c\ube44\uc2a4 \ud638\ucd9c\uc758 \uc608\uc678 \ud578\ub4e4\ub7ec\ub97c \ucd94\uac00\ud558\uc2ed\uc2dc\uc624.',
		'CRRUI1072E' : '\uc624\ub958 \ucf5c\ubc31 \ud568\uc218\uc5d0\uc11c {0} \uc608\uc678\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. try...OnException\uc73c\ub85c \ucf54\ub4dc\ud558\uc2ed\uc2dc\uc624.',		
		'CRRUI1080E' : '\uc704\uc82f\uc5d0 \ubb38\uc11c \uc624\ube0c\uc81d\ud2b8 \ubaa8\ub378(DOM) \uc694\uc18c\uac00 \uc5c6\uc73c\ubbc0\ub85c \ubb38\uc11c\uc5d0 \uc704\uc82f\uc774 \uc5c6\uc2b5\ub2c8\ub2e4. <br>\uc774 \uc704\uc82f\uc758 \ud604\uc7ac \uc18d\uc131:<P>{0}',
		'CRRUI1083E' : '{0} \ube0c\ub77c\uc6b0\uc800 \uc774\ubca4\ud2b8\ub97c \ucc98\ub9ac\ud558\ub294 \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.',
		'CRRUI1150E' : '{0} \ubcc0\uc218\uc5d0\uc11c \"null\"\uc744 \uc81c\uac70\ud558\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4.',		
		'CRRUI1151E' : '\ubb38\uc11c \uc624\ube0c\uc81d\ud2b8 \ubaa8\ub378(DOM) \uc694\uc18c\uac00 \uc5c6\ub294 \uc704\uc82f\uc744 {0} \ubcc0\uc218\uc5d0\uc11c \uc81c\uac70\ud558\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4.',		
		'CRRUI1155E' : '{1} \uc720\ud615\uc758 \ud558\uc704({2} \ubcc0\uc218)\ub97c {0}\uc5d0\uc11c \uc81c\uac70\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.',
		'CRRUI1157E' : '\uc704\uc82f\uc744 \uc704\uc82f \uc790\uccb4\uc5d0\uc11c \uc81c\uac70\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc704\uc82f \uc720\ud615\uc740 {0}\uc785\ub2c8\ub2e4.',
			
		'CRRUI2002E' : '{1}<br>{0}\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4: {2}',
		'CRRUI2004E' : '{0} \ud788\uc2a4\ud1a0\ub9ac\uc5d0 \uc798\ubabb\ub41c \uc778\uc218\uac00 \uc788\uc2b5\ub2c8\ub2e4.',
		'CRRUI2005E' : '\ub110(null) \ucc38\uc870\ub97c \uc0ac\uc6a9\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.',
		'CRRUI2006E' : '{0}', // The text of this message comes from some other error message.
		'CRRUI2007E' : '\uc798\ubabb\ub41c \uc778\uc218: {0}',
		'CRRUI2009E' : 'RUI \ud578\ub4e4\ub7ec\uc5d0\uc11c \uc774\ubca4\ud2b8\uc5d0 \ub300\ud55c \uc778\uc2a4\ud134\uc2a4\ub97c \uc791\uc131\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.',
		'CRRUI2010E' : '\uc798\ubabb\ub41c \ud568\uc218: {0}.',
		
		'CRRUI2015E' : '{1} RUIPropertiesLibrary\uc758 {0} \ud30c\uc77c\uc774 \ub204\ub77d\ub418\uc5c8\uc2b5\ub2c8\ub2e4.',
		'CRRUI2016E' : 'EGL \ud504\ub85c\uadf8\ub7a8 \uc0ac\uc6a9 \uc2dc\uac04\uc774 \ub108\ubb34 \uae41\ub2c8\ub2e4.',
		'CRRUI2017E' : '{1} \uc720\ud615\uc758 \"{0}\" \uac12\uc744 {2} \uc720\ud615\uc73c\ub85c \ubcc0\ud658\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.',
		'CRRUI2018E' : '{0}\uc744(\ub97c) \uc720\ud615 {1}\uc5d0 \uc9c0\uc815 \uc2dc \uc624\ubc84\ud50c\ub85c\uc6b0\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.',
		'CRRUI2019E' : '{0} \uc694\uc18c\ub97c \ubc30\uc5f4\uc5d0 \ucd94\uac00\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \ucd5c\ub300 \ubc30\uc5f4 \ud06c\uae30\ub294 {1}\uc785\ub2c8\ub2e4.',
		'CRRUI2020E' : '\ubc30\uc5f4 \ud568\uc218(setMaxSize())\uc5d0 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc740 {0} \uc778\uc218',
		'CRRUI2021E' : '{0} \uc0c9\uc778\uc5d0\uc11c \uc2dc\uc791\ud558\ub294 \ubb38\uc790\uc5f4\uc5d0\uc11c \ub2e4\uc74c \ud1a0\ud070\uc744 \uac80\uc0c9\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.',
		'CRRUI2022E' : '{0} \uc0c9\uc778\uc774 \uc774 \ubc30\uc5f4\uc758 \ud55c\uacc4\ub97c \ucd08\uacfc\ud569\ub2c8\ub2e4. \ubc30\uc5f4 \ud06c\uae30\ub294 {1}\uc785\ub2c8\ub2e4.',
		'CRRUI2023E' : '\ub110(null) \ucc38\uc870\ub97c \uc0ac\uc6a9\ud568: {0}',
		'CRRUI2024E' : '\ud0a4 \"{0}\"\uc5d0 \ub300\ud55c \ub3d9\uc801 \uc561\uc138\uc2a4\ub294 \uc720\ud615 {1}\uc758 \uc624\ube0c\uc81d\ud2b8\uc5d0 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.',
		'CRRUI2025E' : '\ub3d9\uc801 \uc561\uc138\uc2a4\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4: \"{0}\" \ud0a4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.',
		'CRRUI2030E' : 'XMLLib.convertFromXML\uc5d0 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc740 \uc778\uc218\uc785\ub2c8\ub2e4. \ubb38\uc790\uc5f4\uc774 \uc608\uc0c1\ub418\uc5c8\uc73c\ub098 \"{0}\"\uc744(\ub97c) \uc218\uc2e0\ud588\uc2b5\ub2c8\ub2e4.',
		'CRRUI2031E' : 'XML\uc744 \uad6c\ubb38 \ubd84\uc11d\ud558\ub294 \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4: {0}',
		'CRRUI2032E' : '{0} \uc2dc\uac04\uc18c\uc778 \ud328\ud134\uc774 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.',
		'CRRUI2033E' : '\ubc30\uc5f4 \ud568\uc218(resize())\uc5d0 \uc9c0\uc815\ub41c {0} \uac12\uc774 \ucd5c\ub300 \ubc30\uc5f4 \ud06c\uae30 {1}\ubcf4\ub2e4 \ud07d\ub2c8\ub2e4.',
		'CRRUI2034E' : '\ubc30\uc5f4 \uc694\uc18c\uc5d0 \ub300\ud55c {0} \uc720\ud615\uc774 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.',
		'CRRUI2035E' : '\ud06c\uae30 \uc870\uc815\ub41c \ucc28\uc6d0 \uc218\uac00 \ubc30\uc5f4 \ucc28\uc6d0 \uc218\ubcf4\ub2e4 \ud07d\ub2c8\ub2e4.',
		'CRRUI2036E' : '{0}\uc5d0 \ub300\ud55c \ud638\ucd9c\uc758 \ub3c4\uba54\uc778 \uc624\ub958: \uc778\uc218\ub294 {1}\uacfc(\uc640) {2} \uc0ac\uc774\uc5d0 \uc788\uc5b4\uc57c \ud569\ub2c8\ub2e4.',
		'CRRUI2037E' : '\uc218\ud559 \uc624\ub958: \uc22b\uc790\ub97c 0\uc73c\ub85c \ub098\ub20c \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.',
		'CRRUI2038E' : '{0}\uc5d0 \ub300\ud55c \ud638\ucd9c\uc758 \ub3c4\uba54\uc778 \uc624\ub958: \uc778\uc218\ub294 0\ubcf4\ub2e4 \ucee4\uc57c \ud569\ub2c8\ub2e4.',
		'CRRUI2039E' : '{0}\uc5d0 \ub300\ud55c \ud638\ucd9c\uc758 \ub3c4\uba54\uc778 \uc624\ub958: \uc778\uc218\ub294 0\ubcf4\ub2e4 \ud06c\uac70\ub098 \uac19\uc544\uc57c \ud569\ub2c8\ub2e4.',
		'CRRUI2040E' : '{0}\uc5d0 \ub300\ud55c \ud638\ucd9c\uc758 \ub3c4\uba54\uc778 \uc624\ub958: 0\uc744 \uae30\uc900\uc73c\ub85c \ud558\ub294 \uc9c0\uc218\ub294 0\ubcf4\ub2e4 \ucee4\uc57c \ud569\ub2c8\ub2e4.',
		'CRRUI2041E' : '{0}\uc5d0 \ub300\ud55c \ud638\ucd9c\uc758 \ub3c4\uba54\uc778 \uc624\ub958: \uc74c\uc218\ub97c \uae30\uc900\uc73c\ub85c \ud558\ub294 \uc9c0\uc218\ub294 \uc815\uc218\uc5ec\uc57c \ud569\ub2c8\ub2e4.',
		'CRRUI2042E' : '\uc62c\ubc14\ub974\uc9c0 \uc54a\uc740 \ubd80\ubd84 \ubb38\uc790\uc5f4 \uc0c9\uc778 {0}:{1}',
		'CRRUI2050E' : '\uc218\ud559 \uc624\ub958: abs() - {0} \uc778\uc218\uac00 \uc8fc\uc5b4\uc84c\uc2b5\ub2c8\ub2e4. 0 \ub610\ub294 1\uc774 \uc608\uc0c1\ub429\ub2c8\ub2e4.',
		'CRRUI2051E' : '\uc218\ud559 \uc624\ub958: add() - {0} \uc778\uc218\uac00 \uc8fc\uc5b4\uc84c\uc2b5\ub2c8\ub2e4. 1 \ub610\ub294 2\uac00 \uc608\uc0c1\ub429\ub2c8\ub2e4.',
		'CRRUI2052E' : '\uc218\ud559 \uc624\ub958: compareTo() - {0} \uc778\uc218\uac00 \uc8fc\uc5b4\uc84c\uc2b5\ub2c8\ub2e4. 1 \ub610\ub294 2\uac00 \uc608\uc0c1\ub429\ub2c8\ub2e4.',
		'CRRUI2053E' : '\uc218\ud559 \uc624\ub958: divide() - \uc74c\uc218 \ubc30\uc728 {0}\uc774(\uac00) \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.',
		'CRRUI2054E' : '\uc218\ud559 \uc624\ub958: divide() - {0} \uc778\uc218\uac00 \uc8fc\uc5b4\uc84c\uc2b5\ub2c8\ub2e4. 1 - 3\uc774 \uc608\uc0c1\ub429\ub2c8\ub2e4.',
		'CRRUI2055E' : '\uc218\ud559 \uc624\ub958: divideInteger() - {0} \uc778\uc218\uac00 \uc8fc\uc5b4\uc84c\uc2b5\ub2c8\ub2e4. 1 \ub610\ub294 2\uac00 \uc608\uc0c1\ub429\ub2c8\ub2e4.',
		'CRRUI2056E' : '\uc218\ud559 \uc624\ub958: max() - {0} \uc778\uc218\uac00 \uc8fc\uc5b4\uc84c\uc2b5\ub2c8\ub2e4. 1 \ub610\ub294 2\uac00 \uc608\uc0c1\ub429\ub2c8\ub2e4.',
		'CRRUI2057E' : '\uc218\ud559 \uc624\ub958: min() - {0} \uc778\uc218\uac00 \uc8fc\uc5b4\uc84c\uc2b5\ub2c8\ub2e4. 1 \ub610\ub294 2\uac00 \uc608\uc0c1\ub429\ub2c8\ub2e4.',
		'CRRUI2058E' : '\uc218\ud559 \uc624\ub958: multiply() - {0} \uc778\uc218\uac00 \uc8fc\uc5b4\uc84c\uc2b5\ub2c8\ub2e4. 1 \ub610\ub294 2\uac00 \uc608\uc0c1\ub429\ub2c8\ub2e4.',
		'CRRUI2059E' : '\uc218\ud559 \uc624\ub958: negate() - {0} \uc778\uc218\uac00 \uc8fc\uc5b4\uc84c\uc2b5\ub2c8\ub2e4. 0 \ub610\ub294 1\uc774 \uc608\uc0c1\ub429\ub2c8\ub2e4.',
		'CRRUI2060E' : '\uc218\ud559 \uc624\ub958: plus() - {0} \uc778\uc218\uac00 \uc8fc\uc5b4\uc84c\uc2b5\ub2c8\ub2e4. 0 \ub610\ub294 1\uc774 \uc608\uc0c1\ub429\ub2c8\ub2e4.',
		'CRRUI2061E' : '\uc218\ud559 \uc624\ub958: pow() - {0} \uc778\uc218\uac00 \uc8fc\uc5b4\uc84c\uc2b5\ub2c8\ub2e4. 1 \ub610\ub294 2\uac00 \uc608\uc0c1\ub429\ub2c8\ub2e4.',
		'CRRUI2062E' : '\uc218\ud559 \uc624\ub958: pow() - \uc74c\uc218 \uac70\ub4ed \uc81c\uacf1, {0}',
		'CRRUI2063E' : '\uc218\ud559 \uc624\ub958: pow() - \ub108\ubb34 \ub9ce\uc740 \uc22b\uc790, {0}',
		'CRRUI2064E' : '\uc218\ud559 \uc624\ub958: remainder() - {0} \uc778\uc218\uac00 \uc8fc\uc5b4\uc84c\uc2b5\ub2c8\ub2e4. 1 \ub610\ub294 2\uac00 \uc608\uc0c1\ub429\ub2c8\ub2e4.',
		'CRRUI2065E' : '\uc218\ud559 \uc624\ub958: subtract() - {0} \uc778\uc218\uac00 \uc8fc\uc5b4\uc84c\uc2b5\ub2c8\ub2e4. 1 \ub610\ub294 2\uac00 \uc608\uc0c1\ub429\ub2c8\ub2e4.',
		'CRRUI2066E' : '\uc218\ud559 \uc624\ub958: format() - {0} \uc778\uc218\uac00 \uc8fc\uc5b4\uc84c\uc2b5\ub2c8\ub2e4. 2 \ub610\ub294 6\uc774 \uc608\uc0c1\ub429\ub2c8\ub2e4.',
		'CRRUI2067E' : '\uc218\ud559 \uc624\ub958: format() - \uc9c0\uc218 \uc624\ubc84\ud50c\ub85c\uc6b0, {0}',
		'CRRUI2068E' : '\uc218\ud559 \uc624\ub958: intValueExact() - 0\uc774 \uc544\ub2cc 10\uc9c4\uc218 \ud30c\ud2b8, {0}',
		'CRRUI2069E' : '\uc218\ud559 \uc624\ub958: intValueExact() - \ubcc0\ud658 \uc624\ubc84\ud50c\ub85c\uc6b0, {0}',
		'CRRUI2070E' : '\uc218\ud559 \uc624\ub958: setScale() - {0} \uc778\uc218\uac00 \uc8fc\uc5b4\uc84c\uc2b5\ub2c8\ub2e4. 1 \ub610\ub294 2\uac00 \uc608\uc0c1\ub429\ub2c8\ub2e4.',
		'CRRUI2071E' : '\uc218\ud559 \uc624\ub958: setScale() - \uc74c\uc218 \ubc30\uc728, {0}',
		'CRRUI2072E' : '\uc218\ud559 \uc624\ub958: intCheck() - \ubcc0\ud658 \uc624\ub958, {0}',
		'CRRUI2073E' : '\uc218\ud559 \uc624\ub958: dodivide() - \uc815\uc218 \uc624\ubc84\ud50c\ub85c\uc6b0',
		'CRRUI2074E' : '\uc218\ud559 \uc624\ub958: \ubb38\uc790\uc5f4 \"{1}\"\uc744(\ub97c) \uc22b\uc790\ub85c \ubcc0\ud658\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.',
		'CRRUI2075E' : '\uc218\ud559 \uc624\ub958: \uba54\uc18c\ub4dc {1}\uc5d0 \ub300\ud55c \uc778\uc218 \ubc88\ud638 {0}\uc774(\uac00) \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \uc81c\uacf5\ub41c \uc778\uc218\ub294 {2}\uc785\ub2c8\ub2e4.',
		'CRRUI2076E' : '\uc218\ud559 \uc624\ub958: \ub108\ubb34 \ub9ce\uc740 \uc22b\uc790 - {0}',
		'CRRUI2077E' : '\uc218\ud559 \uc624\ub958: round() - {0} \uc778\uc218\uac00 \uc8fc\uc5b4\uc84c\uc2b5\ub2c8\ub2e4. 1 \ub610\ub294 2\uac00 \uc608\uc0c1\ub429\ub2c8\ub2e4.',
		'CRRUI2078E' : '\uc218\ud559 \uc624\ub958: round() - \ubc18\uc62c\ub9bc \ud544\uc694',
		'CRRUI2079E' : '\uc218\ud559 \uc624\ub958: round() - \uc798\ubabb\ub41c \ubc18\uc62c\ub9bc \uac12, {0}',
		'CRRUI2080E' : '\uc218\ud559 \uc624\ub958: round() - \uc9c0\uc218, {0}, \uc624\ubc84\ud50c\ub85c\uc6b0',
		'CRRUI2081E' : '\uc218\ud559 \uc624\ub958: finish() - \uc9c0\uc218, {0}, \uc624\ubc84\ud50c\ub85c\uc6b0',
		'CRRUI2082E' : '\ub0b4\ubd80 \uc624\ub958: {0}\uc5d0 \ub300\ud55c \uc0dd\uc131\uc790 \ud638\ucd9c \uc2dc',
		'CRRUI2083E' : '\ub0b4\ubd80 \uc624\ub958: {0} \ud074\ub798\uc2a4\ub97c \uc815\uc758\ud558\ub294 \uc911\uc5d0 \ubb38\uc81c\uc810\uc774 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.',
		'CRRUI2084E' : '\ub0b4\ubd80 \uc624\ub958: \uc704\uc82f {0}.{1}\uc744(\ub97c) egl.ui.rui.RUIPropertiesLibrary\uc758 \uc11c\ube0c\ud074\ub798\uc2a4\ub85c \uc815\uc758 \uc2dc',
		'CRRUI2085E' : '\ub0b4\ubd80 \uc624\ub958: \uc704\uc82f {0}.{1}\uc744(\ub97c) {2}.{3}\uc758 \uc11c\ube0c\ud074\ub798\uc2a4\ub85c \uc815\uc758 \uc2dc',
		'CRRUI2086E' : '\ub0b4\ubd80 \uc624\ub958: RUI \ud578\ub4e4\ub7ec {0}\uc744(\ub97c) \uc815\uc758\ud558\ub294 \uc911\uc5d0 \ubb38\uc81c\uc810\uc774 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.',
		'CRRUI2087E' : '\ub0b4\ubd80 \uc624\ub958: RUI \uc704\uc82f {0}\uc744(\ub97c) \uc815\uc758\ud558\ub294 \uc911\uc5d0 \ubb38\uc81c\uc810\uc774 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.',
		'CRRUI2088E' : '\uc774 \ube0c\ub77c\uc6b0\uc800\ub294 EGL Rich UI\ub85c \uc9c0\uc6d0\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.',
		'CRRUI2089E' : '{1}(\uc73c)\ub85c \uc778\ud574 JSON \ud615\uc2dd "{0}"\uc744(\ub97c) \ubcc0\ud658\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.',
		'CRRUI2090E' : '\uc11c\ube44\uc2a4\ub97c \ud638\ucd9c\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4: {0}',
		'CRRUI2091E' : '\uc774\ubca4\ud2b8\ub97c Eclipse IDE\ub85c \ubcf4\ub0bc \uc218 \uc5c6\uc2b5\ub2c8\ub2e4: {0}',
		'CRRUI2092E' : '\ub0b4\ubd80 \uc624\ub958: {0} IDE \uc774\ubca4\ud2b8\ub97c \ud578\ub4e4\ub9c1\ud558\ub294 \uc911\uc5d0 \ubb38\uc81c\uc810\uc774 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.',
		'CRRUI2093E' : '\ub0b4\ubd80 \uc624\ub958: {0} \ud568\uc218\ub97c \uc778\uc2a4\ud2b8\ub8e8\uba3c\ud2b8\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.',
		'CRRUI2094E' : '\uc774 \uc624\ub958\ub97c \ubc1c\uc0dd\uc2dc\ud0a4\ub294 EGL \ud568\uc218 \ud638\ucd9c\uc774 \uc788\uc2b5\ub2c8\ub2e4:',
		'CRRUI2095E' : '\uc774 \uc624\ub958\ub97c \ubc1c\uc0dd\uc2dc\ud0a4\ub294 EGL \ud568\uc218 \ud638\ucd9c\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.',
		'CRRUI2097E' : '{0} \uc18d\uc131\uc5d0 \ub300\ud55c CSS \uc2a4\ud0c0\uc77c \uac12 "{1}"\uc774(\uac00) \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.',
		'CRRUI2097E' : 'CSS \uc2a4\ud0c0\uc77c {0}\uc744(\ub97c) \uc62c\ubc14\ub974\uac8c \uad6c\ubb38 \ubd84\uc11d\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uad6c\ubb38\uc744 \uc810\uac80\ud558\uac70\ub098 \uc678\ubd80 \uc2a4\ud0c0\uc77c\uc2dc\ud2b8\ub97c \uc0ac\uc6a9\ud558\uc2ed\uc2dc\uc624.',
		'CRRUI2098E' : '\ub04c\uc5b4\uc11c \ub193\uae30 \uc9c0\uc6d0 \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud568: {0}',
		'CRRUI2099E' : 'Rich UI\uc5d0\uc11c\ub294 EGL "set" \uc624\ud37c\ub808\uc774\uc158\uc774 \uc720\ud615 {0}\uc5d0 \uc9c0\uc6d0\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.',
		'CRRUI2100E' : 'RuiLib.convertFromXML\uc5d0 \ub300\ud55c \uc778\uc218\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \ubb38\uc790\uc5f4\uc774 \uc608\uc0c1\ub418\uc5c8\uc73c\ub098 {0} \uc720\ud615\uc758 \uc624\ube0c\uc81d\ud2b8\ub97c \uc218\uc2e0\ud588\uc2b5\ub2c8\ub2e4.',
		'CRRUI2101E' : '{2}(\uc73c)\ub85c \uc778\ud574 "{0}"\uc5d0\uc11c indexOf "{1}"\uc744(\ub97c) \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.',
		'CRRUI2102E' : '\ubc30\uc5f4\uc744 \uc815\ub82c\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.',
		'CRRUI2103E' : '{2}(\uc73c)\ub85c \uc778\ud574 \uc720\ud615 "{1}"\uc758 \uc624\ube0c\uc81d\ud2b8\uc5d0\uc11c "{0}"\uc5d0 \ub300\ud55c \uc561\uc138\uc2a4\ub294 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.',
		'CRRUI2104E' : 'JSON \ubb38\uc790\uc5f4 "{0}"\uc744(\ub97c) \uad6c\ubb38 \ubd84\uc11d\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.',
		'CRRUI2105E' : '{0}\uc744(\ub97c) \uc124\uc815\ud558\ub294 \uc911\uc5d0 JSON \uad6c\ubb38 \ubd84\uc11d \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. JSON \ubb38\uc790\uc5f4\uc758 \uc608\uc0c1\ub41c \uc704\uce58\uc5d0 \ud544\ub4dc\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.',
		'CRRUI2106E' : '\ub110 \uc785\ub825 \uac00\ub2a5 \ud544\ub4dc\ub85c \uc120\uc5b8\ud558\uc9c0 \uc54a\uc558\uae30 \ub54c\ubb38\uc5d0 JSON\uc744 \uad6c\ubb38 \ubd84\uc11d\ud558\ub294 \uc911\uc5d0 {0}\uc744(\ub97c) \ub110(null)\ub85c \uc124\uc815\ud558\ub294 \ub370 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4.',
		'CRRUI2107E' : '\uc11c\ube44\uc2a4 \ub77c\uc774\ube0c\ub7ec\ub9ac JSON \ubcc0\ud658 \ud568\uc218\ub294 \ub808\ucf54\ub4dc \ub610\ub294 \uc0ac\uc804\uc5d0\uc11c \uc791\ub3d9\ud569\ub2c8\ub2e4. {0}\uc740(\ub294) \uc9c0\uc6d0\ub418\ub294 \uc720\ud615\uc774 \uc544\ub2d9\ub2c8\ub2e4. ',
		'CRRUI2108E' : 'XML \ub77c\uc774\ube0c\ub7ec\ub9ac XML \ubcc0\ud658 \ud568\uc218\ub294 \ub808\ucf54\ub4dc\uc5d0\uc11c \uc791\ub3d9\ud569\ub2c8\ub2e4. {0}\uc740(\ub294) \uc9c0\uc6d0\ub418\ub294 \uc720\ud615\uc774 \uc544\ub2d9\ub2c8\ub2e4.',
		
		'CRRUI2111E' : 'MathContext() \uc624\ub958: \uc9c0\uc815\ub41c \uc778\uc218 \uac1c\uc218 {0}\uc774(\uac00) \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \uac00\ub2a5\ud55c \uac12\uc740 1 - 4\uc785\ub2c8\ub2e4.',
		'CRRUI2112E' : 'MathContext() \uc624\ub958: \uc9c0\uc815\ub41c \uc22b\uc790 \uac1c\uc218 {0}\uc774(\uac00) \ub108\ubb34 \uc791\uc2b5\ub2c8\ub2e4.',
		'CRRUI2113E' : 'MathContext() \uc624\ub958: \uc9c0\uc815\ub41c \uc22b\uc790 \uac1c\uc218 {0}\uc774(\uac00) \ub108\ubb34 \ud07d\ub2c8\ub2e4.',
		'CRRUI2114E' : 'MathContext() \uc624\ub958: \uc9c0\uc815\ub41c \uc591\uc2dd \uac12 {0}\uc774(\uac00) \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.',
		'CRRUI2115E' : 'MathContext() \uc624\ub958: \uc9c0\uc815\ub41c \ubc18\uc62c\ub9bc \ubaa8\ub4dc \uac12 {0}\uc774(\uac00) \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.',
		
	    'CRRUI2700E' : '\ud544\uc218 \ud544\ub4dc\uc5d0 \ub300\ud55c \uc785\ub825\uc744 \uc218\uc2e0\ud558\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4. \ub2e4\uc2dc \uc785\ub825\ud558\uc2ed\uc2dc\uc624.',
		'CRRUI2702E' : '\uc785\ub825\ud55c \ub370\uc774\ud130 \uc720\ud615\uc5d0 \uc624\ub958\uac00 \uc788\uc2b5\ub2c8\ub2e4. \ub2e4\uc2dc \uc785\ub825\ud558\uc2ed\uc2dc\uc624.',
		'CRRUI2703E' : '\ud5c8\uc6a9 \uac00\ub2a5\ud55c \uc911\uc694 \uc22b\uc790 \uc790\ub9bf\uc218\ub97c \ucd08\uacfc\ud588\uc2b5\ub2c8\ub2e4. \ub2e4\uc2dc \uc785\ub825\ud558\uc2ed\uc2dc\uc624.',
		'CRRUI2704E' : '\uc815\uc758\ub41c \ubc94\uc704 {0} - {1}\uc5d0 \uc785\ub825\uc774 \uc5c6\uc2b5\ub2c8\ub2e4. \ub2e4\uc2dc \uc785\ub825\ud558\uc2ed\uc2dc\uc624.',
		'CRRUI2705E' : '\uc785\ub825 \ucd5c\uc18c \uae38\uc774 \uc624\ub958\uc785\ub2c8\ub2e4. \ub2e4\uc2dc \uc785\ub825\ud558\uc2ed\uc2dc\uc624.',
		'CRRUI2707E' : '\uc785\ub825\uc5d0 \ubaa8\ub4c8 \ud655\uc778 \uc624\ub958\uac00 \uc788\uc2b5\ub2c8\ub2e4. \ub2e4\uc2dc \uc785\ub825\ud558\uc2ed\uc2dc\uc624.',
		'CRRUI2708E' : '\uc815\uc758\ub41c \ub0a0\uc9dc \ub610\ub294 \uc2dc\uac04 \ud615\uc2dd {0}\uc5d0 \ub300\ud574 \uc785\ub825\uc774 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. ',
		'CRRUI2710E' : '\ubd80\uc6b8 \ud544\ub4dc\uc5d0 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc740 \uc785\ub825\uc785\ub2c8\ub2e4.',
		'CRRUI2712E' : '16\uc9c4 \ub370\uc774\ud130\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.',
		'CRRUI2713E' : '\uc785\ub825\ud55c \uac12\uc774 \uc124\uc815\ub41c \ud328\ud134\uacfc \uc77c\uce58\ud558\uc9c0 \uc54a\uc73c\ubbc0\ub85c \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.',		
		'CRRUI2716E' : '\uc785\ub825\uc774 \uc815\uc758\ub41c \uc62c\ubc14\ub978 \uac12 \ubaa9\ub85d\uc5d0 \uc788\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \ub2e4\uc2dc \uc785\ub825\ud558\uc2ed\uc2dc\uc624.',
		'CRRUI2717E' : '{0}\uc758 \uc9c0\uc815\ub41c \ub0a0\uc9dc \ubc0f \uc2dc\uac04 \ud615\uc2dd\uc774 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.',	
		'CRRUI2719E' : '\uc785\ub825 \uac12\uc744 \uad6c\ubb38 \ubd84\uc11d\ud558\ub294 \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.',

		'CRRUI3650E' : '\ubc30\uce58 \ub514\uc2a4\ud06c\ub9bd\ud130 \ud30c\uc77c\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4: \'{0}\'',
		'CRRUI3651E' : '\uc11c\ube44\uc2a4 \ubc14\uc778\ub529 \ud0a4: \'{0}\'\uc774(\uac00) \ubc30\uce58 \ub514\uc2a4\ud06c\ub9bd\ud130 \'{1}\'\uc5d0 \uc5c6\uc2b5\ub2c8\ub2e4.',
		'CRRUI3652E' : '\uc11c\ube44\uc2a4 \ubc14\uc778\ub529 \uc720\ud615 \'{0}\'\uc774(\uac00) \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. \ubc14\uc778\ub529 \uc720\ud615 \'{1}\'\uc774(\uac00) \uc608\uc0c1\ub429\ub2c8\ub2e4.',
		'CRRUI3653E' : '\'{0}\'\uc5d0\uc11c REST \uc11c\ube44\uc2a4\ub97c \ud638\ucd9c\ud558\ub294 \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.',
		'CRRUI3654E' : '\uc694\uccad \uc624\ube0c\uc81d\ud2b8\ub97c \ube4c\ub4dc\ud558\ub294 \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4: \'{0}\'',
		'CRRUI3655E' : '\uc751\ub2f5 \uc624\ube0c\uc81d\ud2b8\ub97c \ucc98\ub9ac\ud558\ub294 \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4: \'{0}\'',
		'CRRUI3656E' : '\'formdata\'\ub294 \uc751\ub2f5 \ud615\uc2dd\uc73c\ub85c \uc9c0\uc6d0\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.',
		'CRRUI3657E' : '\uc11c\ube44\uc2a4\ub97c \ud638\ucd9c\ud558\uae30 \uc704\ud55c \'{0}\'\uc758 \ud504\ub85d\uc2dc\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.',
		'CRRUI3658E' : '\'{1}\'\uc5d0\uc11c \uc11c\ube44\uc2a4\ub97c \ud638\ucd9c\ud558\ub294 \uc911\uc5d0 \'{0}\'\uc758 \ud504\ub85d\uc2dc\uc5d0\uc11c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.',
		'CRRUI3659E' : 'Json \uc751\ub2f5\uc744 \uad6c\ubb38 \ubd84\uc11d\ud558\uba74 \ub110(null)\uc774 \ub429\ub2c8\ub2e4. \uc6d0\ub798\uc758 \uc751\ub2f5: \'{0}\'',
		'CRRUI3660E' : '\uc608\uc678\uac00 \ubc1c\uc0dd\ud588\uc73c\ubbc0\ub85c \'{0}\'\uc5d0 \ub300\ud55c \uc751\ub2f5\uc744 \ud578\ub4e4\ub9c1\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc774\uc720: \'{1}\'',
		'CRRUI3661E' : '\uc11c\ube44\uc2a4 \ud568\uc218 \'{1}\'\uc744(\ub97c) \ud638\ucd9c\ud558\ub294 \uc911\uc5d0 \'{0}\'\uc758 \uc11c\ube44\uc2a4 \ubc14\uc778\ub529 \uc815\ubcf4\uac00 \ub204\ub77d\ub418\uc5c8\uc2b5\ub2c8\ub2e4.'
};

