/*******************************************************************************
 * Copyright © 2008, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
// NLS_ENCODING=UTF-8
// NLS_MESSAGEFORMAT_VAR
//
// Guidelines for defining Rich UI messages:  
// (1) DO NOT change the variable, "egl.eze$$rscBundles["RuiMessages"]"
// (2) The general format of a message is:
//          'MessageId'  :   'Message Text: {n}'
// (3) 'MessageId' (eg: CRRUI2007E) is composed of 4 parts:
//        - the first 5 characters is product identification, must be 'CRRUI'  
//        - the sixth character is a digit which identifies the component:
//                '0' -  Others       ( used to be 'E' )
//                '1' -  Widget       ( used to be 'I' )
//                '2' -  Runtime      ( used to be 'R' )
//                '3' -  Service      ( used to be 'S' )
//        - the 7th to 9th characters identifies message number, eg: '001'
//        - the 10th character identifies the message type:
//                'E' - error message
//                'I' - informational message
//                'W' - warning message
// (5)The message text may contain 1 or more message inserts, 
//         eg: {n},  where n is a 0 based number
// (6)Insert the message in alphabetical and numeric sort order  
//    against the MessageId to avoid conflicts which can be 
//    difficult to track at runtime            
//
egl.eze$$rscBundles["RuiMessages"] =
{
		'CRRUI0001E' : '\u041f\u0443\u0441\u0442\u043e\u0435 \u0438\u043c\u044f InitalUI[{0}]InitialUI. \u0412\u044b\u0437\u043e\u0432 \u0444\u0443\u043d\u043a\u0446\u0438\u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c\u0441\u044f \u0434\u043b\u044f \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0438\u043c\u0435\u043d\u0438.',		
		'CRRUI0006E' : '\u0413\u0440\u0443\u043f\u043f\u0430 {0} RadioGroup \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442.',
					
		'CRRUI1001E' : '\u0414\u043b\u044f \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 {0} {1} \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0440\u0430\u0432\u0435\u043d {2}',
		'CRRUI1010E' : '\u0424\u0443\u043d\u043a\u0446\u0438\u0438 \u043f\u0435\u0440\u0435\u0442\u0430\u0441\u043a\u0438\u0432\u0430\u043d\u0438\u044f\u00a0\u2014 \u044d\u0442\u043e \u0441\u0441\u044b\u043b\u043a\u0438 \u043d\u0430 \u0444\u0443\u043d\u043a\u0446\u0438\u0438, \u0430 \u043d\u0435 \u043c\u0430\u0441\u0441\u0438\u0432\u044b: {0}.',
		'CRRUI1020E' : 'Runtime.asDictionary: \u0432 \u0441\u043b\u043e\u0432\u0430\u0440\u0438 \u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0438 \u0438 \u0437\u0430\u043f\u0438\u0441\u0438, \u0430 \u043d\u0435 {0}.',
		'CRRUI1030E' : '\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0435 {0}.{1} \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e.',
		'CRRUI1050E' : '\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f {0} \u0434\u043e\u043b\u0436\u043d\u0430 \u0432\u043a\u043b\u044e\u0447\u0430\u0442\u044c \u0438\u043c\u044f \"null\".',
		'CRRUI1051E' : '\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432\u0438\u0434\u0436\u0435\u0442 \u0432 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e {0}.',
		'CRRUI1055E' : '\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0434\u043e\u0447\u0435\u0440\u043d\u0438\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 {1} \u0432 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e {2}.',		
		'CRRUI1057E' : '\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432\u0438\u0434\u0436\u0435\u0442 {0} \u0432 \u044d\u0442\u043e\u0442 \u0436\u0435 \u0432\u0438\u0434\u0436\u0435\u0442.',	
		'CRRUI1058E' : '\u041f\u0440\u0435\u0434\u043e\u043a {1} \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u0432 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e {0}. {2} - \u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u043f\u0440\u0435\u0434\u043e\u043a.',
		'CRRUI1060E' : '\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u043d\u0430\u0437\u043d\u0430\u0447\u0438\u0442\u044c \u0443\u043f\u0440\u0430\u0432\u043b\u044f\u044e\u0449\u0435\u043c\u0443 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0443 \"{0}\" \u043f\u0440\u0435\u0434\u043a\u0430 {1}: {2}; \u043f\u0440\u0435\u0434\u043e\u043a \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0443\u043f\u0440\u0430\u0432\u043b\u044f\u044e\u0449\u0438\u043c \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u043c.',
		'CRRUI1070E' : '\u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f {0} \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u0444\u0443\u043d\u043a\u0446\u0438\u0438 \u043e\u0431\u0440\u0430\u0442\u043d\u043e\u0433\u043e \u0432\u044b\u0437\u043e\u0432\u0430. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 try...OnException.',
		'CRRUI1071E' : '\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0438\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0439 \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u0438 \u0434\u043b\u044f \u0432\u044b\u0437\u043e\u0432\u0430 \u0441\u043b\u0443\u0436\u0431\u044b. \u0414\u043e\u0431\u0430\u0432\u044c\u0442\u0435 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0432 \u0432\u044b\u0437\u043e\u0432 \u0441\u043b\u0443\u0436\u0431\u044b.',
		'CRRUI1072E' : '\u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0441\u0438\u0442\u0443\u0430\u0446\u0438\u044f {0} \u0432 \u0444\u0443\u043d\u043a\u0446\u0438\u0438 \u043e\u0431\u0440\u0430\u0442\u043d\u043e\u0433\u043e \u0432\u044b\u0437\u043e\u0432\u0430 \u043e\u0448\u0438\u0431\u043a\u0438, \u0434\u043e\u0431\u0430\u0432\u044c\u0442\u0435 \u0432 \u043a\u043e\u0434 try...OnException',		
		'CRRUI1080E' : '\u0412\u0438\u0434\u0436\u0435\u0442 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 DOM \u0438 \u043d\u0435 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442.<br>\u0422\u0435\u043a\u0443\u0449\u0438\u0435 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u044b \u0434\u043b\u044f \u044d\u0442\u043e\u0433\u043e \u0432\u0438\u0434\u0436\u0435\u0442\u0430:<P>{0}',
		'CRRUI1083E' : '\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u0441\u043e\u0431\u044b\u0442\u0438\u044f {0} \u0431\u0440\u0430\u0443\u0437\u0435\u0440\u0430.',
		'CRRUI1150E' : '\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0443\u0434\u0430\u043b\u0438\u0442\u044c \"null\" \u0438\u0437 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 {0}.',		
		'CRRUI1151E' : '\u041e\u0448\u0438\u0431\u043a\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u0432\u0438\u0434\u0436\u0435\u0442\u0430, \u043d\u0435 \u0438\u043c\u0435\u044e\u0449\u0435\u0433\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 DOM, \u0438\u0437 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 {0}.',		
		'CRRUI1155E' : '\u0414\u043e\u0447\u0435\u0440\u043d\u0438\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0442\u0438\u043f\u0430 {1} \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0443\u0434\u0430\u043b\u0435\u043d \u0438\u0437 {0}: \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f {2}.',
		'CRRUI1157E' : '\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u0438\u0434\u0436\u0435\u0442 \u0438\u0437 \u0441\u0430\u043c\u043e\u0433\u043e \u0441\u0435\u0431\u044f. \u0422\u0438\u043f \u0432\u0438\u0434\u0436\u0435\u0442\u0430 {0}.',
			
		'CRRUI2002E' : '{1}<br>\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0432 {0}: {2}',
		'CRRUI2004E' : '\u0425\u0440\u043e\u043d\u043e\u043b\u043e\u0433\u0438\u044f {0} \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442.',
		'CRRUI2005E' : '\u041d\u0435\u043b\u044c\u0437\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0441\u0441\u044b\u043b\u043a\u0443 \u043d\u0430 null.',
		'CRRUI2006E' : '{0}', // The text of this message comes from some other error message.
		'CRRUI2007E' : '\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442: {0}.',
		'CRRUI2009E' : '\u0421\u043e\u0431\u044b\u0442\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0438\u0437 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430 RUI.',
		'CRRUI2010E' : '\u0423\u0441\u0442\u0430\u0440\u0435\u0432\u0448\u0430\u044f \u0444\u0443\u043d\u043a\u0446\u0438\u044f: {0}.',
		
		'CRRUI2015E' : '\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0444\u0430\u0439\u043b {0} \u0434\u043b\u044f RUIPropertiesLibrary {1}',
		'CRRUI2016E' : '\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430 EGL \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442 \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0434\u043e\u043b\u0433\u043e.',
		'CRRUI2017E' : '\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \"{0}\" \u0442\u0438\u043f\u0430 {1} \u043d\u0435\u043b\u044c\u0437\u044f \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c \u0432 \u0442\u0438\u043f {2}.',
		'CRRUI2018E' : '\u041f\u0435\u0440\u0435\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u043f\u0440\u0438 \u043f\u0440\u0438\u0441\u0432\u0430\u0438\u0432\u0430\u043d\u0438\u0438 {0} \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u0442\u0438\u043f\u0430 {1}.',
		'CRRUI2019E' : '\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 {0} \u0432 \u043c\u0430\u0441\u0441\u0438\u0432. \u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 \u0440\u0430\u0432\u0435\u043d {1}',
		'CRRUI2020E' : '\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 {0} \u0444\u0443\u043d\u043a\u0446\u0438\u0438 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 setMaxSize().',
		'CRRUI2021E' : '\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u043c\u0430\u0440\u043a\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 \u0441 \u0438\u043d\u0434\u0435\u043a\u0441\u043e\u043c {0}',
		'CRRUI2022E' : '\u0418\u043d\u0434\u0435\u043a\u0441 {0} \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u043c\u0438 \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0445 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439. \u0420\u0430\u0437\u043c\u0435\u0440 \u043c\u0430\u0441\u0441\u0438\u0432\u0430\u00a0\u2014 {1}.',
		'CRRUI2023E' : '\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0430 \u043f\u0443\u0441\u0442\u0430\u044f \u0441\u0441\u044b\u043b\u043a\u0430: {0}.',
		'CRRUI2024E' : '\u0423 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u0442\u0438\u043f\u0430 {1} \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u043a\u043b\u044e\u0447\u0443 \"{0}\" \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c.',
		'CRRUI2025E' : '\u041e\u0448\u0438\u0431\u043a\u0430 \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0434\u043e\u0441\u0442\u0443\u043f\u0430: \u043d\u0435\u0442 \u0442\u0430\u043a\u043e\u0433\u043e \u043a\u043b\u044e\u0447\u0430, \"{0}\".',
		'CRRUI2030E' : '\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 \u0434\u043b\u044f XMLLib.convertFromXML. \u041e\u0436\u0438\u0434\u0430\u043b\u0441\u044f String. \u041f\u0435\u0440\u0435\u0434\u0430\u043d \"{0}\".',
		'CRRUI2031E' : '\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0438\u043d\u0442\u0430\u043a\u0441\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0430\u043d\u0430\u043b\u0438\u0437\u0430 JSON: {0}.',
		'CRRUI2032E' : '\u041c\u0435\u0442\u043a\u0430 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 {0} \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430.',
		'CRRUI2033E' : '\u0423\u043a\u0430\u0437\u0430\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 {0} \u0434\u043b\u044f \u0444\u0443\u043d\u043a\u0446\u0438\u0438 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 resize(), \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u044e\u0449\u0435\u0435 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u043c\u0430\u0441\u0441\u0438\u0432\u0430, {1}',
		'CRRUI2034E' : '\u0422\u0438\u043f {0} \u0434\u043b\u044f \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c.',
		'CRRUI2035E' : '\u0427\u0438\u0441\u043b\u043e \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u0439 \u043f\u043e\u0441\u043b\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u043f\u0440\u0435\u0432\u044b\u0441\u0438\u043b\u043e \u0447\u0438\u0441\u043b\u043e \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u0439 \u043c\u0430\u0441\u0441\u0438\u0432\u0430.',
		'CRRUI2036E' : '\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u0438 \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0445 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 \u043f\u0440\u0438 \u0432\u044b\u0437\u043e\u0432\u0435 {0}: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043c\u0435\u0436\u0434\u0443 {1} \u0438 {2}.',
		'CRRUI2037E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: \u0434\u0435\u043b\u0435\u043d\u0438\u0435 \u043d\u0430 \u043d\u043e\u043b\u044c.',
		'CRRUI2038E' : '\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u0438 \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0445 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 \u043f\u0440\u0438 \u0432\u044b\u0437\u043e\u0432\u0435 {0}: \u043d\u0435\u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442.',
		'CRRUI2039E' : '\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u0438 \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0445 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 \u043f\u0440\u0438 \u0432\u044b\u0437\u043e\u0432\u0435 {0}: \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442.',
		'CRRUI2040E' : '\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u0438 \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0445 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 \u043f\u0440\u0438 \u0432\u044b\u0437\u043e\u0432\u0435 {0}: \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044c \u0441\u0442\u0435\u043f\u0435\u043d\u0438 \u043f\u0440\u0438 \u043d\u0443\u043b\u0435\u0432\u043e\u043c \u043e\u0441\u043d\u043e\u0432\u0430\u043d\u0438\u0438.',
		'CRRUI2041E' : '\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u043b\u0430\u0441\u0442\u0438 \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0445 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 \u043f\u0440\u0438 \u0432\u044b\u0437\u043e\u0432\u0435 {0}: \u043d\u0435\u0446\u0435\u043b\u043e\u0447\u0438\u0441\u043b\u0435\u043d\u043d\u044b\u0439 \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044c \u0441\u0442\u0435\u043f\u0435\u043d\u0438 \u043f\u0440\u0438 \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u043c \u043e\u0441\u043d\u043e\u0432\u0430\u043d\u0438\u0438.',
		'CRRUI2042E' : '\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0438\u043d\u0434\u0435\u043a\u0441\u044b {0}:{1}.',
		'CRRUI2050E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: abs()\u00a0\u2014 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u043e {0} \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430(\u043e\u0432); \u043e\u0436\u0438\u0434\u0430\u043b\u043e\u0441\u044c 0 \u0438\u043b\u0438 1.',
		'CRRUI2051E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: add()\u00a0\u2014 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u043e {0} \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430(\u043e\u0432); \u043e\u0436\u0438\u0434\u0430\u043b\u043e\u0441\u044c 1 \u0438\u043b\u0438 2.',
		'CRRUI2052E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: compareTo()\u00a0\u2014 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u043e {0} \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430(\u043e\u0432); \u043e\u0436\u0438\u0434\u0430\u043b\u043e\u0441\u044c 1 \u0438\u043b\u0438 2.',
		'CRRUI2053E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: divide()\u00a0\u2014 \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0434\u043b\u0438\u043d\u0430 \u0434\u0440\u043e\u0431\u043d\u043e\u0439 \u0447\u0430\u0441\u0442\u0438, {0}, \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u0430.',
		'CRRUI2054E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: divide()\u00a0\u2014 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u043e {0} \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430(\u043e\u0432); \u043e\u0436\u0438\u0434\u0430\u043b\u043e\u0441\u044c 1 \u0438 3.',
		'CRRUI2055E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: divideInteger()\u00a0\u2014 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u043e {0} \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430(\u043e\u0432); \u043e\u0436\u0438\u0434\u0430\u043b\u043e\u0441\u044c 1 \u0438\u043b\u0438 2.',
		'CRRUI2056E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: max()\u00a0\u2014 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u043e {0} \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430(\u043e\u0432); \u043e\u0436\u0438\u0434\u0430\u043b\u043e\u0441\u044c 1 \u0438\u043b\u0438 2.',
		'CRRUI2057E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: min()\u00a0\u2014 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u043e {0} \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430(\u043e\u0432); \u043e\u0436\u0438\u0434\u0430\u043b\u043e\u0441\u044c 1 \u0438\u043b\u0438 2.',
		'CRRUI2058E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: multiply()\u00a0\u2014 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u043e {0} \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430(\u043e\u0432); \u043e\u0436\u0438\u0434\u0430\u043b\u043e\u0441\u044c 1 \u0438\u043b\u0438 2.',
		'CRRUI2059E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: negate()\u00a0\u2014 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u043e {0} \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430(\u043e\u0432); \u043e\u0436\u0438\u0434\u0430\u043b\u043e\u0441\u044c 0 \u0438\u043b\u0438 1.',
		'CRRUI2060E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: plus()\u00a0\u2014 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u043e {0} \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430(\u043e\u0432); \u043e\u0436\u0438\u0434\u0430\u043b\u043e\u0441\u044c 0 \u0438\u043b\u0438 1.',
		'CRRUI2061E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: pow()\u00a0\u2014 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u043e {0} \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430(\u043e\u0432); \u043e\u0436\u0438\u0434\u0430\u043b\u043e\u0441\u044c 1 \u0438\u043b\u0438 2.',
		'CRRUI2062E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: pow()\u00a0\u2014 \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044c \u0441\u0442\u0435\u043f\u0435\u043d\u0438 {0}.',
		'CRRUI2063E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: pow()\u00a0\u2014 \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u043d\u043e\u0433\u043e \u0440\u0430\u0437\u0440\u044f\u0434\u043e\u0432 {0}.',
		'CRRUI2064E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: remainder()\u00a0\u2014 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u043e {0} \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430(\u043e\u0432); \u043e\u0436\u0438\u0434\u0430\u043b\u043e\u0441\u044c 1 \u0438\u043b\u0438 2.',
		'CRRUI2065E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: subtract()\u00a0\u2014 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u043e {0} \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430(\u043e\u0432); \u043e\u0436\u0438\u0434\u0430\u043b\u043e\u0441\u044c 1 \u0438\u043b\u0438 2.',
		'CRRUI2066E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: format()\u00a0\u2014 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u043e {0} \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430(\u043e\u0432); \u043e\u0436\u0438\u0434\u0430\u043b\u043e\u0441\u044c 2 \u0438\u043b\u0438 6.',
		'CRRUI2067E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: format()\u00a0\u2014 \u043f\u0435\u0440\u0435\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044f \u0441\u0442\u0435\u043f\u0435\u043d\u0438 {0}.',
		'CRRUI2068E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: intValueExact()\u00a0\u2014 \u0434\u0440\u043e\u0431\u043d\u0430\u044f \u0447\u0430\u0441\u0442\u044c \u043d\u0435 \u0440\u0430\u0432\u043d\u0430 0, {0}',
		'CRRUI2069E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: intValueExact()\u00a0\u2014 \u043f\u0440\u0438 \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u0438 \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u043e \u043f\u0435\u0440\u0435\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435, {0}.',
		'CRRUI2070E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: setScale()\u00a0\u2014 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u043e {0} \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430(\u043e\u0432); \u043e\u0436\u0438\u0434\u0430\u043b\u043e\u0441\u044c 1 \u0438\u043b\u0438 2.',
		'CRRUI2071E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: setScale()\u00a0\u2014 \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0434\u043b\u0438\u043d\u0430 \u0434\u0440\u043e\u0431\u043d\u043e\u0439 \u0447\u0430\u0441\u0442\u0438, {0}.',
		'CRRUI2072E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: intCheck()\u00a0\u2014 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f, {0}.',
		'CRRUI2073E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: dodivide()\u00a0\u2014 \u0446\u0435\u043b\u043e\u0447\u0438\u0441\u043b\u0435\u043d\u043d\u043e\u0435 \u043f\u0435\u0440\u0435\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435.',
		'CRRUI2074E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: \u0441\u0442\u0440\u043e\u043a\u0443 \"{1}\" \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c \u0432 \u0447\u0438\u0441\u043b\u043e.',
		'CRRUI2075E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0447\u0438\u0441\u043b\u043e \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u043e\u0432 {0} \u0434\u043b\u044f \u043c\u0435\u0442\u043e\u0434\u0430 {1}. \u041f\u0435\u0440\u0435\u0434\u0430\u043d\u043d\u044b\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u00a0\u2014 {2}.',
		'CRRUI2076E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u043d\u043e\u0433\u043e \u0440\u0430\u0437\u0440\u044f\u0434\u043e\u0432\u00a0\u2014 {0}.',
		'CRRUI2077E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: round()\u00a0\u2014 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u043e {0} \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430(\u043e\u0432); \u043e\u0436\u0438\u0434\u0430\u043b\u043e\u0441\u044c 1 \u0438\u043b\u0438 2.',
		'CRRUI2078E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: round()\u00a0\u2014 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u043a\u0440\u0443\u0433\u043b\u0435\u043d\u0438\u0435.',
		'CRRUI2079E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: round()\u00a0\u2014 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043e\u043a\u0440\u0443\u0433\u043b\u0435\u043d\u0438\u044f, {0}.',
		'CRRUI2080E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: round()\u00a0\u2014 \u043f\u0435\u0440\u0435\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044f \u0441\u0442\u0435\u043f\u0435\u043d\u0438 {0}.',
		'CRRUI2081E' : '\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: finish()\u00a0\u2014 \u043f\u0435\u0440\u0435\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u044f \u0441\u0442\u0435\u043f\u0435\u043d\u0438 {0}.',
		'CRRUI2082E' : '\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430: \u0432\u043e \u0432\u0440\u0435\u043c\u044f \u0432\u044b\u0437\u043e\u0432\u0430 \u043a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0442\u043e\u0440\u0430 \u0434\u043b\u044f {0}.',
		'CRRUI2083E' : '\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430: \u0432\u043e \u0432\u0440\u0435\u043c\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u043a\u043b\u0430\u0441\u0441\u0430 {0} \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043d\u0435\u043f\u043e\u043b\u0430\u0434\u043a\u0430.',
		'CRRUI2084E' : '\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430: \u0432\u043e \u0432\u0440\u0435\u043c\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u0432\u0438\u0434\u0436\u0435\u0442\u0430 {0}.{1} \u043a\u0430\u043a \u043f\u043e\u0434\u043a\u043b\u0430\u0441\u0441\u0430 egl.ui.rui.RUIPropertiesLibrary',
		'CRRUI2085E' : '\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430: \u0432\u043e \u0432\u0440\u0435\u043c\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u0443\u043f\u0440\u0430\u0432\u043b\u044f\u044e\u0449\u0435\u0433\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 {0}.{1} \u043a\u0430\u043a \u043f\u043e\u0434\u043a\u043b\u0430\u0441\u0441\u0430 {2}.{3}.',
		'CRRUI2086E' : '\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430: \u0432\u043e \u0432\u0440\u0435\u043c\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430 RUI {0} \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043d\u0435\u043f\u043e\u043b\u0430\u0434\u043a\u0430.',
		'CRRUI2087E' : '\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430: \u0432\u043e \u0432\u0440\u0435\u043c\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u0443\u043f\u0440\u0430\u0432\u043b\u044f\u044e\u0449\u0435\u0433\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 RUI {0} \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043d\u0435\u043f\u043e\u043b\u0430\u0434\u043a\u0430.',
		'CRRUI2088E' : '\u042d\u0442\u043e\u0442 \u0431\u0440\u0430\u0443\u0437\u0435\u0440 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u043d\u044b\u043c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u043c \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u043e\u043c EGL.',
		'CRRUI2089E' : '\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0438\u0437 \u0444\u043e\u0440\u043c\u0430\u0442\u0430 JSON: "{0}", \u0438\u0437-\u0437\u0430 {1}.',
		'CRRUI2090E' : '\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u0437\u0432\u0430\u0442\u044c \u0441\u043b\u0443\u0436\u0431\u0443: {0}',
		'CRRUI2091E' : '\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u0441\u043b\u0430\u0442\u044c \u0441\u043e\u0431\u044b\u0442\u0438\u0435 \u0432 \u0441\u0440\u0435\u0434\u0443 \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u043a\u0438 Eclipse: {0}.',
		'CRRUI2092E' : '\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430: \u0432\u043e \u0432\u0440\u0435\u043c\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0441\u043e\u0431\u044b\u0442\u0438\u044f {0} \u0441\u0440\u0435\u0434\u044b \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043d\u0435\u043f\u043e\u043b\u0430\u0434\u043a\u0430.',
		'CRRUI2093E' : '\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u043a\u043e\u0434 \u0432 \u0444\u0443\u043d\u043a\u0446\u0438\u044e {0}.',
		'CRRUI2094E' : '\u0412\u044b\u0437\u043e\u0432\u044b \u0444\u0443\u043d\u043a\u0446\u0438\u0439 EGL \u043f\u0440\u0438\u0432\u043e\u0434\u044f\u0442 \u043a \u043e\u0448\u0438\u0431\u043a\u0435:',
		'CRRUI2095E' : '\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0432\u044b\u0437\u043e\u0432\u044b \u0444\u0443\u043d\u043a\u0446\u0438\u0438 EGL, \u0432\u043b\u0435\u043a\u0443\u0449\u0438\u0435 \u0437\u0430 \u0441\u043e\u0431\u043e\u0439 \u044d\u0442\u0443 \u043e\u0448\u0438\u0431\u043a\u0443.',
		'CRRUI2097E' : '\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 "{1}" \u0441\u0442\u0438\u043b\u044f CSS \u0434\u043b\u044f \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430 {0}.',
		'CRRUI2097E' : '\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u043d\u0430\u043b\u0438\u0437\u0430 \u0441\u0442\u0438\u043b\u044f CSS {0}. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0441\u0438\u043d\u0442\u0430\u043a\u0441\u0438\u0441 \u0438\u043b\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0432\u043d\u0435\u0448\u043d\u044e\u044e \u0442\u0430\u0431\u043b\u0438\u0446\u0443 \u0441\u0442\u0438\u043b\u0435\u0439.',
		'CRRUI2098E' : '\u0412\u043e \u0432\u0440\u0435\u043c\u044f \u043f\u0435\u0440\u0435\u0442\u0430\u0441\u043a\u0438\u0432\u0430\u043d\u0438\u044f \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430: {0}.',
		'CRRUI2099E' : '\u0412 \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u043d\u043e\u043c UI \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f "set" EGL \u0434\u043b\u044f \u0442\u0438\u043f\u0430 {0} \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.',
		'CRRUI2100E' : '\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 \u0434\u043b\u044f RuiLib.convertFromXML. \u041e\u0436\u0438\u0434\u0430\u043b\u0441\u044f \u043e\u0431\u044a\u0435\u043a\u0442 \u0442\u0438\u043f\u0430 String. \u041f\u0435\u0440\u0435\u0434\u0430\u043d \u043e\u0431\u044a\u0435\u043a\u0442 \u0442\u0438\u043f\u0430 {0}.',
		'CRRUI2101E' : '\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d indexOf "{1}" \u0432 "{0}" \u0438\u0437-\u0437\u0430 {2}.',
		'CRRUI2102E' : '\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u0442\u0438\u043f\u0430 Array \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430.',
		'CRRUI2103E' : '\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f \u043a "{0}" \u0432 \u043e\u0431\u044a\u0435\u043a\u0442\u0435 \u0442\u0438\u043f\u0430 "{1}" \u0438\u0437-\u0437\u0430 {2}.',
		'CRRUI2104E' : '\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0441\u0438\u043d\u0442\u0430\u043a\u0441\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0430\u043d\u0430\u043b\u0438\u0437 \u0441\u0442\u0440\u043e\u043a\u0438 JSON "{0}".',
		'CRRUI2105E' : '\u041f\u0440\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435 \u043f\u043e\u043b\u044f {0} \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u0441\u0438\u043d\u0442\u0430\u043a\u0441\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 JSON. \u041f\u043e\u043b\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u043e\u0436\u0438\u0434\u0430\u0435\u043c\u043e\u043c \u043c\u0435\u0441\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0438 JSON.',
		'CRRUI2106E' : '\u0412\u043e \u0432\u0440\u0435\u043c\u044f \u0441\u0438\u043d\u0442\u0430\u043a\u0441\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0430\u043d\u0430\u043b\u0438\u0437\u0430 JSON \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c {0} \u0432 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 null: \u044d\u0442\u043e\u043c\u0443 \u043f\u043e\u043b\u044e \u043d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e \u0438\u043c\u0435\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 null.',
		'CRRUI2107E' : '\u0424\u0443\u043d\u043a\u0446\u0438\u0438 \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f JSON \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 \u0441\u043b\u0443\u0436\u0431 \u0440\u0430\u0431\u043e\u0442\u0430\u044e\u0442 \u0441 \u0437\u0430\u043f\u0438\u0441\u044c\u044e \u0438\u043b\u0438 \u0441\u043b\u043e\u0432\u0430\u0440\u0435\u043c. \u0422\u0438\u043f {0} \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.',
		'CRRUI2108E' : '\u0424\u0443\u043d\u043a\u0446\u0438\u0438 \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f XML \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438 XML \u0440\u0430\u0431\u043e\u0442\u0430\u044e\u0442 \u0441 \u0437\u0430\u043f\u0438\u0441\u044c\u044e. \u0422\u0438\u043f {0} \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.',
		
		'CRRUI2111E' : '\u041e\u0448\u0438\u0431\u043a\u0430 MathContext(): \u0423\u043a\u0430\u0437\u0430\u043d\u043e \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0447\u0438\u0441\u043b\u043e \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u043e\u0432({0}); \u043e\u0436\u0438\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043e\u0442 1 \u0434\u043e 4',
		'CRRUI2112E' : '\u041e\u0448\u0438\u0431\u043a\u0430 MathContext(): \u0423\u043a\u0430\u0437\u0430\u043d\u043e \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u0430\u043b\u0435\u043d\u044c\u043a\u043e\u0435 \u0447\u0438\u0441\u043b\u043e \u0446\u0438\u0444\u0440 ({0}).',
		'CRRUI2113E' : '\u041e\u0448\u0438\u0431\u043a\u0430 MathContext(): \u0423\u043a\u0430\u0437\u0430\u043d\u043e \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0431\u043e\u043b\u044c\u0448\u043e\u0435 \u0447\u0438\u0441\u043b\u043e \u0446\u0438\u0444\u0440 ({0}).',
		'CRRUI2114E' : '\u041e\u0448\u0438\u0431\u043a\u0430 MathContext(): \u0423\u043a\u0430\u0437\u0430\u043d\u043e \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0444\u043e\u0440\u043c\u044b ({0}).',
		'CRRUI2115E' : '\u041e\u0448\u0438\u0431\u043a\u0430 MathContext(): \u0417\u0430\u0434\u0430\u043d \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0440\u0435\u0436\u0438\u043c \u043e\u043a\u0440\u0443\u0433\u043b\u0435\u043d\u0438\u044f ({0}).',
		
	    'CRRUI2700E' : '\u041d\u0435 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0432\u0445\u043e\u0434\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u043e\u043b\u044f - \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u043d\u043e\u0432\u0430.',
		'CRRUI2702E' : '\u041e\u0448\u0438\u0431\u043a\u0430 \u0442\u0438\u043f\u0430 \u0432\u0445\u043e\u0434\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 - \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u043d\u043e\u0432\u0430.',
		'CRRUI2703E' : '\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u043e \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0437\u043d\u0430\u0447\u0430\u0449\u0438\u0445 \u0446\u0438\u0444\u0440 - \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u043d\u043e\u0432\u0430.',
		'CRRUI2704E' : '\u0412\u0445\u043e\u0434\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043b\u0435\u0436\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u043c\u0438 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 {0}\u2014{1}. \u041f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0435 \u0432\u0432\u043e\u0434.',
		'CRRUI2705E' : '\u041e\u0448\u0438\u0431\u043a\u0430 \u043c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0439 \u0434\u043b\u0438\u043d\u044b \u0432\u0432\u043e\u0434\u0430 - \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u043d\u043e\u0432\u0430.',
		'CRRUI2707E' : '\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043e\u0441\u043d\u043e\u0432\u0430\u043d\u0438\u044f \u0432\u0445\u043e\u0434\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 - \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u043d\u043e\u0432\u0430.',
		'CRRUI2708E' : '\u0412\u0432\u0435\u0434\u0435\u043d\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u043c\u0443 \u0444\u043e\u0440\u043c\u0430\u0442\u0443 \u0434\u0430\u0442\u044b \u0438\u043b\u0438 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 {0}.',
		'CRRUI2710E' : '\u0412\u0435\u0434\u0435\u043d\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b \u0434\u043b\u044f \u0431\u0443\u043b\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u043b\u044f.',
		'CRRUI2712E' : '\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0448\u0435\u0441\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u0435\u0440\u0438\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.',
		'CRRUI2713E' : '\u0412\u0432\u0435\u0434\u0435\u043d\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e, \u043f\u043e\u0441\u043a\u043e\u043b\u044c\u043a\u0443 \u043e\u043d\u043e \u043d\u0435 \u0443\u0434\u043e\u0432\u043b\u0435\u0442\u0432\u043e\u0440\u044f\u0435\u0442 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u043e\u043c\u0443 \u0448\u0430\u0431\u043b\u043e\u043d\u0443.',		
		'CRRUI2716E' : '\u0412\u0445\u043e\u0434\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u0435 \u0432\u0445\u043e\u0434\u0438\u0442 \u0432 \u0447\u0438\u0441\u043b\u043e \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 - \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u043d\u043e\u0432\u0430.',
		'CRRUI2717E' : '\u0423\u043a\u0430\u0437\u0430\u043d \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u0442\u044b \u0438 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 {0}.',	
		'CRRUI2719E' : '\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0438\u043d\u0442\u0430\u043a\u0441\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0430\u043d\u0430\u043b\u0438\u0437\u0430 \u0432\u0445\u043e\u0434\u043d\u043e\u0433\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f.',

		'CRRUI3650E' : '\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0444\u0430\u0439\u043b \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u044f: \"{0}\".',
		'CRRUI3651E' : '\u041a\u043b\u044e\u0447 \u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0438 \u0441\u043b\u0443\u0436\u0431\u044b: \"{0}\" \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0444\u0430\u0439\u043b\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u044f \"{1}\".',
		'CRRUI3652E' : '\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0442\u0438\u043f \u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0438 \u0441\u043b\u0443\u0436\u0431\u044b \"{0}\", \u043e\u0436\u0438\u0434\u0430\u043b\u0441\u044f \u0442\u0438\u043f \"{1}\".',
		'CRRUI3653E' : '\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0437\u043e\u0432\u0430 \u0441\u043b\u0443\u0436\u0431\u044b REST \u043d\u0430 \"{0}\".',
		'CRRUI3654E' : '\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430: \"{0}\".',
		'CRRUI3655E' : '\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u043e\u0442\u0432\u0435\u0442\u0430: \"{0}\".',
		'CRRUI3656E' : '\"formdata\" \u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u0444\u043e\u0440\u043c\u0430\u0442\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.',
		'CRRUI3657E' : '\u041d\u0430 \"{0}\" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d proxy \u0434\u043b\u044f \u0432\u044b\u0437\u043e\u0432\u0430 \u0441\u043b\u0443\u0436\u0431.',
		'CRRUI3658E' : '\u041d\u0430 \"{0}\" \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 proxy \u0432\u043e \u0432\u0440\u0435\u043c\u044f \u0432\u044b\u0437\u043e\u0432\u0430 \u0441\u043b\u0443\u0436\u0431\u044b \"{1}\".',
		'CRRUI3659E' : '\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0430\u043d\u0430\u043b\u0438\u0437\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 JSON\u00a0\u2014 \"null\"; \u0438\u0441\u0445\u043e\u0434\u043d\u044b\u0439 \u043e\u0442\u0432\u0435\u0442: \"{0}\".',
		'CRRUI3660E' : '\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u043e\u0442\u0432\u0435\u0442 \u0434\u043b\u044f \"{0}\"; \u043f\u0440\u0438\u0447\u0438\u043d\u0430: \"{1}\".',
		'CRRUI3661E' : '\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0441\u0432\u044f\u0437\u044b\u0432\u0430\u043d\u0438\u0438 \u0441\u043b\u0443\u0436\u0431\u044b \'{0}\', \u0432\u044b\u0437\u0432\u0430\u043d\u0430 \u0441\u043b\u0443\u0436\u0435\u0431\u043d\u0430\u044f \u0444\u0443\u043d\u043a\u0446\u0438\u044f \'{1}\'.'
};

