/*******************************************************************************
 * Copyright © 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/

package org.eclipse.edt.compiler.core.ast;

import java.util.*;

public class NodeNameUtility {

private static Map terminalIntToStringMap = new HashMap();
private static Map nonterminalIntToStringMap = new HashMap();
private static Map terminalStringToIntMap = new HashMap();
private static Map nonterminalStringToIntMap = new HashMap();

static {
terminalIntToStringMap.put(new Integer(133), "DISPLAY");
terminalStringToIntMap.put("DISPLAY", new Integer(133));
terminalIntToStringMap.put(new Integer(146), "FREESQL");
terminalStringToIntMap.put("FREESQL", new Integer(146));
terminalIntToStringMap.put(new Integer(72), "DATATABLE");
terminalStringToIntMap.put("DATATABLE", new Integer(72));
terminalIntToStringMap.put(new Integer(84), "IMPLEMENTS");
terminalStringToIntMap.put("IMPLEMENTS", new Integer(84));
terminalIntToStringMap.put(new Integer(120), "EXIT");
terminalStringToIntMap.put("EXIT", new Integer(120));
terminalIntToStringMap.put(new Integer(24), ">");
terminalStringToIntMap.put(">", new Integer(24));
terminalIntToStringMap.put(new Integer(140), "GET");
terminalStringToIntMap.put("GET", new Integer(140));
terminalIntToStringMap.put(new Integer(185), "HOLD");
terminalStringToIntMap.put("HOLD", new Integer(185));
terminalIntToStringMap.put(new Integer(17), "LIKE");
terminalStringToIntMap.put("LIKE", new Integer(17));
terminalIntToStringMap.put(new Integer(40), "BITANDEQ");
terminalStringToIntMap.put("BITANDEQ", new Integer(40));
terminalIntToStringMap.put(new Integer(45), "DIVEQ");
terminalStringToIntMap.put("DIVEQ", new Integer(45));
terminalIntToStringMap.put(new Integer(7), "ERRORSQLSTMTLIT");
terminalStringToIntMap.put("ERRORSQLSTMTLIT", new Integer(7));
terminalIntToStringMap.put(new Integer(26), ">=");
terminalStringToIntMap.put(">=", new Integer(26));
terminalIntToStringMap.put(new Integer(117), "CALL");
terminalStringToIntMap.put("CALL", new Integer(117));
terminalIntToStringMap.put(new Integer(47), "CONCATEQ");
terminalStringToIntMap.put("CONCATEQ", new Integer(47));
terminalIntToStringMap.put(new Integer(174), "STACK");
terminalStringToIntMap.put("STACK", new Integer(174));
terminalIntToStringMap.put(new Integer(6), "ERRORBLOCKCOMMENT");
terminalStringToIntMap.put("ERRORBLOCKCOMMENT", new Integer(6));
terminalIntToStringMap.put(new Integer(12), "BITAND");
terminalStringToIntMap.put("BITAND", new Integer(12));
terminalIntToStringMap.put(new Integer(90), "SQLNULLABLE");
terminalStringToIntMap.put("SQLNULLABLE", new Integer(90));
terminalIntToStringMap.put(new Integer(52), ")");
terminalStringToIntMap.put(")", new Integer(52));
terminalIntToStringMap.put(new Integer(151), "INTO");
terminalStringToIntMap.put("INTO", new Integer(151));
terminalIntToStringMap.put(new Integer(176), "BYPOSITION");
terminalStringToIntMap.put("BYPOSITION", new Integer(176));
terminalIntToStringMap.put(new Integer(74), "FORM");
terminalStringToIntMap.put("FORM", new Integer(74));
terminalIntToStringMap.put(new Integer(153), "DECREMENT");
terminalStringToIntMap.put("DECREMENT", new Integer(153));
terminalIntToStringMap.put(new Integer(193), "WHERE");
terminalStringToIntMap.put("WHERE", new Integer(193));
terminalIntToStringMap.put(new Integer(32), "*");
terminalStringToIntMap.put("*", new Integer(32));
terminalIntToStringMap.put(new Integer(44), "TIMESEQ");
terminalStringToIntMap.put("TIMESEQ", new Integer(44));
terminalIntToStringMap.put(new Integer(71), "RECORD");
terminalStringToIntMap.put("RECORD", new Integer(71));
terminalIntToStringMap.put(new Integer(65), "BLOCK_COMMENT");
terminalStringToIntMap.put("BLOCK_COMMENT", new Integer(65));
terminalIntToStringMap.put(new Integer(121), "GOTO");
terminalStringToIntMap.put("GOTO", new Integer(121));
terminalIntToStringMap.put(new Integer(112), "INLINE_DLI");
terminalStringToIntMap.put("INLINE_DLI", new Integer(112));
terminalIntToStringMap.put(new Integer(62), "UMINUS");
terminalStringToIntMap.put("UMINUS", new Integer(62));
terminalIntToStringMap.put(new Integer(114), "NUMERICPRIMITIVE");
terminalStringToIntMap.put("NUMERICPRIMITIVE", new Integer(114));
terminalIntToStringMap.put(new Integer(143), "REPLACE");
terminalStringToIntMap.put("REPLACE", new Integer(143));
terminalIntToStringMap.put(new Integer(19), "ESCAPE");
terminalStringToIntMap.put("ESCAPE", new Integer(19));
terminalIntToStringMap.put(new Integer(21), "==");
terminalStringToIntMap.put("==", new Integer(21));
terminalIntToStringMap.put(new Integer(41), "BITOREQ");
terminalStringToIntMap.put("BITOREQ", new Integer(41));
terminalIntToStringMap.put(new Integer(76), "PROGRAM");
terminalStringToIntMap.put("PROGRAM", new Integer(76));
terminalIntToStringMap.put(new Integer(34), "**");
terminalStringToIntMap.put("**", new Integer(34));
terminalIntToStringMap.put(new Integer(136), "ADD");
terminalStringToIntMap.put("ADD", new Integer(136));
terminalIntToStringMap.put(new Integer(46), "TIMESTIMESEQ");
terminalStringToIntMap.put("TIMESTIMESEQ", new Integer(46));
terminalIntToStringMap.put(new Integer(86), "TYPE");
terminalStringToIntMap.put("TYPE", new Integer(86));
terminalIntToStringMap.put(new Integer(168), "RELATIVE");
terminalStringToIntMap.put("RELATIVE", new Integer(168));
terminalIntToStringMap.put(new Integer(113), "PRIMITIVE");
terminalStringToIntMap.put("PRIMITIVE", new Integer(113));
terminalIntToStringMap.put(new Integer(33), "/");
terminalStringToIntMap.put("/", new Integer(33));
terminalIntToStringMap.put(new Integer(3), "EOS");
terminalStringToIntMap.put("EOS", new Integer(3));
terminalIntToStringMap.put(new Integer(59), "=");
terminalStringToIntMap.put("=", new Integer(59));
terminalIntToStringMap.put(new Integer(181), "LABEL");
terminalStringToIntMap.put("LABEL", new Integer(181));
terminalIntToStringMap.put(new Integer(109), "NULL");
terminalStringToIntMap.put("NULL", new Integer(109));
terminalIntToStringMap.put(new Integer(142), "PREPARE");
terminalStringToIntMap.put("PREPARE", new Integer(142));
terminalIntToStringMap.put(new Integer(164), "PREVIOUS");
terminalStringToIntMap.put("PREVIOUS", new Integer(164));
terminalIntToStringMap.put(new Integer(96), "PRIVATE");
terminalStringToIntMap.put("PRIVATE", new Integer(96));
terminalIntToStringMap.put(new Integer(0), "EOF");
terminalStringToIntMap.put("EOF", new Integer(0));
terminalIntToStringMap.put(new Integer(30), "-");
terminalStringToIntMap.put("-", new Integer(30));
terminalIntToStringMap.put(new Integer(77), "LIBRARY");
terminalStringToIntMap.put("LIBRARY", new Integer(77));
terminalIntToStringMap.put(new Integer(190), "LANGUAGEBUNDLE");
terminalStringToIntMap.put("LANGUAGEBUNDLE", new Integer(190));
terminalIntToStringMap.put(new Integer(39), "QUESTION");
terminalStringToIntMap.put("QUESTION", new Integer(39));
terminalIntToStringMap.put(new Integer(123), "MOVE");
terminalStringToIntMap.put("MOVE", new Integer(123));
terminalIntToStringMap.put(new Integer(68), "IMPORT");
terminalStringToIntMap.put("IMPORT", new Integer(68));
terminalIntToStringMap.put(new Integer(67), "PACKAGE");
terminalStringToIntMap.put("PACKAGE", new Integer(67));
terminalIntToStringMap.put(new Integer(161), "USING");
terminalStringToIntMap.put("USING", new Integer(161));
terminalIntToStringMap.put(new Integer(35), "::");
terminalStringToIntMap.put("::", new Integer(35));
terminalIntToStringMap.put(new Integer(184), "ELSE");
terminalStringToIntMap.put("ELSE", new Integer(184));
terminalIntToStringMap.put(new Integer(175), "BYNAME");
terminalStringToIntMap.put("BYNAME", new Integer(175));
terminalIntToStringMap.put(new Integer(128), "TRY");
terminalStringToIntMap.put("TRY", new Integer(128));
terminalIntToStringMap.put(new Integer(49), "MODULOEQ");
terminalStringToIntMap.put("MODULOEQ", new Integer(49));
terminalIntToStringMap.put(new Integer(169), "ABSOLUTE");
terminalStringToIntMap.put("ABSOLUTE", new Integer(169));
terminalIntToStringMap.put(new Integer(81), "DELEGATE");
terminalStringToIntMap.put("DELEGATE", new Integer(81));
terminalIntToStringMap.put(new Integer(69), "END");
terminalStringToIntMap.put("END", new Integer(69));
terminalIntToStringMap.put(new Integer(9), "||");
terminalStringToIntMap.put("||", new Integer(9));
terminalIntToStringMap.put(new Integer(165), "FIRST");
terminalStringToIntMap.put("FIRST", new Integer(165));
terminalIntToStringMap.put(new Integer(115), "CHARPRIMITIVE");
terminalStringToIntMap.put("CHARPRIMITIVE", new Integer(115));
terminalIntToStringMap.put(new Integer(105), "HEXLIT");
terminalStringToIntMap.put("HEXLIT", new Integer(105));
terminalIntToStringMap.put(new Integer(75), "HANDLER");
terminalStringToIntMap.put("HANDLER", new Integer(75));
terminalIntToStringMap.put(new Integer(171), "WHEN");
terminalStringToIntMap.put("WHEN", new Integer(171));
terminalIntToStringMap.put(new Integer(10), "&&");
terminalStringToIntMap.put("&&", new Integer(10));
terminalIntToStringMap.put(new Integer(167), "CURRENT");
terminalStringToIntMap.put("CURRENT", new Integer(167));
terminalIntToStringMap.put(new Integer(94), "THIS");
terminalStringToIntMap.put("THIS", new Integer(94));
terminalIntToStringMap.put(new Integer(8), "ERROR_INLINE_DLI");
terminalStringToIntMap.put("ERROR_INLINE_DLI", new Integer(8));
terminalIntToStringMap.put(new Integer(191), "OF");
terminalStringToIntMap.put("OF", new Integer(191));
terminalIntToStringMap.put(new Integer(18), "MATCHES");
terminalStringToIntMap.put("MATCHES", new Integer(18));
terminalIntToStringMap.put(new Integer(152), "BY");
terminalStringToIntMap.put("BY", new Integer(152));
terminalIntToStringMap.put(new Integer(163), "NEXT");
terminalStringToIntMap.put("NEXT", new Integer(163));
terminalIntToStringMap.put(new Integer(89), "RETURNS");
terminalStringToIntMap.put("RETURNS", new Integer(89));
terminalIntToStringMap.put(new Integer(57), ";");
terminalStringToIntMap.put(";", new Integer(57));
terminalIntToStringMap.put(new Integer(116), "TIMESTAMPINTERVALPRIMITIVE");
terminalStringToIntMap.put("TIMESTAMPINTERVALPRIMITIVE", new Integer(116));
terminalIntToStringMap.put(new Integer(189), "GROUP");
terminalStringToIntMap.put("GROUP", new Integer(189));
terminalIntToStringMap.put(new Integer(166), "LAST");
terminalStringToIntMap.put("LAST", new Integer(166));
terminalIntToStringMap.put(new Integer(131), "CLOSE");
terminalStringToIntMap.put("CLOSE", new Integer(131));
terminalIntToStringMap.put(new Integer(95), "NEW");
terminalStringToIntMap.put("NEW", new Integer(95));
terminalIntToStringMap.put(new Integer(138), "DELETE");
terminalStringToIntMap.put("DELETE", new Integer(138));
terminalIntToStringMap.put(new Integer(192), "REF");
terminalStringToIntMap.put("REF", new Integer(192));
terminalIntToStringMap.put(new Integer(82), "EXTERNALTYPE");
terminalStringToIntMap.put("EXTERNALTYPE", new Integer(82));
terminalIntToStringMap.put(new Integer(43), "MINUSEQ");
terminalStringToIntMap.put("MINUSEQ", new Integer(43));
terminalIntToStringMap.put(new Integer(80), "INTERFACE");
terminalStringToIntMap.put("INTERFACE", new Integer(80));
terminalIntToStringMap.put(new Integer(56), "}");
terminalStringToIntMap.put("}", new Integer(56));
terminalIntToStringMap.put(new Integer(22), "!=");
terminalStringToIntMap.put("!=", new Integer(22));
terminalIntToStringMap.put(new Integer(132), "CONVERSE");
terminalStringToIntMap.put("CONVERSE", new Integer(132));
terminalIntToStringMap.put(new Integer(134), "PRINT");
terminalStringToIntMap.put("PRINT", new Integer(134));
terminalIntToStringMap.put(new Integer(37), "@");
terminalStringToIntMap.put("@", new Integer(37));
terminalIntToStringMap.put(new Integer(27), "AS");
terminalStringToIntMap.put("AS", new Integer(27));
terminalIntToStringMap.put(new Integer(188), "DLICALL");
terminalStringToIntMap.put("DLICALL", new Integer(188));
terminalIntToStringMap.put(new Integer(118), "CASE");
terminalStringToIntMap.put("CASE", new Integer(118));
terminalIntToStringMap.put(new Integer(42), "PLUSEQ");
terminalStringToIntMap.put("PLUSEQ", new Integer(42));
terminalIntToStringMap.put(new Integer(29), "+");
terminalStringToIntMap.put("+", new Integer(29));
terminalIntToStringMap.put(new Integer(129), "THROW");
terminalStringToIntMap.put("THROW", new Integer(129));
terminalIntToStringMap.put(new Integer(51), "(");
terminalStringToIntMap.put("(", new Integer(51));
terminalIntToStringMap.put(new Integer(178), "ALL");
terminalStringToIntMap.put("ALL", new Integer(178));
terminalIntToStringMap.put(new Integer(70), "DATAITEM");
terminalStringToIntMap.put("DATAITEM", new Integer(70));
terminalIntToStringMap.put(new Integer(54), "]");
terminalStringToIntMap.put("]", new Integer(54));
terminalIntToStringMap.put(new Integer(157), "USINGPCB");
terminalStringToIntMap.put("USINGPCB", new Integer(157));
terminalIntToStringMap.put(new Integer(135), "FORWARD");
terminalStringToIntMap.put("FORWARD", new Integer(135));
terminalIntToStringMap.put(new Integer(130), "WHILE");
terminalStringToIntMap.put("WHILE", new Integer(130));
terminalIntToStringMap.put(new Integer(63), "UPLUS");
terminalStringToIntMap.put("UPLUS", new Integer(63));
terminalIntToStringMap.put(new Integer(58), "CONST");
terminalStringToIntMap.put("CONST", new Integer(58));
terminalIntToStringMap.put(new Integer(13), "XOR");
terminalStringToIntMap.put("XOR", new Integer(13));
terminalIntToStringMap.put(new Integer(141), "OPEN");
terminalStringToIntMap.put("OPEN", new Integer(141));
terminalIntToStringMap.put(new Integer(173), "RUNUNIT");
terminalStringToIntMap.put("RUNUNIT", new Integer(173));
terminalIntToStringMap.put(new Integer(108), "MBCHARLIT");
terminalStringToIntMap.put("MBCHARLIT", new Integer(108));
terminalIntToStringMap.put(new Integer(170), "INPARENT");
terminalStringToIntMap.put("INPARENT", new Integer(170));
terminalIntToStringMap.put(new Integer(91), "FIELD");
terminalStringToIntMap.put("FIELD", new Integer(91));
terminalIntToStringMap.put(new Integer(61), ",");
terminalStringToIntMap.put(",", new Integer(61));
terminalIntToStringMap.put(new Integer(23), "<");
terminalStringToIntMap.put("<", new Integer(23));
terminalIntToStringMap.put(new Integer(194), "WRAP");
terminalStringToIntMap.put("WRAP", new Integer(194));
terminalIntToStringMap.put(new Integer(154), "RETURNING");
terminalStringToIntMap.put("RETURNING", new Integer(154));
terminalIntToStringMap.put(new Integer(31), "%");
terminalStringToIntMap.put("%", new Integer(31));
terminalIntToStringMap.put(new Integer(107), "DBCHARLIT");
terminalStringToIntMap.put("DBCHARLIT", new Integer(107));
terminalIntToStringMap.put(new Integer(148), "BIND");
terminalStringToIntMap.put("BIND", new Integer(148));
terminalIntToStringMap.put(new Integer(79), "SERVICE");
terminalStringToIntMap.put("SERVICE", new Integer(79));
terminalIntToStringMap.put(new Integer(83), "ENUMERATION");
terminalStringToIntMap.put("ENUMERATION", new Integer(83));
terminalIntToStringMap.put(new Integer(25), "<=");
terminalStringToIntMap.put("<=", new Integer(25));
terminalIntToStringMap.put(new Integer(186), "SCROLL");
terminalStringToIntMap.put("SCROLL", new Integer(186));
terminalIntToStringMap.put(new Integer(15), "NOT");
terminalStringToIntMap.put("NOT", new Integer(15));
terminalIntToStringMap.put(new Integer(93), "OUT");
terminalStringToIntMap.put("OUT", new Integer(93));
terminalIntToStringMap.put(new Integer(53), "[");
terminalStringToIntMap.put("[", new Integer(53));
terminalIntToStringMap.put(new Integer(106), "CHARLIT");
terminalStringToIntMap.put("CHARLIT", new Integer(106));
terminalIntToStringMap.put(new Integer(66), "LINEBREAKS");
terminalStringToIntMap.put("LINEBREAKS", new Integer(66));
terminalIntToStringMap.put(new Integer(156), "WITH");
terminalStringToIntMap.put("WITH", new Integer(156));
terminalIntToStringMap.put(new Integer(137), "SHOW");
terminalStringToIntMap.put("SHOW", new Integer(137));
terminalIntToStringMap.put(new Integer(20), "!");
terminalStringToIntMap.put("!", new Integer(20));
terminalIntToStringMap.put(new Integer(160), "SINGLEROW");
terminalStringToIntMap.put("SINGLEROW", new Integer(160));
terminalIntToStringMap.put(new Integer(158), "FORUPDATE");
terminalStringToIntMap.put("FORUPDATE", new Integer(158));
terminalIntToStringMap.put(new Integer(125), "RETURN");
terminalStringToIntMap.put("RETURN", new Integer(125));
terminalIntToStringMap.put(new Integer(4), "WS");
terminalStringToIntMap.put("WS", new Integer(4));
terminalIntToStringMap.put(new Integer(102), "FLOATLIT");
terminalStringToIntMap.put("FLOATLIT", new Integer(102));
terminalIntToStringMap.put(new Integer(64), "LINE_COMMENT");
terminalStringToIntMap.put("LINE_COMMENT", new Integer(64));
terminalIntToStringMap.put(new Integer(144), "FOR");
terminalStringToIntMap.put("FOR", new Integer(144));
terminalIntToStringMap.put(new Integer(78), "FUNCTION");
terminalStringToIntMap.put("FUNCTION", new Integer(78));
terminalIntToStringMap.put(new Integer(179), "TRANSACTION");
terminalStringToIntMap.put("TRANSACTION", new Integer(179));
terminalIntToStringMap.put(new Integer(50), "XOREQ");
terminalStringToIntMap.put("XOREQ", new Integer(50));
terminalIntToStringMap.put(new Integer(100), "INTEGER");
terminalStringToIntMap.put("INTEGER", new Integer(100));
terminalIntToStringMap.put(new Integer(38), ".");
terminalStringToIntMap.put(".", new Integer(38));
terminalIntToStringMap.put(new Integer(177), "WITHV60COMPAT");
terminalStringToIntMap.put("WITHV60COMPAT", new Integer(177));
terminalIntToStringMap.put(new Integer(162), "USINGKEYS");
terminalStringToIntMap.put("USINGKEYS", new Integer(162));
terminalIntToStringMap.put(new Integer(127), "TRANSFER");
terminalStringToIntMap.put("TRANSFER", new Integer(127));
terminalIntToStringMap.put(new Integer(104), "STRING");
terminalStringToIntMap.put("STRING", new Integer(104));
terminalIntToStringMap.put(new Integer(2), "BOS");
terminalStringToIntMap.put("BOS", new Integer(2));
terminalIntToStringMap.put(new Integer(183), "INSERT");
terminalStringToIntMap.put("INSERT", new Integer(183));
terminalIntToStringMap.put(new Integer(98), "CONSTRUCTOR");
terminalStringToIntMap.put("CONSTRUCTOR", new Integer(98));
terminalIntToStringMap.put(new Integer(119), "CONTINUE");
terminalStringToIntMap.put("CONTINUE", new Integer(119));
terminalIntToStringMap.put(new Integer(150), "FROM");
terminalStringToIntMap.put("FROM", new Integer(150));
terminalIntToStringMap.put(new Integer(88), "USE");
terminalStringToIntMap.put("USE", new Integer(88));
terminalIntToStringMap.put(new Integer(11), "BITOR");
terminalStringToIntMap.put("BITOR", new Integer(11));
terminalIntToStringMap.put(new Integer(172), "OTHERWISE");
terminalStringToIntMap.put("OTHERWISE", new Integer(172));
terminalIntToStringMap.put(new Integer(87), "EMBED");
terminalStringToIntMap.put("EMBED", new Integer(87));
terminalIntToStringMap.put(new Integer(149), "ONEVENT");
terminalStringToIntMap.put("ONEVENT", new Integer(149));
terminalIntToStringMap.put(new Integer(145), "FOREACH");
terminalStringToIntMap.put("FOREACH", new Integer(145));
terminalIntToStringMap.put(new Integer(14), "IS");
terminalStringToIntMap.put("IS", new Integer(14));
terminalIntToStringMap.put(new Integer(36), "NULLCONCAT");
terminalStringToIntMap.put("NULLCONCAT", new Integer(36));
terminalIntToStringMap.put(new Integer(180), "URL");
terminalStringToIntMap.put("URL", new Integer(180));
terminalIntToStringMap.put(new Integer(16), "IN");
terminalStringToIntMap.put("IN", new Integer(16));
terminalIntToStringMap.put(new Integer(101), "DECIMALLIT");
terminalStringToIntMap.put("DECIMALLIT", new Integer(101));
terminalIntToStringMap.put(new Integer(1), "error");
terminalStringToIntMap.put("error", new Integer(1));
terminalIntToStringMap.put(new Integer(122), "IF");
terminalStringToIntMap.put("IF", new Integer(122));
terminalIntToStringMap.put(new Integer(99), "ID");
terminalStringToIntMap.put("ID", new Integer(99));
terminalIntToStringMap.put(new Integer(97), "STATIC");
terminalStringToIntMap.put("STATIC", new Integer(97));
terminalIntToStringMap.put(new Integer(155), "PASSING");
terminalStringToIntMap.put("PASSING", new Integer(155));
terminalIntToStringMap.put(new Integer(103), "BOOLEANLIT");
terminalStringToIntMap.put("BOOLEANLIT", new Integer(103));
terminalIntToStringMap.put(new Integer(159), "NOCURSOR");
terminalStringToIntMap.put("NOCURSOR", new Integer(159));
terminalIntToStringMap.put(new Integer(110), "SQLSTMTLIT");
terminalStringToIntMap.put("SQLSTMTLIT", new Integer(110));
terminalIntToStringMap.put(new Integer(60), ":");
terminalStringToIntMap.put(":", new Integer(60));
terminalIntToStringMap.put(new Integer(126), "SET");
terminalStringToIntMap.put("SET", new Integer(126));
terminalIntToStringMap.put(new Integer(147), "OPENUI");
terminalStringToIntMap.put("OPENUI", new Integer(147));
terminalIntToStringMap.put(new Integer(28), "ISA");
terminalStringToIntMap.put("ISA", new Integer(28));
terminalIntToStringMap.put(new Integer(111), "SQLCONDITION");
terminalStringToIntMap.put("SQLCONDITION", new Integer(111));
terminalIntToStringMap.put(new Integer(55), "{");
terminalStringToIntMap.put("{", new Integer(55));
terminalIntToStringMap.put(new Integer(139), "EXECUTE");
terminalStringToIntMap.put("EXECUTE", new Integer(139));
terminalIntToStringMap.put(new Integer(5), "ERRORSTRING");
terminalStringToIntMap.put("ERRORSTRING", new Integer(5));
terminalIntToStringMap.put(new Integer(48), "NULLCONCATEQ");
terminalStringToIntMap.put("NULLCONCATEQ", new Integer(48));
terminalIntToStringMap.put(new Integer(85), "EXTENDS");
terminalStringToIntMap.put("EXTENDS", new Integer(85));
terminalIntToStringMap.put(new Integer(73), "FORMGROUP");
terminalStringToIntMap.put("FORMGROUP", new Integer(73));
terminalIntToStringMap.put(new Integer(187), "ONEXCEPTION");
terminalStringToIntMap.put("ONEXCEPTION", new Integer(187));
terminalIntToStringMap.put(new Integer(182), "UPDATE");
terminalStringToIntMap.put("UPDATE", new Integer(182));
terminalIntToStringMap.put(new Integer(124), "TO");
terminalStringToIntMap.put("TO", new Integer(124));
terminalIntToStringMap.put(new Integer(92), "INOUT");
terminalStringToIntMap.put("INOUT", new Integer(92));
nonterminalIntToStringMap.put(new Integer(40), "getByPositionSource");
nonterminalStringToIntMap.put("getByPositionSource", new Integer(40));
nonterminalIntToStringMap.put(new Integer(132), "onException_star");
nonterminalStringToIntMap.put("onException_star", new Integer(132));
nonterminalIntToStringMap.put(new Integer(138), "programParameter_star");
nonterminalStringToIntMap.put("programParameter_star", new Integer(138));
nonterminalIntToStringMap.put(new Integer(152), "structureContent_star");
nonterminalStringToIntMap.put("structureContent_star", new Integer(152));
nonterminalIntToStringMap.put(new Integer(34), "forwardTargetOpt");
nonterminalStringToIntMap.put("forwardTargetOpt", new Integer(34));
nonterminalIntToStringMap.put(new Integer(60), "occursOpt");
nonterminalStringToIntMap.put("occursOpt", new Integer(60));
nonterminalIntToStringMap.put(new Integer(35), "fromExprOpt");
nonterminalStringToIntMap.put("fromExprOpt", new Integer(35));
nonterminalIntToStringMap.put(new Integer(21), "enumerationField");
nonterminalStringToIntMap.put("enumerationField", new Integer(21));
nonterminalIntToStringMap.put(new Integer(39), "getByPositionOption");
nonterminalStringToIntMap.put("getByPositionOption", new Integer(39));
nonterminalIntToStringMap.put(new Integer(46), "inlineSQLStatementOpt");
nonterminalStringToIntMap.put("inlineSQLStatementOpt", new Integer(46));
nonterminalIntToStringMap.put(new Integer(30), "foreachTarget");
nonterminalStringToIntMap.put("foreachTarget", new Integer(30));
nonterminalIntToStringMap.put(new Integer(8), "attrTypeOpt");
nonterminalStringToIntMap.put("attrTypeOpt", new Integer(8));
nonterminalIntToStringMap.put(new Integer(24), "exitModifierOpt");
nonterminalStringToIntMap.put("exitModifierOpt", new Integer(24));
nonterminalIntToStringMap.put(new Integer(15), "handlerContent");
nonterminalStringToIntMap.put("handlerContent", new Integer(15));
nonterminalIntToStringMap.put(new Integer(37), "functionParameter");
nonterminalStringToIntMap.put("functionParameter", new Integer(37));
nonterminalIntToStringMap.put(new Integer(145), "setting_plus");
nonterminalStringToIntMap.put("setting_plus", new Integer(145));
nonterminalIntToStringMap.put(new Integer(19), "direction");
nonterminalStringToIntMap.put("direction", new Integer(19));
nonterminalIntToStringMap.put(new Integer(83), "staticAccessModifierOpt");
nonterminalStringToIntMap.put("staticAccessModifierOpt", new Integer(83));
nonterminalIntToStringMap.put(new Integer(107), "executeOption_star");
nonterminalStringToIntMap.put("executeOption_star", new Integer(107));
nonterminalIntToStringMap.put(new Integer(0), "$START");
nonterminalStringToIntMap.put("$START", new Integer(0));
nonterminalIntToStringMap.put(new Integer(2), "connector");
nonterminalStringToIntMap.put("connector", new Integer(2));
nonterminalIntToStringMap.put(new Integer(79), "settingsBlock");
nonterminalStringToIntMap.put("settingsBlock", new Integer(79));
nonterminalIntToStringMap.put(new Integer(76), "returnsOpt");
nonterminalStringToIntMap.put("returnsOpt", new Integer(76));
nonterminalIntToStringMap.put(new Integer(95), "addOption_star");
nonterminalStringToIntMap.put("addOption_star", new Integer(95));
nonterminalIntToStringMap.put(new Integer(81), "showOption");
nonterminalStringToIntMap.put("showOption", new Integer(81));
nonterminalIntToStringMap.put(new Integer(154), "whenClause_star");
nonterminalStringToIntMap.put("whenClause_star", new Integer(154));
nonterminalIntToStringMap.put(new Integer(26), "extendsOpt");
nonterminalStringToIntMap.put("extendsOpt", new Integer(26));
nonterminalIntToStringMap.put(new Integer(75), "foreachOption");
nonterminalStringToIntMap.put("foreachOption", new Integer(75));
nonterminalIntToStringMap.put(new Integer(90), "type");
nonterminalStringToIntMap.put("type", new Integer(90));
nonterminalIntToStringMap.put(new Integer(64), "packageDeclarationOpt");
nonterminalStringToIntMap.put("packageDeclarationOpt", new Integer(64));
nonterminalIntToStringMap.put(new Integer(129), "interfaceContent_plus");
nonterminalStringToIntMap.put("interfaceContent_plus", new Integer(129));
nonterminalIntToStringMap.put(new Integer(72), "programParameter");
nonterminalStringToIntMap.put("programParameter", new Integer(72));
nonterminalIntToStringMap.put(new Integer(86), "strItemDecl");
nonterminalStringToIntMap.put("strItemDecl", new Integer(86));
nonterminalIntToStringMap.put(new Integer(89), "transferTargetOpt");
nonterminalStringToIntMap.put("transferTargetOpt", new Integer(89));
nonterminalIntToStringMap.put(new Integer(73), "programParametersOpt");
nonterminalStringToIntMap.put("programParametersOpt", new Integer(73));
nonterminalIntToStringMap.put(new Integer(22), "eventBlock");
nonterminalStringToIntMap.put("eventBlock", new Integer(22));
nonterminalIntToStringMap.put(new Integer(78), "setting");
nonterminalStringToIntMap.put("setting", new Integer(78));
nonterminalIntToStringMap.put(new Integer(106), "eventBlock_plus");
nonterminalStringToIntMap.put("eventBlock_plus", new Integer(106));
nonterminalIntToStringMap.put(new Integer(36), "functionInvocation");
nonterminalStringToIntMap.put("functionInvocation", new Integer(36));
nonterminalIntToStringMap.put(new Integer(77), "setTarget");
nonterminalStringToIntMap.put("setTarget", new Integer(77));
nonterminalIntToStringMap.put(new Integer(68), "withClause");
nonterminalStringToIntMap.put("withClause", new Integer(68));
nonterminalIntToStringMap.put(new Integer(116), "formGroupContent_plus");
nonterminalStringToIntMap.put("formGroupContent_plus", new Integer(116));
nonterminalIntToStringMap.put(new Integer(120), "functionParameter_plus");
nonterminalStringToIntMap.put("functionParameter_plus", new Integer(120));
nonterminalIntToStringMap.put(new Integer(144), "setting_star");
nonterminalStringToIntMap.put("setting_star", new Integer(144));
nonterminalIntToStringMap.put(new Integer(131), "name_plus");
nonterminalStringToIntMap.put("name_plus", new Integer(131));
nonterminalIntToStringMap.put(new Integer(93), "whenClause");
nonterminalStringToIntMap.put("whenClause", new Integer(93));
nonterminalIntToStringMap.put(new Integer(141), "replaceOption_plus");
nonterminalStringToIntMap.put("replaceOption_plus", new Integer(141));
nonterminalIntToStringMap.put(new Integer(65), "part");
nonterminalStringToIntMap.put("part", new Integer(65));
nonterminalIntToStringMap.put(new Integer(118), "forwardOption_plus");
nonterminalStringToIntMap.put("forwardOption_plus", new Integer(118));
nonterminalIntToStringMap.put(new Integer(55), "name");
nonterminalStringToIntMap.put("name", new Integer(55));
nonterminalIntToStringMap.put(new Integer(143), "foreachOption_plus");
nonterminalStringToIntMap.put("foreachOption_plus", new Integer(143));
nonterminalIntToStringMap.put(new Integer(31), "formContent");
nonterminalStringToIntMap.put("formContent", new Integer(31));
nonterminalIntToStringMap.put(new Integer(100), "handlerContent_plus");
nonterminalStringToIntMap.put("handlerContent_plus", new Integer(100));
nonterminalIntToStringMap.put(new Integer(20), "elseOpt");
nonterminalStringToIntMap.put("elseOpt", new Integer(20));
nonterminalIntToStringMap.put(new Integer(4), "wsPair");
nonterminalStringToIntMap.put("wsPair", new Integer(4));
nonterminalIntToStringMap.put(new Integer(147), "settingsBlock_plus");
nonterminalStringToIntMap.put("settingsBlock_plus", new Integer(147));
nonterminalIntToStringMap.put(new Integer(128), "interfaceContent_star");
nonterminalStringToIntMap.put("interfaceContent_star", new Integer(128));
nonterminalIntToStringMap.put(new Integer(25), "expr");
nonterminalStringToIntMap.put("expr", new Integer(25));
nonterminalIntToStringMap.put(new Integer(62), "openModifierOpt");
nonterminalStringToIntMap.put("openModifierOpt", new Integer(62));
nonterminalIntToStringMap.put(new Integer(74), "replaceOption");
nonterminalStringToIntMap.put("replaceOption", new Integer(74));
nonterminalIntToStringMap.put(new Integer(122), "getByKeyOption_plus");
nonterminalStringToIntMap.put("getByKeyOption_plus", new Integer(122));
nonterminalIntToStringMap.put(new Integer(135), "openTarget_plus");
nonterminalStringToIntMap.put("openTarget_plus", new Integer(135));
nonterminalIntToStringMap.put(new Integer(84), "stepOpt");
nonterminalStringToIntMap.put("stepOpt", new Integer(84));
nonterminalIntToStringMap.put(new Integer(112), "externalTypeContent_plus");
nonterminalStringToIntMap.put("externalTypeContent_plus", new Integer(112));
nonterminalIntToStringMap.put(new Integer(63), "openTarget");
nonterminalStringToIntMap.put("openTarget", new Integer(63));
nonterminalIntToStringMap.put(new Integer(94), "withNameOpt");
nonterminalStringToIntMap.put("withNameOpt", new Integer(94));
nonterminalIntToStringMap.put(new Integer(105), "eventBlock_star");
nonterminalStringToIntMap.put("eventBlock_star", new Integer(105));
nonterminalIntToStringMap.put(new Integer(38), "getByKeyOption");
nonterminalStringToIntMap.put("getByKeyOption", new Integer(38));
nonterminalIntToStringMap.put(new Integer(92), "useTypeOpt");
nonterminalStringToIntMap.put("useTypeOpt", new Integer(92));
nonterminalIntToStringMap.put(new Integer(115), "formGroupContent_star");
nonterminalStringToIntMap.put("formGroupContent_star", new Integer(115));
nonterminalIntToStringMap.put(new Integer(119), "functionParameter_star");
nonterminalStringToIntMap.put("functionParameter_star", new Integer(119));
nonterminalIntToStringMap.put(new Integer(28), "fieldsOpt");
nonterminalStringToIntMap.put("fieldsOpt", new Integer(28));
nonterminalIntToStringMap.put(new Integer(44), "initializerOpt");
nonterminalStringToIntMap.put("initializerOpt", new Integer(44));
nonterminalIntToStringMap.put(new Integer(127), "importDecl_plus");
nonterminalStringToIntMap.put("importDecl_plus", new Integer(127));
nonterminalIntToStringMap.put(new Integer(49), "interfaceContent");
nonterminalStringToIntMap.put("interfaceContent", new Integer(49));
nonterminalIntToStringMap.put(new Integer(140), "replaceOption_star");
nonterminalStringToIntMap.put("replaceOption_star", new Integer(140));
nonterminalIntToStringMap.put(new Integer(110), "expr_plus");
nonterminalStringToIntMap.put("expr_plus", new Integer(110));
nonterminalIntToStringMap.put(new Integer(117), "forwardOption_star");
nonterminalStringToIntMap.put("forwardOption_star", new Integer(117));
nonterminalIntToStringMap.put(new Integer(151), "stmt_plus");
nonterminalStringToIntMap.put("stmt_plus", new Integer(151));
nonterminalIntToStringMap.put(new Integer(41), "IDOpt");
nonterminalStringToIntMap.put("IDOpt", new Integer(41));
nonterminalIntToStringMap.put(new Integer(32), "formGroupContent");
nonterminalStringToIntMap.put("formGroupContent", new Integer(32));
nonterminalIntToStringMap.put(new Integer(1), "UltraRoot");
nonterminalStringToIntMap.put("UltraRoot", new Integer(1));
nonterminalIntToStringMap.put(new Integer(33), "forwardOption");
nonterminalStringToIntMap.put("forwardOption", new Integer(33));
nonterminalIntToStringMap.put(new Integer(114), "formContent_plus");
nonterminalStringToIntMap.put("formContent_plus", new Integer(114));
nonterminalIntToStringMap.put(new Integer(91), "typeNoName");
nonterminalStringToIntMap.put("typeNoName", new Integer(91));
nonterminalIntToStringMap.put(new Integer(142), "foreachOption_star");
nonterminalStringToIntMap.put("foreachOption_star", new Integer(142));
nonterminalIntToStringMap.put(new Integer(125), "ID_plus");
nonterminalStringToIntMap.put("ID_plus", new Integer(125));
nonterminalIntToStringMap.put(new Integer(52), "literal");
nonterminalStringToIntMap.put("literal", new Integer(52));
nonterminalIntToStringMap.put(new Integer(98), "classContent_plus");
nonterminalStringToIntMap.put("classContent_plus", new Integer(98));
nonterminalIntToStringMap.put(new Integer(99), "handlerContent_star");
nonterminalStringToIntMap.put("handlerContent_star", new Integer(99));
nonterminalIntToStringMap.put(new Integer(82), "simpleNameOpt");
nonterminalStringToIntMap.put("simpleNameOpt", new Integer(82));
nonterminalIntToStringMap.put(new Integer(146), "settingsBlock_star");
nonterminalStringToIntMap.put("settingsBlock_star", new Integer(146));
nonterminalIntToStringMap.put(new Integer(17), "defaultClauseOpt");
nonterminalStringToIntMap.put("defaultClauseOpt", new Integer(17));
nonterminalIntToStringMap.put(new Integer(149), "showOption_plus");
nonterminalStringToIntMap.put("showOption_plus", new Integer(149));
nonterminalIntToStringMap.put(new Integer(16), "continueModifierOpt");
nonterminalStringToIntMap.put("continueModifierOpt", new Integer(16));
nonterminalIntToStringMap.put(new Integer(71), "privateAccessModifierOpt");
nonterminalStringToIntMap.put("privateAccessModifierOpt", new Integer(71));
nonterminalIntToStringMap.put(new Integer(29), "file");
nonterminalStringToIntMap.put("file", new Integer(29));
nonterminalIntToStringMap.put(new Integer(6), "arrayAccess");
nonterminalStringToIntMap.put("arrayAccess", new Integer(6));
nonterminalIntToStringMap.put(new Integer(121), "getByKeyOption_star");
nonterminalStringToIntMap.put("getByKeyOption_star", new Integer(121));
nonterminalIntToStringMap.put(new Integer(47), "inparentOpt");
nonterminalStringToIntMap.put("inparentOpt", new Integer(47));
nonterminalIntToStringMap.put(new Integer(3), "ErrorNode");
nonterminalStringToIntMap.put("ErrorNode", new Integer(3));
nonterminalIntToStringMap.put(new Integer(11), "callReturnToOpt");
nonterminalStringToIntMap.put("callReturnToOpt", new Integer(11));
nonterminalIntToStringMap.put(new Integer(5), "addOption");
nonterminalStringToIntMap.put("addOption", new Integer(5));
nonterminalIntToStringMap.put(new Integer(124), "getByPositionOption_plus");
nonterminalStringToIntMap.put("getByPositionOption_plus", new Integer(124));
nonterminalIntToStringMap.put(new Integer(134), "openTarget_star");
nonterminalStringToIntMap.put("openTarget_star", new Integer(134));
nonterminalIntToStringMap.put(new Integer(56), "namedType");
nonterminalStringToIntMap.put("namedType", new Integer(56));
nonterminalIntToStringMap.put(new Integer(111), "externalTypeContent_star");
nonterminalStringToIntMap.put("externalTypeContent_star", new Integer(111));
nonterminalIntToStringMap.put(new Integer(88), "timestampIntervalPrimitiveSpecOpt");
nonterminalStringToIntMap.put("timestampIntervalPrimitiveSpecOpt", new Integer(88));
nonterminalIntToStringMap.put(new Integer(137), "part_plus");
nonterminalStringToIntMap.put("part_plus", new Integer(137));
nonterminalIntToStringMap.put(new Integer(66), "partSubTypeOpt");
nonterminalStringToIntMap.put("partSubTypeOpt", new Integer(66));
nonterminalIntToStringMap.put(new Integer(61), "onException");
nonterminalStringToIntMap.put("onException", new Integer(61));
nonterminalIntToStringMap.put(new Integer(102), "deleteOption_plus");
nonterminalStringToIntMap.put("deleteOption_plus", new Integer(102));
nonterminalIntToStringMap.put(new Integer(126), "importDecl_star");
nonterminalStringToIntMap.put("importDecl_star", new Integer(126));
nonterminalIntToStringMap.put(new Integer(85), "stmt");
nonterminalStringToIntMap.put("stmt", new Integer(85));
nonterminalIntToStringMap.put(new Integer(109), "expr_star");
nonterminalStringToIntMap.put("expr_star", new Integer(109));
nonterminalIntToStringMap.put(new Integer(27), "fieldAccess");
nonterminalStringToIntMap.put("fieldAccess", new Integer(27));
nonterminalIntToStringMap.put(new Integer(150), "stmt_star");
nonterminalStringToIntMap.put("stmt_star", new Integer(150));
nonterminalIntToStringMap.put(new Integer(104), "enumerationField_plus");
nonterminalStringToIntMap.put("enumerationField_plus", new Integer(104));
nonterminalIntToStringMap.put(new Integer(113), "formContent_star");
nonterminalStringToIntMap.put("formContent_star", new Integer(113));
nonterminalIntToStringMap.put(new Integer(50), "intoClauseOpt");
nonterminalStringToIntMap.put("intoClauseOpt", new Integer(50));
nonterminalIntToStringMap.put(new Integer(12), "callOnExceptionOpt");
nonterminalStringToIntMap.put("callOnExceptionOpt", new Integer(12));
nonterminalIntToStringMap.put(new Integer(97), "classContent_star");
nonterminalStringToIntMap.put("classContent_star", new Integer(97));
nonterminalIntToStringMap.put(new Integer(48), "externalTypeContent");
nonterminalStringToIntMap.put("externalTypeContent", new Integer(48));
nonterminalIntToStringMap.put(new Integer(45), "inlineSQLStatement");
nonterminalStringToIntMap.put("inlineSQLStatement", new Integer(45));
nonterminalIntToStringMap.put(new Integer(148), "showOption_star");
nonterminalStringToIntMap.put("showOption_star", new Integer(148));
nonterminalIntToStringMap.put(new Integer(133), "onException_plus");
nonterminalStringToIntMap.put("onException_plus", new Integer(133));
nonterminalIntToStringMap.put(new Integer(139), "programParameter_plus");
nonterminalStringToIntMap.put("programParameter_plus", new Integer(139));
nonterminalIntToStringMap.put(new Integer(153), "structureContent_plus");
nonterminalStringToIntMap.put("structureContent_plus", new Integer(153));
nonterminalIntToStringMap.put(new Integer(7), "assignment");
nonterminalStringToIntMap.put("assignment", new Integer(7));
nonterminalIntToStringMap.put(new Integer(67), "passingRecordOpt");
nonterminalStringToIntMap.put("passingRecordOpt", new Integer(67));
nonterminalIntToStringMap.put(new Integer(70), "primaryNoNew");
nonterminalStringToIntMap.put("primaryNoNew", new Integer(70));
nonterminalIntToStringMap.put(new Integer(43), "importDecl");
nonterminalStringToIntMap.put("importDecl", new Integer(43));
nonterminalIntToStringMap.put(new Integer(87), "structureContent");
nonterminalStringToIntMap.put("structureContent", new Integer(87));
nonterminalIntToStringMap.put(new Integer(53), "lvalue");
nonterminalStringToIntMap.put("lvalue", new Integer(53));
nonterminalIntToStringMap.put(new Integer(123), "getByPositionOption_star");
nonterminalStringToIntMap.put("getByPositionOption_star", new Integer(123));
nonterminalIntToStringMap.put(new Integer(130), "setTarget_plus");
nonterminalStringToIntMap.put("setTarget_plus", new Integer(130));
nonterminalIntToStringMap.put(new Integer(58), "parmConstOpt");
nonterminalStringToIntMap.put("parmConstOpt", new Integer(58));
nonterminalIntToStringMap.put(new Integer(136), "part_star");
nonterminalStringToIntMap.put("part_star", new Integer(136));
nonterminalIntToStringMap.put(new Integer(23), "executeOption");
nonterminalStringToIntMap.put("executeOption", new Integer(23));
nonterminalIntToStringMap.put(new Integer(80), "settingsBlockOpt");
nonterminalStringToIntMap.put("settingsBlockOpt", new Integer(80));
nonterminalIntToStringMap.put(new Integer(51), "levelOpt");
nonterminalStringToIntMap.put("levelOpt", new Integer(51));
nonterminalIntToStringMap.put(new Integer(14), "classContent");
nonterminalStringToIntMap.put("classContent", new Integer(14));
nonterminalIntToStringMap.put(new Integer(13), "charPrimitiveSpecOpt");
nonterminalStringToIntMap.put("charPrimitiveSpecOpt", new Integer(13));
nonterminalIntToStringMap.put(new Integer(57), "sqlNullableOpt");
nonterminalStringToIntMap.put("sqlNullableOpt", new Integer(57));
nonterminalIntToStringMap.put(new Integer(54), "moveModifierOpt");
nonterminalStringToIntMap.put("moveModifierOpt", new Integer(54));
nonterminalIntToStringMap.put(new Integer(101), "deleteOption_star");
nonterminalStringToIntMap.put("deleteOption_star", new Integer(101));
nonterminalIntToStringMap.put(new Integer(18), "deleteOption");
nonterminalStringToIntMap.put("deleteOption", new Integer(18));
nonterminalIntToStringMap.put(new Integer(59), "numericPrimitiveSpecOpt");
nonterminalStringToIntMap.put("numericPrimitiveSpecOpt", new Integer(59));
nonterminalIntToStringMap.put(new Integer(108), "executeOption_plus");
nonterminalStringToIntMap.put("executeOption_plus", new Integer(108));
nonterminalIntToStringMap.put(new Integer(9), "bindOpt");
nonterminalStringToIntMap.put("bindOpt", new Integer(9));
nonterminalIntToStringMap.put(new Integer(42), "implementsOpt");
nonterminalStringToIntMap.put("implementsOpt", new Integer(42));
nonterminalIntToStringMap.put(new Integer(103), "enumerationField_star");
nonterminalStringToIntMap.put("enumerationField_star", new Integer(103));
nonterminalIntToStringMap.put(new Integer(69), "primary");
nonterminalStringToIntMap.put("primary", new Integer(69));
nonterminalIntToStringMap.put(new Integer(96), "addOption_plus");
nonterminalStringToIntMap.put("addOption_plus", new Integer(96));
nonterminalIntToStringMap.put(new Integer(155), "whenClause_plus");
nonterminalStringToIntMap.put("whenClause_plus", new Integer(155));
nonterminalIntToStringMap.put(new Integer(10), "callParametersOpt");
nonterminalStringToIntMap.put("callParametersOpt", new Integer(10));
}

private NodeNameUtility() { }

public static int getNonterminalCount() {
return nonterminalStringToIntMap.size();
}

public static String getTerminalName(int terminalType) {
return (String)(terminalIntToStringMap.get(new Integer(terminalType)));
}

public static String getNonterminalName(int nonterminalType) {
return (String)(nonterminalIntToStringMap.get(new Integer(nonterminalType)));
}

public static int getTerminalType(String terminalName) {
return ((Integer)(terminalStringToIntMap.get(terminalName))).intValue();
}

public static int getNonterminalType(String nonterminalName) {
return ((Integer)(nonterminalStringToIntMap.get(nonterminalName))).intValue();
}

}
