/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.resources.egldd;

import java.util.Map;
import org.eclipse.edt.javart.resources.egldd.Parameter;

public class ParameterUtil {
    public static int getIntValue(Parameter parameter, int defaultValue) {
        try {
            return parameter != null && parameter.getValue() != null ? Integer.parseInt(parameter.getValue()) : defaultValue;
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static boolean getBooleanValue(Parameter parameter, boolean defaultValue) {
        return parameter != null && parameter.getValue() != null ? "true".equalsIgnoreCase(parameter.getValue()) : defaultValue;
    }

    public static String getStringValue(Parameter parameter, String defaultValue) {
        return parameter != null && parameter.getValue() != null ? parameter.getValue() : defaultValue;
    }

    static void setValue(Map<String, Parameter> parameters, String name, boolean value) {
        Parameter parameter = parameters.get(name);
        if (parameter == null) {
            parameter = new Parameter(name, "boolean", String.valueOf(value));
            parameters.put(name, parameter);
        } else {
            parameter.setValue(String.valueOf(value));
        }
    }

    static void setValue(Map<String, Parameter> parameters, String name, String value) {
        Parameter parameter = parameters.get(name);
        if (parameter == null) {
            parameter = new Parameter(name, "boolean", value);
        } else {
            parameter.setValue(value);
        }
    }
}

