/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.util.gzip;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.eclipse.edt.javart.resources.Trace;
import org.eclipse.edt.javart.util.gzip.CompressionServletOutputStream;

public class CompressionServletResponseWrapper
extends HttpServletResponseWrapper {
    protected HttpServletResponse origResponse = null;
    protected ServletOutputStream stream = null;
    protected PrintWriter writer = null;
    protected int threshold = 0;
    protected String contentType = null;
    protected Trace tracer;
    protected static final String WRITER_CALLED_MSG = "getWriter() has already been called for this response";
    protected static final String OUTPUTSTREAM_CALLED_MSG = "getOutputStream() has already been called for this response";

    public CompressionServletResponseWrapper(HttpServletResponse response, Trace tracer) {
        super(response);
        this.origResponse = response;
        this.tracer = tracer;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
        this.origResponse.setContentType(contentType);
    }

    public void setCompressionThreshold(int threshold) {
        this.threshold = threshold;
    }

    public ServletOutputStream createOutputStream() throws IOException {
        CompressionServletOutputStream stream = new CompressionServletOutputStream(this.origResponse, this.tracer);
        stream.setBuffer(this.threshold);
        return stream;
    }

    public void finishResponse() {
        try {
            if (this.writer != null) {
                this.writer.close();
            } else if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (IOException iOException) {}
    }

    public void flushBuffer() throws IOException {
        ((CompressionServletOutputStream)this.stream).flush();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException(WRITER_CALLED_MSG);
        }
        if (this.stream == null) {
            this.stream = this.createOutputStream();
        }
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.stream != null) {
            throw new IllegalStateException(OUTPUTSTREAM_CALLED_MSG);
        }
        this.stream = this.createOutputStream();
        String charEnc = this.origResponse.getCharacterEncoding();
        this.writer = charEnc != null ? new PrintWriter(new OutputStreamWriter((OutputStream)this.stream, charEnc)) : new PrintWriter((OutputStream)this.stream);
        return this.writer;
    }

    public void setContentLength(int length) {
    }
}

