/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.editor;

import java.text.DecimalFormat;
import org.eclipse.edt.compiler.internal.EGLBasePlugin;
import org.eclipse.edt.ide.rui.visualeditor.internal.actions.EvActionBidiSettings;
import org.eclipse.edt.ide.rui.visualeditor.internal.actions.EvActionPreferences;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvDesignPage;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvHelp;
import org.eclipse.edt.ide.rui.visualeditor.internal.nl.Tooltips;
import org.eclipse.edt.ide.rui.visualeditor.internal.preferences.EvPreferences;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.BidiFormat;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.BidiUtils;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.TranslationTestMode;
import org.eclipse.edt.ide.rui.visualeditor.plugin.Activator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class EvDesignToolbar
extends Composite
implements SelectionListener,
IPropertyChangeListener {
    protected Button _buttonOverlayOnTop = null;
    protected Button _buttonBrowserOnTop = null;
    protected Button _buttonTranslationTest = null;
    protected Composite _compositeTransparencyControls = null;
    protected DecimalFormat _decimalFormat = new DecimalFormat("####%");
    protected ToolItem _itemPreferences = null;
    protected ToolItem _itemRefreshPalette = null;
    protected ToolItem _itemRefreshWebPage = null;
    protected ToolItem _itemShowBrowserSizeControls = null;
    protected ToolItem _itemShowTransparencyControls = null;
    protected ToolItem _itemTransparencyDisabled = null;
    protected ToolItem _itemTransparencyFixed = null;
    protected ToolItem _itemTransparencyVariable = null;
    protected Label _labelTransparencyPercent = null;
    protected EvDesignPage _pageDesign = null;
    protected Slider _sliderTransparencyAmount = null;
    protected ToolItem _itemBidiPreferences = null;

    public EvDesignToolbar(Composite compositeParent, int style, EvDesignPage pageDesign) {
        super(compositeParent, style);
        this._pageDesign = pageDesign;
        boolean bTranslationTest = pageDesign.getEditor().isTranslationTestMode();
        boolean bShowZOrderControls = false;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        if (bTranslationTest) {
            ++gridLayout.numColumns;
        }
        if (bShowZOrderControls) {
            gridLayout.numColumns += 2;
        }
        gridLayout.marginWidth = 16;
        gridLayout.marginHeight = 1;
        gridLayout.horizontalSpacing = 2;
        this.setLayout((Layout)gridLayout);
        if (bTranslationTest) {
            this._buttonTranslationTest = new Button((Composite)this, 8);
            this._buttonTranslationTest.setText("TVT");
            this._buttonTranslationTest.addSelectionListener((SelectionListener)this);
        }
        if (bShowZOrderControls) {
            this._buttonBrowserOnTop = new Button((Composite)this, 8);
            this._buttonBrowserOnTop.setText("Browser");
            GridData gridData = new GridData();
            this._buttonBrowserOnTop.setLayoutData((Object)gridData);
            this._buttonBrowserOnTop.addSelectionListener((SelectionListener)this);
            this._buttonOverlayOnTop = new Button((Composite)this, 8);
            this._buttonOverlayOnTop.setText("Overlay");
            gridData = new GridData();
            this._buttonOverlayOnTop.setLayoutData((Object)gridData);
            this._buttonOverlayOnTop.addSelectionListener((SelectionListener)this);
            this._buttonOverlayOnTop.setEnabled(false);
        }
        Label label = new Label((Composite)this, 0);
        GridData gridData = new GridData(512);
        label.setLayoutData((Object)gridData);
        this.createTransparencyComposite(this);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.widthHint = 16;
        label.setLayoutData((Object)gridData);
        ToolBar toolbar = new ToolBar((Composite)this, 0x800100);
        gridData = new GridData(128);
        toolbar.setLayoutData((Object)gridData);
        this._itemShowTransparencyControls = this.createShowTransparencyControls(toolbar);
        this._itemShowBrowserSizeControls = this.createShowBrowserSizeControls(toolbar);
        new ToolItem(toolbar, 2);
        this._itemBidiPreferences = this.createBidiPreferences(toolbar);
        this._itemBidiPreferences.setEnabled(BidiUtils.isBidi());
        EGLBasePlugin.getPlugin().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this._itemPreferences = this.createPreferences(toolbar);
        new ToolItem(toolbar, 2);
        this._itemRefreshPalette = this.createRefreshPalette(toolbar);
        this._itemRefreshWebPage = this.createRefreshWebPage(toolbar);
        EvHelp.setHelp((Control)toolbar, EvHelp.DESIGN_TOOLBAR);
        int i = 0;
        while (i < toolbar.getItemCount()) {
            EvHelp.setHelp(toolbar.getItem(i).getControl(), EvHelp.DESIGN_TOOLBAR);
            ++i;
        }
        EvHelp.setHelp((Control)this._buttonOverlayOnTop, EvHelp.DESIGN_TOOLBAR);
        EvHelp.setHelp((Control)this._buttonBrowserOnTop, EvHelp.DESIGN_TOOLBAR);
    }

    protected ToolItem createBidiPreferences(ToolBar toolbar) {
        ToolItem item = new ToolItem(toolbar, 0x800008);
        item.setImage(Activator.getImage("elcl16/bidisettings_obj.gif"));
        item.addSelectionListener((SelectionListener)this);
        item.setToolTipText(Tooltips.NL_Configure_bidirectional_options);
        return item;
    }

    protected ToolItem createPreferences(ToolBar toolbar) {
        ToolItem item = new ToolItem(toolbar, 0x800008);
        item.setImage(Activator.getImage("elcl16/preferences_obj.gif"));
        item.addSelectionListener((SelectionListener)this);
        item.setToolTipText(Tooltips.NL_Configure_preferences);
        return item;
    }

    protected ToolItem createRefreshPalette(ToolBar toolbar) {
        ToolItem item = new ToolItem(toolbar, 0x800008);
        item.setImage(Activator.getImage("elcl16/refreshpalette_obj.gif"));
        item.addSelectionListener((SelectionListener)this);
        item.setToolTipText(Tooltips.NL_Refresh_palette);
        return item;
    }

    protected ToolItem createRefreshWebPage(ToolBar toolbar) {
        ToolItem item = new ToolItem(toolbar, 0x800008);
        item.setImage(Activator.getImage("elcl16/refreshwebpage_obj.gif"));
        item.addSelectionListener((SelectionListener)this);
        item.setToolTipText(Tooltips.NL_Refresh_web_page);
        item.setEnabled(this._pageDesign.getEditor().isRuiHandler());
        return item;
    }

    protected ToolItem createShowBrowserSizeControls(ToolBar toolbar) {
        ToolItem item = new ToolItem(toolbar, 0x800020);
        item.setImage(Activator.getImage("elcl16/showbrowsersizecontrols_obj.gif"));
        item.setToolTipText(Tooltips.NL_Show_browser_size_controls);
        boolean bShowBrowserSizeControls = EvPreferences.getBoolean("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeControlsVisible");
        item.setSelection(bShowBrowserSizeControls);
        item.addSelectionListener((SelectionListener)this);
        return item;
    }

    protected ToolItem createShowTransparencyControls(ToolBar toolbar) {
        ToolItem item = new ToolItem(toolbar, 0x800020);
        item.setImage(Activator.getImage("elcl16/showtransparencycontrols_obj.gif"));
        item.setToolTipText(Tooltips.NL_Show_transparency_controls);
        boolean bShowBrowserSizeControls = EvPreferences.getBoolean("org.eclipse.edt.ide.rui.visualeditor.TransparencyControlsVisible");
        item.setSelection(bShowBrowserSizeControls);
        item.addSelectionListener((SelectionListener)this);
        return item;
    }

    protected void createTransparencyComposite(Composite compositeParent) {
        this._compositeTransparencyControls = new Composite(compositeParent, 0);
        GridData gridData = new GridData(128);
        this._compositeTransparencyControls.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.horizontalSpacing = 2;
        gridLayout.marginWidth = 4;
        gridLayout.marginHeight = 0;
        this._compositeTransparencyControls.setLayout((Layout)gridLayout);
        ToolBar toolbar = new ToolBar(this._compositeTransparencyControls, 0x800100);
        gridData = new GridData(128);
        toolbar.setLayoutData((Object)gridData);
        int iTransparencyMode = EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.SemiTransparencyMode");
        this._itemTransparencyDisabled = new ToolItem(toolbar, 16);
        this._itemTransparencyDisabled.setImage(Activator.getImage("elcl16/transparencynone_obj.gif"));
        this._itemTransparencyDisabled.setSelection(iTransparencyMode == 0);
        this._itemTransparencyDisabled.addSelectionListener((SelectionListener)this);
        this._itemTransparencyDisabled.setToolTipText(Tooltips.NL_Fully_transparent);
        this._itemTransparencyFixed = new ToolItem(toolbar, 16);
        this._itemTransparencyFixed.setImage(Activator.getImage("elcl16/transparencyfixed_obj.gif"));
        this._itemTransparencyFixed.setSelection(iTransparencyMode == 1);
        this._itemTransparencyFixed.addSelectionListener((SelectionListener)this);
        this._itemTransparencyFixed.setToolTipText(Tooltips.NL_Dotted_transparency_pattern);
        if (this._pageDesign.isGraphicsTransparencyAvailable()) {
            this._itemTransparencyVariable = new ToolItem(toolbar, 16);
            this._itemTransparencyVariable.setImage(Activator.getImage("elcl16/transparencyvariable_obj.gif"));
            this._itemTransparencyVariable.setSelection(iTransparencyMode == 2);
            this._itemTransparencyVariable.addSelectionListener((SelectionListener)this);
            this._itemTransparencyVariable.setToolTipText(Tooltips.NL_Variable_transparency);
            this._sliderTransparencyAmount = new Slider(this._compositeTransparencyControls, 0);
            gridData = new GridData();
            gridData.widthHint = 100;
            this._sliderTransparencyAmount.setLayoutData((Object)gridData);
            this._sliderTransparencyAmount.setToolTipText(Tooltips.NL_Variable_transparency);
            int iTransparencyAmount = EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.SemiTransparencyAmount");
            this._sliderTransparencyAmount.setValues(iTransparencyAmount, 0, 256, 1, 1, 10);
            this._sliderTransparencyAmount.addSelectionListener((SelectionListener)this);
            this._labelTransparencyPercent = new Label(this._compositeTransparencyControls, 0);
            gridData = new GridData();
            this._labelTransparencyPercent.setLayoutData((Object)gridData);
            this._labelTransparencyPercent.setText("000%");
        }
        EvHelp.setHelp((Control)this._compositeTransparencyControls, EvHelp.DESIGN_TOOLBAR);
        EvHelp.setHelp((Control)toolbar, EvHelp.DESIGN_TOOLBAR);
        if (this._sliderTransparencyAmount != null) {
            EvHelp.setHelp((Control)this._sliderTransparencyAmount, EvHelp.DESIGN_TOOLBAR);
        }
        int i = 0;
        while (i < toolbar.getItemCount()) {
            EvHelp.setHelp(toolbar.getItem(i).getControl(), EvHelp.DESIGN_TOOLBAR);
            ++i;
        }
        this.updateTransparencyControls();
        boolean bShowTransparencyControls = EvPreferences.getBoolean("org.eclipse.edt.ide.rui.visualeditor.TransparencyControlsVisible");
        this._compositeTransparencyControls.setVisible(bShowTransparencyControls);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("BidiEnabledOption".equals(event.getProperty()) && !this._itemBidiPreferences.isDisposed()) {
            this._itemBidiPreferences.setEnabled(((Boolean)event.getNewValue()).booleanValue());
        }
    }

    public void updateTransparencyControls() {
        if (this._sliderTransparencyAmount == null) {
            return;
        }
        this._sliderTransparencyAmount.setEnabled(this._itemTransparencyVariable.getSelection());
        int iPercent = this._sliderTransparencyAmount.getSelection() * 100 / 255;
        StringBuffer strb = new StringBuffer();
        double dPercentage = new Double(iPercent);
        if (dPercentage < 100.0) {
            strb.append("  ");
        }
        if (dPercentage < 0.1) {
            strb.append("  ");
        }
        this._labelTransparencyPercent.setText(String.valueOf(this._decimalFormat.format(dPercentage / 100.0)) + strb.toString());
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this._itemBidiPreferences) {
            BidiFormat bidiFormat = this._pageDesign.getBidiFormat();
            EvActionBidiSettings action = new EvActionBidiSettings(bidiFormat);
            action.run();
            bidiFormat = action.getBidiFormat();
            this._pageDesign.setBidiFormat(bidiFormat);
            this._itemBidiPreferences.getParent().setFocus();
        } else if (event.widget == this._itemRefreshPalette) {
            this._pageDesign.refreshPalette();
        } else if (event.widget == this._itemRefreshWebPage) {
            this._pageDesign._bFullRefresh = true;
            this._pageDesign.getEditor().modelChanged();
        } else if (event.widget == this._itemPreferences) {
            EvActionPreferences action = new EvActionPreferences();
            action.run();
            this._itemPreferences.getParent().setFocus();
        } else if (event.widget == this._itemShowBrowserSizeControls) {
            this._pageDesign.updateBrowserSizeControlsVisible(this._itemShowBrowserSizeControls.getSelection());
        } else if (event.widget == this._itemShowTransparencyControls) {
            this._compositeTransparencyControls.setVisible(this._itemShowTransparencyControls.getSelection());
        } else if (event.widget == this._itemTransparencyDisabled) {
            if (this._itemTransparencyDisabled.getSelection()) {
                this._pageDesign.setTransparency(0, 0);
            }
            this.updateTransparencyControls();
            this._itemTransparencyDisabled.getParent().setFocus();
        } else if (event.widget == this._itemTransparencyFixed) {
            if (this._itemTransparencyFixed.getSelection()) {
                this._pageDesign.setTransparency(1, 0);
            }
            this.updateTransparencyControls();
            this._itemTransparencyFixed.getParent().setFocus();
        } else if (event.widget == this._itemTransparencyVariable) {
            this._pageDesign.setTransparency(2, this._sliderTransparencyAmount.getSelection());
            this.updateTransparencyControls();
            this._itemTransparencyVariable.getParent().setFocus();
        } else if (this._sliderTransparencyAmount != null && event.widget == this._sliderTransparencyAmount) {
            this._pageDesign.setTransparency(2, this._sliderTransparencyAmount.getSelection());
            this.updateTransparencyControls();
            this._sliderTransparencyAmount.setFocus();
        } else if (event.widget == this._buttonTranslationTest) {
            TranslationTestMode testMode = new TranslationTestMode();
            testMode.execute(this._pageDesign.getEditor());
        } else if (event.widget == this._buttonOverlayOnTop) {
            this._buttonOverlayOnTop.setEnabled(false);
            this._buttonBrowserOnTop.setEnabled(true);
            this._pageDesign.setDesignMode(true);
        } else if (event.widget == this._buttonBrowserOnTop) {
            this._buttonOverlayOnTop.setEnabled(true);
            this._buttonBrowserOnTop.setEnabled(false);
            this._pageDesign.setDesignMode(false);
        }
    }
}

