/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.outline;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetManager;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPart;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class WidgetTransfer
extends ByteArrayTransfer {
    private static final String TYPE_NAME = "egl-rui-widget-transfer-format";
    private static final int TYPEID = WidgetTransfer.registerType((String)"egl-rui-widget-transfer-format");
    private WidgetManager manager;

    public WidgetTransfer(WidgetManager manager) {
        this.manager = manager;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        byte[] bytes = this.toByteArray((WidgetPart[])object);
        if (bytes != null) {
            super.javaToNative((Object)bytes, transferData);
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        return this.fromByteArray(bytes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected WidgetPart[] fromByteArray(byte[] bytes) {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            int n = in.readInt();
            WidgetPart[] widgets = new WidgetPart[n];
            int i = 0;
            while (true) {
                if (i >= n) {
                    return widgets;
                }
                WidgetPart widget = this.readWidget(null, in);
                if (widget == null) {
                    return null;
                }
                widgets[i] = widget;
                ++i;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private WidgetPart readWidget(WidgetPart parent, DataInputStream dataIn) throws IOException {
        int iOffset = dataIn.readInt();
        int iLength = dataIn.readInt();
        WidgetPart newParent = this.manager.getWidget(iOffset, iLength);
        return newParent;
    }

    protected byte[] toByteArray(WidgetPart[] widgets) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOut);
        byte[] bytes = null;
        try {
            out.writeInt(widgets.length);
            int i = 0;
            while (i < widgets.length) {
                this.writeWidget(widgets[i], out);
                ++i;
            }
            out.close();
            bytes = byteOut.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bytes;
    }

    private void writeWidget(WidgetPart widget, DataOutputStream dataOut) throws IOException {
        dataOut.writeInt(widget.getStatementOffset());
        dataOut.writeInt(widget.getStatementLength());
    }
}

