/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.preferences;

import java.util.StringTokenizer;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvConstants;
import org.eclipse.edt.ide.rui.visualeditor.plugin.Activator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.RGB;

public class EvPreferences {
    protected static IPreferenceStore _preferenceStore = null;

    protected static String convertRGBToString(RGB rgb) {
        if (rgb != null) {
            return String.valueOf(rgb.red) + "," + rgb.green + "," + rgb.blue;
        }
        return "0,0,0";
    }

    protected static RGB convertStringToRGB(String value) {
        StringTokenizer st;
        RGB ret = null;
        if (value != null && (st = new StringTokenizer(value, ",")).hasMoreTokens()) {
            try {
                int red = Integer.parseInt(st.nextToken());
                int green = Integer.parseInt(st.nextToken());
                int blue = Integer.parseInt(st.nextToken());
                ret = new RGB(red, green, blue);
            }
            catch (Exception exception) {}
        }
        if (ret == null) {
            ret = new RGB(0, 0, 0);
        }
        return ret;
    }

    public static boolean getBoolean(String name) {
        EvPreferences.initialize();
        return _preferenceStore.getBoolean(name);
    }

    public static double getDouble(String name) {
        EvPreferences.initialize();
        return _preferenceStore.getDouble(name);
    }

    public static float getFloat(String name) {
        EvPreferences.initialize();
        return _preferenceStore.getFloat(name);
    }

    public static int getInt(String name) {
        EvPreferences.initialize();
        return _preferenceStore.getInt(name);
    }

    public static IPreferenceStore getPreferenceStore() {
        EvPreferences.initialize();
        return _preferenceStore;
    }

    public static RGB getRGB(String name) {
        EvPreferences.initialize();
        RGB rgb = EvPreferences.convertStringToRGB(_preferenceStore.getString(name));
        return rgb;
    }

    public static String getString(String name) {
        EvPreferences.initialize();
        return _preferenceStore.getString(name);
    }

    protected static void initialize() {
        if (_preferenceStore != null) {
            return;
        }
        _preferenceStore = Activator.getDefault().getPreferenceStore();
        _preferenceStore.setDefault("org.eclipse.edt.ide.rui.visualeditor.EditorOpeningTab", 0);
        _preferenceStore.setDefault("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeControlsVisible", false);
        _preferenceStore.setDefault("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMinimumWidth", 200);
        _preferenceStore.setDefault("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMinimumHeight", 200);
        _preferenceStore.setDefault("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMaximumWidth", 3000);
        _preferenceStore.setDefault("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMaximumHeight", 5000);
        _preferenceStore.setDefault("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeDefaultWidth", 1000);
        _preferenceStore.setDefault("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeDefaultHeight", 1000);
        _preferenceStore.setDefault("org.eclipse.edt.ide.rui.visualeditor.TransparencyControlsVisible", false);
        _preferenceStore.setDefault("org.eclipse.edt.ide.rui.visualeditor.SemiTransparencyWhileDragging", true);
        _preferenceStore.setDefault("org.eclipse.edt.ide.rui.visualeditor.SemiTransparencyMode", 0);
        _preferenceStore.setDefault("org.eclipse.edt.ide.rui.visualeditor.SemiTransparencyAmount", 255);
        _preferenceStore.setDefault("org.eclipse.edt.ide.rui.visualeditor.ColorDropLocationPotential", "253 253 237");
        _preferenceStore.setDefault("org.eclipse.edt.ide.rui.visualeditor.ColorDropLocationSelected", "234 248 213");
        _preferenceStore.setDefault("org.eclipse.edt.ide.rui.visualeditor.ColorSelection", "0 0 140");
        _preferenceStore.setDefault("org.eclipse.edt.ide.rui.visualeditor.PatternDropLocationSelected", false);
        _preferenceStore.setDefault("org.eclipse.edt.ide.rui.visualeditor.PatternSelection", true);
        _preferenceStore.setDefault("org.eclipse.edt.ide.rui.visualeditor.Performance", 0);
        _preferenceStore.setDefault("org.eclipse.edt.ide.rui.visualeditor.RenderEngine", 0);
        _preferenceStore.setDefault("org.eclipse.edt.ide.rui.visualeditor.PromptForNewWidgetName", true);
        _preferenceStore.setDefault("org.eclipse.edt.ide.rui.visualeditor.BidiWidgetOrientation", EvConstants.PREFERENCE_DEFAULT_BIDI_WIDGET_ORIENTATION);
        _preferenceStore.setDefault("org.eclipse.edt.ide.rui.visualeditor.BidiTextLayout", EvConstants.PREFERENCE_DEFAULT_BIDI_TEXT_LAYOUT);
        _preferenceStore.setDefault("org.eclipse.edt.ide.rui.visualeditor.BidiReverseTextDirection", EvConstants.PREFERENCE_DEFAULT_BIDI_REVERSE_TEXT_DIRECTION);
        _preferenceStore.setDefault("org.eclipse.edt.ide.rui.visualeditor.BidiSymSwap", EvConstants.PREFERENCE_DEFAULT_BIDI_SYM_SWAPPING);
        _preferenceStore.setDefault("org.eclipse.edt.ide.rui.visualeditor.BidiNumSwap", EvConstants.PREFERENCE_DEFAULT_BIDI_NUM_SWAPPING);
        if (!_preferenceStore.contains("org.eclipse.edt.ide.rui.visualeditor.PreferencePageLast")) {
            EvPreferences.setInt("org.eclipse.edt.ide.rui.visualeditor.PreferencePageLast", 0);
        }
        if (!_preferenceStore.contains("org.eclipse.edt.ide.rui.visualeditor.EditorOpeningTab")) {
            EvPreferences.setInt("org.eclipse.edt.ide.rui.visualeditor.EditorOpeningTab", 0);
        }
        if (!_preferenceStore.contains("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeControlsVisible")) {
            EvPreferences.setBoolean("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeControlsVisible", false);
        }
        if (!_preferenceStore.contains("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMinimumWidth")) {
            EvPreferences.setInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMinimumWidth", 200);
        }
        if (!_preferenceStore.contains("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMinimumHeight")) {
            EvPreferences.setInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMinimumHeight", 200);
        }
        if (!_preferenceStore.contains("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMaximumWidth")) {
            EvPreferences.setInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMaximumWidth", 3000);
        }
        if (!_preferenceStore.contains("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMaximumHeight")) {
            EvPreferences.setInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeMaximumHeight", 5000);
        }
        if (!_preferenceStore.contains("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeDefaultWidth")) {
            EvPreferences.setInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeDefaultWidth", 1000);
        }
        if (!_preferenceStore.contains("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeDefaultHeight")) {
            EvPreferences.setInt("org.eclipse.edt.ide.rui.visualeditor.BrowserSizeDefaultHeight", 800);
        }
        if (!_preferenceStore.contains("org.eclipse.edt.ide.rui.visualeditor.TransparencyControlsVisible")) {
            EvPreferences.setBoolean("org.eclipse.edt.ide.rui.visualeditor.TransparencyControlsVisible", false);
        }
        if (!_preferenceStore.contains("org.eclipse.edt.ide.rui.visualeditor.SemiTransparencyWhileDragging")) {
            EvPreferences.setBoolean("org.eclipse.edt.ide.rui.visualeditor.SemiTransparencyWhileDragging", true);
        }
        if (!_preferenceStore.contains("org.eclipse.edt.ide.rui.visualeditor.SemiTransparencyMode")) {
            EvPreferences.setInt("org.eclipse.edt.ide.rui.visualeditor.SemiTransparencyMode", 0);
        }
        if (!_preferenceStore.contains("org.eclipse.edt.ide.rui.visualeditor.SemiTransparencyAmount")) {
            EvPreferences.setInt("org.eclipse.edt.ide.rui.visualeditor.SemiTransparencyAmount", 255);
        }
        if (!_preferenceStore.contains("org.eclipse.edt.ide.rui.visualeditor.ColorDropLocationPotential")) {
            EvPreferences.setString("org.eclipse.edt.ide.rui.visualeditor.ColorDropLocationPotential", "253 253 237");
        }
        if (!_preferenceStore.contains("org.eclipse.edt.ide.rui.visualeditor.ColorDropLocationSelected")) {
            EvPreferences.setString("org.eclipse.edt.ide.rui.visualeditor.ColorDropLocationSelected", "234 248 213");
        }
        if (!_preferenceStore.contains("org.eclipse.edt.ide.rui.visualeditor.ColorSelection")) {
            EvPreferences.setString("org.eclipse.edt.ide.rui.visualeditor.ColorSelection", "0 0 140");
        }
        if (!_preferenceStore.contains("org.eclipse.edt.ide.rui.visualeditor.PatternDropLocationSelected")) {
            EvPreferences.setBoolean("org.eclipse.edt.ide.rui.visualeditor.PatternDropLocationSelected", false);
        }
        if (!_preferenceStore.contains("org.eclipse.edt.ide.rui.visualeditor.PatternSelection")) {
            EvPreferences.setBoolean("org.eclipse.edt.ide.rui.visualeditor.PatternSelection", true);
        }
        if (!_preferenceStore.contains("org.eclipse.edt.ide.rui.visualeditor.Performance")) {
            EvPreferences.setInt("org.eclipse.edt.ide.rui.visualeditor.Performance", 0);
        }
        if (!_preferenceStore.contains("org.eclipse.edt.ide.rui.visualeditor.RenderEngine")) {
            EvPreferences.setInt("org.eclipse.edt.ide.rui.visualeditor.RenderEngine", 0);
        }
        if (!_preferenceStore.contains("org.eclipse.edt.ide.rui.visualeditor.PromptForNewWidgetName")) {
            EvPreferences.setBoolean("org.eclipse.edt.ide.rui.visualeditor.PromptForNewWidgetName", true);
        }
        if (!_preferenceStore.contains("org.eclipse.edt.ide.rui.visualeditor.BidiWidgetOrientation")) {
            EvPreferences.setString("org.eclipse.edt.ide.rui.visualeditor.BidiWidgetOrientation", EvConstants.PREFERENCE_DEFAULT_BIDI_WIDGET_ORIENTATION);
        }
        if (!_preferenceStore.contains("org.eclipse.edt.ide.rui.visualeditor.BidiTextLayout")) {
            EvPreferences.setString("org.eclipse.edt.ide.rui.visualeditor.BidiTextLayout", EvConstants.PREFERENCE_DEFAULT_BIDI_TEXT_LAYOUT);
        }
        if (!_preferenceStore.contains("org.eclipse.edt.ide.rui.visualeditor.BidiReverseTextDirection")) {
            EvPreferences.setString("org.eclipse.edt.ide.rui.visualeditor.BidiReverseTextDirection", EvConstants.PREFERENCE_DEFAULT_BIDI_REVERSE_TEXT_DIRECTION);
        }
        if (!_preferenceStore.contains("org.eclipse.edt.ide.rui.visualeditor.BidiSymSwap")) {
            EvPreferences.setString("org.eclipse.edt.ide.rui.visualeditor.BidiSymSwap", EvConstants.PREFERENCE_DEFAULT_BIDI_SYM_SWAPPING);
        }
        if (!_preferenceStore.contains("org.eclipse.edt.ide.rui.visualeditor.BidiNumSwap")) {
            EvPreferences.setString("org.eclipse.edt.ide.rui.visualeditor.BidiNumSwap", EvConstants.PREFERENCE_DEFAULT_BIDI_NUM_SWAPPING);
        }
    }

    public static void setBoolean(String name, boolean value) {
        EvPreferences.initialize();
        _preferenceStore.setValue(name, value);
    }

    public static void setDouble(String name, double value) {
        EvPreferences.initialize();
        _preferenceStore.setValue(name, value);
    }

    public static void setFloat(String name, float value) {
        EvPreferences.initialize();
        _preferenceStore.setValue(name, value);
    }

    public static void setInt(String name, int value) {
        EvPreferences.initialize();
        _preferenceStore.setValue(name, value);
    }

    public static void setRGB(String name, RGB value) {
        EvPreferences.initialize();
        _preferenceStore.setValue(name, EvPreferences.convertRGBToString(value));
    }

    public static void setString(String name, String value) {
        EvPreferences.initialize();
        _preferenceStore.setValue(name, value);
    }

    private EvPreferences() {
    }
}

