/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.properties;

import java.util.ArrayList;
import org.eclipse.edt.ide.rui.visualeditor.internal.nl.Tooltips;
import org.eclipse.edt.ide.rui.visualeditor.internal.properties.PropertyEditorAbstract;
import org.eclipse.edt.ide.rui.visualeditor.internal.properties.PropertyPage;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.ColorSelectionDialog;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.ColorUtil;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPropertyDescriptor;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPropertyValue;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PropertyEditorColor
extends PropertyEditorAbstract
implements DisposeListener,
FocusListener,
SelectionListener {
    protected Button _button = null;
    protected Color _color = null;
    protected Image _image = null;
    protected Point _ptExtents = null;
    protected WidgetPropertyValue _propertyValueOriginal = null;
    protected RGB _rgbColorValue = null;
    protected Text _textValue = null;

    public PropertyEditorColor(PropertyPage page, WidgetPropertyDescriptor descriptor) {
        super(page, descriptor);
    }

    protected Point computeImageSize(Control window) {
        GC gc = new GC((Drawable)window);
        Font f = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
        gc.setFont(f);
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        Point p = new Point(height * 3 - 6, height);
        return p;
    }

    @Override
    public void createControl(Composite compositeParent) {
        Composite composite = new Composite(compositeParent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setBackground(compositeParent.getBackground());
        this._button = new Button(composite, 8);
        this._button.setBackground(compositeParent.getBackground());
        gridData = new GridData();
        gridData.horizontalAlignment = 0x1000008;
        this._button.setLayoutData((Object)gridData);
        this._button.setToolTipText(Tooltips.NL_Press_to_select_a_color);
        this._textValue = new Text(composite, 2056);
        this._textValue.setBackground(compositeParent.getBackground());
        gridData = new GridData(768);
        gridData.widthHint = 80;
        this._textValue.setLayoutData((Object)gridData);
        this._textValue.addSelectionListener((SelectionListener)this);
        this._textValue.addFocusListener((FocusListener)this);
        this._ptExtents = this.computeImageSize((Control)compositeParent);
        this._image = new Image((Device)compositeParent.getDisplay(), this._ptExtents.x, this._ptExtents.y);
        GC gc = new GC((Drawable)this._image);
        gc.setBackground(this._button.getBackground());
        gc.fillRectangle(0, 0, this._ptExtents.x, this._ptExtents.y);
        gc.dispose();
        this.updateColorImage();
        this._button.setImage(this._image);
        this._button.addDisposeListener((DisposeListener)this);
        this._button.addSelectionListener((SelectionListener)this);
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        String strColorValue = this._textValue.getText();
        this._rgbColorValue = strColorValue.length() > 0 ? ColorUtil.convertStringToRGB(strColorValue) : null;
        this.updateColorImage();
        WidgetPropertyValue propertyValue = new WidgetPropertyValue(this._textValue.getText());
        super.propertyValueChanged(this.getPropertyDescriptor(), this._propertyValueOriginal, propertyValue);
    }

    @Override
    public void initialize() {
        this._propertyValueOriginal = this.getPropertyValue(this.getPropertyDescriptor().getID(), this.getPropertyDescriptor().getType());
        if (this._propertyValueOriginal == null) {
            this.reset();
            return;
        }
        ArrayList listValues = this._propertyValueOriginal.getValues();
        if (listValues == null || listValues.size() == 0) {
            this.reset();
            return;
        }
        String strValue = (String)listValues.get(0);
        if (strValue == null || strValue.length() == 0) {
            this.reset();
            return;
        }
        this._rgbColorValue = ColorUtil.convertStringToRGB(strValue);
        this._textValue.setText(strValue);
        this.updateColorImage();
        this._button.setEnabled(this._propertyValueOriginal.isEditable());
    }

    protected void reset() {
        this._textValue.setText("");
        this._rgbColorValue = null;
        this.updateColorImage();
    }

    protected void updateColorImage() {
        Display display = this._button.getDisplay();
        GC gc = new GC((Drawable)this._image);
        if (this._rgbColorValue != null) {
            gc.setForeground(display.getSystemColor(2));
            gc.drawRectangle(0, 2, this._ptExtents.x - 1, this._ptExtents.y - 4);
        }
        if (this._color != null && !this._color.isDisposed()) {
            this._color.dispose();
            this._color = null;
        }
        if (this._rgbColorValue != null) {
            this._color = new Color((Device)display, this._rgbColorValue);
            gc.setBackground(this._color);
            gc.fillRectangle(1, 3, this._ptExtents.x - 2, this._ptExtents.y - 5);
        } else {
            gc.setBackground(this._button.getBackground());
            gc.fillRectangle(0, 0, this._ptExtents.x, this._ptExtents.y);
        }
        gc.dispose();
        this._button.setImage(this._image);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        String strColorValue = this._textValue.getText();
        this._rgbColorValue = ColorUtil.convertStringToRGB(strColorValue);
        this.updateColorImage();
        WidgetPropertyValue propertyValue = new WidgetPropertyValue(strColorValue);
        super.propertyValueChanged(this.getPropertyDescriptor(), this._propertyValueOriginal, propertyValue);
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this._color != null && !this._color.isDisposed()) {
            this._color.dispose();
            this._color = null;
        }
        if (this._image != null && !this._image.isDisposed()) {
            this._image.dispose();
            this._image = null;
        }
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this._button) {
            ColorSelectionDialog colorDialog;
            int iRC;
            if (this._button.isDisposed()) {
                return;
            }
            String strValue = this._textValue.getText();
            if (strValue.length() > 0 && strValue.charAt(0) == '\"') {
                strValue = strValue.substring(1);
            }
            if (strValue.length() > 0 && strValue.charAt(strValue.length() - 1) == '\"') {
                strValue = strValue.substring(0, strValue.length() - 1);
            }
            if ((iRC = (colorDialog = new ColorSelectionDialog(this._button.getShell(), strValue)).open()) == 1) {
                return;
            }
            String strColorValue = colorDialog.getColorValue();
            this._textValue.setText(strColorValue);
            this._rgbColorValue = strColorValue.length() > 0 ? ColorUtil.convertStringToRGB(strColorValue) : null;
            this.updateColorImage();
            WidgetPropertyValue propertyValue = new WidgetPropertyValue(strColorValue);
            super.propertyValueChanged(this.getPropertyDescriptor(), this._propertyValueOriginal, propertyValue);
            this._textValue.setFocus();
        }
    }
}

