/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.util;

import java.util.List;
import org.eclipse.edt.ide.rui.server.EvEditorProvider;
import org.eclipse.edt.ide.rui.visualeditor.internal.nl.Messages;
import org.eclipse.edt.ide.rui.visualeditor.internal.preferences.EvPreferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EvWidgetNameDialog
extends Dialog
implements ModifyListener,
SelectionListener {
    protected boolean _bTranslationTestMode = false;
    protected Button _checkPromptForName = null;
    protected EvEditorProvider _editorProvider = null;
    protected int _iTranslationTestModeCount = 0;
    protected Label _labelErrorMessage = null;
    protected List _listFunctionNames = null;
    protected List _listWidgetNames = null;
    protected String _strName = null;
    protected String _strWidgetType = null;
    protected Text _textName = null;

    public EvWidgetNameDialog(Shell shell, String strWidgetType, EvEditorProvider editorProvider) {
        super(shell);
        this._strWidgetType = strWidgetType;
        this._editorProvider = editorProvider;
    }

    protected int computeMaximumErrorMessageLength(Display display) {
        GC gc = new GC((Drawable)display);
        Point ptString = gc.stringExtent(Messages.NL_A_function_with_the_same_name_already_exists);
        int iMax = ptString.x;
        ptString = gc.stringExtent(Messages.NL_The_name_already_exists);
        iMax = Math.max(iMax, ptString.x);
        ptString = gc.stringExtent(Messages.NL_The_name_is_not_allowed);
        iMax = Math.max(iMax, ptString.x);
        return iMax;
    }

    protected Control createContents(Composite compositeParent) {
        if (this._editorProvider != null) {
            this._listFunctionNames = this._editorProvider.getExistingFunctionNames();
            this._listWidgetNames = this._editorProvider.getWidgetNames();
            this._strName = this._editorProvider.getWidgetDefaultName(this._strWidgetType);
        }
        Control control = super.createContents(compositeParent);
        if (!this._bTranslationTestMode) {
            this.validate();
        }
        return control;
    }

    protected Control createDialogArea(Composite compositeParent) {
        int iMaximumErrorMessageLength;
        this.getShell().setText(Messages.NL_New_Variable);
        Composite compositeDialog = new Composite(compositeParent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        compositeDialog.setLayout((Layout)gridLayout);
        Label labelFunctionName = new Label(compositeDialog, 0);
        GridData gridData = new GridData();
        labelFunctionName.setLayoutData((Object)gridData);
        labelFunctionName.setText(Messages.NL_Variable_nameXcolonX);
        this._textName = new Text(compositeDialog, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 150;
        this._textName.setLayoutData((Object)gridData);
        if (this._strName != null) {
            this._textName.setText(this._strName);
            this._textName.selectAll();
        }
        this._textName.setTextLimit(128);
        this._textName.addModifyListener((ModifyListener)this);
        this._labelErrorMessage = new Label(compositeDialog, 0);
        gridData = new GridData(768);
        gridData.widthHint = iMaximumErrorMessageLength = this.computeMaximumErrorMessageLength(compositeParent.getDisplay());
        gridData.horizontalSpan = 2;
        this._labelErrorMessage.setLayoutData((Object)gridData);
        Label labelSeparator = new Label(compositeDialog, 258);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        labelSeparator.setLayoutData((Object)gridData);
        this._checkPromptForName = new Button(compositeDialog, 32);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 16;
        this._checkPromptForName.setLayoutData((Object)gridData);
        this._checkPromptForName.setText(Messages.NL_Prompt_for_a_variable_name);
        this._checkPromptForName.setSelection(true);
        this._checkPromptForName.addSelectionListener((SelectionListener)this);
        Label labelInformation = new Label(compositeDialog, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 32;
        labelInformation.setLayoutData((Object)gridData);
        labelInformation.setText(Messages.NL_You_may_also_change_this_setting_in_the_preferences);
        return compositeDialog;
    }

    public String getName() {
        return this._strName;
    }

    public void modifyText(ModifyEvent e) {
        this.validate();
    }

    protected void okPressed() {
        if (!this._bTranslationTestMode || this._iTranslationTestModeCount > 2) {
            super.okPressed();
            return;
        }
        if (this._iTranslationTestModeCount == 0) {
            this._labelErrorMessage.setText(Messages.NL_A_function_with_the_same_name_already_exists);
        } else if (this._iTranslationTestModeCount == 1) {
            this._labelErrorMessage.setText(Messages.NL_The_name_already_exists);
        } else if (this._iTranslationTestModeCount == 2) {
            this._labelErrorMessage.setText(Messages.NL_The_name_is_not_allowed);
        }
        ++this._iTranslationTestModeCount;
    }

    public void setTranslationTestMode(boolean bTranslationTestMode) {
        this._bTranslationTestMode = bTranslationTestMode;
    }

    protected void validate() {
        this._strName = this._textName.getText();
        String strErrorMessage = "";
        if (this._strName.length() > 0) {
            int i = 0;
            while (i < this._listFunctionNames.size()) {
                if (((String)this._listFunctionNames.get(i)).equalsIgnoreCase(this._strName)) {
                    strErrorMessage = Messages.NL_A_function_with_the_same_name_already_exists;
                    break;
                }
                ++i;
            }
            i = 0;
            while (i < this._listWidgetNames.size()) {
                String strExistingName = (String)this._listWidgetNames.get(i);
                if (strExistingName.equalsIgnoreCase(this._strName)) {
                    strErrorMessage = Messages.NL_The_name_already_exists;
                    break;
                }
                ++i;
            }
            if (strErrorMessage.length() == 0 && this._strName.length() > 0 && !this._editorProvider.isValidName(this._strName)) {
                strErrorMessage = Messages.NL_The_name_is_not_allowed;
            }
        }
        Button buttonOK = this.getButton(0);
        buttonOK.setEnabled(strErrorMessage.length() == 0 && this._strName.length() != 0);
        this._labelErrorMessage.setText(strErrorMessage);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void widgetSelected(SelectionEvent e) {
        boolean bPromptForName = this._checkPromptForName.getSelection();
        EvPreferences.setBoolean("org.eclipse.edt.ide.rui.visualeditor.PromptForNewWidgetName", bPromptForName);
        this._textName.setEnabled(bPromptForName);
    }
}

