/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.engine;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.GenNode;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.engine.BindingNameResolver;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.engine.ChildWidgetsResolver;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.engine.ColumnResolver;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.engine.ColumnsResolver;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.engine.ControllerNameResolver;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.engine.ErrorLabelNameResolver;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.engine.FormFieldNameResolver;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.engine.FormFieldsResolver;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.engine.FormManagerNameResolver;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.engine.IGenVariableResolver;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.engine.LabelTextResolver;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.engine.NameLabelNameResolver;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.engine.RepeatResolver;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.engine.RowResolver;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.engine.RowsResolver;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.engine.ShortBindingNameResolver;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.engine.ValidStateSetterNameResolver;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.engine.WidgetNameResolver;

public class GenVariableResolverManager {
    private static GenVariableResolverManager instance;
    private List<IGenVariableResolver> resolvers = new ArrayList<IGenVariableResolver>();

    private GenVariableResolverManager() {
        this.resolvers.add(new RepeatResolver());
        this.resolvers.add(new WidgetNameResolver());
        this.resolvers.add(new FormManagerNameResolver());
        this.resolvers.add(new ControllerNameResolver());
        this.resolvers.add(new ValidStateSetterNameResolver());
        this.resolvers.add(new BindingNameResolver());
        this.resolvers.add(new ShortBindingNameResolver());
        this.resolvers.add(new LabelTextResolver());
        this.resolvers.add(new NameLabelNameResolver());
        this.resolvers.add(new ErrorLabelNameResolver());
        this.resolvers.add(new FormFieldNameResolver());
        this.resolvers.add(new ChildWidgetsResolver());
        this.resolvers.add(new FormFieldsResolver());
        this.resolvers.add(new RowsResolver());
        this.resolvers.add(new RowResolver());
        this.resolvers.add(new ColumnsResolver());
        this.resolvers.add(new ColumnResolver());
    }

    public static GenVariableResolverManager getInstance() {
        if (instance == null) {
            instance = new GenVariableResolverManager();
        }
        return instance;
    }

    public void resolve(GenNode genNode) {
        int i = 0;
        while (i < this.resolvers.size()) {
            IGenVariableResolver resolver = this.resolvers.get(i);
            resolver.resolve(genNode);
            ++i;
        }
    }

    public void resolve(GenNode genNode, IGenVariableResolver resolver) {
        resolver.resolve(genNode);
    }
}

