/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.widget.layout;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.ide.rui.server.EvEditorProvider;
import org.eclipse.edt.ide.rui.server.PropertyValue;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvDesignOverlayDropLocation;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetDescriptor;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetDescriptorRegistry;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetManager;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPart;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.layout.WidgetLayout;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.layout.WidgetLayoutRegistry;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Rectangle;

public abstract class AbstractWidgetLayout
implements WidgetLayout {
    protected static final int DROP_THICKNESS = 5;
    protected ScrolledComposite parentComposite;
    protected WidgetPart widgetRoot;
    protected WidgetPart _widgetDragging;
    protected WidgetManager widgetManager;
    protected WidgetDescriptorRegistry widgetDescriptorRegistry;
    protected EvEditorProvider evEditorProvider;

    @Override
    public void initialize(ScrolledComposite parentComposite, WidgetPart widget, WidgetPart _widgetDragging, WidgetManager widgetManager, WidgetDescriptorRegistry widgetDescriptorRegistry, EvEditorProvider evEditorProvider) {
        this.parentComposite = parentComposite;
        this.widgetRoot = widget;
        this._widgetDragging = _widgetDragging;
        this.widgetManager = widgetManager;
        this.widgetDescriptorRegistry = widgetDescriptorRegistry;
        this.evEditorProvider = evEditorProvider;
    }

    protected Iterator getWidgets() {
        return this.widgetManager.getWidgetList().iterator();
    }

    protected void setupDropLocationsForChildren(Collection listDropLocations) {
        List listChildren = this.widgetRoot.getChildren();
        int i = 0;
        while (i < listChildren.size()) {
            WidgetPart widget = (WidgetPart)listChildren.get(i);
            if (widget == this._widgetDragging) {
                return;
            }
            if (this._widgetDragging != null && !this.isContainable(this._widgetDragging.getTypeName(), widget.getTypeName())) {
                return;
            }
            WidgetLayout handlerLayout = WidgetLayoutRegistry.getInstance().getWidgetLayout(WidgetLayoutRegistry.getLayoutName(widget), this.isContainer(widget));
            if (handlerLayout != null) {
                handlerLayout.initialize(this.parentComposite, widget, this._widgetDragging, this.widgetManager, this.widgetDescriptorRegistry, this.evEditorProvider);
                handlerLayout.setupDropLocations(listDropLocations);
            }
            ++i;
        }
    }

    protected boolean isContainable(String strType, String strContainerType) {
        return !(strType.equalsIgnoreCase("treenode") ? !strContainerType.equalsIgnoreCase("treenode") && !strContainerType.equalsIgnoreCase("tree") : strContainerType.equalsIgnoreCase("treenode") || strContainerType.equalsIgnoreCase("tree"));
    }

    protected boolean isContainer(WidgetPart widget) {
        if (widget.getTypeName().equalsIgnoreCase("div") || widget.getTypeName().equalsIgnoreCase("span") || widget.getTypeName().equalsIgnoreCase("grouping") || widget.getTypeName().equalsIgnoreCase("treenode") || widget.getTypeName().equalsIgnoreCase("tree")) {
            return true;
        }
        WidgetDescriptor descriptor = this.widgetDescriptorRegistry.getDescriptor(widget.getTypeID());
        if (descriptor != null) {
            return descriptor.isContainer();
        }
        return false;
    }

    public PropertyValue getPropertyValue(String strPropertyName, String strPropertyType) {
        return this.evEditorProvider.getPropertyValue(this.widgetRoot.getStatementOffset(), this.widgetRoot.getStatementLength(), strPropertyName, strPropertyType);
    }

    protected void setupDropLocationsForInsideContainer(WidgetPart widget, Collection listDropLocations) {
        if (widget.getStatementLength() <= 0) {
            return;
        }
        Rectangle rectBounds = widget.getBounds();
        EvDesignOverlayDropLocation location = new EvDesignOverlayDropLocation();
        location.setBounds(rectBounds.x + 5, rectBounds.y + 5, rectBounds.width - 10, rectBounds.height - 10);
        location.iIndex = 0;
        location.iLocation = 0x1000000;
        location.widgetParent = widget;
        listDropLocations.add(location);
    }

    @Override
    public void updateLayoutData(EvEditorProvider editorProvider, int statementOffset, WidgetPart widget, Object layoutData, PropertyValue oldLayoutData, String layoutDataTemplte) {
    }

    @Override
    public String processNewLayoutData(Object layoutData, String template) {
        return null;
    }

    @Override
    public String[] getLayoutDataQualifiedName() {
        return null;
    }

    @Override
    public String[] getLayoutWidgetQualifiedName() {
        return null;
    }

    @Override
    public List getInnerRectanglesForPaintingWidget(WidgetPart widget) {
        return null;
    }
}

