/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript.templates;

import org.eclipse.edt.gen.javascript.CommonUtilities;
import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.gen.javascript.templates.JavaScriptTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.NewExpression;

public class NewExpressionTemplate
extends JavaScriptTemplate {
    public void genExpression(NewExpression expr, Context ctx, TabbedWriter out) {
        ctx.invoke("genContainerBasedNewExpression", expr.getType(), new Object[]{ctx, out, expr});
    }

    public void genNewExpression(NewExpression expr, Context ctx, TabbedWriter out) {
        if (CommonUtilities.isRUIWidget((Object)expr.getType())) {
            String name = ctx.nextTempName();
            Field field = factory.createField();
            field.setName(name);
            field.setType(expr.getType());
            field.setHasSetValuesBlock(Boolean.valueOf(true));
            if (expr.getAnnotation("EGL_Location") != null) {
                field.addAnnotation(expr.getAnnotation("EGL_Location"));
            }
            out.println("(function () {");
            ctx.invoke("genDeclaration", (EObject)field, new Object[]{ctx, out});
            out.println("return " + name + ";");
            out.print("}).call(this)");
        } else {
            out.print("new ");
            ctx.invoke("genRuntimeTypeName", expr.getType(), new Object[]{ctx, out, JavaScriptTemplate.TypeNameKind.JavascriptImplementation});
            out.print("(");
            if (expr.getArguments() != null && expr.getArguments().size() > 0) {
                String delim = "";
                for (Expression argument : expr.getArguments()) {
                    out.print(delim);
                    ctx.invoke("genExpression", (EObject)argument, new Object[]{ctx, out});
                    delim = ", ";
                }
            } else {
                ctx.invoke("genConstructorOptions", expr.getType(), new Object[]{ctx, out});
            }
            out.print(")");
        }
    }
}

