/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.edt.ide.core.EDTRuntimeContainer;
import org.eclipse.edt.ide.core.GenerationContributorEntry;
import org.eclipse.edt.ide.core.IGenerator;
import org.eclipse.edt.ide.core.utils.EclipseUtilities;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.jface.preference.IPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public abstract class AbstractGenerator
extends org.eclipse.edt.compiler.AbstractGenerator
implements IGenerator {
    protected static GenerationContributorEntry[] contributions;
    protected List<GenerationContributorEntry> contributionsUsed;
    protected EDTRuntimeContainer[] runtimeContainers;

    public AbstractGenerator() {
        this.registerContributions();
    }

    public GenerationContributorEntry[] getContributions() {
        return contributions;
    }

    @Override
    public boolean supportsProject(IProject project) {
        return true;
    }

    @Override
    public EDTRuntimeContainer[] getRuntimeContainers() {
        return this.runtimeContainers;
    }

    @Override
    public IFile[] getOutputFiles(IFile eglFile, Part part) throws CoreException {
        String relativeFilePath = this.getRelativeFilePath(eglFile, part);
        String outputDirectory = this.getOutputDirectory((IResource)eglFile);
        IContainer container = EclipseUtilities.getOutputContainer(outputDirectory, eglFile, relativeFilePath);
        IPath filePath = EclipseUtilities.getOutputFilePath(outputDirectory, eglFile, relativeFilePath);
        return new IFile[]{container.getFile(filePath)};
    }

    public String getOutputDirectory(IResource resource) {
        IProject project = resource.getProject();
        return ProjectSettingsUtility.getGenerationDirectory(resource, this.getPreferenceStore(), new ProjectScope(project).getNode(this.getProjectSettingsPluginId()), this.getGenerationDirectoryPropertyKey(), this.getGenerationDirectoryPreferenceKey());
    }

    public String[] getPrjojectOutputDirectors(IProject project) {
        Preferences propertyPrefs = new ProjectScope(project).getNode(this.getProjectSettingsPluginId()).node(this.getGenerationDirectoryPropertyKey());
        try {
            String[] keys = propertyPrefs.keys();
            HashSet<String> dirs = new HashSet<String>();
            int i = 0;
            while (i < keys.length) {
                dirs.add(propertyPrefs.get(keys[i], null));
                ++i;
            }
            String[] result = new String[dirs.size() + 1];
            dirs.toArray(result);
            result[result.length - 1] = this.getOutputDirectory((IResource)project);
            return result;
        }
        catch (BackingStoreException backingStoreException) {
            return null;
        }
    }

    public void registerContributions() {
        if (contributions == null) {
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.edt.gen.GenerationContributors");
            if (elements != null) {
                ArrayList<GenerationContributorEntry> contributions = new ArrayList<GenerationContributorEntry>();
                int i = 0;
                while (i < elements.length) {
                    try {
                        elements[i].createExecutableExtension("class");
                        GenerationContributorEntry contribution = new GenerationContributorEntry();
                        contribution.setClassName(elements[i].getAttribute("class"));
                        contribution.setProvider(elements[i].getAttribute("provider"));
                        contribution.setIdentifier(elements[i].getAttribute("id"));
                        contribution.setRequires(elements[i].getAttribute("requires"));
                        contributions.add(contribution);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                AbstractGenerator.contributions = contributions.toArray(new GenerationContributorEntry[contributions.size()]);
            } else {
                contributions = new GenerationContributorEntry[0];
            }
        }
    }

    public String[] getGenerationArguments(IResource resource) {
        IProject project = resource.getProject();
        String args = ProjectSettingsUtility.getGenerationArgument(resource, this.getPreferenceStore(), new ProjectScope(project).getNode(this.getProjectSettingsPluginId()), this.getGenerationArgumentsPropertyKey());
        return this.splitIntoArgs(args);
    }

    protected String[] buildArgs(IFile file, Part part) throws Exception {
        int numArgs = 6;
        String[] additionalArgs = this.getGenerationArguments((IResource)file);
        if (additionalArgs != null) {
            numArgs += additionalArgs.length;
        }
        if (this.contributionsUsed == null && this.getId() != null) {
            this.contributionsUsed = new ArrayList<GenerationContributorEntry>();
            AbstractGenerator.determineContributions(this.getId(), this.contributionsUsed);
        }
        if (this.contributionsUsed != null) {
            numArgs += this.contributionsUsed.size() + 1;
        }
        String[] args = new String[numArgs];
        int idx = 0;
        args[idx++] = "-o";
        args[idx++] = this.getOutputDirectory((IResource)file);
        args[idx++] = "-p";
        args[idx++] = part.getName();
        args[idx++] = "-r";
        args[idx++] = file.getFullPath().toOSString();
        if (additionalArgs != null) {
            String[] stringArray = additionalArgs;
            int n = additionalArgs.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                args[idx++] = string;
                ++n2;
            }
        }
        if (this.contributionsUsed != null) {
            args[idx++] = "-c";
            for (GenerationContributorEntry generationContributorEntry : this.contributionsUsed) {
                args[idx++] = generationContributorEntry.getClassName();
            }
        }
        return args;
    }

    public static void determineContributions(String provider, List<GenerationContributorEntry> contributionsUsed) {
        int i = 0;
        while (i < contributions.length) {
            GenerationContributorEntry contribution = contributions[i];
            if (provider.equals(contribution.getProvider())) {
                AbstractGenerator.locateContributions(contribution.getIdentifier(), contributionsUsed);
            }
            ++i;
        }
    }

    private static void locateContributions(String contributionId, List<GenerationContributorEntry> contributionsUsed) {
        ArrayList<String> requires = new ArrayList<String>();
        int i = 0;
        while (i < contributions.length) {
            GenerationContributorEntry contribution = contributions[i];
            if (contributionId.equals(contribution.getIdentifier())) {
                contributionsUsed.add(contribution);
                if (contribution.getRequires() != null && !requires.contains(contribution.getRequires())) {
                    requires.add(contribution.getRequires());
                }
            }
            ++i;
        }
        i = 0;
        while (i < requires.size()) {
            AbstractGenerator.locateContributions((String)requires.get(i), contributionsUsed);
            ++i;
        }
    }

    private String[] splitIntoArgs(String args) {
        if (args == null) {
            return null;
        }
        if ((args = args.trim()).length() != 0) {
            char[] chars = args.toCharArray();
            int size = chars.length;
            int curr = 0;
            boolean quoted = false;
            boolean escaped = false;
            ArrayList<String> entries = new ArrayList<String>(10);
            StringBuilder buf = new StringBuilder(50);
            while (curr < size) {
                char c = chars[curr];
                if (escaped && c != '\"') {
                    buf.append('\\');
                }
                if (c == '\\') {
                    if (escaped) {
                        buf.append(c);
                    }
                    escaped = !escaped;
                } else if (Character.isWhitespace(c)) {
                    escaped = false;
                    if (!quoted) {
                        if (buf.length() != 0) {
                            entries.add(buf.toString());
                            buf = new StringBuilder(50);
                        }
                    } else {
                        buf.append(c);
                    }
                } else if (c == '\"') {
                    if (escaped) {
                        escaped = false;
                        buf.append(c);
                    } else {
                        quoted = !quoted;
                    }
                } else {
                    escaped = false;
                    buf.append(c);
                }
                ++curr;
            }
            if (buf.length() > 0) {
                entries.add(buf.toString());
            }
            return entries.toArray(new String[entries.size()]);
        }
        return null;
    }

    protected abstract String getRelativeFilePath(IFile var1, Part var2);

    protected abstract String getGenerationDirectoryPropertyKey();

    protected abstract String getGenerationArgumentsPropertyKey();

    protected abstract String getGenerationDirectoryPreferenceKey();

    protected abstract IPreferenceStore getPreferenceStore();
}

