/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.simpleconfigurator.manipulator.SimpleConfiguratorManipulator;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public class EDTRuntimeContainerEntry {
    private final String bundleId;
    private final String bundleRoot;
    private final String sourceBundleId;
    private final String sourceBundleRoot;
    private final VersionRange bundleVersionRange;
    private final String javadocLocation;
    private IClasspathEntry entry;

    public EDTRuntimeContainerEntry(String bundleId, String bundleRoot, VersionRange versionRange, String sourceBundleId, String sourceBundleRoot, String javadocLocation) {
        this.bundleId = bundleId;
        this.bundleVersionRange = versionRange;
        this.bundleRoot = bundleRoot;
        this.sourceBundleId = sourceBundleId;
        this.sourceBundleRoot = sourceBundleRoot;
        this.javadocLocation = javadocLocation;
        this.create();
    }

    protected void create() {
        try {
            BundleInfo srcBundle;
            BundleContext context = EDTCoreIDEPlugin.getPlugin().getBundleContext();
            if (context == null) {
                return;
            }
            ServiceReference ref = context.getServiceReference(SimpleConfiguratorManipulator.class.getName());
            if (ref == null) {
                return;
            }
            SimpleConfiguratorManipulator manipulator = (SimpleConfiguratorManipulator)context.getService(ref);
            if (manipulator == null) {
                return;
            }
            BundleInfo mainBundle = EDTRuntimeContainerEntry.findBestBundle(this.bundleId, manipulator.loadConfiguration(context, null), this.bundleVersionRange);
            if (mainBundle == null) {
                return;
            }
            URL bundleURL = FileLocator.toFileURL((URL)URIUtil.toURL((URI)mainBundle.getLocation()));
            String path = bundleURL.getPath();
            path = URLDecoder.decode(path, "UTF-8");
            Path bundlePath = new Path(path);
            if (this.bundleRoot != null && this.bundleRoot.length() != 0 && bundlePath.toFile().isDirectory()) {
                bundlePath = bundlePath.append(this.bundleRoot);
            }
            Path srcBundlePath = null;
            Path srcRootPath = null;
            if (this.sourceBundleRoot != null && this.sourceBundleRoot.length() != 0) {
                File bundleFile = new File(bundleURL.getFile());
                if (bundleFile.isDirectory()) {
                    File srcFile = new File(bundleFile, this.sourceBundleRoot);
                    if (srcFile.exists()) {
                        srcBundlePath = new Path(srcFile.getPath());
                        if (srcFile.isDirectory()) {
                            srcBundlePath = srcBundlePath.addTrailingSeparator();
                        }
                    }
                } else if (bundleFile.exists()) {
                    try {
                        ZipFile zip = new ZipFile(bundleFile);
                        if (zip.getEntry(this.sourceBundleRoot) != null) {
                            srcBundlePath = bundlePath;
                            srcRootPath = new Path(this.sourceBundleRoot);
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            if (srcBundlePath == null && this.sourceBundleId != null && this.sourceBundleId.length() != 0 && (srcBundle = EDTRuntimeContainerEntry.findBestBundle(this.sourceBundleId, manipulator.loadConfiguration(context, SimpleConfiguratorManipulator.SOURCE_INFO), this.bundleVersionRange)) != null) {
                path = FileLocator.toFileURL((URL)URIUtil.toURL((URI)srcBundle.getLocation())).getPath();
                path = URLDecoder.decode(path, "UTF-8");
                srcBundlePath = new Path(path);
            }
            IClasspathAttribute[] attrs = this.javadocLocation != null && this.javadocLocation.length() != 0 ? new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"javadoc_location", (String)this.javadocLocation)} : new IClasspathAttribute[]{};
            this.entry = JavaCore.newLibraryEntry((IPath)bundlePath, srcBundlePath, srcRootPath, (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])attrs, (boolean)false);
        }
        catch (IOException e) {
            EDTCoreIDEPlugin.log(e);
        }
    }

    public static BundleInfo findBestBundle(String id, VersionRange range, boolean isSource) throws IOException {
        BundleContext context = EDTCoreIDEPlugin.getPlugin().getBundleContext();
        if (context == null) {
            return null;
        }
        ServiceReference ref = context.getServiceReference(SimpleConfiguratorManipulator.class.getName());
        if (ref == null) {
            return null;
        }
        SimpleConfiguratorManipulator manipulator = (SimpleConfiguratorManipulator)context.getService(ref);
        if (manipulator == null) {
            return null;
        }
        return EDTRuntimeContainerEntry.findBestBundle(id, manipulator.loadConfiguration(context, isSource ? SimpleConfiguratorManipulator.SOURCE_INFO : null), range);
    }

    public static BundleInfo findBestBundle(String id, BundleInfo[] infos, VersionRange range) {
        if (infos == null) {
            return null;
        }
        BundleInfo bestMatch = null;
        Version bestVersion = null;
        int i = 0;
        while (i < infos.length) {
            URI location;
            BundleInfo info = infos[i];
            if (id.equals(info.getSymbolicName()) && (location = info.getLocation()) != null) {
                Version version = new Version(info.getVersion());
                if (range == null || range.isIncluded(version)) {
                    try {
                        String path = FileLocator.toFileURL((URL)URIUtil.toURL((URI)location)).getPath();
                        path = URLDecoder.decode(path, "UTF-8");
                        Path bundlePath = new Path(path);
                        if (bundlePath.toFile().exists() && (bestMatch == null || bestVersion.compareTo((Object)version) < 0)) {
                            bestMatch = info;
                            bestVersion = version;
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            ++i;
        }
        return bestMatch;
    }

    public IClasspathEntry getClasspathEntry() {
        return this.entry;
    }
}

