/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.EDTRuntimeContainer;
import org.eclipse.edt.ide.core.IGenerator;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class EDTRuntimeContainerInitializer
extends ClasspathContainerInitializer {
    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        if (this.isValidEDTContainerPath(containerPath)) {
            IGenerator[] gens = EDTCoreIDEPlugin.getPlugin().getGenerators();
            if (gens == null || gens.length == 0) {
                return;
            }
            String containerId = containerPath.segment(1);
            int i = 0;
            while (i < gens.length) {
                EDTRuntimeContainer[] containers = gens[i].getRuntimeContainers();
                if (containers != null && containers.length != 0) {
                    int j = 0;
                    while (j < containers.length) {
                        if (containerId.equals(containers[j].getId())) {
                            EDTContainer container = new EDTContainer(containerPath, containers[j].getEntries(), containers[j].getName());
                            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
                            return;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private boolean isValidEDTContainerPath(IPath path) {
        return path != null && path.segmentCount() == 2 && "org.eclipse.edt.ide.core.EDT_CONTAINER".equals(path.segment(0));
    }

    private static class EDTContainer
    implements IClasspathContainer {
        private final IPath path;
        private final IClasspathEntry[] entries;
        private final String description;

        public EDTContainer(IPath path, IClasspathEntry[] entries, String description) {
            this.path = path;
            this.entries = entries;
            this.description = description;
        }

        public IClasspathEntry[] getClasspathEntries() {
            return this.entries;
        }

        public String getDescription() {
            return this.description;
        }

        public int getKind() {
            return 1;
        }

        public IPath getPath() {
            return this.path;
        }
    }
}

