/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.bindings;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.internal.util.EGLFileExtensionUtility;
import org.eclipse.edt.ide.core.internal.bindings.AbstractImportContainer;
import org.eclipse.edt.ide.core.internal.bindings.AbstractImportResolver;
import org.eclipse.edt.ide.core.internal.bindings.WorkspaceImportContainer;
import org.eclipse.edt.ide.core.internal.utils.PatternMatcher;

public class WorkspaceImportResolver
extends AbstractImportResolver {
    private IProject[] projects = new IProject[0];
    private boolean resolvedImports = false;

    public WorkspaceImportResolver(IProject[] projects, String[] imports) {
        super(imports);
        if (projects != null) {
            this.setProjects(projects);
            this.resolvedImports = false;
        }
    }

    private IFile[] doResolveImports() {
        ArrayList imports = this.getImportContainers();
        ArrayList unresolvedImports = new ArrayList();
        if (!this.resolvedImports) {
            int i = 0;
            while (i < imports.size()) {
                boolean resolvedImport = false;
                AbstractImportContainer nextImport = (AbstractImportContainer)imports.get(i);
                int j = 0;
                while (j < this.projects.length) {
                    resolvedImport = this.doResolveImports(nextImport, (IResource)this.projects[j]);
                    if (resolvedImport) break;
                    ++j;
                }
                if (!resolvedImport && !this.importHasWildcard(nextImport)) {
                    unresolvedImports.add(imports.get(i));
                }
                ++i;
            }
        }
        this.setUnresolvedImports(unresolvedImports);
        return this.getResolvedImports().toArray(new IFile[this.getResolvedImports().size()]);
    }

    private boolean doResolveImports(AbstractImportContainer importContainer, IResource resource) {
        IFile file;
        boolean resolvedImport = false;
        if (resource.getType() == 4) {
            IResource[] members = null;
            try {
                members = ((IContainer)resource).members();
            }
            catch (CoreException coreException) {}
            if (members != null) {
                int i = 0;
                while (i < members.length) {
                    resolvedImport = this.doResolveImports(importContainer, members[i]);
                    if (!resolvedImport) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        } else if (resource.getType() == 2) {
            String[] importFolderSegments;
            String[] iFolderSegments = this.getFolderSegments((IFolder)resource);
            if (iFolderSegments.length <= (importFolderSegments = this.getFolderSegments(importContainer)).length && this.isMatchingFolder(iFolderSegments, importFolderSegments)) {
                IResource[] members = null;
                try {
                    members = ((IContainer)resource).members();
                }
                catch (CoreException coreException) {}
                if (members != null) {
                    int i = 0;
                    while (i < members.length) {
                        resolvedImport = this.doResolveImports(importContainer, members[i]);
                        if (!resolvedImport) {
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
            }
        } else if (resource.getType() == 1 && this.isMatchingFolder(this.getFolderStringForFile(file = (IFile)resource), importContainer.getFolder()) && this.isMatchingFile(file, importContainer.getFile())) {
            if (!this.isDuplicateImport(file)) {
                this.storeFile(file);
            }
            if (!this.importHasWildcard(importContainer)) {
                resolvedImport = true;
            }
        }
        return resolvedImport;
    }

    private boolean isMatchingFolder(String[] iFolderSegments, String[] importFolderSegments) {
        boolean result = false;
        String iFolderString = "";
        String importFolderString = "";
        if (importFolderSegments.length >= iFolderSegments.length) {
            int i = 0;
            while (i < iFolderSegments.length) {
                iFolderString = String.valueOf(iFolderString) + iFolderSegments[i];
                importFolderString = String.valueOf(importFolderString) + importFolderSegments[i];
                ++i;
            }
            result = this.isMatchingFolder(iFolderString, importFolderString);
        } else {
            result = false;
        }
        return result;
    }

    private String[] getFolderSegments(AbstractImportContainer importContainer) {
        Path folderPath = new Path(importContainer.getFolder());
        return folderPath.segments();
    }

    private String[] getFolderSegments(IFolder iFolder) {
        ArrayList<String> result = new ArrayList<String>();
        IFolder resource = iFolder;
        while (!(resource instanceof IProject)) {
            result.add(0, resource.getName());
            resource = resource.getParent();
        }
        return result.toArray(new String[result.size()]);
    }

    private IProject[] getProjects() {
        return this.projects;
    }

    private boolean isDuplicateImport(IFile file) {
        boolean duplicate = false;
        if (this.getHashedImports().contains(file.getProjectRelativePath())) {
            duplicate = true;
        }
        return duplicate;
    }

    public IFile[] resolveImports() {
        return this.doResolveImports();
    }

    private void setProjects(IProject[] newProjects) {
        this.projects = newProjects;
    }

    private void storeFile(IFile file) {
        if (file.getFileExtension() != null && file.getFileExtension().equalsIgnoreCase(EGLFileExtensionUtility.getEGLBuildFileExtension())) {
            this.getResolvedImports().add(file);
            this.getHashedImports().add(file.getProjectRelativePath());
        }
    }

    @Override
    protected AbstractImportContainer getNewImportContainer(String importString) {
        return new WorkspaceImportContainer(importString);
    }

    private String getFolderStringForFile(IFile file) {
        IPath folderPath = file.getParent().getFullPath();
        String result = "";
        if (folderPath.segmentCount() > 0) {
            folderPath = folderPath.removeFirstSegments(1);
        }
        result = folderPath.segmentCount() > 0 ? folderPath.toString() : "";
        return result;
    }

    private boolean isMatchingFile(IFile file, String fileName) {
        boolean result = false;
        PatternMatcher fileMatcher = new PatternMatcher(fileName);
        if (fileMatcher.equals(file.getName())) {
            result = true;
        }
        return result;
    }

    private boolean isMatchingFolder(String folderString, String folderName) {
        boolean match = false;
        PatternMatcher folderMatcher = new PatternMatcher(this.fixFolderSeparators(folderName));
        if (folderMatcher.equals(folderString)) {
            match = true;
        }
        return match;
    }
}

