/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.builder;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.ISyntaxErrorRequestor;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.builder.CancelledException;
import org.eclipse.edt.compiler.internal.core.builder.IBuildNotifier;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.io.IRFileNameUtility;
import org.eclipse.edt.compiler.tools.IRUtils;
import org.eclipse.edt.ide.core.internal.binding.BinaryFileManager;
import org.eclipse.edt.ide.core.internal.builder.ASTManager;
import org.eclipse.edt.ide.core.internal.builder.AbstractMarkerProblemRequestor;
import org.eclipse.edt.ide.core.internal.builder.AbstractProcessingQueue;
import org.eclipse.edt.ide.core.internal.builder.BuildManager;
import org.eclipse.edt.ide.core.internal.builder.Builder;
import org.eclipse.edt.ide.core.internal.builder.BuilderResources;
import org.eclipse.edt.ide.core.internal.builder.DuplicatePartManager;
import org.eclipse.edt.ide.core.internal.builder.DuplicatePartRequestor;
import org.eclipse.edt.ide.core.internal.builder.FileMarkerProblemRequestor;
import org.eclipse.edt.ide.core.internal.builder.IProcessorRequestor;
import org.eclipse.edt.ide.core.internal.builder.MarkerProblemRequestor;
import org.eclipse.edt.ide.core.internal.builder.MarkerSyntaxErrorRequestor;
import org.eclipse.edt.ide.core.internal.builder.SyntaxMarkerProblemRequestor;
import org.eclipse.edt.ide.core.internal.builder.Util;
import org.eclipse.edt.ide.core.internal.dependency.DependencyGraph;
import org.eclipse.edt.ide.core.internal.dependency.DependencyGraphManager;
import org.eclipse.edt.ide.core.internal.dependency.IFunctionRequestor;
import org.eclipse.edt.ide.core.internal.lookup.FileInfoDifferencer;
import org.eclipse.edt.ide.core.internal.lookup.FileInfoManager;
import org.eclipse.edt.ide.core.internal.lookup.IASTFileInfo;
import org.eclipse.edt.ide.core.internal.lookup.IFileInfo;
import org.eclipse.edt.ide.core.internal.lookup.IFileInfoDifferenceNotificationRequestor;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectInfo;
import org.eclipse.edt.ide.core.internal.lookup.ProjectInfoManager;
import org.eclipse.edt.ide.core.internal.lookup.ResourceFileInfoCreator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public abstract class AbstractBuilder
implements IProcessorRequestor {
    private IContainer[] sourceLocations;
    private boolean hasStructuralChanges = false;
    protected IBuildNotifier notifier;
    protected ProjectInfo projectInfo;
    protected AbstractProcessingQueue processingQueue = null;
    protected Builder builder = null;
    protected DependencyGraph dependencyGraph = null;
    protected BuildManager buildManager = BuildManager.getInstance();
    protected HashSet processedFiles = new HashSet();

    protected AbstractBuilder(Builder builder, IBuildNotifier notifier) {
        this.builder = builder;
        this.dependencyGraph = DependencyGraphManager.getInstance().getDependencyGraph(builder.getProject());
        this.projectInfo = ProjectInfoManager.getInstance().getProjectInfo(builder.getProject());
        this.sourceLocations = ProjectBuildPathManager.getInstance().getProjectBuildPath(builder.getProject()).getSourceLocations();
        this.notifier = notifier;
    }

    public AbstractProcessingQueue getProcessingQueue() {
        return this.processingQueue;
    }

    public Builder getBuilder() {
        return this.builder;
    }

    protected void beginBuilding() {
        this.notifier.setAborted(false);
        ProjectEnvironmentManager.getInstance().beginBuilding(this);
    }

    protected void endBuilding() {
        ProjectEnvironmentManager.getInstance().endBuilding(this);
    }

    protected void addPart(String[] packageName, String caseSensitiveInternedPartName) {
        this.processingQueue.addPart(packageName, caseSensitiveInternedPartName);
    }

    protected void processParts() {
        this.processingQueue.setProcessorRequestor(this);
        this.processingQueue.process();
    }

    protected void addDependents(String[] packageName, String partName) {
        this.processingQueue.addDependents(packageName, partName);
    }

    protected void addDependents(String[] qualifiedName) {
        this.processingQueue.addDependents(qualifiedName);
    }

    protected void addDependents(String partName) {
        this.processingQueue.addDependents(partName);
    }

    public boolean build(IResourceDelta sourceDelta) {
        boolean abortedBuild = false;
        try {
            try {
                this.beginBuilding();
                if (sourceDelta != null && !this.processDeltas(sourceDelta)) {
                    abortedBuild = true;
                }
                if (!abortedBuild) {
                    this.build();
                    this.processParts();
                    abortedBuild = this.notifier.isAborted();
                    if (!abortedBuild) {
                        this.notifier.subTask(BuilderResources.buildSavingDependencyGraph);
                        this.dependencyGraph.save();
                        this.notifier.subTask(BuilderResources.buildSavingIRFiles);
                        DuplicatePartManager.getInstance().saveDuplicatePartList(this.builder.getProject());
                    }
                    if (!abortedBuild && this.hasStructuralChanges && ProjectBuildPathManager.getInstance().getProjectBuildPath(this.builder.getProject()).hasCycle()) {
                        this.builder.mustPropagateStructuralChanges();
                    }
                }
            }
            catch (CancelledException e) {
                throw e;
            }
            catch (BuildException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new BuildException((Throwable)e);
            }
        }
        finally {
            this.endBuilding();
        }
        return abortedBuild;
    }

    protected abstract void build();

    protected boolean processDeltas(IResourceDelta delta) {
        this.notifier.updateProgressDelta(0.2f);
        this.notifier.subTask(BuilderResources.buildAnalyzingChangedEGLFiles);
        int i = 0;
        int l = this.sourceLocations.length;
        while (i < l) {
            IContainer sourceLocation = this.sourceLocations[i];
            if (sourceLocation.equals((Object)this.builder.getProject())) {
                int segmentCount = delta.getFullPath().segmentCount();
                IResourceDelta[] children = delta.getAffectedChildren();
                int j = 0;
                int m = children.length;
                while (j < m) {
                    this.processDeltas(children[j], segmentCount);
                    ++j;
                }
            } else {
                IResourceDelta sourceDelta = delta.findMember(sourceLocation.getProjectRelativePath());
                if (sourceDelta != null) {
                    if (sourceDelta.getKind() == 2) {
                        System.out.println("ABORTING incremental build... found removed source folder");
                        return false;
                    }
                    int segmentCount = sourceDelta.getFullPath().segmentCount();
                    IResourceDelta[] children = sourceDelta.getAffectedChildren();
                    int j = 0;
                    int m = children.length;
                    while (j < m) {
                        this.processDeltas(children[j], segmentCount);
                        ++j;
                    }
                }
            }
            this.notifier.checkCancel();
            ++i;
        }
        return true;
    }

    private void processDeltas(IResourceDelta sourceDelta, int segmentCount) {
        IResource resource = sourceDelta.getResource();
        switch (resource.getType()) {
            case 2: {
                switch (sourceDelta.getKind()) {
                    case 1: {
                        IPath addedPackagePath = resource.getFullPath().removeFirstSegments(segmentCount);
                        this.processAddedPackage(InternUtil.intern((String[])org.eclipse.edt.ide.core.internal.utils.Util.pathToStringArray(addedPackagePath)));
                    }
                    case 4: {
                        IResourceDelta[] children = sourceDelta.getAffectedChildren();
                        int i = 0;
                        int l = children.length;
                        while (i < l) {
                            this.processDeltas(children[i], segmentCount);
                            ++i;
                        }
                        return;
                    }
                    case 2: {
                        IPath removedPackagePath = resource.getFullPath().removeFirstSegments(segmentCount);
                        if (this.sourceLocations.length > 1) {
                            int i = 0;
                            int l = this.sourceLocations.length;
                            while (i < l) {
                                if (this.sourceLocations[i].getFolder(removedPackagePath).exists()) {
                                    IResourceDelta[] removedChildren = sourceDelta.getAffectedChildren();
                                    int j = 0;
                                    int m = removedChildren.length;
                                    while (j < m) {
                                        this.processDeltas(removedChildren[j], segmentCount);
                                        ++j;
                                    }
                                    return;
                                }
                                ++i;
                            }
                        }
                        this.processRemovedPackage(InternUtil.intern((String[])org.eclipse.edt.ide.core.internal.utils.Util.pathToStringArray(removedPackagePath)), sourceDelta);
                        return;
                    }
                }
            }
            case 1: {
                String resourceName = resource.getName();
                this.processedFiles.add(resource);
                if (org.eclipse.edt.ide.core.internal.model.Util.isEGLFileName(resourceName)) {
                    IPath packagePath = resource.getFullPath().removeFirstSegments(segmentCount).removeLastSegments(1);
                    switch (sourceDelta.getKind()) {
                        case 1: {
                            this.cleanMarkersFromFile((IFile)resource);
                            this.processAddedFile(InternUtil.intern((String[])org.eclipse.edt.ide.core.internal.utils.Util.pathToStringArray(packagePath)), (IFile)resource);
                            return;
                        }
                        case 2: {
                            this.processRemovedFile(InternUtil.intern((String[])org.eclipse.edt.ide.core.internal.utils.Util.pathToStringArray(packagePath)), (IFile)resource);
                            return;
                        }
                        case 4: {
                            if ((sourceDelta.getFlags() & 0x100) == 0 && (sourceDelta.getFlags() & 0x100000) == 0) {
                                return;
                            }
                            this.processChangedFile(InternUtil.intern((String[])org.eclipse.edt.ide.core.internal.utils.Util.pathToStringArray(packagePath)), (IFile)resource);
                            return;
                        }
                    }
                    return;
                }
                if (this.isOKToCopy(resourceName) && sourceDelta.getKind() != 2) {
                    IPath packagePath = resource.getFullPath().removeFirstSegments(segmentCount).removeLastSegments(1);
                    this.copyFileToOutputLocation((IFile)resource, org.eclipse.edt.ide.core.internal.utils.Util.pathToStringArray(packagePath));
                }
                return;
            }
        }
    }

    private void recordStructuralChange(String[] packageName) {
        this.hasStructuralChanges = true;
        this.buildManager.recordPackage(this.builder.getProject(), packageName);
    }

    @Override
    public void recordStructuralChange(String[] packageName, String partName, int partType) {
        this.buildManager.recordPart(this.builder.getProject(), packageName, partName, partType);
        this.hasStructuralChanges = true;
    }

    private void processRemovedPackageHelper(String[] packageName, IResourceDelta[] children) {
        int i = 0;
        while (i < children.length) {
            IResource resource = children[i].getResource();
            switch (resource.getType()) {
                case 2: {
                    String[] subPackageName = new String[packageName.length + 1];
                    System.arraycopy(packageName, 0, subPackageName, 0, packageName.length);
                    subPackageName[packageName.length] = resource.getName();
                    this.processRemovedPackageHelper(InternUtil.intern((String[])subPackageName), children[i].getAffectedChildren());
                    break;
                }
                case 1: {
                    IPath filePath = resource.getProjectRelativePath();
                    if (!org.eclipse.edt.ide.core.internal.model.Util.isEGLFileName(filePath.lastSegment())) break;
                    IFileInfo fileInfo = FileInfoManager.getInstance().getFileInfo(this.builder.getProject(), filePath);
                    Set partNames = fileInfo.getPartNames();
                    for (String partName : partNames) {
                        this.removeMarkersFromInvokedFunctions((IFile)resource, packageName, partName);
                        this.dependencyGraph.removePart(packageName, partName, org.eclipse.edt.ide.core.internal.utils.Util.getFilePartName((IFile)resource));
                        ProjectEnvironmentManager.getInstance().getProjectEnvironment(this.builder.getProject()).removePartBinding(packageName, partName);
                        HashSet otherFilesToProcess = new HashSet();
                        this.locateDuplicateFile(otherFilesToProcess, packageName, partName);
                        if (this.processingQueue.isPending(packageName, partName)) {
                            this.processingQueue.removePart(packageName, partName);
                        }
                        if (fileInfo.getPartType(partName) != 16) {
                            BinaryFileManager.getInstance().removePart(packageName, partName, this.builder.getProject());
                        }
                        this.processDuplicateFiles(packageName, otherFilesToProcess);
                    }
                    FileInfoManager.getInstance().removeFile(this.builder.getProject(), filePath);
                }
            }
            ++i;
        }
    }

    private void processAddedPackage(String[] packageName) {
        this.projectInfo.packageAdded(packageName);
        BinaryFileManager.getInstance().addPackage(packageName, this.builder.getProject());
        this.addDependents(packageName);
        this.recordStructuralChange(packageName);
    }

    private void processRemovedPackage(String[] packageName, IResourceDelta sourceDelta) {
        this.projectInfo.packageRemoved(packageName);
        this.processRemovedPackageHelper(packageName, sourceDelta.getAffectedChildren());
        BinaryFileManager.getInstance().removePackage(packageName, this.builder.getProject());
        this.addDependents(packageName);
        this.recordStructuralChange(packageName);
        FileInfoManager.getInstance().removePackage(this.builder.getProject(), sourceDelta.getProjectRelativePath());
    }

    private void processAddedFile(String[] packageName, IFile addedFile) {
        try {
            String fileContents = org.eclipse.edt.ide.core.internal.utils.Util.getFileContents(addedFile);
            File fileAST = ASTManager.getInstance().getFileAST(addedFile, fileContents);
            ResourceFileInfoCreator fileInfoCreator = new ResourceFileInfoCreator(this.projectInfo, packageName, addedFile, fileAST, fileContents, new DuplicatePartRequestor(this.builder.getProject(), packageName, addedFile));
            IASTFileInfo fileInfo = fileInfoCreator.getASTInfo();
            fileInfo.accept((IProblemRequestor)new FileMarkerProblemRequestor(addedFile, fileInfo));
            fileAST.accept((ISyntaxErrorRequestor)new MarkerSyntaxErrorRequestor(new SyntaxMarkerProblemRequestor(addedFile, fileInfo), fileContents));
            Set partNames = fileInfo.getPartNames();
            for (String partName : partNames) {
                this.projectInfo.partAdded(packageName, partName, fileInfo.getPartType(partName), addedFile, fileInfo.getCaseSensitivePartName(partName));
                this.recordStructuralChange(packageName, partName, fileInfo.getPartType(partName));
                this.addPart(packageName, fileInfo.getCaseSensitivePartName(partName));
                if (fileInfo.getPartType(partName) == 20) {
                    this.addDependents(partName);
                    continue;
                }
                this.addDependents(packageName, partName);
            }
            FileInfoManager.getInstance().saveFileInfo(this.builder.getProject(), addedFile.getProjectRelativePath(), fileInfo);
        }
        catch (Exception e) {
            throw new BuildException("Error processing added file: " + addedFile.getProjectRelativePath(), (Throwable)e);
        }
    }

    private void cleanMarkersFromFile(IFile addedFile) {
        try {
            addedFile.deleteMarkers(AbstractMarkerProblemRequestor.PROBLEM, true, 2);
        }
        catch (CoreException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void processRemovedFile(String[] packageName, IFile removedFile) {
        HashSet otherFilesToProcess = new HashSet();
        IFileInfo fileInfo = FileInfoManager.getInstance().getFileInfo(this.builder.getProject(), removedFile.getProjectRelativePath());
        Set partNames = fileInfo.getPartNames();
        for (String partName : partNames) {
            this.recordStructuralChange(packageName, partName, fileInfo.getPartType(partName));
            this.removeMarkersFromInvokedFunctions(removedFile, packageName, partName);
            this.dependencyGraph.removePart(packageName, partName, org.eclipse.edt.ide.core.internal.utils.Util.getFilePartName(removedFile));
            this.projectInfo.partRemoved(packageName, partName, removedFile);
            this.addDependents(packageName, partName);
            ProjectEnvironmentManager.getInstance().getProjectEnvironment(this.builder.getProject()).removePartBinding(packageName, partName);
            this.locateDuplicateFile(otherFilesToProcess, packageName, partName);
            if (this.processingQueue.isPending(packageName, partName)) {
                this.processingQueue.removePart(packageName, partName);
            }
            if (fileInfo.getPartType(partName) == 16) continue;
            BinaryFileManager.getInstance().removePart(packageName, partName, this.builder.getProject());
        }
        FileInfoManager.getInstance().removeFile(this.builder.getProject(), removedFile.getProjectRelativePath());
        this.processDuplicateFiles(packageName, otherFilesToProcess);
    }

    private void processDuplicateFiles(String[] packageName, HashSet otherFilesToProcess) {
        for (IFile file : otherFilesToProcess) {
            this.processedFiles.add(file);
            this.processChangedFile(packageName, file);
        }
    }

    private void locateDuplicateFile(HashSet otherFilesToProcess, String[] packageName, String partName) {
        Set filesForDuplicatePart = DuplicatePartManager.getInstance().getDuplicatePartList(this.builder.getProject()).getFilesForDuplicatePart(packageName, partName);
        if (filesForDuplicatePart != null) {
            for (IFile file : filesForDuplicatePart) {
                if (!file.exists()) continue;
                otherFilesToProcess.add(file);
                break;
            }
        }
    }

    private void processChangedFile(final String[] packageName, final IFile changedFile) {
        try {
            final HashSet duplicateFlies = new HashSet();
            String fileContents = org.eclipse.edt.ide.core.internal.utils.Util.getFileContents(changedFile);
            File fileAST = ASTManager.getInstance().getFileAST(changedFile, fileContents);
            ResourceFileInfoCreator fileInfoCreator = new ResourceFileInfoCreator(this.projectInfo, packageName, changedFile, fileAST, fileContents, new DuplicatePartRequestor(this.builder.getProject(), packageName, changedFile));
            final IASTFileInfo newInfo = fileInfoCreator.getASTInfo();
            final IFileInfo oldFileInfo = FileInfoManager.getInstance().getFileInfo(this.builder.getProject(), changedFile.getProjectRelativePath());
            newInfo.accept((IProblemRequestor)new FileMarkerProblemRequestor(changedFile, newInfo));
            fileAST.accept((ISyntaxErrorRequestor)new MarkerSyntaxErrorRequestor(new SyntaxMarkerProblemRequestor(changedFile, newInfo), fileContents));
            IFileInfoDifferenceNotificationRequestor requestor = new IFileInfoDifferenceNotificationRequestor(){

                @Override
                public void partAdded(String partName) {
                    AbstractBuilder.this.projectInfo.partAdded(packageName, partName, newInfo.getPartType(partName), changedFile, newInfo.getCaseSensitivePartName(partName));
                    AbstractBuilder.this.recordStructuralChange(packageName, partName, newInfo.getPartType(partName));
                    AbstractBuilder.this.addPart(packageName, newInfo.getCaseSensitivePartName(partName));
                    if (newInfo.getPartType(partName) != 16) {
                        if (newInfo.getPartType(partName) == 20) {
                            AbstractBuilder.this.addDependents(partName);
                        } else {
                            AbstractBuilder.this.addDependents(packageName, partName);
                        }
                    }
                }

                @Override
                public void partRemoved(String partName) {
                    new MarkerProblemRequestor(changedFile, partName);
                    AbstractBuilder.this.removeMarkersFromInvokedFunctions(changedFile, packageName, partName);
                    AbstractBuilder.this.removeContextSpecificMarkers(changedFile, partName);
                    AbstractBuilder.this.recordStructuralChange(packageName, partName, oldFileInfo.getPartType(partName));
                    AbstractBuilder.this.dependencyGraph.removePart(packageName, partName, org.eclipse.edt.ide.core.internal.utils.Util.getFilePartName(changedFile));
                    AbstractBuilder.this.projectInfo.partRemoved(packageName, partName, changedFile);
                    if (oldFileInfo.getPartType(partName) == 16) {
                        for (String nextName : newInfo.getPartNames()) {
                            AbstractBuilder.this.addPart(packageName, newInfo.getCaseSensitivePartName(nextName));
                        }
                    } else {
                        BinaryFileManager.getInstance().removePart(packageName, partName, AbstractBuilder.this.builder.getProject());
                        AbstractBuilder.this.addDependents(packageName, partName);
                    }
                    ProjectEnvironmentManager.getInstance().getProjectEnvironment(AbstractBuilder.this.builder.getProject()).removePartBinding(packageName, partName);
                    if (AbstractBuilder.this.processingQueue.isPending(packageName, partName)) {
                        AbstractBuilder.this.processingQueue.removePart(packageName, partName);
                    }
                    AbstractBuilder.this.locateDuplicateFile(duplicateFlies, packageName, partName);
                }

                @Override
                public void partChanged(String partName) {
                    AbstractBuilder.this.addPart(packageName, newInfo.getCaseSensitivePartName(partName));
                    if (newInfo.getPartType(partName) != 16 && newInfo.getPartType(partName) == 20) {
                        AbstractBuilder.this.addDependents(packageName, partName);
                        AbstractBuilder.this.recordStructuralChange(packageName, partName, 20);
                    }
                }
            };
            FileInfoDifferencer differ = new FileInfoDifferencer(requestor);
            differ.findDifferences(oldFileInfo, newInfo);
            FileInfoManager.getInstance().saveFileInfo(this.builder.getProject(), changedFile.getProjectRelativePath(), newInfo);
            this.processDuplicateFiles(packageName, duplicateFlies);
        }
        catch (Exception e) {
            throw new BuildException("Error processing changed file: " + changedFile.getProjectRelativePath(), (Throwable)e);
        }
    }

    private void removeContextSpecificMarkers(IFile changedFile, String removedPartName) {
        try {
            IMarker[] markers = changedFile.findMarkers(AbstractMarkerProblemRequestor.CONTEXT_SPECIFIC_PROBLEM, false, 2);
            int i = 0;
            while (i < markers.length) {
                String markerPartName = InternUtil.intern((String)markers[i].getAttribute("partName", ""));
                if (markerPartName == removedPartName) {
                    markers[i].delete();
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void removeMarkersFromInvokedFunctions(final IFile contextFile, String[] contextPackageName, final String contextPartName) {
        this.dependencyGraph.findFunctionDependencies(contextPackageName, contextPartName, new IFunctionRequestor(){

            @Override
            public void acceptFunction(String projectName, String[] packageName, String partName) {
                Util.removeMarkersFromInvokedFunctions(contextPartName, contextFile.getFullPath(), projectName, packageName, partName);
            }
        });
    }

    protected boolean isOKToCopy(String name) {
        return !org.eclipse.edt.ide.core.internal.model.Util.isEGLBLDFileName(name) && !IRUtils.isEGLIRFileName((String)name) && !org.eclipse.edt.ide.core.internal.model.Util.isEGLFileName(name);
    }

    protected void copyFileToOutputLocation(IFile file, String[] packageName) {
        IContainer outputLocation = ProjectBuildPathManager.getInstance().getProjectBuildPath(this.builder.getProject()).getOutputLocation();
        try {
            IContainer outputFolder = Util.createFolder(org.eclipse.edt.ide.core.internal.utils.Util.stringArrayToPath(IRFileNameUtility.toIRFileName((String[])packageName)), outputLocation);
            Path filePath = new Path(IRFileNameUtility.toIRFileName((String)file.getName()));
            IFile newfile = outputFolder.getFile((IPath)filePath);
            if (!file.getLocation().isPrefixOf(newfile.getLocation())) {
                if (!newfile.exists()) {
                    newfile.create((InputStream)new FileInputStream(file.getLocation().toFile()), true, null);
                } else {
                    newfile.setContents((InputStream)new FileInputStream(file.getLocation().toFile()), true, false, null);
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

