/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.errors;

import java.io.StringReader;
import org.eclipse.edt.compiler.internal.EGLVAGCompatibilitySetting;
import org.eclipse.edt.ide.core.internal.errors.ErrorLexer;
import org.eclipse.edt.ide.core.internal.errors.ErrorVAGLexer;
import org.eclipse.edt.ide.core.internal.errors.IErrorLexer;

public class ErrorLexerFactory {
    public static final int STRICT_LEXER = 0;
    public static final int VAG_LEXER = 1;

    public static IErrorLexer createLexer(String input) {
        if (EGLVAGCompatibilitySetting.isVAGCompatibility()) {
            return ErrorLexerFactory.createVAGLexer(input);
        }
        return ErrorLexerFactory.createStrictLexer(input);
    }

    public static IErrorLexer createVAGLexer(String input) {
        return new ErrorVAGLexer(new StringReader(input));
    }

    public static IErrorLexer createStrictLexer(String input) {
        return new ErrorLexer(new StringReader(input));
    }

    public static IErrorLexer createLexer(String input, boolean isVAG) {
        return isVAG ? ErrorLexerFactory.createVAGLexer(input) : ErrorLexerFactory.createStrictLexer(input);
    }

    public static IErrorLexer createLexer(String input, int lexerType) {
        switch (lexerType) {
            case 0: {
                return ErrorLexerFactory.createStrictLexer(input);
            }
            case 1: {
                return ErrorLexerFactory.createVAGLexer(input);
            }
        }
        throw new IllegalArgumentException();
    }
}

