/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.generation;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;

public class GenerationBuildManager {
    protected static final IPath BUILD_MANAGER_SAVED_FILE = EDTCoreIDEPlugin.getPlugin().getStateLocation().append(".genbuildmanager");
    private static GenerationBuildManager INSTANCE = new GenerationBuildManager();
    private HashMap<String, BuildManagerEntry> projectMap;

    public static GenerationBuildManager getInstance() {
        return INSTANCE;
    }

    private GenerationBuildManager() {
        this.read();
    }

    private void prune() {
        ArrayList<IProject> projectsToRemove = new ArrayList<IProject>();
        for (String projName : this.projectMap.keySet()) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
            if (!project.exists() || !project.isOpen()) {
                projectsToRemove.add(project);
                continue;
            }
            BuildManagerEntry entry = this.getEntry(project);
            if (entry.getState() >= 2) continue;
            entry.setState(-1);
        }
        if (projectsToRemove.size() > 0) {
            for (IProject project : projectsToRemove) {
                this.removeProject(project);
            }
            this.save();
        }
    }

    private void read() {
        File file = BUILD_MANAGER_SAVED_FILE.toFile();
        if (file.exists()) {
            try {
                ObjectInputStream inputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
                try {
                    this.projectMap = (HashMap)inputStream.readObject();
                }
                finally {
                    inputStream.close();
                }
                this.prune();
            }
            catch (Exception exception) {
                this.projectMap = new HashMap();
            }
        } else {
            this.projectMap = new HashMap();
        }
    }

    private void save() {
        File file = BUILD_MANAGER_SAVED_FILE.toFile();
        try {
            ObjectOutputStream outputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            try {
                outputStream.writeObject(this.projectMap);
            }
            finally {
                outputStream.close();
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private BuildManagerEntry getEntry(IProject project) {
        BuildManagerEntry entry = this.projectMap.get(project.getName());
        if (entry == null) {
            entry = new BuildManagerEntry();
            this.projectMap.put(project.getName(), entry);
        }
        return entry;
    }

    public void removeProject(IProject project) {
        this.projectMap.remove(project.getName());
        this.save();
    }

    public void clear(IProject project) {
        BuildManagerEntry entry = this.getEntry(project);
        entry.setState(-1);
        this.save();
    }

    public boolean getProjectState(IProject project) {
        BuildManagerEntry entry = this.getEntry(project);
        return entry.getState() == 2;
    }

    public void setProjectState(IProject project, boolean state) {
        BuildManagerEntry entry = this.getEntry(project);
        entry.setState(state ? 2 : -1);
        this.save();
    }

    public String[] getDefaultGenIDs(IProject project) {
        BuildManagerEntry entry = this.getEntry(project);
        return entry.getDefaultGenIDs();
    }

    public void putProject(IProject project, String[] defaultGenIDs) {
        BuildManagerEntry entry = this.getEntry(project);
        entry.setDefaultGenIDs(defaultGenIDs);
        entry.setState(2);
        this.save();
    }

    private static class BuildManagerEntry
    implements Serializable {
        private static final long serialVersionUID = 3834040728112637975L;
        private int state = -1;
        private String[] defaultGenIds;

        private BuildManagerEntry() {
        }

        public int getState() {
            return this.state;
        }

        public void setState(int state) {
            this.state = state;
        }

        public String[] getDefaultGenIDs() {
            return this.defaultGenIds;
        }

        public void setDefaultGenIDs(String[] ids) {
            this.defaultGenIds = ids;
        }
    }
}

