/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectIREnvironment;
import org.eclipse.edt.ide.core.internal.model.ISourceElementRequestor;
import org.eclipse.edt.ide.core.internal.model.index.IDocument;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.EVisitor;
import org.eclipse.edt.mof.egl.AccessKind;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.DataItem;
import org.eclipse.edt.mof.egl.Library;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Record;
import org.eclipse.edt.mof.impl.AbstractVisitor;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.Deserializer;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.xml.XMLSerializationFactory;

public class BinaryElementParser {
    private char[] packageName;
    private ISourceElementRequestor requestor;
    private IProject project;
    private boolean reportReferencesInStatements;

    public BinaryElementParser(ISourceElementRequestor requestor, IProject project) {
        this.requestor = requestor;
        this.project = project;
    }

    public void parseDocument(IDocument file, boolean reportReferencesInStatements) {
        this.reportReferencesInStatements = reportReferencesInStatements;
        try {
            byte[] contents = file.getByteContent();
            this.index(contents);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void index(byte[] IRContents) {
        XMLSerializationFactory factory = new XMLSerializationFactory();
        ByteArrayInputStream input = new ByteArrayInputStream(IRContents);
        ProjectEnvironmentManager.getInstance().beginEGLarSearch(this.project);
        ProjectIREnvironment irEnv = ProjectEnvironmentManager.getInstance().getIREnvironment(this.project);
        Deserializer deserializer = factory.createDeserializer((Object)input, (IEnvironment)irEnv);
        try {
            EObject obj = deserializer.deserialize();
            this.packageName = obj.getEClass().getPackageName().toCharArray();
            this.requestor.enterEGLFile();
            if (this.packageName != null) {
                this.requestor.acceptPackage(0, 0, this.packageName);
            }
            if (obj instanceof Part) {
                Part part = (Part)obj;
                this.handleEnterPart(part);
            }
        }
        catch (DeserializationException ex) {
            ex.printStackTrace();
        }
    }

    private void handleEnterPart(Part partElement) {
        PartInfoHelper partInfo = new PartInfoHelper();
        Annotation annotation = partElement.getAnnotation("EGL_Location");
        if (annotation != null) {
            int startOffset = 0;
            int length = 0;
            if (annotation.getValue("off") != null) {
                startOffset = (Integer)annotation.getValue("off");
            }
            if (annotation.getValue("len") != null) {
                length = (Integer)annotation.getValue("len");
            }
            partInfo.nameStart = startOffset;
            partInfo.nameEnd = startOffset + length;
        }
        partInfo.name = partElement.getName().toCharArray();
        partInfo.modifier = partElement.getAccessKind() == AccessKind.ACC_PRIVATE ? 2 : 1;
        new PartVisitor(partInfo, partElement);
    }

    private void visitPart(int partType, PartInfoHelper pInfo, Part partElement) {
        String subTypeName = "";
        if (partElement instanceof DataItem) {
            subTypeName = ((DataItem)partElement).getBaseType().toString();
        } else if (partElement.getSubType() != null) {
            subTypeName = partElement.getSubType().getEClass().getName();
        }
        this.requestor.enterPart(partType, subTypeName.toCharArray(), partElement.hashCode(), 0, pInfo.modifier, pInfo.name, pInfo.nameStart, pInfo.nameEnd, pInfo.interfaceNames, pInfo.parameterNames, pInfo.parameterTypes, pInfo.usagePartTypes, pInfo.usagePartPackages, partElement.getFileName());
    }

    private class PartInfoHelper {
        char[] name;
        int nameStart;
        int nameEnd;
        int modifier;
        char[][] interfaceNames = null;
        char[][] parameterNames = null;
        char[][] parameterTypes = null;
        char[][] usagePartTypes = null;
        char[][] usagePartPackages = null;

        private PartInfoHelper() {
        }
    }

    public class PartVisitor
    extends AbstractVisitor {
        private int partType;
        private PartInfoHelper partInfo;

        PartVisitor(PartInfoHelper partInfo, Part part) {
            this.disallowRevisit();
            this.partInfo = partInfo;
            part.accept((EVisitor)this);
        }

        public boolean visit(Library library) {
            this.partType = 11;
            List usedParts = library.getUsedParts();
            if (usedParts != null && usedParts.size() > 0) {
                char[][] usagePartTypes = new char[usedParts.size()][];
                char[][] usagePartPackages = new char[usedParts.size()][];
                int i = 0;
                for (Part usedPart : usedParts) {
                    usagePartTypes[i] = usedPart.getName().toCharArray();
                    usagePartPackages[i] = usedPart.getPackageName().toCharArray();
                    ++i;
                }
                this.partInfo.usagePartTypes = usagePartTypes;
                this.partInfo.usagePartPackages = usagePartPackages;
            }
            BinaryElementParser.this.visitPart(this.partType, this.partInfo, (Part)library);
            return true;
        }

        public boolean visit(Record partElement) {
            this.partType = 2;
            BinaryElementParser.this.visitPart(this.partType, this.partInfo, (Part)partElement);
            return true;
        }
    }
}

