/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.core.internal.model.EGLElement;
import org.eclipse.edt.ide.core.internal.model.EGLElementDelta;
import org.eclipse.edt.ide.core.internal.model.EGLModelResources;
import org.eclipse.edt.ide.core.internal.model.EGLModelStatus;
import org.eclipse.edt.ide.core.internal.model.MultiOperation;
import org.eclipse.edt.ide.core.internal.model.PackageFragmentRoot;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IBuffer;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLElementDelta;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLModelStatus;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageDeclaration;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.model.ISourceRange;

public class CopyResourceElementsOperation
extends MultiOperation {
    protected ArrayList fRenamedCompilationUnits = null;
    protected Map fDeltasPerProject = new HashMap(1);
    protected ArrayList fCreatedElements;

    public CopyResourceElementsOperation(IEGLElement[] resourcesToCopy, IEGLElement[] destContainers, boolean force) {
        super(resourcesToCopy, destContainers, force);
    }

    public CopyResourceElementsOperation(IEGLElement[] resourcesToCopy, IEGLElement destContainer, boolean force) {
        this(resourcesToCopy, new IEGLElement[]{destContainer}, force);
    }

    protected IResource[] collectResourcesOfInterest(IPackageFragment source) throws EGLModelException {
        IEGLElement[] children = source.getChildren();
        int childOfInterest = 6;
        if (source.getKind() == 2) {
            childOfInterest = 7;
        }
        ArrayList<IResource> correctKindChildren = new ArrayList<IResource>(children.length);
        int i = 0;
        while (i < children.length) {
            IEGLElement child = children[i];
            if (child.getElementType() == childOfInterest) {
                correctKindChildren.add(child.getResource());
            }
            ++i;
        }
        Object[] nonEGLResources = source.getNonEGLResources();
        int actualNonEGLResourceCount = 0;
        int i2 = 0;
        int max = nonEGLResources.length;
        while (i2 < max) {
            if (nonEGLResources[i2] instanceof IResource) {
                ++actualNonEGLResourceCount;
            }
            ++i2;
        }
        IResource[] actualNonEGLResources = new IResource[actualNonEGLResourceCount];
        int i3 = 0;
        int max2 = nonEGLResources.length;
        int index = 0;
        while (i3 < max2) {
            if (nonEGLResources[i3] instanceof IResource) {
                actualNonEGLResources[index++] = (IResource)nonEGLResources[i3];
            }
            ++i3;
        }
        if (actualNonEGLResourceCount != 0) {
            int correctKindChildrenSize = correctKindChildren.size();
            IResource[] result = new IResource[correctKindChildrenSize + actualNonEGLResourceCount];
            correctKindChildren.toArray(result);
            System.arraycopy(actualNonEGLResources, 0, result, correctKindChildrenSize, actualNonEGLResourceCount);
            return result;
        }
        IResource[] result = new IResource[correctKindChildren.size()];
        correctKindChildren.toArray(result);
        return result;
    }

    protected void createNeededPackageFragments(IContainer sourceFolder, IPackageFragmentRoot root, String newFragName, boolean moveFolder) throws EGLModelException {
        IContainer parentFolder = (IContainer)root.getResource();
        EGLElementDelta projectDelta = null;
        String[] names = Util.getTrimmedSimpleNames(newFragName);
        StringBuffer sideEffectPackageName = new StringBuffer();
        char[][] exclusionsPatterns = ((PackageFragmentRoot)root).fullExclusionPatternChars();
        int i = 0;
        while (i < names.length) {
            String subFolderName = names[i];
            sideEffectPackageName.append(subFolderName);
            IResource subFolder = parentFolder.findMember(subFolderName);
            if (subFolder == null) {
                if (!moveFolder || i != names.length - 1) {
                    this.createFolder(parentFolder, subFolderName, this.fForce);
                }
                parentFolder = parentFolder.getFolder((IPath)new Path(subFolderName));
                if ((sourceFolder = sourceFolder.getFolder((IPath)new Path(subFolderName))).isReadOnly()) {
                    parentFolder.setReadOnly(true);
                }
                IPackageFragment sideEffectPackage = root.getPackageFragment(sideEffectPackageName.toString());
                if (i < names.length - 1 && !Util.isExcluded((IResource)parentFolder, exclusionsPatterns)) {
                    if (projectDelta == null) {
                        projectDelta = this.getDeltaFor(root.getEGLProject());
                    }
                    projectDelta.added(sideEffectPackage);
                }
                this.fCreatedElements.add(sideEffectPackage);
            } else {
                parentFolder = (IContainer)subFolder;
            }
            sideEffectPackageName.append('.');
            ++i;
        }
    }

    private EGLElementDelta getDeltaFor(IEGLProject eglProject) {
        EGLElementDelta delta = (EGLElementDelta)this.fDeltasPerProject.get(eglProject);
        if (delta == null) {
            delta = new EGLElementDelta(eglProject);
            this.fDeltasPerProject.put(eglProject, delta);
        }
        return delta;
    }

    @Override
    protected String getMainTaskName() {
        return EGLModelResources.operationCopyResourceProgress;
    }

    protected void prepareDeltas(IEGLElement sourceElement, IEGLElement destinationElement, boolean isMove) {
        if (Util.isExcluded(sourceElement) || Util.isExcluded(destinationElement)) {
            return;
        }
        IEGLProject destProject = destinationElement.getEGLProject();
        if (isMove) {
            IEGLProject sourceProject = sourceElement.getEGLProject();
            this.getDeltaFor(sourceProject).movedFrom(sourceElement, destinationElement);
            this.getDeltaFor(destProject).movedTo(destinationElement, sourceElement);
        } else {
            this.getDeltaFor(destProject).added(destinationElement);
        }
    }

    private void processCompilationUnitResource(IEGLFile source, IPackageFragment dest) throws EGLModelException {
        String newCUName = this.getNewNameFor(source);
        String destName = newCUName != null ? newCUName : source.getElementName();
        String newContent = this.updatedContent(source, dest);
        IFile sourceResource = (IFile)(source.isWorkingCopy() ? source.getOriginalElement() : source).getResource();
        IContainer destFolder = (IContainer)dest.getResource();
        IFile destFile = destFolder.getFile((IPath)new Path(destName));
        if (!destFile.equals((Object)sourceResource)) {
            try {
                int flags;
                if (destFile.exists()) {
                    if (this.fForce) {
                        this.deleteResource((IResource)destFile, 2);
                    } else {
                        throw new EGLModelException(new EGLModelStatus(977, EGLModelResources.bind((String)EGLModelResources.statusNameCollision, (Object)destFile.getFullPath().toString())));
                    }
                }
                int n = flags = this.fForce ? 1 : 0;
                if (this.isMove()) {
                    sourceResource.move(destFile.getFullPath(), flags |= 2, this.getSubProgressMonitor(1));
                } else {
                    if (newContent != null) {
                        flags |= 2;
                    }
                    sourceResource.copy(destFile.getFullPath(), flags, this.getSubProgressMonitor(1));
                }
                this.setAttribute("hasModifiedResource", "true");
            }
            catch (EGLModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new EGLModelException(e);
            }
            try {
                if (newContent != null) {
                    String encoding = source.getEGLProject().getOption(EGLCore.CORE_ENCODING, true);
                    destFile.setContents((InputStream)new ByteArrayInputStream(encoding == null ? newContent.getBytes() : newContent.getBytes(encoding)), this.fForce ? 3 : 2, this.getSubProgressMonitor(1));
                }
            }
            catch (IOException e) {
                throw new EGLModelException(e, 985);
            }
            catch (CoreException e) {
                throw new EGLModelException(e);
            }
            IEGLFile destCU = dest.getEGLFile(destName);
            this.prepareDeltas(source, destCU, this.isMove());
            if (newCUName != null) {
                String oldName = source.getElementName();
                oldName = oldName.substring(0, oldName.length() - 5);
                String newName = newCUName;
                newName = newName.substring(0, newName.length() - 5);
                this.prepareDeltas(source.getPart(oldName), destCU.getPart(newName), this.isMove());
            }
        } else if (!this.fForce) {
            throw new EGLModelException(new EGLModelStatus(977, EGLModelResources.bind((String)EGLModelResources.statusNameCollision, (Object)destFile.getFullPath().toString())));
        }
    }

    protected void processDeltas() {
        Iterator deltas = this.fDeltasPerProject.values().iterator();
        while (deltas.hasNext()) {
            this.addDelta((IEGLElementDelta)deltas.next());
        }
    }

    @Override
    protected void processElement(IEGLElement element) throws EGLModelException {
        IEGLElement dest = this.getDestinationParent(element);
        switch (element.getElementType()) {
            case 6: {
                this.processCompilationUnitResource((IEGLFile)element, (IPackageFragment)dest);
                this.fCreatedElements.add(((IPackageFragment)dest).getEGLFile(element.getElementName()));
                break;
            }
            case 4: {
                this.processPackageFragmentResource((IPackageFragment)element, (IPackageFragmentRoot)dest, this.getNewNameFor(element));
                break;
            }
            default: {
                throw new EGLModelException(new EGLModelStatus(967, element));
            }
        }
    }

    @Override
    protected void processElements() throws EGLModelException {
        this.fCreatedElements = new ArrayList(this.fElementsToProcess.length);
        try {
            super.processElements();
        }
        finally {
            this.fResultElements = new IEGLElement[this.fCreatedElements.size()];
            this.fCreatedElements.toArray(this.fResultElements);
            this.processDeltas();
        }
    }

    private void processPackageFragmentResource(IPackageFragment source, IPackageFragmentRoot root, String newName) throws EGLModelException {
        try {
            String newFragName = newName == null ? source.getElementName() : newName;
            IPackageFragment newFrag = root.getPackageFragment(newFragName);
            IResource[] resources = this.collectResourcesOfInterest(source);
            boolean shouldMoveFolder = this.isMove() && !newFrag.getResource().exists();
            IFolder srcFolder = (IFolder)source.getResource();
            IPath destPath = newFrag.getPath();
            if (shouldMoveFolder) {
                if (srcFolder.getFullPath().isPrefixOf(destPath)) {
                    shouldMoveFolder = false;
                } else {
                    IResource[] members = srcFolder.members();
                    int i = 0;
                    while (i < members.length) {
                        if (members[i] instanceof IFolder) {
                            shouldMoveFolder = false;
                            break;
                        }
                        ++i;
                    }
                }
            }
            this.createNeededPackageFragments((IContainer)source.getParent().getResource(), root, newFragName, shouldMoveFolder);
            if (shouldMoveFolder) {
                srcFolder.move(destPath, this.fForce, true, this.getSubProgressMonitor(1));
                this.setAttribute("hasModifiedResource", "true");
            } else if (resources.length > 0) {
                IResource destinationResource;
                int max;
                if (this.isRename()) {
                    if (!destPath.equals((Object)source.getPath())) {
                        this.moveResources(resources, destPath);
                    }
                } else if (this.isMove()) {
                    int i = 0;
                    max = resources.length;
                    while (i < max) {
                        destinationResource = ResourcesPlugin.getWorkspace().getRoot().findMember(destPath.append(resources[i].getName()));
                        if (destinationResource != null) {
                            if (this.fForce) {
                                this.deleteResource(destinationResource, 2);
                            } else {
                                throw new EGLModelException(new EGLModelStatus(977, EGLModelResources.bind((String)EGLModelResources.statusNameCollision, (Object)destinationResource.getFullPath().toString())));
                            }
                        }
                        ++i;
                    }
                    this.moveResources(resources, destPath);
                } else {
                    int i = 0;
                    max = resources.length;
                    while (i < max) {
                        destinationResource = ResourcesPlugin.getWorkspace().getRoot().findMember(destPath.append(resources[i].getName()));
                        if (destinationResource != null) {
                            if (this.fForce) {
                                this.deleteResource(destinationResource, 2);
                            } else {
                                throw new EGLModelException(new EGLModelStatus(977, EGLModelResources.bind((String)EGLModelResources.statusNameCollision, (Object)destinationResource.getFullPath().toString())));
                            }
                        }
                        ++i;
                    }
                    this.copyResources(resources, destPath);
                }
            }
            boolean isEmpty = true;
            if (this.isMove()) {
                if (srcFolder.exists()) {
                    IResource[] remaingFiles = srcFolder.members();
                    int i = 0;
                    int length = remaingFiles.length;
                    while (i < length) {
                        IResource file = remaingFiles[i];
                        if (file instanceof IFile) {
                            this.deleteResource(file, 3);
                        } else {
                            isEmpty = false;
                        }
                        ++i;
                    }
                }
                if (isEmpty) {
                    IResource rootResource = destPath.isPrefixOf(srcFolder.getFullPath()) ? newFrag.getResource() : source.getParent().getResource();
                    this.deleteEmptyPackageFragment(source, false, rootResource);
                }
            }
            this.prepareDeltas(source, newFrag, this.isMove() && isEmpty);
        }
        catch (EGLModelException e) {
            throw e;
        }
        catch (CoreException ce) {
            throw new EGLModelException(ce);
        }
    }

    private String updatedContent(IEGLFile cu, IPackageFragment dest) throws EGLModelException {
        String destPackageName;
        String currPackageName = cu.getParent().getElementName();
        if (currPackageName.equals(destPackageName = dest.getElementName())) {
            return null;
        }
        IBuffer buffer = cu.getBuffer();
        if (buffer == null) {
            return null;
        }
        char[] contents = buffer.getCharacters();
        if (contents == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(buffer.getContents());
        this.updatePackageStatement(cu, sb, destPackageName);
        return sb.toString();
    }

    private void updatePackageStatement(IEGLFile cu, StringBuffer buffer, String pkgName) throws EGLModelException {
        boolean defaultPackage = pkgName.equals("");
        boolean seenPackageNode = false;
        int i = 0;
        IPackageDeclaration[] packageDeclarations = cu.getPackageDeclarations();
        if (i < packageDeclarations.length) {
            IPackageDeclaration packageDeclaration = packageDeclarations[i];
            ISourceRange sourceRange = packageDeclaration.getSourceRange();
            if (!defaultPackage) {
                buffer.replace(sourceRange.getOffset(), sourceRange.getOffset() + sourceRange.getLength(), "package " + pkgName + ";");
            } else {
                buffer.replace(sourceRange.getOffset(), sourceRange.getOffset() + sourceRange.getLength(), "");
            }
            seenPackageNode = true;
        }
        if (!seenPackageNode && !defaultPackage) {
            buffer.replace(0, 0, "package " + pkgName + ";" + System.getProperty("line.separator"));
        }
    }

    @Override
    protected IEGLModelStatus verify() {
        IEGLModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        if (this.fRenamingsList != null && this.fRenamingsList.length != this.fElementsToProcess.length) {
            return new EGLModelStatus(980);
        }
        return EGLModelStatus.VERIFIED_OK;
    }

    @Override
    protected void verify(IEGLElement element) throws EGLModelException {
        int elementType;
        IResource resource;
        if (element == null || !element.exists()) {
            this.error(969, element);
        }
        if (element.isReadOnly() && (this.isRename() || this.isMove())) {
            this.error(976, element);
        }
        if ((resource = element.getResource()) instanceof IFolder && resource.isLinked()) {
            this.error(995, element);
        }
        if ((elementType = element.getElementType()) == 6) {
            if (this.isMove() && ((IEGLFile)element).isWorkingCopy()) {
                this.error(967, element);
            }
        } else if (elementType != 4) {
            this.error(967, element);
        }
        EGLElement dest = (EGLElement)this.getDestinationParent(element);
        this.verifyDestination(element, dest);
        if (this.fRenamings != null) {
            this.verifyRenaming(element);
        }
    }
}

