/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.ide.core.internal.model.EGLElementDelta;
import org.eclipse.edt.ide.core.internal.model.EGLModelOperation;
import org.eclipse.edt.ide.core.internal.model.EGLModelResources;
import org.eclipse.edt.ide.core.internal.model.EGLModelStatus;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.model.EGLConventions;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IBuffer;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLModelStatus;
import org.eclipse.edt.ide.core.model.IPackageFragment;

public class CreateEGLFileOperation
extends EGLModelOperation {
    protected String fName;
    protected String fSource = null;

    public CreateEGLFileOperation(IPackageFragment parentElement, String name, String source, boolean force) {
        super(null, new IEGLElement[]{parentElement}, force);
        this.fName = name;
        this.fSource = source;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void executeOperation() throws EGLModelException {
        try {
            this.beginTask(EGLModelResources.operationCreateEGLFileProgress, 2);
            EGLElementDelta delta = this.newEGLElementDelta();
            IEGLFile unit = this.getEGLFile();
            IPackageFragment pkg = (IPackageFragment)this.getParentElement();
            IContainer folder = (IContainer)pkg.getResource();
            this.worked(1);
            IFile compilationUnitFile = folder.getFile((IPath)new Path(this.fName));
            if (compilationUnitFile.exists()) {
                if (!this.fForce) throw new EGLModelException(new EGLModelStatus(977, EGLModelResources.bind((String)EGLModelResources.statusNameCollision, (Object)compilationUnitFile.getFullPath().toString())));
                IBuffer buffer = unit.getBuffer();
                if (buffer == null) {
                    return;
                }
                buffer.setContents(this.fSource);
                unit.save((IProgressMonitor)new NullProgressMonitor(), false);
                this.fResultElements = new IEGLElement[]{unit};
                if (!Util.isExcluded(unit) && unit.getParent().exists()) {
                    int i = 0;
                    while (i < this.fResultElements.length) {
                        delta.changed(this.fResultElements[i], 1);
                        ++i;
                    }
                    this.addDelta(delta);
                }
            } else {
                try {
                    String encoding = unit.getEGLProject().getOption(EGLCore.CORE_ENCODING, true);
                    ByteArrayInputStream stream = new ByteArrayInputStream(encoding == null ? this.fSource.getBytes() : this.fSource.getBytes(encoding));
                    this.createFile(folder, unit.getElementName(), stream, false);
                    this.fResultElements = new IEGLElement[]{unit};
                    if (!Util.isExcluded(unit) && unit.getParent().exists()) {
                        int i = 0;
                        while (i < this.fResultElements.length) {
                            delta.added(this.fResultElements[i]);
                            ++i;
                        }
                        this.addDelta(delta);
                    }
                }
                catch (IOException e) {
                    throw new EGLModelException(e, 985);
                }
            }
            this.worked(1);
            return;
        }
        finally {
            this.done();
        }
    }

    protected IEGLFile getEGLFile() {
        return ((IPackageFragment)this.getParentElement()).getEGLFile(this.fName);
    }

    @Override
    public IEGLModelStatus verify() {
        if (this.getParentElement() == null) {
            return new EGLModelStatus(968);
        }
        if (EGLConventions.validateEGLFileName(this.fName).getSeverity() == 4) {
            return new EGLModelStatus(983, this.fName);
        }
        if (this.fSource == null) {
            return new EGLModelStatus(984);
        }
        return EGLModelStatus.VERIFIED_OK;
    }

    @Override
    protected ISchedulingRule getSchedulingRule() {
        IResource resource = this.getEGLFile().getResource();
        IWorkspace workspace = resource.getWorkspace();
        if (resource.exists()) {
            return workspace.getRuleFactory().modifyRule(resource);
        }
        return workspace.getRuleFactory().createRule(resource);
    }
}

