/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.model.EGLElement;
import org.eclipse.edt.ide.core.internal.model.EGLElementDelta;
import org.eclipse.edt.ide.core.internal.model.EGLElementInfo;
import org.eclipse.edt.ide.core.internal.model.EGLModel;
import org.eclipse.edt.ide.core.internal.model.EGLModelInfo;
import org.eclipse.edt.ide.core.internal.model.EGLModelManager;
import org.eclipse.edt.ide.core.internal.model.EGLModelResources;
import org.eclipse.edt.ide.core.internal.model.EGLModelStatus;
import org.eclipse.edt.ide.core.internal.model.EGLPathEntry;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.internal.model.EGLProjectElementInfo;
import org.eclipse.edt.ide.core.internal.model.EglarPackageFragmentRoot;
import org.eclipse.edt.ide.core.internal.model.IProjectsChangedListener;
import org.eclipse.edt.ide.core.internal.model.Openable;
import org.eclipse.edt.ide.core.internal.model.PackageFragmentInfo;
import org.eclipse.edt.ide.core.internal.model.PackageFragmentRoot;
import org.eclipse.edt.ide.core.internal.model.PackageFragmentRootInfo;
import org.eclipse.edt.ide.core.internal.model.SetEGLPathOperation;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.internal.model.indexing.IndexManager;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLElementDelta;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;

public class DeltaProcessor
implements IResourceChangeListener {
    static final int IGNORE = 0;
    static final int SOURCE = 1;
    static final int BINARY = 2;
    static final int NON_EGL_RESOURCE = -1;
    protected EGLElementDelta currentDelta;
    private List projectChangedListeners = new ArrayList();
    protected IndexManager indexManager = new IndexManager();
    public Map roots;
    Map otherRoots;
    public boolean rootsAreStale = true;
    public Map oldRoots;
    Map oldOtherRoots;
    Map sourceAttachments;
    Openable currentElement;
    public HashMap externalTimeStamps = new HashMap();
    public HashSet projectsToUpdate = new HashSet();
    public HashSet changedProjects = new HashSet();
    public HashSet projectsForDependentNamelookupRefresh = new HashSet();
    EGLModelManager manager;
    public Map removedRoots;
    private HashSet eglProjectNamesCache;
    HashSet refreshedElements;
    public static boolean VERBOSE = false;
    public static final int DEFAULT_CHANGE_EVENT = 0;
    private static final String EXTERNAL_JAR_ADDED = "external jar added";
    private static final String EXTERNAL_JAR_CHANGED = "external jar changed";
    private static final String EXTERNAL_JAR_REMOVED = "external jar removed";
    private static final String EXTERNAL_JAR_UNCHANGED = "external jar unchanged";
    private static final String INTERNAL_JAR_IGNORE = "internal jar ignore";
    public int[] elementChangedListenerMasks = new int[5];
    public int elementChangedListenerCount = 0;

    DeltaProcessor(EGLModelManager manager) {
        this.manager = manager;
    }

    void addDependentProjects(IPath projectPath, HashSet result) {
        try {
            IEGLProject[] projects = this.manager.getEGLModel().getEGLProjects();
            int i = 0;
            int length = projects.length;
            while (i < length) {
                IEGLProject project = projects[i];
                IEGLPathEntry[] eglpath = ((EGLProject)project).getExpandedEGLPath(true);
                int j = 0;
                int length2 = eglpath.length;
                while (j < length2) {
                    IEGLPathEntry entry = eglpath[j];
                    if (entry.getEntryKind() == 2 && entry.getPath().equals((Object)projectPath)) {
                        result.add(project);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (EGLModelException eGLModelException) {}
    }

    public void addForRefresh(IEGLElement element) {
        if (this.refreshedElements == null) {
            this.refreshedElements = new HashSet();
        }
        this.refreshedElements.add(element);
    }

    public synchronized HashSet removeExternalElementsToRefresh() {
        HashSet result = this.refreshedElements;
        this.refreshedElements = null;
        return result;
    }

    void addToProjectsToUpdateWithDependents(IProject project) {
        this.projectsToUpdate.add(EGLCore.create(project));
        this.addDependentProjects(project.getFullPath(), this.projectsToUpdate);
    }

    protected void addToParentInfo(Openable child) {
        Openable parent = (Openable)child.getParent();
        if (parent != null && parent.isOpen()) {
            try {
                EGLElementInfo info = (EGLElementInfo)parent.getElementInfo();
                info.addChild(child);
            }
            catch (EGLModelException eGLModelException) {}
        }
    }

    public boolean createExternalArchiveDelta(HashSet refreshedElements, IProgressMonitor monitor) {
        HashMap<IPath, String> externalArchivesStatus = new HashMap<IPath, String>();
        boolean hasDelta = false;
        HashSet<IPath> archivePathsToRefresh = new HashSet<IPath>();
        block11: for (IEGLElement element : refreshedElements) {
            switch (element.getElementType()) {
                case 3: {
                    archivePathsToRefresh.add(element.getPath());
                    break;
                }
                case 2: {
                    IEGLPathEntry[] classpath;
                    EGLProject eglProject = (EGLProject)element;
                    if (!EGLProject.hasEGLNature(eglProject.getProject())) continue block11;
                    try {
                        classpath = eglProject.getResolvedEGLPath(true);
                        int j = 0;
                        int cpLength = classpath.length;
                        while (j < cpLength) {
                            if (classpath[j].getEntryKind() == 1) {
                                archivePathsToRefresh.add(classpath[j].getPath());
                            }
                            ++j;
                        }
                    }
                    catch (EGLModelException eGLModelException) {}
                    continue block11;
                }
                case 1: {
                    IEGLPathEntry[] classpath;
                    EGLProject eglProject;
                    for (String projectName : this.getOldJavaProjecNames()) {
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                        if (!EGLProject.hasEGLNature(project)) continue;
                        eglProject = (EGLProject)EGLCore.create(project);
                        try {
                            classpath = eglProject.getResolvedEGLPath(true);
                            int k = 0;
                            int cpLength = classpath.length;
                            while (k < cpLength) {
                                if (classpath[k].getEntryKind() == 1) {
                                    archivePathsToRefresh.add(classpath[k].getPath());
                                }
                                ++k;
                            }
                        }
                        catch (EGLModelException eGLModelException) {}
                    }
                    continue block11;
                }
            }
        }
        Iterator projectNames = this.getOldJavaProjecNames().iterator();
        IWorkspaceRoot wksRoot = ResourcesPlugin.getWorkspace().getRoot();
        while (projectNames.hasNext()) {
            IEGLPathEntry[] entries;
            if (monitor != null && monitor.isCanceled()) break;
            String projectName = (String)projectNames.next();
            IProject project = wksRoot.getProject(projectName);
            if (!EGLProject.hasEGLNature(project)) continue;
            EGLProject javaProject = (EGLProject)EGLCore.create(project);
            try {
                entries = javaProject.getResolvedEGLPath(true);
            }
            catch (EGLModelException eGLModelException) {
                continue;
            }
            int j = 0;
            while (j < entries.length) {
                IPath entryPath;
                if (entries[j].getEntryKind() == 1 && archivePathsToRefresh.contains(entryPath = entries[j].getPath())) {
                    Object root;
                    String status = (String)externalArchivesStatus.get(entryPath);
                    if (status == null) {
                        root = ResourcesPlugin.getWorkspace().getRoot();
                        Object targetLibrary = EGLModel.getTarget((IContainer)root, entryPath, true);
                        if (targetLibrary == null) {
                            if (this.getExternalLibTimeStamps().remove(entryPath) != null && this.roots.get(entryPath) != null) {
                                externalArchivesStatus.put(entryPath, EXTERNAL_JAR_REMOVED);
                                this.manager.getIndexManager().removeIndex(entryPath);
                            }
                        } else if (targetLibrary instanceof File) {
                            File externalFile = (File)targetLibrary;
                            Long oldTimestamp = (Long)this.getExternalLibTimeStamps().get(entryPath);
                            long newTimeStamp = DeltaProcessor.getTimeStamp(externalFile);
                            if (oldTimestamp != null) {
                                if (newTimeStamp == 0L) {
                                    externalArchivesStatus.put(entryPath, EXTERNAL_JAR_REMOVED);
                                    this.getExternalLibTimeStamps().remove(entryPath);
                                    this.manager.getIndexManager().removeIndex(entryPath);
                                } else if (oldTimestamp != newTimeStamp) {
                                    externalArchivesStatus.put(entryPath, EXTERNAL_JAR_CHANGED);
                                    this.getExternalLibTimeStamps().put(entryPath, new Long(newTimeStamp));
                                    this.manager.getIndexManager().removeIndex(entryPath);
                                    this.manager.getIndexManager().indexLibrary(entryPath, project.getProject());
                                } else {
                                    externalArchivesStatus.put(entryPath, EXTERNAL_JAR_UNCHANGED);
                                }
                            } else if (newTimeStamp == 0L) {
                                externalArchivesStatus.put(entryPath, EXTERNAL_JAR_UNCHANGED);
                            } else {
                                externalArchivesStatus.put(entryPath, EXTERNAL_JAR_ADDED);
                                this.getExternalLibTimeStamps().put(entryPath, new Long(newTimeStamp));
                                this.manager.getIndexManager().indexLibrary(entryPath, project.getProject());
                            }
                        } else {
                            externalArchivesStatus.put(entryPath, INTERNAL_JAR_IGNORE);
                        }
                    }
                    if ((status = (String)externalArchivesStatus.get(entryPath)) != null) {
                        if (status == EXTERNAL_JAR_ADDED) {
                            root = (PackageFragmentRoot)javaProject.getPackageFragmentRoot(entryPath.toString());
                            if (VERBOSE) {
                                System.out.println("- External JAR ADDED, affecting root: " + ((EGLElement)root).getElementName());
                            }
                            this.elementAdded((Openable)root, null, null);
                            hasDelta = true;
                        } else if (status == EXTERNAL_JAR_CHANGED) {
                            root = (PackageFragmentRoot)javaProject.getPackageFragmentRoot(entryPath.toString());
                            if (VERBOSE) {
                                System.out.println("- External JAR CHANGED, affecting root: " + ((EGLElement)root).getElementName());
                            }
                            this.contentChanged((Openable)root);
                            hasDelta = true;
                        } else if (status == EXTERNAL_JAR_REMOVED) {
                            root = (PackageFragmentRoot)javaProject.getPackageFragmentRoot(entryPath.toString());
                            if (VERBOSE) {
                                System.out.println("- External JAR REMOVED, affecting root: " + ((EGLElement)root).getElementName());
                            }
                            this.elementRemoved((Openable)root, null, null);
                            hasDelta = true;
                        }
                    }
                }
                ++j;
            }
        }
        EGLModel.flushExternalFileCache();
        if (hasDelta) {
            EGLModelManager.getEGLModelManager().resetJarTypeCache();
        }
        return hasDelta;
    }

    public void checkExternalArchiveChanges(IEGLElement[] elementsScope, IProgressMonitor monitor) throws EGLModelException {
        block11: {
            if (monitor != null && monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            try {
                boolean hasDelta;
                if (monitor != null) {
                    monitor.beginTask("", 1);
                }
                int i = 0;
                int length = elementsScope.length;
                while (i < length) {
                    IEGLElement cfr_ignored_0 = elementsScope[i];
                    this.addForRefresh(elementsScope[i]);
                    ++i;
                }
                HashSet elementsToRefresh = this.removeExternalElementsToRefresh();
                boolean bl = hasDelta = elementsToRefresh != null && this.createExternalArchiveDelta(elementsToRefresh, monitor);
                if (!hasDelta) break block11;
                IEGLElementDelta[] projectDeltas = this.currentDelta.getAffectedChildren();
                final int length2 = projectDeltas.length;
                final IProject[] projectsToTouch = new IProject[length2];
                int i2 = 0;
                while (i2 < length2) {
                    IEGLElementDelta delta = projectDeltas[i2];
                    EGLProject javaProject = (EGLProject)delta.getElement();
                    projectsToTouch[i2] = javaProject.getProject();
                    ++i2;
                }
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor progressMonitor) throws CoreException {
                        int i = 0;
                        while (i < length2) {
                            IProject project = projectsToTouch[i];
                            project.touch(progressMonitor);
                            ++i;
                        }
                    }
                };
                try {
                    ResourcesPlugin.getWorkspace().run(runnable, monitor);
                }
                catch (CoreException e) {
                    throw new EGLModelException(e);
                }
                if (this.currentDelta != null) {
                    EGLModelManager.getEGLModelManager().fire(this.currentDelta, 0);
                }
            }
            finally {
                this.currentDelta = null;
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
    }

    private void contentChanged(Openable element) {
        this.currentDelta().changed(element, 1);
    }

    public synchronized HashSet getOldJavaProjecNames() {
        if (this.eglProjectNamesCache == null) {
            IEGLProject[] projects;
            HashSet<String> result = new HashSet<String>();
            try {
                projects = EGLModelManager.getEGLModelManager().getEGLModel().getEGLProjects();
            }
            catch (EGLModelException eGLModelException) {
                return this.eglProjectNamesCache;
            }
            int i = 0;
            int length = projects.length;
            while (i < length) {
                IEGLProject project = projects[i];
                result.add(project.getElementName());
                ++i;
            }
            this.eglProjectNamesCache = result;
            return this.eglProjectNamesCache;
        }
        return this.eglProjectNamesCache;
    }

    public HashMap getExternalLibTimeStamps() {
        if (this.externalTimeStamps == null) {
            HashMap<IPath, Long> timeStamps;
            block17: {
                timeStamps = new HashMap<IPath, Long>();
                File timestampsFile = this.getTimeStampsFile();
                FilterInputStream in = null;
                try {
                    try {
                        in = new DataInputStream(new BufferedInputStream(new FileInputStream(timestampsFile)));
                        int size = ((DataInputStream)in).readInt();
                        while (size-- > 0) {
                            String key = ((DataInputStream)in).readUTF();
                            long timestamp = ((DataInputStream)in).readLong();
                            timeStamps.put(Path.fromPortableString((String)key), new Long(timestamp));
                        }
                    }
                    catch (IOException e) {
                        if (timestampsFile.exists()) {
                            Util.log(e, "Unable to read external time stamps");
                        }
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.externalTimeStamps = timeStamps;
        }
        return this.externalTimeStamps;
    }

    private File getTimeStampsFile() {
        return EDTCoreIDEPlugin.getPlugin().getStateLocation().append("externalLibsTimeStamps").toFile();
    }

    EGLElementDelta currentDelta() {
        if (this.currentDelta == null) {
            this.currentDelta = new EGLElementDelta(this.manager.getEGLModel());
        }
        return this.currentDelta;
    }

    public void checkProjectsBeingAddedOrRemoved(IResourceDelta delta) {
        IResource resource = delta.getResource();
        boolean processChildren = false;
        switch (resource.getType()) {
            case 8: {
                if (this.manager.eglProjectsCache == null) {
                    try {
                        this.manager.eglProjectsCache = this.manager.getEGLModel().getEGLProjects();
                    }
                    catch (EGLModelException eGLModelException) {}
                }
                processChildren = true;
                break;
            }
            case 4: {
                IProject project = (IProject)resource;
                EGLProject eglProject = (EGLProject)EGLCore.create(project);
                int deltaKind = delta.getKind();
                if (deltaKind == 1) {
                    this.addToProjectsToUpdateWithDependents(project);
                    this.changedProjects.add(project);
                    if (EGLProject.hasEGLNature(project)) {
                        this.addToParentInfo(eglProject);
                    }
                    this.rootsAreStale = true;
                    break;
                }
                if (deltaKind == 4) {
                    if ((delta.getFlags() & 0x4000) != 0) {
                        this.addToProjectsToUpdateWithDependents(project);
                        this.changedProjects.add(project);
                        if (project.isOpen()) {
                            if (EGLProject.hasEGLNature(project)) {
                                this.addToParentInfo(eglProject);
                            }
                        } else {
                            try {
                                eglProject.close();
                            }
                            catch (EGLModelException eGLModelException) {}
                            this.removeFromParentInfo(eglProject);
                            this.manager.removePerProjectInfo(eglProject);
                        }
                        this.rootsAreStale = true;
                        break;
                    }
                    if ((delta.getFlags() & 0x80000) != 0) {
                        boolean isEGLProject;
                        boolean wasEGLProject = this.manager.getEGLModel().findEGLProject(project) != null;
                        if (wasEGLProject != (isEGLProject = EGLProject.hasEGLNature(project))) {
                            this.addToProjectsToUpdateWithDependents(project);
                            this.changedProjects.add(project);
                            if (isEGLProject) {
                                this.addToParentInfo(eglProject);
                            } else {
                                this.manager.removePerProjectInfo(eglProject);
                                try {
                                    eglProject.close();
                                }
                                catch (EGLModelException eGLModelException) {}
                                this.removeFromParentInfo(eglProject);
                            }
                            this.rootsAreStale = true;
                            break;
                        }
                        if (!EGLProject.hasEGLNature(project)) break;
                        this.addToParentInfo(eglProject);
                        processChildren = true;
                        break;
                    }
                    if (EGLProject.hasEGLNature(project)) {
                        this.addToParentInfo(eglProject);
                        processChildren = true;
                    }
                    this.rootsAreStale = true;
                    break;
                }
                if (deltaKind != 2) break;
                this.manager.removePerProjectInfo(eglProject);
                this.changedProjects.add(project);
                this.rootsAreStale = true;
                break;
            }
            case 1: {
                IFile file = (IFile)resource;
                if (!file.getName().equals(".eglPath")) break;
                this.reconcileEGLPathFileUpdate(delta, file, (EGLProject)EGLCore.create(file.getProject()));
                this.rootsAreStale = true;
            }
        }
        if (processChildren) {
            IResourceDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                this.checkProjectsBeingAddedOrRemoved(children[i]);
                ++i;
            }
        }
    }

    private void checkEGLPathChange(IResourceDelta delta, IResource res) {
        if (res.getName().equals(".eglPath")) {
            this.changedProjects.add(res.getProject());
        }
    }

    private void checkSourceAttachmentChange(IResourceDelta delta, IResource res) {
        RootInfo rootInfo;
        IPath rootPath = (IPath)this.sourceAttachments.get(res.getFullPath());
        if (rootPath != null && (rootInfo = this.rootInfo(rootPath, delta.getKind())) != null) {
            IEGLProject projectOfRoot = rootInfo.project;
            IPackageFragmentRoot root = null;
            try {
                root = projectOfRoot.findPackageFragmentRoot(rootPath);
                if (root != null) {
                    root.close();
                }
            }
            catch (EGLModelException eGLModelException) {}
            if (root == null) {
                return;
            }
            switch (delta.getKind()) {
                case 1: {
                    this.currentDelta().sourceAttached(root);
                    break;
                }
                case 4: {
                    this.currentDelta().sourceDetached(root);
                    this.currentDelta().sourceAttached(root);
                    break;
                }
                case 2: {
                    this.currentDelta().sourceDetached(root);
                }
            }
        }
    }

    protected static void close(Openable element) {
        try {
            element.close();
        }
        catch (EGLModelException eGLModelException) {}
    }

    protected void contentChanged(Openable element, IResourceDelta delta) {
        DeltaProcessor.close(element);
        int flags = 1;
        this.currentDelta().changed(element, flags);
    }

    protected Openable createElement(IResource resource, int elementType, RootInfo rootInfo) {
        if (resource == null) {
            return null;
        }
        IPath path = resource.getFullPath();
        IEGLElement element = null;
        switch (elementType) {
            case 2: {
                if (!(resource instanceof IProject)) break;
                this.popUntilPrefixOf(path);
                if (this.currentElement != null && this.currentElement.getElementType() == 2 && ((IEGLProject)((Object)this.currentElement)).getProject().equals((Object)resource)) {
                    return this.currentElement;
                }
                if (rootInfo != null && rootInfo.project.getProject().equals((Object)resource)) {
                    element = (Openable)((Object)rootInfo.project);
                    break;
                }
                IProject proj = (IProject)resource;
                if (EGLProject.hasEGLNature(proj)) {
                    element = EGLCore.create(proj);
                    break;
                }
                element = (Openable)((Object)this.manager.getEGLModel().findEGLProject(proj));
                break;
            }
            case 3: {
                element = rootInfo == null ? EGLCore.create(resource) : rootInfo.project.getPackageFragmentRoot(resource);
                break;
            }
            case 4: {
                this.popUntilPrefixOf(path);
                if (this.currentElement == null) {
                    element = rootInfo == null ? EGLCore.create(resource) : EGLModelManager.create(resource, rootInfo.project);
                    break;
                }
                PackageFragmentRoot root = this.currentElement.getPackageFragmentRoot();
                if (root == null) {
                    element = rootInfo == null ? EGLCore.create(resource) : EGLModelManager.create(resource, rootInfo.project);
                    break;
                }
                if (!((EGLProject)root.getEGLProject()).contains(resource)) break;
                IPath pkgPath = path.removeFirstSegments(root.getPath().segmentCount());
                String pkg = Util.packageName(pkgPath);
                if (pkg == null) {
                    return null;
                }
                element = root.getPackageFragment(pkg);
                break;
            }
            case 6: 
            case 7: {
                this.popUntilPrefixOf(path);
                if (this.currentElement == null) {
                    element = rootInfo == null ? EGLCore.create(resource) : EGLModelManager.create(resource, rootInfo.project);
                    break;
                }
                IPackageFragment pkgFragment = null;
                switch (this.currentElement.getElementType()) {
                    case 3: {
                        IPackageFragmentRoot root = (IPackageFragmentRoot)((Object)this.currentElement);
                        IPath rootPath = root.getPath();
                        IPath pkgPath = path.removeLastSegments(1);
                        String pkgName = Util.packageName(pkgPath.removeFirstSegments(rootPath.segmentCount()));
                        if (pkgName == null) break;
                        pkgFragment = root.getPackageFragment(pkgName);
                        break;
                    }
                    case 4: {
                        Openable pkg = this.currentElement;
                        if (!pkg.getPath().equals((Object)path.removeLastSegments(1))) break;
                        pkgFragment = (IPackageFragment)((Object)pkg);
                        break;
                    }
                    case 6: 
                    case 7: {
                        pkgFragment = (IPackageFragment)this.currentElement.getParent();
                    }
                }
                if (pkgFragment == null) {
                    element = rootInfo == null ? EGLCore.create(resource) : EGLModelManager.create(resource, rootInfo.project);
                    break;
                }
                if (elementType != 6) break;
                String fileName = path.lastSegment();
                element = pkgFragment.getEGLFile(fileName);
            }
        }
        if (element == null) {
            return null;
        }
        this.currentElement = (Openable)element;
        return this.currentElement;
    }

    public void deleting(IProject project) {
        try {
            this.indexManager.discardJobs(project.getName());
            EGLProject eglProject = (EGLProject)EGLCore.create(project);
            if (this.removedRoots == null) {
                this.removedRoots = new HashMap();
            }
            if (eglProject.isOpen()) {
                this.removedRoots.put(eglProject, eglProject.getPackageFragmentRoots());
            } else {
                this.removedRoots.put(eglProject, eglProject.computePackageFragmentRoots(eglProject.getResolvedEGLPath(true), false));
            }
            eglProject.close();
            if (this.manager.eglProjectsCache == null) {
                this.manager.eglProjectsCache = this.manager.getEGLModel().getEGLProjects();
            }
            this.removeFromParentInfo(eglProject);
        }
        catch (EGLModelException eGLModelException) {}
        this.addDependentProjects(project.getFullPath(), this.projectsToUpdate);
    }

    protected void elementAdded(Openable element, IResourceDelta delta, RootInfo rootInfo) {
        int elementType = element.getElementType();
        if (elementType == 2) {
            if (delta != null && EGLProject.hasEGLNature((IProject)delta.getResource())) {
                this.addToParentInfo(element);
                if ((delta.getFlags() & 0x1000) != 0) {
                    Openable movedFromElement = (Openable)((Object)element.getEGLModel().getEGLProject(delta.getMovedFromPath().lastSegment()));
                    this.currentDelta().movedTo(element, movedFromElement);
                } else {
                    this.currentDelta().added(element);
                }
                this.projectsToUpdate.add(element);
                this.updateRoots(element.getPath(), delta);
                this.projectsForDependentNamelookupRefresh.add((EGLProject)element);
            }
        } else {
            this.addToParentInfo(element);
            DeltaProcessor.close(element);
            if (delta != null && (delta.getFlags() & 0x1000) != 0) {
                Openable movedFromElement;
                IPath movedFromPath = delta.getMovedFromPath();
                IResource res = delta.getResource();
                Object movedFromRes = res instanceof IFile ? res.getWorkspace().getRoot().getFile(movedFromPath) : res.getWorkspace().getRoot().getFolder(movedFromPath);
                RootInfo movedFromInfo = this.enclosingRootInfo(movedFromPath, 2);
                int movedFromType = this.elementType((IResource)movedFromRes, 2, element.getParent().getElementType(), movedFromInfo);
                this.currentElement = null;
                Openable openable = movedFromElement = elementType != 2 && movedFromType == 2 ? null : this.createElement((IResource)movedFromRes, movedFromType, movedFromInfo);
                if (movedFromElement == null) {
                    this.currentDelta().added(element);
                } else {
                    this.currentDelta().movedTo(element, movedFromElement);
                }
            } else {
                this.currentDelta().added(element);
            }
            switch (elementType) {
                case 3: {
                    EGLProject project = (EGLProject)element.getEGLProject();
                    this.projectsToUpdate.add(project);
                    this.projectsForDependentNamelookupRefresh.add(project);
                    break;
                }
                case 4: {
                    EGLProject project = (EGLProject)element.getEGLProject();
                    try {
                        project.getEGLProjectElementInfo().setNameLookup(null);
                        this.projectsForDependentNamelookupRefresh.add(project);
                    }
                    catch (EGLModelException eGLModelException) {}
                    if (delta == null) break;
                    PackageFragmentRoot root = element.getPackageFragmentRoot();
                    String name = element.getElementName();
                    IResourceDelta[] children = delta.getAffectedChildren();
                    int i = 0;
                    int length = children.length;
                    while (i < length) {
                        String folderName;
                        IResourceDelta child = children[i];
                        IResource resource = child.getResource();
                        if (resource instanceof IFolder && Util.isValidFolderNameForPackage(folderName = resource.getName())) {
                            String subpkgName = name.length() == 0 ? folderName : String.valueOf(name) + "." + folderName;
                            Openable subpkg = (Openable)((Object)root.getPackageFragment(subpkgName));
                            this.updateIndex(subpkg, child);
                            this.elementAdded(subpkg, child, rootInfo);
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
    }

    protected void elementRemoved(Openable element, IResourceDelta delta, RootInfo rootInfo) {
        if (element.isOpen()) {
            DeltaProcessor.close(element);
        }
        this.removeFromParentInfo(element);
        int elementType = element.getElementType();
        if (delta != null && (delta.getFlags() & 0x2000) != 0) {
            Openable movedToElement;
            IFolder movedToRes;
            IPath movedToPath = delta.getMovedToPath();
            IResource res = delta.getResource();
            switch (res.getType()) {
                case 4: {
                    movedToRes = res.getWorkspace().getRoot().getProject(movedToPath.lastSegment());
                    break;
                }
                case 2: {
                    movedToRes = res.getWorkspace().getRoot().getFolder(movedToPath);
                    break;
                }
                case 1: {
                    movedToRes = res.getWorkspace().getRoot().getFile(movedToPath);
                    break;
                }
                default: {
                    return;
                }
            }
            RootInfo movedToInfo = this.enclosingRootInfo(movedToPath, 1);
            int movedToType = this.elementType((IResource)movedToRes, 1, element.getParent().getElementType(), movedToInfo);
            this.currentElement = null;
            Openable openable = movedToElement = elementType != 2 && movedToType == 2 ? null : this.createElement((IResource)movedToRes, movedToType, movedToInfo);
            if (movedToElement == null) {
                this.currentDelta().removed(element);
            } else {
                this.currentDelta().movedFrom(element, movedToElement);
            }
        } else {
            this.currentDelta().removed(element);
        }
        switch (elementType) {
            case 1: {
                this.indexManager.reset();
                break;
            }
            case 2: {
                this.manager.removePerProjectInfo((EGLProject)element);
                this.updateRoots(element.getPath(), delta);
                this.projectsForDependentNamelookupRefresh.add((EGLProject)element);
                break;
            }
            case 3: {
                EGLProject project = (EGLProject)element.getEGLProject();
                this.projectsToUpdate.add(project);
                this.projectsForDependentNamelookupRefresh.add(project);
                break;
            }
            case 4: {
                EGLProject project = (EGLProject)element.getEGLProject();
                try {
                    project.getEGLProjectElementInfo().setNameLookup(null);
                    this.projectsForDependentNamelookupRefresh.add(project);
                }
                catch (EGLModelException eGLModelException) {}
                if (delta == null) break;
                PackageFragmentRoot root = element.getPackageFragmentRoot();
                String name = element.getElementName();
                IResourceDelta[] children = delta.getAffectedChildren();
                int i = 0;
                int length = children.length;
                while (i < length) {
                    String folderName;
                    IResourceDelta child = children[i];
                    IResource resource = child.getResource();
                    if (resource instanceof IFolder && Util.isValidFolderNameForPackage(folderName = resource.getName())) {
                        String subpkgName = name.length() == 0 ? folderName : String.valueOf(name) + "." + folderName;
                        Openable subpkg = (Openable)((Object)root.getPackageFragment(subpkgName));
                        this.updateIndex(subpkg, child);
                        this.elementRemoved(subpkg, child, rootInfo);
                    }
                    ++i;
                }
                break;
            }
        }
    }

    private int elementType(IResource res, int kind, int parentType, RootInfo rootInfo) {
        switch (parentType) {
            case 1: {
                return 2;
            }
            case -1: 
            case 2: {
                if (rootInfo == null) {
                    rootInfo = this.enclosingRootInfo(res.getFullPath(), kind);
                }
                if (rootInfo != null && rootInfo.isRootOfProject(res.getFullPath())) {
                    return 3;
                }
                return -1;
            }
            case 3: 
            case 4: {
                if (rootInfo == null) {
                    rootInfo = this.enclosingRootInfo(res.getFullPath(), kind);
                }
                if (rootInfo == null || Util.isExcluded(res, rootInfo.exclusionPatterns)) {
                    return -1;
                }
                if (res instanceof IFolder) {
                    if (Util.isValidFolderNameForPackage(res.getName())) {
                        return 4;
                    }
                    return -1;
                }
                String fileName = res.getName();
                if (Util.isValidEGLFileName(fileName)) {
                    return 6;
                }
                if (Util.isValidClassFileName(fileName)) {
                    return 7;
                }
                if (this.rootInfo(res.getFullPath(), kind) != null) {
                    return 3;
                }
                return -1;
            }
        }
        return -1;
    }

    public static long getTimeStamp(File file) {
        return file.lastModified() + file.length();
    }

    public void initializeRoots() {
        IEGLProject[] projects;
        this.oldRoots = this.roots == null ? new HashMap() : this.roots;
        Map map = this.oldOtherRoots = this.otherRoots == null ? new HashMap() : this.otherRoots;
        if (!this.rootsAreStale) {
            return;
        }
        this.roots = new HashMap();
        this.otherRoots = new HashMap();
        this.sourceAttachments = new HashMap();
        EGLModel model = this.manager.getEGLModel();
        try {
            projects = model.getEGLProjects();
        }
        catch (EGLModelException eGLModelException) {
            return;
        }
        int i = 0;
        int length = projects.length;
        while (i < length) {
            block15: {
                IEGLPathEntry[] eglpath;
                IEGLProject project = projects[i];
                try {
                    eglpath = project.getResolvedEGLPath(true);
                }
                catch (EGLModelException eGLModelException) {
                    break block15;
                }
                int j = 0;
                int eglpathLength = eglpath.length;
                while (j < eglpathLength) {
                    block16: {
                        IEGLPathEntry entry = eglpath[j];
                        if (entry.getEntryKind() != 2) {
                            IPath path = entry.getPath();
                            if (this.roots.get(path) == null) {
                                this.roots.put(path, new RootInfo(project, path, ((EGLPathEntry)entry).fullExclusionPatternChars()));
                            } else {
                                ArrayList<RootInfo> rootList = (ArrayList<RootInfo>)this.otherRoots.get(path);
                                if (rootList == null) {
                                    rootList = new ArrayList<RootInfo>();
                                    this.otherRoots.put(path, rootList);
                                }
                                rootList.add(new RootInfo(project, path, ((EGLPathEntry)entry).fullExclusionPatternChars()));
                            }
                            if (entry.getEntryKind() == 1) {
                                int index;
                                QualifiedName qName = new QualifiedName(EGLCore.PLUGIN_ID, "sourceattachment: " + path.toOSString());
                                String propertyString = null;
                                try {
                                    propertyString = ResourcesPlugin.getWorkspace().getRoot().getPersistentProperty(qName);
                                }
                                catch (CoreException coreException) {
                                    break block16;
                                }
                                Object sourceAttachmentPath = propertyString != null ? ((index = propertyString.lastIndexOf(42)) < 0 ? new Path(propertyString) : new Path(propertyString.substring(0, index))) : entry.getSourceAttachmentPath();
                                if (sourceAttachmentPath != null) {
                                    this.sourceAttachments.put(sourceAttachmentPath, path);
                                }
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.rootsAreStale = false;
    }

    public boolean isAffectedBy(IResourceDelta rootDelta) {
        if (rootDelta != null) {
            class FoundRelevantDeltaException
            extends RuntimeException {
                FoundRelevantDeltaException() {
                }
            }
            try {
                rootDelta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        switch (delta.getKind()) {
                            case 1: 
                            case 2: {
                                throw new FoundRelevantDeltaException();
                            }
                            case 4: {
                                if (delta.getAffectedChildren().length != 0 || (delta.getFlags() & 0xFFFCFFFF) == 0) break;
                                throw new FoundRelevantDeltaException();
                            }
                        }
                        return true;
                    }
                });
            }
            catch (FoundRelevantDeltaException foundRelevantDeltaException) {
                return true;
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    private boolean isResFilteredFromOutput(OutputsInfo info, IResource res, int elementType) {
        if (info != null) {
            IPath resPath = res.getFullPath();
            int i = 0;
            while (i < info.outputCount) {
                if (info.paths[i].isPrefixOf(resPath)) {
                    if (info.traverseModes[i] != 0) {
                        if (info.traverseModes[i] == 1 && elementType == 7) {
                            return true;
                        }
                        if (elementType == 2 && res instanceof IFile && Util.isValidClassFileName(res.getName())) {
                            return true;
                        }
                    } else {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    protected void nonEGLResourcesChanged(Openable element, IResourceDelta delta) throws EGLModelException {
        EGLElementDelta elementDelta;
        if (element.isOpen()) {
            EGLElementInfo info = (EGLElementInfo)element.getElementInfo();
            switch (element.getElementType()) {
                case 1: {
                    ((EGLModelInfo)info).nonEGLResources = null;
                    this.currentDelta().addResourceDelta(delta);
                    return;
                }
                case 2: {
                    ((EGLProjectElementInfo)info).setNonEGLResources(null);
                    EGLProject project = (EGLProject)element;
                    PackageFragmentRoot projectRoot = (PackageFragmentRoot)project.getPackageFragmentRoot((IResource)project.getProject());
                    if (!projectRoot.isOpen()) break;
                    ((PackageFragmentRootInfo)projectRoot.getElementInfo()).setNonEGLResources(null);
                    break;
                }
                case 4: {
                    ((PackageFragmentInfo)info).setNonEGLResources(null);
                    break;
                }
                case 3: {
                    ((PackageFragmentRootInfo)info).setNonEGLResources(null);
                }
            }
        }
        if ((elementDelta = this.currentDelta().find(element)) == null) {
            this.currentDelta().changed(element, 1);
            elementDelta = this.currentDelta().find(element);
        }
        elementDelta.addResourceDelta(delta);
    }

    private OutputsInfo outputsInfo(RootInfo rootInfo, IResource res) {
        try {
            IEGLProject proj;
            IEGLProject iEGLProject = proj = rootInfo == null ? (IEGLProject)((Object)this.createElement((IResource)res.getProject(), 2, null)) : rootInfo.project;
            if (proj != null) {
                IPath projectOutput = proj.getOutputLocation();
                int traverseMode = 0;
                if (proj.getProject().getFullPath().equals((Object)projectOutput)) {
                    return new OutputsInfo(new IPath[]{projectOutput}, new int[]{1}, 1);
                }
                IEGLPathEntry[] eglpath = proj.getResolvedEGLPath(true);
                IPath[] outputs = new IPath[eglpath.length + 1];
                int[] traverseModes = new int[eglpath.length + 1];
                int outputCount = 1;
                outputs[0] = projectOutput;
                traverseModes[0] = traverseMode;
                int i = 0;
                int length = eglpath.length;
                while (i < length) {
                    IEGLPathEntry entry = eglpath[i];
                    IPath entryPath = entry.getPath();
                    IPath output = entry.getOutputLocation();
                    if (output != null) {
                        outputs[outputCount] = output;
                        if (entryPath.equals((Object)output)) {
                            traverseModes[outputCount++] = entry.getEntryKind() == 3 ? 1 : 2;
                        } else {
                            traverseModes[outputCount++] = 0;
                        }
                    }
                    if (entryPath.equals((Object)projectOutput)) {
                        traverseModes[0] = entry.getEntryKind() == 3 ? 1 : 2;
                    }
                    ++i;
                }
                return new OutputsInfo(outputs, traverseModes, outputCount);
            }
        }
        catch (EGLModelException eGLModelException) {}
        return null;
    }

    private void popUntilPrefixOf(IPath path) {
        while (this.currentElement != null) {
            IPath currentElementPath = null;
            if (this.currentElement instanceof IPackageFragmentRoot) {
                currentElementPath = ((IPackageFragmentRoot)((Object)this.currentElement)).getPath();
            } else {
                IResource currentElementResource = this.currentElement.getResource();
                if (currentElementResource != null) {
                    currentElementPath = currentElementResource.getFullPath();
                }
            }
            if (currentElementPath != null) {
                if (this.currentElement instanceof IPackageFragment && this.currentElement.getElementName().length() == 0 && currentElementPath.segmentCount() != path.segmentCount() - 1) {
                    this.currentElement = (Openable)this.currentElement.getParent();
                }
                if (currentElementPath.isPrefixOf(path)) {
                    return;
                }
            }
            this.currentElement = (Openable)this.currentElement.getParent();
        }
    }

    public IEGLElementDelta processResourceDelta(IResourceDelta changes) {
        try {
            EGLModel model = this.manager.getEGLModel();
            if (!model.isOpen()) {
                try {
                    model.open(null);
                }
                catch (EGLModelException e) {
                    if (VERBOSE) {
                        e.printStackTrace();
                    }
                    this.currentDelta = null;
                    this.projectsToUpdate.clear();
                    this.projectsForDependentNamelookupRefresh.clear();
                    return null;
                }
            }
            this.initializeRoots();
            this.currentElement = null;
            IResourceDelta[] deltas = changes.getAffectedChildren();
            int i = 0;
            while (i < deltas.length) {
                IResourceDelta delta = deltas[i];
                IResource res = delta.getResource();
                RootInfo rootInfo = null;
                IProject proj = (IProject)res;
                boolean wasEGLProject = this.manager.getEGLModel().findEGLProject(proj) != null;
                boolean isEGLProject = EGLProject.hasEGLNature(proj);
                int elementType = !wasEGLProject && !isEGLProject ? -1 : ((rootInfo = this.enclosingRootInfo(res.getFullPath(), delta.getKind())) != null && rootInfo.isRootOfProject(res.getFullPath()) ? 3 : 2);
                if (!this.traverseDelta(delta, elementType, rootInfo, null) || wasEGLProject != isEGLProject && delta.getKind() == 4) {
                    try {
                        this.nonEGLResourcesChanged(model, delta);
                    }
                    catch (EGLModelException eGLModelException) {}
                }
                ++i;
            }
            for (EGLProject project : this.projectsToUpdate) {
                project.updatePackageFragmentRoots();
            }
            this.updateDependentNamelookups();
            EGLElementDelta eGLElementDelta = this.currentDelta;
            return eGLElementDelta;
        }
        finally {
            this.currentDelta = null;
            this.projectsToUpdate.clear();
            this.projectsForDependentNamelookupRefresh.clear();
        }
    }

    /*
     * Unable to fully structure code
     */
    void reconcileEGLPathFileUpdate(IResourceDelta delta, IFile file, EGLProject project) {
        switch (delta.getKind()) {
            case 2: {
                try {
                    info = EGLModelManager.getEGLModelManager().getPerProjectInfoCheckExistence(project.getProject());
                    if (info.eglpath == null) break;
                    project.saveEGLPath(info.eglpath, info.outputLocation);
                }
                catch (EGLModelException e) {
                    if (!project.getProject().isAccessible()) break;
                    Util.log((Throwable)e, "Could not save eglpath for " + project.getPath());
                }
                break;
            }
            case 4: {
                if ((delta.getFlags() & 256) == 0 && (delta.getFlags() & 4096) == 0) break;
            }
            case 1: {
                project.flushEGLPathProblemMarkers(false, true);
                wasSuccessful = false;
                fileEntries = project.readEGLPathFile(true, false);
                if (fileEntries != null) ** GOTO lbl29
                if (wasSuccessful) break;
                try {
                    project.setRawEGLPath0(EGLProject.INVALID_EGLPATH);
                    project.updatePackageFragmentRoots();
                }
                catch (EGLModelException v0) {}
                break;
lbl29:
                // 2 sources

                info = EGLModelManager.getEGLModelManager().getPerProjectInfoCheckExistence(project.getProject());
                if (info.eglpath == null || !project.isEGLPathEqualsTo(info.eglpath, info.outputLocation, fileEntries)) ** GOTO lbl40
                wasSuccessful = true;
                if (wasSuccessful) break;
                try {
                    project.setRawEGLPath0(EGLProject.INVALID_EGLPATH);
                    project.updatePackageFragmentRoots();
                }
                catch (EGLModelException v1) {}
                break;
lbl40:
                // 2 sources

                try {
                    outputLocation = null;
                    if (fileEntries != null && fileEntries.length > 0 && (entry = fileEntries[fileEntries.length - 1]).getContentKind() == 10) {
                        outputLocation = entry.getPath();
                        copy = new IEGLPathEntry[fileEntries.length - 1];
                        System.arraycopy(fileEntries, 0, copy, 0, copy.length);
                        fileEntries = copy;
                    }
                    if (outputLocation == null) {
                        outputLocation = SetEGLPathOperation.ReuseOutputLocation;
                    }
                    project.setRawEGLPath(fileEntries, outputLocation, null, ResourcesPlugin.getWorkspace().isTreeLocked() == false, project.getResolvedEGLPath(true), true, false);
                    wasSuccessful = true;
                }
                catch (RuntimeException e) {
                    if (project.getProject().isAccessible()) {
                        Util.log(e, "Could not set eglpath for " + project.getPath());
                    }
                    if (wasSuccessful) break;
                    try {
                        project.setRawEGLPath0(EGLProject.INVALID_EGLPATH);
                        project.updatePackageFragmentRoots();
                    }
                    catch (EGLModelException v2) {}
                    break;
                }
                catch (EGLModelException e) {
                    try {
                        if (project.getProject().isAccessible()) {
                            if (e.getEGLModelStatus().getException() instanceof CoreException) {
                                project.createEGLPathProblemMarker(new EGLModelStatus(1000, EGLModelResources.bind((String)EGLModelResources.eglpathCouldNotWriteEGLpathFile, (Object)project.getElementName(), (Object)e.getMessage())));
                            } else {
                                project.createEGLPathProblemMarker(new EGLModelStatus(1000, EGLModelResources.bind((String)EGLModelResources.eglpathInvalidEGLpathInEGLpathFile, (Object)project.getElementName(), (Object)e.getMessage())));
                            }
                        }
                        if (wasSuccessful) break;
                    }
                    catch (Throwable var10_14) {
                        if (!wasSuccessful) {
                            try {
                                project.setRawEGLPath0(EGLProject.INVALID_EGLPATH);
                                project.updatePackageFragmentRoots();
                            }
                            catch (EGLModelException v3) {}
                        }
                        throw var10_14;
                    }
                    try {
                        project.setRawEGLPath0(EGLProject.INVALID_EGLPATH);
                        project.updatePackageFragmentRoots();
                    }
                    catch (EGLModelException v4) {}
                    break;
                }
                if (wasSuccessful) break;
                try {
                    project.setRawEGLPath0(EGLProject.INVALID_EGLPATH);
                    project.updatePackageFragmentRoots();
                    break;
                }
                catch (EGLModelException v5) {}
            }
        }
    }

    void reconcilePreferenceFileUpdate(IResourceDelta delta, IFile file, EGLProject project) {
    }

    protected void removeFromParentInfo(Openable child) {
        Openable parent = (Openable)child.getParent();
        if (parent != null && parent.isOpen()) {
            try {
                EGLElementInfo info = (EGLElementInfo)parent.getElementInfo();
                info.removeChild(child);
            }
            catch (EGLModelException eGLModelException) {}
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        block18: {
            if (!(event.getSource() instanceof IWorkspace)) break block18;
            IResource resource = event.getResource();
            IResourceDelta delta = event.getDelta();
            switch (event.getType()) {
                case 4: {
                    try {
                        if (resource.getType() == 4 && ((IProject)resource).hasNature("org.eclipse.edt.ide.core.eglnature")) {
                            this.deleting((IProject)resource);
                        }
                    }
                    catch (CoreException coreException) {}
                    return;
                }
                case 8: {
                    if (this.isAffectedBy(delta)) {
                        this.manager.setLastUpdateTime(System.currentTimeMillis());
                        this.updateEGLPathMarkers();
                    }
                    this.manager.fire(null, 2);
                    if (this.changedProjects.size() <= 0) break;
                    this.fireProjectsChanged(this.changedProjects.toArray(new IProject[this.changedProjects.size()]));
                    this.changedProjects.clear();
                    break;
                }
                case 16: {
                    break;
                }
                case 1: {
                    if (!this.isAffectedBy(delta)) break;
                    try {
                        try {
                            IEGLElementDelta translatedDelta;
                            this.manager.stopDeltas();
                            this.checkProjectsBeingAddedOrRemoved(delta);
                            if (this.refreshedElements != null) {
                                this.createExternalArchiveDelta(this.refreshedElements, null);
                            }
                            if ((translatedDelta = this.processResourceDelta(delta)) != null) {
                                this.manager.registerEGLModelDelta(translatedDelta);
                            }
                        }
                        finally {
                            this.manager.startDeltas();
                        }
                        this.manager.fire(null, 1);
                    }
                    finally {
                        this.manager.eglProjectsCache = null;
                        this.removedRoots = null;
                    }
                }
            }
        }
    }

    RootInfo enclosingRootInfo(IPath path, int kind) {
        while (path != null && path.segmentCount() > 0) {
            RootInfo rootInfo = this.rootInfo(path, kind);
            if (rootInfo != null) {
                return rootInfo;
            }
            path = path.removeLastSegments(1);
        }
        return null;
    }

    RootInfo rootInfo(IPath path, int kind) {
        if (kind == 2) {
            return (RootInfo)this.oldRoots.get(path);
        }
        return (RootInfo)this.roots.get(path);
    }

    ArrayList otherRootsInfo(IPath path, int kind) {
        if (kind == 2) {
            return (ArrayList)this.oldOtherRoots.get(path);
        }
        return (ArrayList)this.otherRoots.get(path);
    }

    protected boolean traverseDelta(IResourceDelta delta, int elementType, RootInfo rootInfo, OutputsInfo outputsInfo) {
        IResource res = delta.getResource();
        if (this.currentElement == null && rootInfo != null) {
            this.currentElement = (Openable)((Object)rootInfo.project);
        }
        boolean processChildren = true;
        processChildren = res instanceof IProject ? this.updateCurrentDeltaAndIndex(delta, elementType == 3 ? 2 : elementType, rootInfo) : (rootInfo != null ? this.updateCurrentDeltaAndIndex(delta, elementType, rootInfo) : true);
        if (outputsInfo == null) {
            outputsInfo = this.outputsInfo(rootInfo, res);
        }
        if (processChildren) {
            IProject rscProject;
            EGLProject adoptiveProject;
            IResourceDelta[] children = delta.getAffectedChildren();
            boolean oneChildOnEGLPath = false;
            int length = children.length;
            IResourceDelta[] orphanChildren = null;
            Openable parent = null;
            boolean isValidParent = true;
            int i = 0;
            while (i < length) {
                block24: {
                    ArrayList rootList;
                    boolean isNestedRoot;
                    RootInfo childRootInfo2;
                    int childKind;
                    IPath childPath;
                    IResourceDelta child;
                    block25: {
                        child = children[i];
                        IResource childRes = child.getResource();
                        this.checkSourceAttachmentChange(child, childRes);
                        this.checkEGLPathChange(child, childRes);
                        childPath = childRes.getFullPath();
                        childKind = child.getKind();
                        childRootInfo2 = this.rootInfo(childPath, childKind);
                        if (childRootInfo2 != null && !childRootInfo2.isRootOfProject(childPath)) {
                            childRootInfo2 = null;
                        }
                        int childType = this.elementType(childRes, childKind, elementType, rootInfo == null ? childRootInfo2 : rootInfo);
                        boolean isResFilteredFromOutput = this.isResFilteredFromOutput(outputsInfo, childRes, childType);
                        boolean bl = isNestedRoot = rootInfo != null && childRootInfo2 != null;
                        if (!isResFilteredFromOutput && !isNestedRoot) {
                            if (!this.traverseDelta(child, childType, rootInfo == null ? childRootInfo2 : rootInfo, outputsInfo)) {
                                try {
                                    if (rootInfo != null) {
                                        if (!isValidParent) break block24;
                                        if (parent == null) {
                                            if (this.currentElement == null || !this.currentElement.getEGLProject().equals(rootInfo.project)) {
                                                this.currentElement = (Openable)((Object)rootInfo.project);
                                            }
                                            if ((parent = elementType == 2 || elementType == 3 && res instanceof IProject ? (Openable)((Object)rootInfo.project) : this.createElement(res, elementType, rootInfo)) == null) {
                                                isValidParent = false;
                                                break block24;
                                            }
                                        }
                                        this.nonEGLResourcesChanged(parent, child);
                                        break block25;
                                    }
                                    if (orphanChildren == null) {
                                        orphanChildren = new IResourceDelta[length];
                                    }
                                    orphanChildren[i] = child;
                                }
                                catch (EGLModelException eGLModelException) {}
                            } else {
                                oneChildOnEGLPath = true;
                            }
                        } else {
                            oneChildOnEGLPath = true;
                        }
                    }
                    if (isNestedRoot || childRootInfo2 == null && (childRootInfo2 = this.rootInfo(childPath, childKind)) != null) {
                        this.traverseDelta(child, 3, childRootInfo2, null);
                    }
                    if ((rootList = this.otherRootsInfo(childPath, childKind)) != null) {
                        for (RootInfo childRootInfo2 : rootList) {
                            this.traverseDelta(child, 3, childRootInfo2, null);
                        }
                    }
                }
                ++i;
            }
            if (orphanChildren != null && (oneChildOnEGLPath || res instanceof IProject) && (adoptiveProject = (EGLProject)EGLCore.create(rscProject = res.getProject())) != null && EGLProject.hasEGLNature(rscProject)) {
                int i2 = 0;
                while (i2 < length) {
                    if (orphanChildren[i2] != null) {
                        try {
                            this.nonEGLResourcesChanged(adoptiveProject, orphanChildren[i2]);
                        }
                        catch (EGLModelException eGLModelException) {}
                    }
                    ++i2;
                }
            }
            return elementType != -1;
        }
        return elementType != -1;
    }

    void updateEGLPathMarkers() {
        try {
            if (!ResourcesPlugin.getWorkspace().isAutoBuilding()) {
                Iterator iterator = this.projectsToUpdate.iterator();
                while (iterator.hasNext()) {
                    try {
                        EGLProject project = (EGLProject)iterator.next();
                        project.getResolvedEGLPath(true, true);
                    }
                    catch (EGLModelException eGLModelException) {}
                }
            }
            if (!this.projectsToUpdate.isEmpty()) {
                try {
                    EGLProject.updateAllCycleMarkers();
                }
                catch (EGLModelException eGLModelException) {}
            }
        }
        finally {
            this.projectsToUpdate = new HashSet();
        }
    }

    private boolean updateCurrentDeltaAndIndex(IResourceDelta delta, int elementType, RootInfo rootInfo) {
        switch (delta.getKind()) {
            case 1: {
                IResource deltaRes = delta.getResource();
                Openable element = this.createElement(deltaRes, elementType, rootInfo);
                if (element == null) {
                    this.updateRoots(deltaRes.getFullPath(), delta);
                    return false;
                }
                this.updateIndex(element, delta);
                this.elementAdded(element, delta, rootInfo);
                return false;
            }
            case 2: {
                IResource deltaRes = delta.getResource();
                Openable element = this.createElement(deltaRes, elementType, rootInfo);
                if (element == null) {
                    this.updateRoots(deltaRes.getFullPath(), delta);
                    return false;
                }
                this.updateIndex(element, delta);
                this.elementRemoved(element, delta, rootInfo);
                return false;
            }
            case 4: {
                int flags = delta.getFlags();
                if ((flags & 0x100) != 0) {
                    Openable element = this.createElement(delta.getResource(), elementType, rootInfo);
                    if (element == null) {
                        return false;
                    }
                    this.updateIndex(element, delta);
                    this.contentChanged(element, delta);
                } else if (elementType == 2) {
                    if ((flags & 0x4000) != 0) {
                        IProject res = (IProject)delta.getResource();
                        Openable element = this.createElement((IResource)res, elementType, rootInfo);
                        if (element == null) {
                            this.updateRoots(res.getFullPath(), delta);
                            return false;
                        }
                        if (res.isOpen()) {
                            if (EGLProject.hasEGLNature(res)) {
                                this.elementAdded(element, delta, rootInfo);
                                this.indexManager.indexAll(res);
                            }
                        } else {
                            boolean wasEGLProject;
                            EGLModel eglModel = this.manager.getEGLModel();
                            boolean bl = wasEGLProject = eglModel.findEGLProject(res) != null;
                            if (wasEGLProject) {
                                this.elementRemoved(element, delta, rootInfo);
                                this.indexManager.discardJobs(element.getElementName());
                                this.indexManager.removeIndexFamily(res.getFullPath());
                            }
                        }
                        return false;
                    }
                    if ((flags & 0x80000) != 0) {
                        boolean isEGLProject;
                        IProject res = (IProject)delta.getResource();
                        EGLModel eglModel = this.manager.getEGLModel();
                        boolean wasEGLProject = eglModel.findEGLProject(res) != null;
                        if (wasEGLProject != (isEGLProject = EGLProject.hasEGLNature(res))) {
                            Openable element = this.createElement((IResource)res, elementType, rootInfo);
                            if (element == null) {
                                return false;
                            }
                            if (isEGLProject) {
                                this.elementAdded(element, delta, rootInfo);
                                this.indexManager.indexAll(res);
                            } else {
                                this.elementRemoved(element, delta, rootInfo);
                                this.indexManager.discardJobs(element.getElementName());
                                this.indexManager.removeIndexFamily(res.getFullPath());
                            }
                            return false;
                        }
                    }
                }
                return true;
            }
        }
        return true;
    }

    public void updateDependentNamelookups() {
        Iterator iterator = this.projectsForDependentNamelookupRefresh.iterator();
        HashSet affectedDependents = new HashSet();
        while (iterator.hasNext()) {
            EGLProject project = (EGLProject)iterator.next();
            this.addDependentProjects(project.getPath(), affectedDependents);
        }
        for (EGLProject project : affectedDependents) {
            if (!project.isOpen()) continue;
            try {
                ((EGLProjectElementInfo)project.getElementInfo()).setNameLookup(null);
            }
            catch (EGLModelException eGLModelException) {}
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void updateIndex(Openable element, IResourceDelta delta) {
        if (this.indexManager == null) {
            return;
        }
        block0 : switch (element.getElementType()) {
            case 2: {
                switch (delta.getKind()) {
                    case 1: {
                        this.indexManager.indexAll(element.getEGLProject().getProject());
                        return;
                    }
                    case 2: {
                        this.indexManager.removeIndexFamily(element.getEGLProject().getProject().getFullPath());
                    }
                }
                return;
            }
            case 3: {
                int kind = delta.getKind();
                if (kind == 1 || kind == 2) {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)((Object)element);
                    IProject proj = root.getEGLProject().getProject();
                    if (kind == 1 && org.eclipse.edt.ide.core.internal.model.util.Util.isBinaryProject(proj) && root instanceof EglarPackageFragmentRoot) {
                        this.indexManager.indexLibrary(root.getPath(), proj);
                        return;
                    }
                    this.updateRootIndex(root, root.getPackageFragment(""), delta);
                    return;
                }
            }
            case 4: {
                switch (delta.getKind()) {
                    case 1: 
                    case 2: {
                        IPackageFragment pkg = null;
                        if (element instanceof IPackageFragmentRoot) {
                            IPackageFragmentRoot root = (IPackageFragmentRoot)((Object)element);
                            pkg = root.getPackageFragment("");
                        } else {
                            pkg = (IPackageFragment)((Object)element);
                        }
                        IResourceDelta[] children = delta.getAffectedChildren();
                        int i = 0;
                        int length = children.length;
                        while (i < length) {
                            String name;
                            IResourceDelta child = children[i];
                            IResource resource = child.getResource();
                            if (resource instanceof IFile && Util.isEGLFileName(name = resource.getName())) {
                                Openable cu = (Openable)((Object)pkg.getEGLFile(name));
                                this.updateIndex(cu, child);
                            }
                            ++i;
                        }
                        return;
                    }
                }
                return;
            }
            case 6: {
                IFile file = (IFile)delta.getResource();
                switch (delta.getKind()) {
                    case 4: {
                        if ((delta.getFlags() & 0x100) == 0) return;
                    }
                    case 1: {
                        if (org.eclipse.edt.ide.core.internal.model.util.Util.isBinaryProject(file.getProject().getProject())) return;
                        this.indexManager.addSource(file, file.getProject().getProject().getFullPath());
                        break block0;
                    }
                    case 2: {
                        this.indexManager.remove(file.getFullPath().toString(), file.getProject().getProject().getFullPath());
                    }
                }
            }
        }
    }

    private void updateRootIndex(IPackageFragmentRoot root, IPackageFragment pkg, IResourceDelta delta) {
        this.updateIndex((Openable)((Object)pkg), delta);
        IResourceDelta[] children = delta.getAffectedChildren();
        String name = pkg.getElementName();
        int i = 0;
        int length = children.length;
        while (i < length) {
            IResourceDelta child = children[i];
            IResource resource = child.getResource();
            if (resource instanceof IFolder) {
                String subpkgName = name.length() == 0 ? resource.getName() : String.valueOf(name) + "." + resource.getName();
                IPackageFragment subpkg = root.getPackageFragment(subpkgName);
                this.updateRootIndex(root, subpkg, child);
            }
            ++i;
        }
    }

    private void updateRoots(IPath containerPath, IResourceDelta containerDelta) {
        Map otherRoots;
        Map roots;
        if (containerDelta.getKind() == 2) {
            roots = this.oldRoots;
            otherRoots = this.oldOtherRoots;
        } else {
            roots = this.roots;
            otherRoots = this.otherRoots;
        }
        for (IPath path : roots.keySet()) {
            ArrayList rootList;
            IResourceDelta rootDelta;
            if (!containerPath.isPrefixOf(path) || containerPath.equals((Object)path) || (rootDelta = containerDelta.findMember(path.removeFirstSegments(1))) == null) continue;
            RootInfo rootInfo2 = (RootInfo)roots.get(path);
            if (!rootInfo2.project.getPath().isPrefixOf(path)) {
                this.updateCurrentDeltaAndIndex(rootDelta, 3, rootInfo2);
            }
            if ((rootList = (ArrayList)otherRoots.get(path)) == null) continue;
            for (RootInfo rootInfo2 : rootList) {
                if (rootInfo2.project.getPath().isPrefixOf(path)) continue;
                this.updateCurrentDeltaAndIndex(rootDelta, 3, rootInfo2);
            }
        }
    }

    public void addProjectsChangedListener(IProjectsChangedListener listener) {
        this.projectChangedListeners.add(listener);
    }

    public void removeProjectsChangedListener(IProjectsChangedListener listener) {
        this.projectChangedListeners.remove(listener);
    }

    public void fireProjectsChanged(IProject[] projects) {
        for (IProjectsChangedListener listener : this.projectChangedListeners) {
            listener.projectsChanged(projects);
        }
    }

    class OutputsInfo {
        IPath[] paths;
        int[] traverseModes;
        int outputCount;

        OutputsInfo(IPath[] paths, int[] traverseModes, int outputCount) {
            this.paths = paths;
            this.traverseModes = traverseModes;
            this.outputCount = outputCount;
        }

        public String toString() {
            if (this.paths == null) {
                return "<none>";
            }
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < this.outputCount) {
                buffer.append("path=");
                buffer.append(this.paths[i].toString());
                buffer.append("\n->traverse=");
                switch (this.traverseModes[i]) {
                    case 2: {
                        buffer.append("BINARY");
                        break;
                    }
                    case 0: {
                        buffer.append("IGNORE");
                        break;
                    }
                    case 1: {
                        buffer.append("SOURCE");
                        break;
                    }
                    default: {
                        buffer.append("<unknown>");
                    }
                }
                if (i + 1 < this.outputCount) {
                    buffer.append('\n');
                }
                ++i;
            }
            return buffer.toString();
        }
    }

    class RootInfo {
        IEGLProject project;
        IPath rootPath;
        char[][] exclusionPatterns;

        RootInfo(IEGLProject project, IPath rootPath, char[][] exclusionPatterns) {
            this.project = project;
            this.rootPath = rootPath;
            this.exclusionPatterns = exclusionPatterns;
        }

        boolean isRootOfProject(IPath path) {
            return this.rootPath.equals((Object)path) && this.project.getProject().getFullPath().isPrefixOf(path);
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer("project=");
            if (this.project == null) {
                buffer.append("null");
            } else {
                buffer.append(this.project.getElementName());
            }
            buffer.append("\npath=");
            if (this.rootPath == null) {
                buffer.append("null");
            } else {
                buffer.append(this.rootPath.toString());
            }
            buffer.append("\nexcluding=");
            if (this.exclusionPatterns == null) {
                buffer.append("null");
            } else {
                int i = 0;
                int length = this.exclusionPatterns.length;
                while (i < length) {
                    buffer.append(new String(this.exclusionPatterns[i]));
                    if (i < length - 1) {
                        buffer.append("|");
                    }
                    ++i;
                }
            }
            return buffer.toString();
        }
    }
}

