/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.edt.ide.core.internal.model.Assert;
import org.eclipse.edt.ide.core.internal.model.EGLElementInfo;
import org.eclipse.edt.ide.core.internal.model.EGLModelManager;
import org.eclipse.edt.ide.core.internal.model.EGLModelResources;
import org.eclipse.edt.ide.core.internal.model.EGLModelStatus;
import org.eclipse.edt.ide.core.internal.model.Openable;
import org.eclipse.edt.ide.core.internal.model.SourceMapper;
import org.eclipse.edt.ide.core.internal.model.SourceRefElement;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IClassFile;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLModel;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IOpenable;
import org.eclipse.edt.ide.core.model.IParent;
import org.eclipse.edt.ide.core.model.ISourceRange;
import org.eclipse.edt.ide.core.model.ISourceReference;

public abstract class EGLElement
extends PlatformObject
implements IEGLElement {
    public static final char EGLM_EGLPROJECT = '=';
    public static final char EGLM_PACKAGEFRAGMENTROOT = '/';
    public static final char EGLM_PACKAGEFRAGMENT = '<';
    public static final char EGLM_FIELD = '^';
    public static final char EGLM_FUNCTION = '~';
    public static final char EGLM_INITIALIZER = '|';
    public static final char EGLM_EGLFILE = '{';
    public static final char EGLM_PART = '[';
    public static final char EGLM_PACKAGEDECLARATION = '%';
    public static final char EGLM_IMPORTDECLARATION = '\'';
    public static final char EGLM_PROPERTYBLOCK = '!';
    public static final char EGLM_PROPERTY = '>';
    public static final char EGLM_USE = '*';
    protected static final EGLElement[] NO_ELEMENTS = new EGLElement[0];
    protected int fOccurrenceCount = 1;
    protected int fLEType = 0;
    protected IEGLElement fParent;
    protected String fName;
    protected static final Object NO_INFO = new Object();

    protected EGLElement(int type, IEGLElement parent, String name) throws IllegalArgumentException {
        if (type < 1 || type > 17) {
            throw new IllegalArgumentException(EGLModelResources.elementInvalidType);
        }
        this.fLEType = type;
        this.fParent = parent;
        this.fName = name;
    }

    public void close() throws EGLModelException {
        Object info = EGLModelManager.getEGLModelManager().peekAtInfo(this);
        if (info != null) {
            boolean wasVerbose = false;
            try {
                if (EGLModelManager.VERBOSE) {
                    System.out.println("CLOSING Element (" + Thread.currentThread() + "): " + this.toStringWithAncestors());
                    wasVerbose = true;
                    EGLModelManager.VERBOSE = false;
                }
                if (this instanceof IParent) {
                    IEGLElement[] children = ((EGLElementInfo)info).getChildren();
                    int i = 0;
                    int size = children.length;
                    while (i < size) {
                        EGLElement child = (EGLElement)children[i];
                        child.close();
                        ++i;
                    }
                }
                this.closing(info);
                EGLModelManager.getEGLModelManager().removeInfo(this);
                if (wasVerbose) {
                    System.out.println("-> Package cache size = " + EGLModelManager.getEGLModelManager().cache.pkgSize());
                    System.out.println("-> Openable cache filling ratio = " + EGLModelManager.getEGLModelManager().cache.openableFillingRatio() + "%");
                }
            }
            finally {
                EGLModelManager.VERBOSE = wasVerbose;
            }
        }
    }

    protected void closing(Object info) throws EGLModelException {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.fParent == null) {
            return super.equals(o);
        }
        if (o instanceof EGLElement) {
            EGLElement other = (EGLElement)o;
            if (this.fLEType != other.fLEType) {
                return false;
            }
            return this.fOccurrenceCount == other.fOccurrenceCount && this.fName.equals(other.fName) && this.fParent.equals(other.fParent);
        }
        return false;
    }

    @Override
    public boolean exists() {
        try {
            this.getElementInfo();
            return true;
        }
        catch (EGLModelException eGLModelException) {
            return false;
        }
    }

    @Override
    public IEGLElement getAncestor(int ancestorType) {
        IEGLElement element = this;
        while (element != null) {
            if (element.getElementType() == ancestorType) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    public IEGLElement[] getChildren() throws EGLModelException {
        return ((EGLElementInfo)this.getElementInfo()).getChildren();
    }

    public ArrayList getChildrenOfType(int type) throws EGLModelException {
        IEGLElement[] children = this.getChildren();
        int size = children.length;
        ArrayList<EGLElement> list = new ArrayList<EGLElement>(size);
        int i = 0;
        while (i < size) {
            EGLElement elt = (EGLElement)children[i];
            if (elt.getElementType() == type) {
                list.add(elt);
            }
            ++i;
        }
        return list;
    }

    @Override
    public abstract IResource getCorrespondingResource() throws EGLModelException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getElementInfo() throws EGLModelException {
        EGLModelManager manager;
        IEGLProject project = this.getEGLProject();
        if (project != null && !project.isOpen()) {
            try {
                project.getResolvedEGLPath(true);
            }
            catch (EGLModelException eGLModelException) {}
        }
        EGLModelManager eGLModelManager = manager = EGLModelManager.getEGLModelManager();
        synchronized (manager) {
            Object info = manager.getInfo(this);
            if (info == null) {
                this.openHierarchy();
                info = manager.getInfo(this);
                if (info == null) {
                    throw this.newNotPresentException();
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return info;
        }
    }

    @Override
    public String getElementName() {
        return this.fName;
    }

    @Override
    public int getElementType() {
        return this.fLEType;
    }

    @Override
    public String getHandleIdentifier() {
        return this.getHandleMemento();
    }

    public String getHandleMemento() {
        StringBuffer buff = new StringBuffer(((EGLElement)this.getParent()).getHandleMemento());
        buff.append(this.getHandleMementoDelimiter());
        buff.append(this.getElementName());
        return buff.toString();
    }

    public IEGLFile getEGLFile() {
        return null;
    }

    public IClassFile getClassFile() {
        return null;
    }

    protected abstract char getHandleMementoDelimiter();

    @Override
    public IEGLModel getEGLModel() {
        IEGLElement current = this;
        do {
            if (!(current instanceof IEGLModel)) continue;
            return (IEGLModel)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    @Override
    public IEGLProject getEGLProject() {
        IEGLElement current = this;
        do {
            if (!(current instanceof IEGLProject)) continue;
            return (IEGLProject)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    protected int getOccurrenceCount() {
        return this.fOccurrenceCount;
    }

    @Override
    public IEGLElement getParent() {
        return this.fParent;
    }

    @Override
    public IOpenable getOpenable() {
        return this.getOpenableParent();
    }

    public IOpenable getOpenableParent() {
        return (IOpenable)((Object)this.fParent);
    }

    protected IEGLElement getSourceElementAt(int position) throws EGLModelException {
        if (this instanceof ISourceReference) {
            IEGLElement[] children = this.getChildren();
            int i = 0;
            while (i < children.length) {
                SourceRefElement child;
                ISourceRange range;
                IEGLElement aChild = children[i];
                if (aChild instanceof SourceRefElement && position < (range = (child = (SourceRefElement)children[i]).getSourceRange()).getOffset() + range.getLength() && position >= range.getOffset()) {
                    if (child instanceof IParent) {
                        return child.getSourceElementAt(position);
                    }
                    return child;
                }
                ++i;
            }
        } else {
            Assert.isTrue(false);
        }
        return this;
    }

    public int hashCode() {
        if (this.fParent == null) {
            return super.hashCode();
        }
        return Util.combineHashCodes(this.fName.hashCode(), this.fParent.hashCode());
    }

    protected boolean isAncestorOf(IEGLElement e) {
        IEGLElement parent = e.getParent();
        while (parent != null && !parent.equals(this)) {
            parent = parent.getParent();
        }
        return parent != null;
    }

    @Override
    public abstract IPath getPath();

    @Override
    public abstract IResource getResource();

    @Override
    public abstract IResource getUnderlyingResource() throws EGLModelException;

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isStructureKnown() throws EGLModelException {
        return ((EGLElementInfo)this.getElementInfo()).isStructureKnown();
    }

    protected EGLModelException newNotPresentException() {
        return new EGLModelException(new EGLModelStatus(969, this));
    }

    protected void openHierarchy() throws EGLModelException {
        if (this instanceof IOpenable) {
            ((Openable)this).openWhenClosed(null);
        } else {
            Openable openableParent = (Openable)this.getOpenableParent();
            if (openableParent != null) {
                EGLElementInfo openableParentInfo = (EGLElementInfo)EGLModelManager.getEGLModelManager().getInfo(openableParent);
                if (openableParentInfo == null) {
                    openableParent.openWhenClosed(null);
                } else {
                    throw this.newNotPresentException();
                }
            }
        }
    }

    protected void opening(Object info) {
    }

    public String readableName() {
        return this.getElementName();
    }

    protected void removeInfo() {
        Object info = EGLModelManager.getEGLModelManager().peekAtInfo(this);
        if (info != null) {
            if (this instanceof IParent) {
                IEGLElement[] children = ((EGLElementInfo)info).getChildren();
                int i = 0;
                int size = children.length;
                while (i < size) {
                    EGLElement child = (EGLElement)children[i];
                    child.removeInfo();
                    ++i;
                }
            }
            EGLModelManager.getEGLModelManager().removeInfo(this);
        }
    }

    protected void setOccurrenceCount(int count) {
        this.fOccurrenceCount = count;
    }

    protected String tabString(int tab) {
        StringBuffer buffer = new StringBuffer();
        int i = tab;
        while (i > 0) {
            buffer.append("  ");
            --i;
        }
        return buffer.toString();
    }

    public String toDebugString() {
        StringBuffer buffer = new StringBuffer();
        this.toStringInfo(0, buffer, NO_INFO);
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.toString(0, buffer);
        return buffer.toString();
    }

    protected void toString(int tab, StringBuffer buffer) {
        Object info = this.toStringInfo(tab, buffer);
        if (tab == 0) {
            this.toStringAncestors(buffer);
        }
        this.toStringChildren(tab, buffer, info);
    }

    public String toStringWithAncestors() {
        StringBuffer buffer = new StringBuffer();
        this.toStringInfo(0, buffer, NO_INFO);
        this.toStringAncestors(buffer);
        return buffer.toString();
    }

    protected void toStringAncestors(StringBuffer buffer) {
        EGLElement parent = (EGLElement)this.getParent();
        if (parent != null && parent.getParent() != null) {
            buffer.append(" [in ");
            parent.toStringInfo(0, buffer, NO_INFO);
            parent.toStringAncestors(buffer);
            buffer.append("]");
        }
    }

    protected void toStringChildren(int tab, StringBuffer buffer, Object info) {
        if (info == null || !(info instanceof EGLElementInfo)) {
            return;
        }
        IEGLElement[] children = ((EGLElementInfo)info).getChildren();
        int i = 0;
        while (i < children.length) {
            buffer.append("\n");
            ((EGLElement)children[i]).toString(tab + 1, buffer);
            ++i;
        }
    }

    public Object toStringInfo(int tab, StringBuffer buffer) {
        Object info = EGLModelManager.getEGLModelManager().peekAtInfo(this);
        this.toStringInfo(tab, buffer, info);
        return info;
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        buffer.append(this.getElementName());
        if (info == null) {
            buffer.append(" (not open)");
        }
    }

    public abstract IEGLElement rootedAt(IEGLProject var1);

    public SourceMapper getSourceMapper() {
        return ((EGLElement)this.getParent()).getSourceMapper();
    }
}

