/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.core.internal.model.EGLModel;
import org.eclipse.edt.ide.core.internal.model.EGLModelManager;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.internal.model.Openable;
import org.eclipse.edt.ide.core.internal.model.PackageFragmentRoot;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IClassFile;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;

public class HandleFactory {
    private String lastPkgFragmentRootPath;
    private IPackageFragmentRoot lastPkgFragmentRoot;
    private Map packageHandles;
    private IWorkspace workspace;
    private EGLModel eglModel;

    public HandleFactory(IWorkspace workspace) {
        this.workspace = workspace;
        this.eglModel = EGLModelManager.getEGLModelManager().getEGLModel();
    }

    public Openable createOpenable(String resourcePath) {
        int lastSlash;
        String packageName;
        IPackageFragment pkgFragment;
        int separatorIndex;
        if (resourcePath.startsWith("eglar://")) {
            resourcePath = resourcePath.substring("eglar://".length());
        }
        if ((separatorIndex = resourcePath.indexOf("|")) > -1) {
            String[] pkgName;
            String classFilePath;
            String[] simpleNames;
            int length;
            int rootPathLength;
            if (this.lastPkgFragmentRootPath == null || (rootPathLength = this.lastPkgFragmentRootPath.length()) != resourcePath.length() || !resourcePath.regionMatches(0, this.lastPkgFragmentRootPath, 0, rootPathLength)) {
                String jarPath = resourcePath.substring(0, separatorIndex);
                PackageFragmentRoot root = this.getJarPkgFragmentRoot(resourcePath, separatorIndex, jarPath);
                if (root == null) {
                    return null;
                }
                this.lastPkgFragmentRootPath = jarPath;
                this.lastPkgFragmentRoot = root;
                this.packageHandles = new HashMap(5);
            }
            if ((length = (simpleNames = new Path(classFilePath = resourcePath.substring(separatorIndex + 1)).segments()).length - 1) > 0) {
                pkgName = new String[length];
                System.arraycopy(simpleNames, 0, pkgName, 0, length);
            } else {
                pkgName = new String[]{};
            }
            IPackageFragment pkgFragment2 = (IPackageFragment)this.packageHandles.get(pkgName);
            if (pkgFragment2 == null) {
                pkgFragment2 = ((PackageFragmentRoot)this.lastPkgFragmentRoot).getPackageFragment(pkgName);
                this.packageHandles.put(pkgName, pkgFragment2);
            }
            IClassFile classFile = pkgFragment2.getClassFile(simpleNames[length]);
            return (Openable)((Object)classFile);
        }
        int length = -1;
        if (this.lastPkgFragmentRootPath == null || !resourcePath.startsWith(this.lastPkgFragmentRootPath) || (length = this.lastPkgFragmentRootPath.length()) <= 0 || resourcePath.charAt(length) != '/') {
            IPackageFragmentRoot root = this.getPkgFragmentRoot(resourcePath);
            if (root == null) {
                return null;
            }
            this.lastPkgFragmentRoot = root;
            this.lastPkgFragmentRootPath = this.lastPkgFragmentRoot.getPath().toString();
            this.packageHandles = new HashMap(5);
        }
        if ((pkgFragment = (IPackageFragment)this.packageHandles.get(packageName = (lastSlash = resourcePath.lastIndexOf(47)) > (length = this.lastPkgFragmentRootPath.length()) ? resourcePath.substring(length + 1, lastSlash).replace('/', '.') : "")) == null) {
            pkgFragment = this.lastPkgFragmentRoot.getPackageFragment(packageName);
            this.packageHandles.put(packageName, pkgFragment);
        }
        String simpleName = resourcePath.substring(lastSlash + 1);
        IEGLFile unit = pkgFragment.getEGLFile(simpleName);
        return (Openable)((Object)unit);
    }

    private IPackageFragmentRoot getPkgFragmentRoot(String pathString) {
        Path path = new Path(pathString);
        IProject[] projects = this.workspace.getRoot().getProjects();
        int i = 0;
        int max = projects.length;
        while (i < max) {
            try {
                IProject project = projects[i];
                if (project.isAccessible() && project.hasNature("org.eclipse.edt.ide.core.eglnature")) {
                    IEGLProject eglProject = this.eglModel.getEGLProject((IResource)project);
                    IPackageFragmentRoot[] roots = eglProject.getPackageFragmentRoots();
                    int j = 0;
                    int rootCount = roots.length;
                    while (j < rootCount) {
                        PackageFragmentRoot root = (PackageFragmentRoot)roots[j];
                        if (root.getPath().isPrefixOf((IPath)path) && !Util.isExcluded((IPath)path, root.fullExclusionPatternChars())) {
                            return root;
                        }
                        ++j;
                    }
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        return null;
    }

    private PackageFragmentRoot getJarPkgFragmentRoot(String resourcePathString, int jarSeparatorIndex, String jarPathString) {
        IEGLProject[] projects;
        Path jarPath = new Path(jarPathString);
        Object target = EGLModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), (IPath)jarPath, false);
        if (target instanceof IFile) {
            IFile jarFile = (IFile)target;
            EGLProject javaProject = (EGLProject)this.eglModel.getEGLProject((IResource)jarFile);
            try {
                IEGLPathEntry entry = javaProject.getEGLPathEntryFor((IPath)jarPath);
                if (entry != null) {
                    return (PackageFragmentRoot)javaProject.getPackageFragmentRoot((IResource)jarFile);
                }
            }
            catch (EGLModelException eGLModelException) {}
        }
        try {
            projects = this.eglModel.getEGLProjects();
        }
        catch (EGLModelException eGLModelException) {
            return null;
        }
        return this.getJarPkgFragmentRoot((IPath)jarPath, target, projects);
    }

    private PackageFragmentRoot getJarPkgFragmentRoot(IPath jarPath, Object target, IEGLProject[] projects) {
        int i = 0;
        int projectCount = projects.length;
        while (i < projectCount) {
            try {
                EGLProject javaProject = (EGLProject)projects[i];
                IEGLPathEntry classpathEnty = javaProject.getEGLPathEntryFor(jarPath);
                if (classpathEnty != null) {
                    if (target instanceof IFile) {
                        return (PackageFragmentRoot)javaProject.getPackageFragmentRoot((IResource)((IFile)target));
                    }
                    return (PackageFragmentRoot)javaProject.getPackageFragmentRoot0(jarPath);
                }
            }
            catch (EGLModelException eGLModelException) {}
            ++i;
        }
        return null;
    }
}

