/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.tools.IRUtils;
import org.eclipse.edt.ide.core.internal.model.ClassFile;
import org.eclipse.edt.ide.core.internal.model.CreateEGLFileOperation;
import org.eclipse.edt.ide.core.internal.model.EGLElement;
import org.eclipse.edt.ide.core.internal.model.EGLElementInfo;
import org.eclipse.edt.ide.core.internal.model.EGLFile;
import org.eclipse.edt.ide.core.internal.model.EGLModelResources;
import org.eclipse.edt.ide.core.internal.model.Openable;
import org.eclipse.edt.ide.core.internal.model.OpenableElementInfo;
import org.eclipse.edt.ide.core.internal.model.PackageFragmentInfo;
import org.eclipse.edt.ide.core.internal.model.PackageFragmentRoot;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IClassFile;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.Signature;

public class PackageFragment
extends Openable
implements IPackageFragment {
    protected static IEGLFile[] fgEmptyEGLFileList = new IEGLFile[0];
    protected static IPart[] fEmptyPartList = new IPart[0];
    public String[] names;

    protected PackageFragment(IPackageFragmentRoot root, String name) {
        super(4, root, name);
        this.names = new String[]{name};
    }

    protected PackageFragment(PackageFragmentRoot root, String[] names) {
        super(4, root, null);
        this.names = names;
        this.fName = Util.concatWith(this.names, '.');
    }

    protected boolean computeChildren(OpenableElementInfo info, IResource resource) throws EGLModelException {
        ArrayList<IEGLFile> vChildren = new ArrayList<IEGLFile>();
        int kind = this.getKind();
        String extType = "egl";
        try {
            char[][] exclusionPatterns = this.getPackageFragmentRoot().fullExclusionPatternChars();
            IResource[] members = ((IContainer)resource).members();
            int i = 0;
            int max = members.length;
            while (i < max) {
                String extension;
                IResource child = members[i];
                if (child.getType() != 2 && !Util.isExcluded(child, exclusionPatterns) && (extension = child.getProjectRelativePath().getFileExtension()) != null && extension.equalsIgnoreCase(extType) && kind == 1 && Util.isValidEGLFileName(child.getName())) {
                    IEGLFile childElement = this.getEGLFile(child.getName());
                    vChildren.add(childElement);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new EGLModelException(e);
        }
        IEGLElement[] children = new IEGLElement[vChildren.size()];
        vChildren.toArray(children);
        info.setChildren(children);
        return true;
    }

    @Override
    public boolean containsEGLResources() throws EGLModelException {
        return ((PackageFragmentInfo)this.getElementInfo()).containsEGLResources();
    }

    @Override
    public void copy(IEGLElement container, IEGLElement sibling, String rename, boolean force, IProgressMonitor monitor) throws EGLModelException {
        if (container == null) {
            throw new IllegalArgumentException(EGLModelResources.operationNullContainer);
        }
        IEGLElement[] elements = new IEGLElement[]{this};
        IEGLElement[] containers = new IEGLElement[]{container};
        IEGLElement[] siblings = null;
        if (sibling != null) {
            siblings = new IEGLElement[]{sibling};
        }
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getEGLModel().copy(elements, containers, siblings, renamings, force, monitor);
    }

    @Override
    public IEGLFile createEGLFile(String name, String contents, boolean force, IProgressMonitor monitor) throws EGLModelException {
        CreateEGLFileOperation op = new CreateEGLFileOperation(this, name, contents, force);
        op.runOperation(monitor);
        return this.getEGLFile(name);
    }

    @Override
    protected OpenableElementInfo createElementInfo() {
        return new PackageFragmentInfo();
    }

    @Override
    public void delete(boolean force, IProgressMonitor monitor) throws EGLModelException {
        IEGLElement[] elements = new IEGLElement[]{this};
        this.getEGLModel().delete(elements, force, monitor);
    }

    @Override
    protected boolean generateInfos(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws EGLModelException {
        return this.computeChildren(info, underlyingResource);
    }

    @Override
    public IEGLFile getEGLFile(String name) {
        return new EGLFile(this, name);
    }

    @Override
    public IEGLFile[] getEGLFiles() throws EGLModelException {
        if (this.getKind() == 2) {
            return fgEmptyEGLFileList;
        }
        ArrayList list = this.getChildrenOfType(6);
        IEGLFile[] array = new IEGLFile[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '<';
    }

    @Override
    public int getKind() throws EGLModelException {
        return ((IPackageFragmentRoot)this.getParent()).getKind();
    }

    @Override
    public Object[] getNonEGLResources() throws EGLModelException {
        if (this.isDefaultPackage()) {
            return EGLElementInfo.NO_NON_EGL_RESOURCES;
        }
        return ((PackageFragmentInfo)this.getElementInfo()).getNonEGLResources(this.getResource(), this.getPackageFragmentRoot());
    }

    @Override
    public IPath getPath() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root.isArchive()) {
            return root.getPath();
        }
        return root.getPath().append(this.getElementName().replace('.', '/'));
    }

    @Override
    public IResource getResource() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root.isArchive()) {
            return root.getResource();
        }
        String elementName = this.getElementName();
        if (elementName.length() == 0) {
            return root.getResource();
        }
        return ((IContainer)root.getResource()).getFolder((IPath)new Path(this.getElementName().replace('.', '/')));
    }

    @Override
    public IResource getUnderlyingResource() throws EGLModelException {
        IResource rootResource = this.fParent.getUnderlyingResource();
        if (rootResource == null) {
            return null;
        }
        if (rootResource.getType() == 2 || rootResource.getType() == 4) {
            IContainer folder = (IContainer)rootResource;
            String[] segs = Signature.getSimpleNames(this.fName);
            int i = 0;
            while (i < segs.length) {
                IResource child = folder.findMember(segs[i]);
                if (child == null || child.getType() != 2) {
                    throw this.newNotPresentException();
                }
                folder = (IFolder)child;
                ++i;
            }
            return folder;
        }
        return rootResource;
    }

    @Override
    public boolean hasSubpackages() throws EGLModelException {
        IEGLElement[] packages = ((IPackageFragmentRoot)this.getParent()).getChildren();
        String name = this.getElementName();
        int nameLength = name.length();
        String packageName = this.isDefaultPackage() ? name : String.valueOf(name) + ".";
        int i = 0;
        while (i < packages.length) {
            String otherName = packages[i].getElementName();
            if (otherName.length() > nameLength && otherName.startsWith(packageName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isDefaultPackage() {
        return this.getElementName().length() == 0;
    }

    @Override
    public void move(IEGLElement container, IEGLElement sibling, String rename, boolean force, IProgressMonitor monitor) throws EGLModelException {
        if (container == null) {
            throw new IllegalArgumentException(EGLModelResources.operationNullContainer);
        }
        IEGLElement[] elements = new IEGLElement[]{this};
        IEGLElement[] containers = new IEGLElement[]{container};
        IEGLElement[] siblings = null;
        if (sibling != null) {
            siblings = new IEGLElement[]{sibling};
        }
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getEGLModel().move(elements, containers, siblings, renamings, force, monitor);
    }

    @Override
    protected void openWhenClosed(IProgressMonitor pm) throws EGLModelException {
        if (!this.resourceExists()) {
            throw this.newNotPresentException();
        }
        super.openWhenClosed(pm);
    }

    public void refreshChildren() {
        try {
            OpenableElementInfo info = (OpenableElementInfo)this.getElementInfo();
            this.computeChildren(info, this.getResource());
        }
        catch (EGLModelException eGLModelException) {}
    }

    @Override
    public void rename(String name, boolean force, IProgressMonitor monitor) throws EGLModelException {
        if (name == null) {
            throw new IllegalArgumentException(EGLModelResources.elementNullName);
        }
        IEGLElement[] elements = new IEGLElement[]{this};
        IEGLElement[] dests = new IEGLElement[]{this.getParent()};
        String[] renamings = new String[]{name};
        this.getEGLModel().rename(elements, dests, renamings, force, monitor);
    }

    @Override
    public IEGLElement rootedAt(IEGLProject project) {
        return new PackageFragment((IPackageFragmentRoot)((EGLElement)this.fParent).rootedAt(project), this.fName);
    }

    @Override
    protected void toStringChildren(int tab, StringBuffer buffer, Object info) {
        if (tab == 0) {
            super.toStringChildren(tab, buffer, info);
        }
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        if (this.getElementName().length() == 0) {
            buffer.append("[default]");
        } else {
            buffer.append(this.getElementName());
        }
        if (info == null) {
            buffer.append(" (not open)");
        } else if (tab > 0) {
            buffer.append(" (...)");
        }
    }

    @Override
    public IPart getPart(String name) {
        return null;
    }

    @Override
    public IPart[] getParts() throws EGLModelException {
        return fEmptyPartList;
    }

    @Override
    public IClassFile getClassFile(String name) {
        if (!IRUtils.isEGLIRFileName((String)name)) {
            throw new IllegalArgumentException();
        }
        int length = name.length() - 3;
        char[] nameWithoutExtension = new char[length];
        name.getChars(0, length, nameWithoutExtension, 0);
        return new ClassFile(this, new String(nameWithoutExtension));
    }

    @Override
    public IClassFile[] getClassFiles() throws EGLModelException {
        return null;
    }
}

