/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.internal.model.CommitWorkingCopyOperation;
import org.eclipse.edt.ide.core.internal.model.DestroyWorkingCopyOperation;
import org.eclipse.edt.ide.core.internal.model.EGLElement;
import org.eclipse.edt.ide.core.internal.model.EGLFile;
import org.eclipse.edt.ide.core.internal.model.EGLFileElementInfo;
import org.eclipse.edt.ide.core.internal.model.EGLFileProblemFinder;
import org.eclipse.edt.ide.core.internal.model.EGLModelManager;
import org.eclipse.edt.ide.core.internal.model.EGLModelStatus;
import org.eclipse.edt.ide.core.internal.model.OpenableElementInfo;
import org.eclipse.edt.ide.core.internal.model.ReconcileWorkingCopyOperation;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.internal.model.WorkingCopyElementInfo;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IBuffer;
import org.eclipse.edt.ide.core.model.IBufferFactory;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.IProblemRequestor;

public class WorkingCopy
extends EGLFile {
    protected IBufferFactory bufferFactory;
    protected IProblemRequestor problemRequestor;
    protected int useCount = 1;

    protected WorkingCopy(IPackageFragment parent, String name, IBufferFactory bufferFactory) {
        this(parent, name, bufferFactory, null);
    }

    protected WorkingCopy(IPackageFragment parent, String name, IBufferFactory bufferFactory, IProblemRequestor problemRequestor) {
        super(parent, name);
        this.bufferFactory = bufferFactory == null ? this.getBufferManager().getDefaultBufferFactory() : bufferFactory;
        this.problemRequestor = problemRequestor;
    }

    @Override
    public void commit(boolean force, IProgressMonitor monitor) throws EGLModelException {
        IEGLFile original = (IEGLFile)this.getOriginalElement();
        if (original.exists()) {
            CommitWorkingCopyOperation op = new CommitWorkingCopyOperation(this, force);
            op.runOperation(monitor);
        } else {
            String encoding = this.getEGLProject().getOption(EGLCore.CORE_ENCODING, true);
            String contents = this.getSource();
            if (contents == null) {
                return;
            }
            try {
                byte[] bytes = encoding == null ? contents.getBytes() : contents.getBytes(encoding);
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                IFile originalRes = (IFile)original.getResource();
                if (originalRes.exists()) {
                    originalRes.setContents((InputStream)stream, force ? 3 : 2, null);
                } else {
                    originalRes.create((InputStream)stream, force, monitor);
                }
            }
            catch (CoreException e) {
                throw new EGLModelException(e);
            }
            catch (UnsupportedEncodingException e) {
                throw new EGLModelException(e, 985);
            }
        }
    }

    @Override
    protected OpenableElementInfo createElementInfo() {
        return new WorkingCopyElementInfo();
    }

    @Override
    public void destroy() {
        if (--this.useCount > 0) {
            if (SHARED_WC_VERBOSE) {
                System.out.println("Decrementing use count of shared working copy " + this.toStringWithAncestors());
            }
            return;
        }
        try {
            DestroyWorkingCopyOperation op = new DestroyWorkingCopyOperation(this);
            op.runOperation(null);
        }
        catch (EGLModelException eGLModelException) {}
    }

    @Override
    public boolean exists() {
        return this.useCount != 0;
    }

    @Override
    public IBufferFactory getBufferFactory() {
        return this.bufferFactory;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getElementInfo() throws EGLModelException {
        EGLModelManager manager;
        EGLModelManager eGLModelManager = manager = EGLModelManager.getEGLModelManager();
        synchronized (eGLModelManager) {
            Object info = manager.getInfo(this);
            if (info == null) {
                // empty if block
            }
        }
        Object info = super.getElementInfo();
        return info;
    }

    @Override
    public IEGLElement getOriginal(IEGLElement workingCopyElement) {
        int eglElementType = workingCopyElement.getElementType();
        if (eglElementType < 6 || eglElementType == 7) {
            return null;
        }
        IEGLElement parent = workingCopyElement.getParent();
        ArrayList<IEGLElement> hierarchy = new ArrayList<IEGLElement>(4);
        while (parent.getElementType() > 6) {
            hierarchy.add(parent);
            parent = parent.getParent();
        }
        if (parent.getElementType() == 6) {
            hierarchy.add(((IEGLFile)parent).getOriginalElement());
        }
        IEGLFile cu = (IEGLFile)this.getOriginalElement();
        if (eglElementType == 6) {
            parent = workingCopyElement;
        }
        if (((IEGLFile)parent).isWorkingCopy() && !((IEGLFile)parent).getOriginalElement().equals(cu)) {
            return null;
        }
        switch (eglElementType) {
            case 12: {
                return cu.getPackageDeclaration(workingCopyElement.getElementName());
            }
            case 13: {
                return cu.getImportContainer();
            }
            case 14: {
                return cu.getImport(workingCopyElement.getElementName());
            }
            case 8: {
                return cu.getPart(workingCopyElement.getElementName());
            }
            case 6: {
                return cu;
            }
        }
        return null;
    }

    @Override
    public IEGLElement getOriginalElement() {
        return new EGLFile((IPackageFragment)this.getParent(), this.getElementName());
    }

    protected IPart getOriginalType(ArrayList hierarchy) {
        int size = hierarchy.size() - 1;
        IEGLFile typeCU = (IEGLFile)hierarchy.get(size);
        String typeName = ((IEGLElement)hierarchy.get(size - 1)).getElementName();
        IPart type = typeCU.getPart(typeName);
        size -= 2;
        while (size > -1) {
            typeName = ((IEGLElement)hierarchy.get(size)).getElementName();
            type = type.getPart(typeName);
            --size;
        }
        return type;
    }

    @Override
    public IResource getResource() {
        return null;
    }

    @Override
    public IEGLElement getSharedWorkingCopy(IProgressMonitor monitor, IBufferFactory factory, IProblemRequestor problemRequestor) throws EGLModelException {
        return this;
    }

    @Override
    public IResource getUnderlyingResource() throws EGLModelException {
        return null;
    }

    @Override
    public IEGLElement getWorkingCopy() throws EGLModelException {
        return this;
    }

    @Override
    public IEGLElement getWorkingCopy(IProgressMonitor monitor, IBufferFactory factory, IProblemRequestor problemRequestor) throws EGLModelException {
        return this;
    }

    @Override
    public boolean isBasedOn(IResource resource) {
        if (resource.getType() != 1) {
            return false;
        }
        if (this.useCount == 0) {
            return false;
        }
        try {
            return ((EGLFileElementInfo)this.getElementInfo()).fTimestamp == ((IFile)resource).getModificationStamp();
        }
        catch (EGLModelException eGLModelException) {
            return false;
        }
    }

    @Override
    public boolean isWorkingCopy() {
        return true;
    }

    @Override
    public void makeConsistent(IProgressMonitor monitor) throws EGLModelException {
        if (!this.isConsistent()) {
            super.makeConsistent(monitor);
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            if (this.problemRequestor != null && this.problemRequestor.isActive()) {
                this.problemRequestor.beginReporting();
                EGLFileProblemFinder.process(this, this.problemRequestor, monitor);
                this.problemRequestor.endReporting();
            }
        }
    }

    @Override
    public void open(IProgressMonitor monitor) throws EGLModelException {
        if (this.useCount == 0) {
            throw this.newNotPresentException();
        }
        super.open(monitor);
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        if (this.problemRequestor != null && this.problemRequestor.isActive()) {
            this.problemRequestor.beginReporting();
            EGLFileProblemFinder.process(this, this.problemRequestor, monitor);
            this.problemRequestor.endReporting();
        }
    }

    @Override
    protected IBuffer openBuffer(IProgressMonitor pm, Object info) throws EGLModelException {
        if (this.useCount == 0) {
            throw this.newNotPresentException();
        }
        IBuffer buffer = this.getBufferFactory().createBuffer(this);
        if (buffer == null) {
            return null;
        }
        if (buffer.getCharacters() == null) {
            IEGLFile original = (IEGLFile)this.getOriginalElement();
            if (original.isOpen()) {
                buffer.setContents(original.getSource());
            } else {
                IFile file = (IFile)original.getResource();
                if (file == null || !file.exists()) {
                    buffer.setContents(CharOperation.NO_CHAR);
                } else {
                    buffer.setContents(Util.getResourceContentsAsCharArray(file));
                }
            }
        }
        this.getBufferManager().addBuffer(buffer);
        buffer.addBufferChangedListener(this);
        return buffer;
    }

    @Override
    public IMarker[] reconcile() throws EGLModelException {
        this.reconcile(false, null);
        return null;
    }

    @Override
    public void reconcile(boolean forceProblemDetection, IProgressMonitor monitor) throws EGLModelException {
        ReconcileWorkingCopyOperation op = new ReconcileWorkingCopyOperation(this, forceProblemDetection);
        op.runOperation(monitor);
    }

    @Override
    public void restore() throws EGLModelException {
        if (this.useCount == 0) {
            throw this.newNotPresentException();
        }
        EGLFile original = (EGLFile)this.getOriginalElement();
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return;
        }
        buffer.setContents(original.getContents());
        this.updateTimeStamp(original);
        this.makeConsistent(null);
    }

    @Override
    public IEGLElement rootedAt(IEGLProject project) {
        return new WorkingCopy((IPackageFragment)((EGLElement)this.fParent).rootedAt(project), this.fName, this.bufferFactory);
    }

    @Override
    public void save(IProgressMonitor pm, boolean force) throws EGLModelException {
        if (this.isReadOnly()) {
            throw new EGLModelException(new EGLModelStatus(976, this));
        }
        this.reconcile();
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        buffer.append("[Working copy] ");
        super.toStringInfo(0, buffer, info);
    }

    protected void updateTimeStamp(EGLFile original) throws EGLModelException {
        long timeStamp = ((IFile)original.getResource()).getModificationStamp();
        if (timeStamp == -1L) {
            throw new EGLModelException(new EGLModelStatus(995));
        }
        ((EGLFileElementInfo)this.getElementInfo()).fTimestamp = timeStamp;
    }
}

