/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.search;

import java.io.IOException;
import java.util.zip.ZipEntry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.core.internal.model.search.SearchDocument;
import org.eclipse.edt.ide.core.internal.model.search.SearchParticipant;

public class EGLSearchDocument
extends SearchDocument {
    protected byte[] byteContents;
    protected char[] charContents;
    private String zipFilePath;

    public EGLSearchDocument(ZipEntry zipEntry, IPath zipFilePath, byte[] contents, SearchParticipant participant) {
        super(zipFilePath + "|" + zipEntry.getName(), participant);
        this.byteContents = contents;
        this.zipFilePath = zipFilePath.toOSString();
    }

    protected EGLSearchDocument(String documentPath, SearchParticipant participant) {
        super(documentPath, participant);
    }

    @Override
    public byte[] getByteContent() {
        return this.byteContents;
    }

    @Override
    public char[] getCharContent() {
        return this.charContents;
    }

    @Override
    public String getEncoding() {
        return null;
    }

    @Override
    public String getName() {
        return this.getPath();
    }

    @Override
    public String getStringContent() throws IOException {
        return new String(this.getCharContent());
    }

    @Override
    public String getType() {
        return "eglxml";
    }
}

