/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.core.CoreIDEPluginStrings;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.EDTRuntimeContainer;
import org.eclipse.edt.ide.core.internal.utils.Util;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.osgi.util.NLS;

public class EclipseUtilities {
    private EclipseUtilities() {
    }

    public static boolean shouldWriteFileInEclipse(String outputFolder) {
        return !new Path(outputFolder).isAbsolute();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IContainer getOutputContainer(String outputFolder, IFile eglFile, String relativeFilePath) throws CoreException {
        void var3_8;
        Object var3_3 = null;
        Path outputFolderPath = new Path(EclipseUtilities.convertFromInternalPath(outputFolder));
        int lastSlash = relativeFilePath.lastIndexOf(47);
        if (outputFolderPath.isAbsolute()) {
            Path path = outputFolderPath;
            if (lastSlash != -1) {
                path = path.append(relativeFilePath.substring(0, lastSlash));
            }
            if (path.segmentCount() > 1) {
                IFolder iFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
                if (iFolder.getProject().isAccessible()) return var3_8;
                throw new CoreException((IStatus)new Status(4, EDTCoreIDEPlugin.PLUGIN_ID, NLS.bind((String)CoreIDEPluginStrings.ProjectNotAccessible, (Object)iFolder.getProject().getName())));
            }
            if (path.segmentCount() != 1) throw new CoreException((IStatus)new Status(4, EDTCoreIDEPlugin.PLUGIN_ID, NLS.bind((String)CoreIDEPluginStrings.CouldNotGetOutputFolder, (Object)outputFolderPath)));
            IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
            if (iProject.isAccessible()) return var3_8;
            throw new CoreException((IStatus)new Status(4, EDTCoreIDEPlugin.PLUGIN_ID, NLS.bind((String)CoreIDEPluginStrings.ProjectNotAccessible, (Object)iProject.getName())));
        }
        if (lastSlash == -1) {
            IProject iProject = outputFolderPath.segmentCount() == 0 ? eglFile.getProject() : eglFile.getProject().getFolder((IPath)outputFolderPath);
            return var3_8;
        } else {
            IFolder iFolder = eglFile.getProject().getFolder(outputFolderPath.append(relativeFilePath.substring(0, lastSlash)));
        }
        return var3_8;
    }

    public static IPath getOutputFilePath(String outputFolder, IFile eglFile, String relativeFilePath) {
        int lastSlash = relativeFilePath.lastIndexOf(47);
        String fileName = lastSlash == -1 ? relativeFilePath : relativeFilePath.substring(lastSlash + 1);
        return new Path(fileName);
    }

    public static IFile writeFileInEclipse(Part part, String outputFolder, IFile eglFile, String contentsToWrite, String relativeFilePath) throws CoreException {
        IPath filePath = EclipseUtilities.getOutputFilePath(outputFolder, eglFile, relativeFilePath);
        IContainer container = EclipseUtilities.getOutputContainer(outputFolder, eglFile, relativeFilePath);
        EclipseUtilities.writeFileInEclipse(container, filePath, EclipseUtilities.getInputStream(eglFile, contentsToWrite), true);
        return container.getFile(filePath);
    }

    public static void writeFileInEclipse(IContainer outputContainer, IPath fileName, InputStream dataStream, boolean createFoldersIfNecessary) throws CoreException {
        try {
            IFile outputFile;
            if (createFoldersIfNecessary && outputContainer instanceof IFolder) {
                EclipseUtilities.createFolder((IFolder)outputContainer);
            }
            if ((outputFile = outputContainer.getFile(fileName)).exists()) {
                outputFile.setContents(dataStream, true, false, null);
            } else {
                outputFile.create(dataStream, 1, null);
            }
        }
        catch (Throwable throwable) {
            if (dataStream != null) {
                try {
                    dataStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (dataStream != null) {
            try {
                dataStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void createFolder(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                EclipseUtilities.createFolder((IFolder)parent);
            }
            folder.create(true, true, null);
            folder.setDerived(true, null);
        }
    }

    public static InputStream getInputStream(IFile sourceFile, String data) {
        if (sourceFile != null) {
            try {
                String encoding = sourceFile.getCharset();
                if (encoding != null) {
                    try {
                        return new ByteArrayInputStream(data.getBytes(encoding));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
            }
            catch (CoreException coreException) {}
        }
        return new ByteArrayInputStream(data.getBytes());
    }

    public static void addToJavaBuildPathIfNecessary(IProject project, String outputFolder) throws CoreException {
        IJavaProject javaProject;
        if (project.hasNature("org.eclipse.jdt.core.javanature") && (javaProject = JavaCore.create((IProject)project)).exists()) {
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            Path outputFolderPath = new Path(EclipseUtilities.convertFromInternalPath(outputFolder));
            boolean needToAdd = true;
            Path fullPath = outputFolderPath.isAbsolute() ? outputFolderPath : (outputFolderPath.segmentCount() == 0 ? project.getFullPath() : project.getFolder((IPath)outputFolderPath).getFullPath());
            int i = 0;
            while (i < entries.length) {
                IPath nextPath;
                if (entries[i].getEntryKind() == 3 && ((nextPath = entries[i].getPath()).isPrefixOf((IPath)fullPath) || fullPath.isPrefixOf(nextPath))) {
                    needToAdd = false;
                    break;
                }
                ++i;
            }
            if (needToAdd) {
                IClasspathEntry[] newEntries = new IClasspathEntry[entries.length + 1];
                System.arraycopy(entries, 0, newEntries, 0, entries.length);
                newEntries[newEntries.length - 1] = JavaCore.newSourceEntry((IPath)fullPath);
                javaProject.setRawClasspath(newEntries, null);
            }
        }
    }

    public static String convertFromInternalPath(String path) {
        if (path.startsWith("W/")) {
            return path.substring(1);
        }
        if (path.startsWith("P/")) {
            return path.substring(2);
        }
        return path;
    }

    public static String convertToInternalPath(String path) {
        if (path.startsWith("/")) {
            return "W" + path;
        }
        return "P/" + path;
    }

    public static void addRuntimesToProject(IProject project, EDTRuntimeContainer[] runtimes) {
        if (runtimes == null || runtimes.length == 0) {
            return;
        }
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IClasspathEntry[] classpath = javaProject.getRawClasspath();
                ArrayList<IClasspathEntry> additions = new ArrayList<IClasspathEntry>();
                int i = 0;
                while (i < runtimes.length) {
                    IPath path = runtimes[i].getPath();
                    boolean found = false;
                    int j = 0;
                    while (j < classpath.length) {
                        if (classpath[j].getEntryKind() == 5 && classpath[j].getPath().equals((Object)path)) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        additions.add(JavaCore.newContainerEntry((IPath)path));
                    }
                    ++i;
                }
                if (additions.size() > 0) {
                    IClasspathEntry[] newEntries = new IClasspathEntry[classpath.length + additions.size()];
                    System.arraycopy(classpath, 0, newEntries, 0, classpath.length);
                    int i2 = 0;
                    while (i2 < additions.size()) {
                        newEntries[classpath.length + i2] = (IClasspathEntry)additions.get(i2);
                        ++i2;
                    }
                    javaProject.setRawClasspath(newEntries, null);
                }
            }
        }
        catch (CoreException e) {
            EDTCoreIDEPlugin.log(e);
        }
    }

    public static void addSMAPBuilder(IProject project) {
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                ICommand[] commands;
                String builderID = "org.eclipse.edt.debug.core.smapBuilder";
                IProjectDescription description = project.getDescription();
                ICommand smapCommand = null;
                ICommand[] iCommandArray = commands = description.getBuildSpec();
                int n = commands.length;
                int n2 = 0;
                while (n2 < n) {
                    Object attr;
                    ICommand command = iCommandArray[n2];
                    if (command.getBuilderName().equals(builderID)) {
                        smapCommand = command;
                        break;
                    }
                    if ("org.eclipse.ui.externaltools.ExternalToolBuilder".equals(command.getBuilderName()) && (attr = command.getArguments().get("LaunchConfigHandle")) instanceof String && ((String)attr).contains(builderID)) {
                        smapCommand = command;
                        break;
                    }
                    ++n2;
                }
                if (smapCommand == null) {
                    smapCommand = description.newCommand();
                    smapCommand.setBuilderName(builderID);
                    ICommand[] newCommands = new ICommand[commands.length + 1];
                    System.arraycopy(commands, 0, newCommands, 0, commands.length);
                    newCommands[commands.length] = smapCommand;
                    description.setBuildSpec(newCommands);
                    project.setDescription(description, null);
                }
            }
        }
        catch (CoreException e) {
            EDTCoreIDEPlugin.log(e);
        }
    }

    public static boolean isWebProject(IProject project) {
        return JavaEEProjectUtilities.isDynamicWebProject((IProject)project);
    }

    public static String getJavaSourceFolderName(IProject project) {
        String folderName = null;
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IClasspathEntry[] entries = javaProject.getRawClasspath();
                int i = 0;
                while (i < entries.length) {
                    IClasspathEntry entry = entries[i];
                    if (entry.getEntryKind() == 3) {
                        IPath path = entry.getPath().removeFirstSegments(1);
                        return path.toString();
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {}
        return folderName;
    }

    public static List<String> getDependentDescriptors(IProject project) throws Exception {
        List eglProjectPath = Util.getEGLProjectPath(project);
        final ArrayList<String> egldds = new ArrayList<String>();
        for (IEGLProject eglProject : eglProjectPath) {
            IProject dependentPro = eglProject.getProject();
            final IPath outputPath = eglProject.getOutputLocation();
            dependentPro.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource.getFullPath().equals((Object)outputPath)) {
                        return false;
                    }
                    if (resource instanceof IFile && "egldd".equals(resource.getFileExtension())) {
                        try {
                            egldds.add(resource.getFullPath().toString());
                        }
                        catch (Exception exception) {}
                        return false;
                    }
                    return true;
                }
            });
        }
        return egldds;
    }
}

