/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.codegen.java;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.EClassifier;
import org.eclipse.edt.mof.EDataType;
import org.eclipse.edt.mof.EField;
import org.eclipse.edt.mof.EFunction;
import org.eclipse.edt.mof.EGenericType;
import org.eclipse.edt.mof.EMember;
import org.eclipse.edt.mof.EParameter;
import org.eclipse.edt.mof.EType;
import org.eclipse.edt.mof.ETypedElement;
import org.eclipse.edt.mof.MofFactory;

public class GenUtils {
    private static MofFactory azure = MofFactory.INSTANCE;

    public static EClassifier[] getReferencedTypes(EClass eClass) {
        Set<EClassifier> set = GenUtils.getReferencedTypesSet(eClass);
        return set.toArray(new EClassifier[set.size()]);
    }

    public static Set<EClassifier> getReferencedTypesSet(EClass eClass) {
        HashSet<EClassifier> set = new HashSet<EClassifier>();
        set.addAll(eClass.getSuperTypes());
        for (EField field : eClass.getEFields()) {
            GenUtils.collectReferencedTypes(field, set);
        }
        for (EFunction func : eClass.getEFunctions()) {
            GenUtils.collectReferencedTypes(func, set);
            for (EParameter parm : func.getEParameters()) {
                GenUtils.collectReferencedTypes(parm, set);
            }
        }
        return set;
    }

    private static void collectReferencedTypes(ETypedElement element, Set<EClassifier> set) {
        if (element.getEType() != null) {
            set.add(element.getEType().getEClassifier());
        }
        if (element.getEType() instanceof EGenericType) {
            for (EType arg : ((EGenericType)element.getEType()).getETypeArguments()) {
                set.add(arg.getEClassifier());
            }
        }
    }

    public static List<EClassifier> getImportTypes(EClass eClass, boolean forImpl) {
        ArrayList<EClassifier> list = new ArrayList<EClassifier>();
        if (forImpl) {
            list.add(eClass);
        }
        for (EClassifier type : GenUtils.getReferencedTypesSet(eClass)) {
            if (!GenUtils.needsImport(type)) continue;
            if (type.getPackageName().equals(eClass.getPackageName())) {
                if (forImpl && type != eClass) {
                    list.add(type);
                    continue;
                }
                if (!(type instanceof EDataType)) continue;
                list.add(type);
                continue;
            }
            list.add(type);
        }
        return list;
    }

    public static boolean needsImport(EClassifier type) {
        if (type instanceof EDataType) {
            return GenUtils.needsImport((EDataType)type);
        }
        return GenUtils.needsImport((EClass)type);
    }

    public static boolean needsImport(EClassifier importType, EClass referencingClass) {
        EClass superType = GenUtils.getSuperType(referencingClass);
        return GenUtils.needsImport(importType) && superType == null ? true : !superType.getPackageName().equalsIgnoreCase(importType.getPackageName());
    }

    public static boolean needsImport(EDataType type) {
        return !type.getJavaClassName().startsWith("java.lang");
    }

    public static boolean needsImport(EClass eClass) {
        return eClass != null;
    }

    public static EClass getSuperType(EClass eClass) {
        if (eClass.getSuperTypes().isEmpty()) {
            return null;
        }
        return eClass.getSuperTypes().get(0);
    }

    public static String getterName(EField field) {
        if (field.getEType() == azure.getEBooleanEDataType()) {
            return field.getName();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("get");
        buffer.append(field.getName().substring(0, 1).toUpperCase());
        buffer.append(field.getName().substring(1));
        return buffer.toString();
    }

    public static String setterName(EField field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("set");
        buffer.append(field.getName().substring(0, 1).toUpperCase());
        buffer.append(field.getName().substring(1));
        return buffer.toString();
    }

    public static String getTypeSignature(EMember mbr) {
        return GenUtils.getTypeSignature(mbr.getEType());
    }

    public static String getTypeSignature(EType type) {
        if (type == null) {
            return "void";
        }
        EClassifier classifier = type.getEClassifier();
        String typeSignature = GenUtils.getTypeSignature(classifier);
        if (type instanceof EGenericType) {
            typeSignature = String.valueOf(typeSignature) + "<";
            for (EType arg : ((EGenericType)type).getETypeArguments()) {
                typeSignature = String.valueOf(typeSignature) + GenUtils.getTypeSignature(arg);
            }
            typeSignature = String.valueOf(typeSignature) + ">";
        }
        return typeSignature;
    }

    public static String getTypeSignature(EClassifier type) {
        if (type == azure.getEStringEDataType()) {
            return "java.lang.String";
        }
        if (type == azure.getEBooleanEDataType()) {
            return "java.lang.Boolean";
        }
        if (type == azure.getEIntEDataType()) {
            return "java.lang.Integer";
        }
        if (type == azure.getEListEDataType()) {
            return "java.util.List";
        }
        return type.getETypeSignature();
    }

    public static String getTypeName(EMember mbr) {
        return GenUtils.getTypeName(mbr.getEType());
    }

    public static String getTypeName(EType type) {
        if (type == null) {
            return "void";
        }
        EClassifier classifier = type.getEClassifier();
        String typeSignature = GenUtils.getTypeName(classifier);
        if (type instanceof EGenericType) {
            typeSignature = String.valueOf(typeSignature) + "<";
            for (EType arg : ((EGenericType)type).getETypeArguments()) {
                typeSignature = String.valueOf(typeSignature) + GenUtils.getTypeName(arg);
            }
            typeSignature = String.valueOf(typeSignature) + ">";
        }
        return typeSignature;
    }

    public static String getTypeName(EClassifier type) {
        if (type == azure.getEStringEDataType()) {
            return "String";
        }
        if (type == azure.getEBooleanEDataType()) {
            return "Boolean";
        }
        if (type == azure.getEIntEDataType()) {
            return "Integer";
        }
        if (type == azure.getEListEDataType()) {
            return "List";
        }
        return type.getName();
    }
}

