/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.EClassifier;
import org.eclipse.edt.mof.EDataType;
import org.eclipse.edt.mof.EEnumLiteral;
import org.eclipse.edt.mof.EField;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.EVisitor;
import org.eclipse.edt.mof.MofSerializable;
import org.eclipse.edt.mof.impl.AbstractVisitor;
import org.eclipse.edt.mof.impl.EClassImpl;
import org.eclipse.edt.mof.impl.EFieldImpl;
import org.eclipse.edt.mof.impl.NullableSlot;
import org.eclipse.edt.mof.impl.Slot;
import org.eclipse.edt.mof.serialization.ProxyEObject;
import org.eclipse.edt.mof.utils.EList;

public class InternalEObject
implements Cloneable {
    protected Slot[] slots;

    Object internalGet(EField field) {
        int index = this.calculateIndex(field);
        if (this.slots[index] == null) {
            this.slots[index] = field.isNullable() ? new NullableSlot() : new Slot();
        }
        return this.slots[index].get();
    }

    void internalSet(EField field, Object value) {
        int index = this.calculateIndex(field);
        if (this.slots[index] == null) {
            this.slots[index] = field.isNullable() ? new NullableSlot() : new Slot();
        }
        this.slotSet(index, value);
    }

    Object internalGet(String name) {
        EField field = this.internalEType().getEField(name);
        if (field != null) {
            return this.internalGet(field);
        }
        throw new IllegalArgumentException("No such field named: " + name + " in EClass " + this.internalEType().getETypeSignature());
    }

    void internalSet(String name, Object value) {
        EField field = this.internalEType().getEField(name);
        if (field == null) {
            throw new IllegalArgumentException("No such field named: " + name + " in EClass " + this.internalEType().getETypeSignature());
        }
        this.internalSet(field, value);
    }

    Object internalGet(Integer index) {
        EField field = this.internalEType().getEFields().get(index);
        return this.internalGet(field);
    }

    void internalSet(Integer index, Object value) {
        if (index >= this.internalEType().getEFields().size()) {
            throw new IllegalArgumentException("No field at index: " + index);
        }
        EField field = this.internalEType().getEFields().get(index);
        this.internalSet(field, value);
    }

    boolean internalIsNull(EField field) {
        int i = this.calculateIndex(field);
        return this.slots[i].isNull();
    }

    EClass internalEType() {
        return (EClass)this.slots[0].value;
    }

    void init(EClassImpl eClass) {
        if (this.getSlots() == null) {
            this.setSlots(new Slot[eClass.getTotalSlots()]);
        }
        for (EField field : eClass.getEFields()) {
            if (field.getEType() == null) continue;
            EClassifier type = field.getEType().getEClassifier();
            if (field.getInitialValue() != null) {
                this.slotSet(field, field.getInitialValue());
                continue;
            }
            if (!(type instanceof EDataType) || field.isNullable()) continue;
            Object defaultValue = ((EDataType)type).getDefaultValue();
            this.slotSet(field, defaultValue);
        }
        if (!eClass.getSuperTypes().isEmpty()) {
            this.init((EClassImpl)eClass.getSuperTypes().get(0));
        }
        this.slotSet(0, (Object)eClass);
    }

    public int calculateIndex(EField field) {
        Integer I = ((EFieldImpl)field).slotIndex;
        if (I == null) {
            EClassImpl superType;
            EClass type = (EClass)field.getDeclarer();
            int i = type.getEFields().indexOf(field);
            if (type instanceof EClass && (superType = (EClassImpl)(type.getSuperTypes().isEmpty() ? null : type.getSuperTypes().get(0))) != null) {
                i += superType.getTotalSlots();
            }
            ((EFieldImpl)field).slotIndex = i;
            return i;
        }
        return I;
    }

    public Object slotGet(int i) {
        if (this.slots[i] == null) {
            this.slots[i] = new Slot();
        }
        return this.slots[i].get();
    }

    public void slotSet(int i, Object value) {
        if (this.slots[i] == null) {
            this.slots[i] = new Slot();
        }
        this.slots[i].set(value);
        if (value instanceof ProxyEObject) {
            ((ProxyEObject)value).registerReference(this.slots, i);
        }
    }

    public void slotSet(EField field, Object value) {
        int i = this.calculateIndex(field);
        if (this.slots[i] == null) {
            this.slots[i] = field.isNullable() ? new NullableSlot() : new Slot();
        }
        this.slots[i].set(value);
    }

    public Slot[] getSlots() {
        return this.slots;
    }

    public void setSlots(Slot[] slots) {
        this.slots = slots;
    }

    public void accept(EVisitor visitor) {
        boolean visitChildren = ((AbstractVisitor)visitor).primVisit(this);
        if (visitChildren) {
            this.visitChildren(visitor);
        }
        ((AbstractVisitor)visitor).primEndVisit(this);
    }

    public void visitChildren(EVisitor visitor) {
        int i = -1;
        boolean isTracking = visitor.isTrackingParent();
        if (visitor.isTrackingParent()) {
            visitor.pushParent((EObject)((Object)this));
        }
        Slot[] slotArray = this.slots;
        int n = this.slots.length;
        int n2 = 0;
        while (n2 < n) {
            Slot slot = slotArray[n2];
            if (++i != 0 && slot != null && slot.value != null) {
                if (slot.value instanceof EObject && slot.value != this) {
                    if (isTracking) {
                        visitor.pushSlotIndex(i);
                    }
                    ((EObject)slot.value).accept(visitor);
                    if (isTracking) {
                        visitor.popSlotIndex();
                    }
                } else if (slot.value instanceof List) {
                    if (isTracking) {
                        visitor.pushParent(slot.value);
                    }
                    int j = 0;
                    for (Object obj : (List)slot.value) {
                        if (obj != null && obj instanceof EObject && obj != this) {
                            if (isTracking) {
                                visitor.pushSlotIndex(j);
                            }
                            ((EObject)obj).accept(visitor);
                            if (isTracking) {
                                visitor.popSlotIndex();
                            }
                        }
                        ++j;
                    }
                    if (isTracking) {
                        visitor.popParent();
                    }
                }
            }
            ++n2;
        }
        if (visitor.isTrackingParent()) {
            visitor.popParent();
        }
    }

    private boolean isValidToSet(EField field, Object value) {
        if (value == null) {
            return true;
        }
        boolean isValid = false;
        EClassifier type = field.getEType().getEClassifier();
        isValid = value instanceof EEnumLiteral ? ((EEnumLiteral)value).getDeclarer().equals(type) : (value instanceof EObject ? ((EObject)value).getEClass().isInstance((EObject)value) : (value instanceof List ? ((EDataType)type).getJavaClassName().equals("java.util.List") : ((EDataType)type).getJavaClassName().equals(value.getClass().getName()) || ((EDataType)type).getJavaClassName().equals("java.lang.Object")));
        return isValid;
    }

    public Object clone() {
        Cloner.cloneStart(this);
        InternalEObject obj = Cloner.clone(this);
        Cloner.cloneFinished();
        return obj;
    }

    public static Object cloneIfNeeded(Object value) {
        if (value instanceof MofSerializable) {
            InternalEObject hasClone = Cloner.alreadyCloned.get(value);
            if (hasClone != null) {
                return hasClone;
            }
            return value;
        }
        if (value instanceof EObject) {
            return ((EObject)value).clone();
        }
        if (value instanceof EList) {
            return ((EList)value).clone();
        }
        return value;
    }

    private InternalEObject primClone(InternalEObject cloned) {
        cloned.slots = new Slot[this.slots.length];
        int i = 0;
        while (i < this.slots.length) {
            cloned.slots[i] = this.slots[i] == null ? new Slot() : (Slot)this.slots[i].clone();
            Object value = this.slotGet(i);
            cloned.slots[i].set(InternalEObject.cloneIfNeeded(value));
            ++i;
        }
        return cloned;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.slots == null) {
            buffer.append("Invalid EObject - no slots allocated");
            return buffer.toString();
        }
        buffer.append(this.toStringHeader());
        buffer.append("\n\t");
        EClass type = this.internalEType();
        if (type == null) {
            buffer.append("Invalid EObject - no EClass specified");
        } else {
            int i = 0;
            while (i < this.slots.length) {
                if (type.getEField(i) != null) {
                    buffer.append(type.getEField(i).getName());
                } else {
                    buffer.append("Error - null Field");
                }
                buffer.append(" -> ");
                Object value = this.slotGet(i);
                if (value instanceof EObject) {
                    buffer.append(((EObject)value).toStringHeader());
                } else {
                    buffer.append(value == null ? "null" : value.toString());
                }
                buffer.append("\n\t");
                ++i;
            }
        }
        return buffer.toString();
    }

    public String toStringHeader() {
        return "Instance of: " + this.internalEType().getETypeSignature();
    }

    private static class Cloner {
        static Map<InternalEObject, InternalEObject> alreadyCloned = null;
        static Stack<InternalEObject> cloneStack = new Stack();

        private Cloner() {
        }

        static InternalEObject clone(InternalEObject obj) {
            InternalEObject cloned;
            if (alreadyCloned == null) {
                alreadyCloned = new HashMap<InternalEObject, InternalEObject>();
            }
            if ((cloned = alreadyCloned.get(obj)) == null) {
                cloned = (InternalEObject)((Object)obj.internalEType().newInstance(false));
                alreadyCloned.put(obj, cloned);
                obj.primClone(cloned);
            }
            return cloned;
        }

        static void cloneFinished() {
            cloneStack.pop();
            if (cloneStack.isEmpty()) {
                alreadyCloned = null;
            }
        }

        static void cloneStart(InternalEObject obj) {
            cloneStack.push(obj);
        }
    }
}

