/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.serialization;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.serialization.AbstractObjectStore;
import org.eclipse.edt.mof.serialization.CachingObjectStore;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.Deserializer;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.IZipFileEntryManager;

public class ZipFileObjectStore
extends AbstractObjectStore
implements CachingObjectStore {
    public static final String MOFBIN = ".mofbin";
    public static final String MOFXML = ".mofxml";
    File zipFile;
    String fileExtension;
    IZipFileEntryManager entryManager;
    Map<String, EObject> cache = new HashMap<String, EObject>();

    public ZipFileObjectStore(File zipFile, IEnvironment env) {
        super(env);
        this.zipFile = zipFile;
    }

    public ZipFileObjectStore(File root, IEnvironment env, String storageFormat) {
        super(env, storageFormat);
        this.zipFile = root;
        this.fileExtension = storageFormat == "XML" ? MOFXML : MOFBIN;
    }

    public ZipFileObjectStore(File root, IEnvironment env, String storageFormat, String fileExtension, IZipFileEntryManager manager) {
        super(env, storageFormat);
        this.zipFile = root;
        this.fileExtension = fileExtension;
        this.entryManager = manager;
    }

    public ZipFileObjectStore(File root, IEnvironment env, String storageFormat, String fileExtension, String keyScheme, IZipFileEntryManager manager) {
        super(env, storageFormat, keyScheme);
        this.zipFile = root;
        this.fileExtension = fileExtension;
        this.entryManager = manager;
    }

    @Override
    public Deserializer createDeserializer(String typeSignature) {
        if (!this.containsKey(typeSignature)) {
            return null;
        }
        String path = String.valueOf(typeSignature.replace('.', '/')) + this.getFileExtension();
        Deserializer deserializer = null;
        try {
            InputStream is = this.getInputStream(path);
            if (is != null) {
                deserializer = this.factory.createDeserializer(is, this.env);
            }
            return deserializer;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private InputStream getInputStream(String name) throws IOException {
        if (this.zipFile.exists()) {
            ZipFile zip = new ZipFile(this.zipFile);
            ZipEntry entry = this.isCaseSensitive() ? zip.getEntry(name) : zip.getEntry(name.toUpperCase().toLowerCase());
            if (entry == null) {
                zip.close();
                return null;
            }
            return zip.getInputStream(entry);
        }
        return null;
    }

    private boolean isCaseSensitive() {
        return this.getFileExtension() == MOFBIN || this.getFileExtension() == MOFXML;
    }

    @Override
    public void store(String typeSignature, Object obj) {
    }

    @Override
    public void primRemove(String key) {
        String normKey = key.toUpperCase().toLowerCase();
        this.cache.remove(normKey);
    }

    @Override
    public boolean containsKey(String key) {
        key = this.removeSchemeFromKey(key);
        String path = String.valueOf(key.replace('.', '/')) + this.getFileExtension();
        return this.entryManager.hasEntry(path);
    }

    public String getFileExtension() {
        if (this.fileExtension == null) {
            this.fileExtension = this.storageFormat.equals("BINARY") ? MOFBIN : MOFXML;
        }
        return this.fileExtension;
    }

    @Override
    public EObject get(String key) throws DeserializationException {
        String normKey = this.removeSchemeFromKey(key).toUpperCase().toLowerCase();
        EObject value = this.cache.get(normKey);
        if (value == null) {
            value = super.get(key);
            this.cache.put(normKey, value);
        }
        return value;
    }

    @Override
    public EObject getFromCache(String key) {
        String normKey = this.removeSchemeFromKey(key).toUpperCase().toLowerCase();
        return this.cache.get(normKey);
    }

    @Override
    public void addToCache(String key, EObject object) {
        String normKey = this.removeSchemeFromKey(key).toUpperCase().toLowerCase();
        this.cache.put(normKey, object);
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }

    @Override
    public List<String> getAllKeysFromPkg(String pkg, boolean includeSubPkgs) {
        return this.entryManager.getAllKeysFromPkg(pkg, includeSubPkgs);
    }
}

