/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.egl.templates;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.eclipse.edt.gen.egl.Context;
import org.eclipse.edt.gen.egl.templates.CommonUtilities;
import org.eclipse.edt.gen.egl.templates.EglTemplate;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.LogicAndDataPart;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.MofObjectNotFoundException;

public class FieldTemplate
extends EglTemplate {
    public void genName(Field field, Context ctx, Member member) {
        member.setName(CommonUtilities.getValidEGLName(field.getName()));
    }

    public void genField(Field field, Context ctx, Class<?> clazz, LogicAndDataPart part) throws MofObjectNotFoundException, DeserializationException {
        boolean isJavaProperty = FieldTemplate.isJavaProperty(field, clazz);
        if (isJavaProperty || Modifier.isPublic(field.getModifiers())) {
            Annotation annotation;
            org.eclipse.edt.mof.egl.Field eField = ctx.getFactory().createField();
            eField.setContainer((Container)part);
            part.getFields().add(eField);
            ctx.invoke("genName", (Object)field, new Object[]{ctx, eField});
            if (Modifier.isStatic(field.getModifiers())) {
                eField.setIsStatic(Boolean.valueOf(Modifier.isStatic(field.getModifiers())));
            }
            ctx.invoke("genType", (Object)field.getGenericType(), new Object[]{ctx, eField});
            if (isJavaProperty && (annotation = CommonUtilities.getAnnotation(ctx, "egl:eglx.lang.Property")) != null) {
                eField.addAnnotation(annotation);
            }
            if (!eField.getName().equals(field.getName()) && (annotation = CommonUtilities.getAnnotation(ctx, "egl:eglx.lang.ExternalName")) != null) {
                annotation.setValue((Object)field.getName());
                eField.addAnnotation(annotation);
            }
            ctx.invoke("genAnnotations", (Object)field, new Object[]{ctx, eField});
        }
    }

    public void genAnnotations(Field field, Context ctx, Member member) {
        java.lang.annotation.Annotation[] annotationArray = field.getDeclaredAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            java.lang.annotation.Annotation annotation = annotationArray[n2];
            ctx.invoke("genAnnotation", (Object)annotation, new Object[]{ctx, member});
            ++n2;
        }
    }

    public static boolean isJavaProperty(Field field, Class<?> parent) {
        return CommonUtilities.getSetter(field.getName(), field.getType(), parent) != null && CommonUtilities.getGetter(field.getName(), field.getType(), parent) != null;
    }
}

