/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.egl.templates;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.eclipse.edt.gen.egl.Context;
import org.eclipse.edt.gen.egl.templates.CommonUtilities;
import org.eclipse.edt.gen.egl.templates.EglTemplate;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.LogicAndDataPart;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.MofObjectNotFoundException;

public class MethodTemplate
extends EglTemplate {
    public void genName(Method method, Context ctx, Function eFunction) {
        eFunction.setName(CommonUtilities.getValidEGLName(method.getName()));
    }

    public void genFunctionParameters(Method method, Context ctx, FunctionMember functionMember) {
        int idx = 0;
        Type[] typeArray = method.getGenericParameterTypes();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            ctx.invoke("genFunctionParameter", (Object)method, new Object[]{ctx, functionMember, idx, type});
            ++idx;
            ++n2;
        }
    }

    public void genFunction(Method method, Context ctx, Class<?> clazz, LogicAndDataPart part) throws MofObjectNotFoundException, DeserializationException {
        if (Modifier.isPublic(method.getModifiers()) && !MethodTemplate.isJavaProperty(method, clazz)) {
            Annotation annotation;
            Function eFunction = ctx.getFactory().createFunction();
            eFunction.setContainer((Container)part);
            eFunction.setName(CommonUtilities.getValidEGLName(method.getName()));
            part.getFunctions().add(eFunction);
            eFunction.setIsStatic(Boolean.valueOf(Modifier.isStatic(method.getModifiers())));
            ctx.invoke("genName", (Object)method, new Object[]{ctx, eFunction});
            ctx.invoke("genFunctionParameters", (Object)method, new Object[]{ctx, eFunction});
            if (!Void.TYPE.equals(method.getGenericReturnType())) {
                ctx.invoke("genType", (Object)method.getGenericReturnType(), new Object[]{ctx, eFunction});
            }
            if (!eFunction.getName().equals(method.getName()) && (annotation = CommonUtilities.getAnnotation(ctx, "egl:eglx.lang.ExternalName")) != null) {
                annotation.setValue((Object)method.getName());
                eFunction.addAnnotation(annotation);
            }
            ctx.invoke("genAnnotations", (Object)method, new Object[]{ctx, eFunction});
        }
    }

    public void genAnnotations(Method method, Context ctx, Member eFunction) {
        java.lang.annotation.Annotation[] annotationArray = method.getDeclaredAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            java.lang.annotation.Annotation annotation = annotationArray[n2];
            ctx.invoke("genAnnotation", (Object)annotation, new Object[]{ctx, eFunction});
            ++n2;
        }
    }

    public java.lang.annotation.Annotation getAnnotation(Method method, Context ctx, Integer argIdx, Class<?> annotationClass) {
        if (method.getParameterAnnotations() != null && method.getParameterAnnotations()[argIdx] != null) {
            java.lang.annotation.Annotation[] annotationArray = method.getParameterAnnotations()[argIdx];
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                java.lang.annotation.Annotation annotation = annotationArray[n2];
                if (annotationClass.equals(annotation.getClass())) {
                    return annotation;
                }
                ++n2;
            }
        }
        return null;
    }

    public static boolean isJavaProperty(Method method, Class<?> parent) {
        if (method.getName() != null && method.getName().startsWith("is") && (method.getParameterTypes() == null || method.getParameterTypes().length == 0)) {
            String fieldName = method.getName().substring(2);
            return CommonUtilities.getSetter(fieldName, method.getGenericReturnType(), parent) != null;
        }
        if (method.getName() != null && method.getName().startsWith("get") && (method.getParameterTypes() == null || method.getParameterTypes().length == 0)) {
            String fieldName = method.getName().substring(3);
            return CommonUtilities.getSetter(fieldName, method.getGenericReturnType(), parent) != null;
        }
        if (method.getName() != null && method.getName().startsWith("set") && method.getParameterTypes() != null && method.getParameterTypes().length == 1 && Void.TYPE.equals(method.getGenericReturnType())) {
            String fieldName = method.getName().substring(3);
            return CommonUtilities.getGetter(fieldName, method.getParameterTypes()[0], parent) != null;
        }
        return false;
    }
}

