/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.compiler.gen;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.compiler.ICompiler;
import org.eclipse.edt.gen.CommandParameter;
import org.eclipse.edt.gen.Generator;
import org.eclipse.edt.gen.generator.java.EGL2Java;
import org.eclipse.edt.ide.compiler.gen.GenerationReport;
import org.eclipse.edt.ide.core.EDTRuntimeContainer;
import org.eclipse.edt.ide.core.IGenerator;
import org.eclipse.edt.ide.core.utils.EclipseUtilities;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.utils.LoadPartException;

public class EclipseEGL2Java
extends EGL2Java {
    private final IFile eglFile;
    private final Part part;
    private final IGenerator generatorProvider;

    public EclipseEGL2Java(IFile eglFile, Part part, IGenerator generator) {
        this.eglFile = eglFile;
        this.part = part;
        this.generatorProvider = generator;
    }

    protected List<Part> loadEGLParts(ICompiler compiler) throws LoadPartException {
        ArrayList<Part> parts = new ArrayList<Part>();
        parts.add(this.part);
        return parts;
    }

    protected void writeFile(Part part, Generator generator) throws Exception {
        String outputFolder = (String)((CommandParameter)this.getParameterMapping().get("output")).getValue();
        if (EclipseUtilities.shouldWriteFileInEclipse((String)outputFolder)) {
            IFile outputFile = EclipseUtilities.writeFileInEclipse((Part)part, (String)outputFolder, (IFile)this.eglFile, (String)generator.getResult().toString(), (String)generator.getRelativeFileName(part));
            GenerationReport.writeFile(part, this.eglFile, generator);
            IProject targetProject = outputFile.getProject();
            EclipseUtilities.addToJavaBuildPathIfNecessary((IProject)targetProject, (String)outputFolder);
            EclipseUtilities.addRuntimesToProject((IProject)targetProject, (EDTRuntimeContainer[])this.generatorProvider.getRuntimeContainers());
            EclipseUtilities.addSMAPBuilder((IProject)targetProject);
            generator.processFile(outputFile.getFullPath().toString());
        } else {
            super.writeFile(part, generator);
        }
    }
}

