/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.jtopen.pages;

import org.eclipse.edt.ide.jtopen.Messages;
import org.eclipse.edt.ide.ui.internal.deployment.Binding;
import org.eclipse.edt.ide.ui.internal.deployment.Parameters;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDRootHelper;
import org.eclipse.edt.ide.ui.internal.deployment.ui.WebBindingDetailPage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class IBMiConnectionBindingDetailPage
extends WebBindingDetailPage {
    private Binding fIBMiBinding;
    private Text fSystemField;
    private Text fUserIdField;
    private Text fPasswordField;
    private Text fLibraryField;

    public IBMiConnectionBindingDetailPage() {
        this.nColumnSpan = 3;
    }

    protected Composite createDetailSection(Composite parent, FormToolkit toolkit, int sectionStyle, int columnSpan) {
        return this.createSection(parent, toolkit, Messages.IBMiBindingDetailSecTitle, Messages.IBMiBindingDetailSecDescp, sectionStyle, columnSpan);
    }

    protected void createDetailControls(FormToolkit toolkit, Composite parent) {
        this.createSystemControl(toolkit, parent);
        this.createUserIdControl(toolkit, parent);
        this.createPasswordControl(toolkit, parent);
        this.createLibraryControl(toolkit, parent);
    }

    private void createSystemControl(FormToolkit toolkit, Composite parent) {
        toolkit.createLabel(parent, Messages.LabelSystem);
        this.fSystemField = this.createTextControl(toolkit, parent);
        this.fSystemField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EGLDDRootHelper.addOrUpdateParameter((Parameters)EGLDDRootHelper.getParameters((Binding)IBMiConnectionBindingDetailPage.this.fIBMiBinding), (String)"system", (String)IBMiConnectionBindingDetailPage.this.fSystemField.getText());
            }
        });
    }

    private void createUserIdControl(FormToolkit toolkit, Composite parent) {
        toolkit.createLabel(parent, Messages.LabelUserId);
        this.fUserIdField = this.createTextControl(toolkit, parent);
        this.fUserIdField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EGLDDRootHelper.addOrUpdateParameter((Parameters)EGLDDRootHelper.getParameters((Binding)IBMiConnectionBindingDetailPage.this.fIBMiBinding), (String)"userid", (String)IBMiConnectionBindingDetailPage.this.fUserIdField.getText());
            }
        });
    }

    private void createPasswordControl(FormToolkit toolkit, Composite parent) {
        toolkit.createLabel(parent, Messages.LabelPassword);
        this.fPasswordField = this.createTextControl(toolkit, parent);
        this.fPasswordField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EGLDDRootHelper.addOrUpdateParameter((Parameters)EGLDDRootHelper.getParameters((Binding)IBMiConnectionBindingDetailPage.this.fIBMiBinding), (String)"password", (String)IBMiConnectionBindingDetailPage.this.fPasswordField.getText());
            }
        });
    }

    private void createLibraryControl(FormToolkit toolkit, Composite parent) {
        toolkit.createLabel(parent, Messages.LabelLibrary);
        this.fLibraryField = this.createTextControl(toolkit, parent);
        this.fLibraryField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EGLDDRootHelper.addOrUpdateParameter((Parameters)EGLDDRootHelper.getParameters((Binding)IBMiConnectionBindingDetailPage.this.fIBMiBinding), (String)"library", (String)IBMiConnectionBindingDetailPage.this.fLibraryField.getText());
            }
        });
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        this.fIBMiBinding = ssel.size() == 1 ? (Binding)ssel.getFirstElement() : null;
        this.update();
    }

    protected void update() {
        String library;
        String password;
        String userid;
        this.fNameText.setText(this.fIBMiBinding.getName() == null ? "" : this.fIBMiBinding.getName());
        String system = EGLDDRootHelper.getParameterValue((Parameters)EGLDDRootHelper.getParameters((Binding)this.fIBMiBinding), (String)"system");
        if (system != null) {
            this.fSystemField.setText(system);
        }
        if ((userid = EGLDDRootHelper.getParameterValue((Parameters)EGLDDRootHelper.getParameters((Binding)this.fIBMiBinding), (String)"userid")) != null) {
            this.fUserIdField.setText(userid);
        }
        if ((password = EGLDDRootHelper.getParameterValue((Parameters)EGLDDRootHelper.getParameters((Binding)this.fIBMiBinding), (String)"password")) != null) {
            this.fPasswordField.setText(password);
        }
        if ((library = EGLDDRootHelper.getParameterValue((Parameters)EGLDDRootHelper.getParameters((Binding)this.fIBMiBinding), (String)"library")) != null) {
            this.fLibraryField.setText(library);
        }
    }

    protected void HandleNameChanged() {
        this.fIBMiBinding.setName(this.fNameText.getText());
        this.refreshMainTableViewer();
    }
}

