/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.jtopen.wizards;

import org.eclipse.edt.ide.jtopen.Messages;
import org.eclipse.edt.ide.jtopen.wizards.IBMiBindingConnectionConfiguration;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.deployment.ui.SOAMessages;
import org.eclipse.edt.ide.ui.internal.wizards.EGLDDBindingWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPartWizard;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.edt.ide.ui.wizards.BindingBaseConfiguration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class IBMiBindingWizardPage
extends EGLDDBindingWizardPage {
    private StringDialogField fSystemField;
    private StringDialogField fUserIdField;
    private StringDialogField fPasswordField;
    private StringDialogField fLibraryField;

    public IBMiBindingWizardPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.TitleAddIBMiBinding);
        this.setDescription(Messages.DescAddIBMiBinding);
        this.nColumns = 4;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IUIHelpConstants.MODULE_RESTBINDING);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = this.nColumns;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createComponentNameControl(composite, Messages.LabelIBMiBindingName, this.getEGLDDBindingConfiguration().getConfiguration("edt.binding.ibmiconnection"));
        this.createSystemControl(composite);
        this.createUserIdControl(composite);
        this.createPasswordControl(composite);
        this.createLibraryControl(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)parent);
        this.determinePageCompletion();
    }

    private IBMiBindingConnectionConfiguration getConfiguration() {
        return (IBMiBindingConnectionConfiguration)((EGLPartWizard)this.getWizard()).getConfiguration(this.getName());
    }

    private void createSystemControl(Composite composite) {
        Label spacer = new Label(composite, 64);
        GridData gd = new GridData(768);
        gd.horizontalSpan = this.nColumns;
        spacer.setLayoutData((Object)gd);
        Label desc = new Label(composite, 64);
        desc.setText(SOAMessages.BaseURIDesc);
        gd = new GridData(768);
        gd.horizontalSpan = this.nColumns;
        gd.widthHint = 550;
        desc.setLayoutData((Object)gd);
        spacer = new Label(composite, 64);
        gd = new GridData(768);
        gd.horizontalSpan = this.nColumns;
        spacer.setLayoutData((Object)gd);
        this.fSystemField = new StringDialogField();
        this.fSystemField.setLabelText(Messages.LabelSystem);
        this.fSystemField.setText(this.getConfiguration().getSystem());
        this.createStringDialogField(composite, this.fSystemField, new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                if (field == IBMiBindingWizardPage.this.fSystemField) {
                    IBMiBindingWizardPage.this.HandleSystemFieldChanged();
                }
            }
        });
    }

    protected void HandleSystemFieldChanged() {
        this.getConfiguration().setSystem(this.fSystemField.getText());
        this.determinePageCompletion();
    }

    private void createUserIdControl(Composite composite) {
        Label spacer = new Label(composite, 64);
        GridData gd = new GridData(768);
        gd.horizontalSpan = this.nColumns;
        spacer.setLayoutData((Object)gd);
        this.fUserIdField = new StringDialogField();
        this.fUserIdField.setLabelText(Messages.LabelUserId);
        this.fUserIdField.setText(this.getConfiguration().getUserId());
        this.createStringDialogField(composite, this.fUserIdField, new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                if (field == IBMiBindingWizardPage.this.fUserIdField) {
                    IBMiBindingWizardPage.this.HandleUserIdChanged();
                }
            }
        });
    }

    protected void HandleUserIdChanged() {
        this.getConfiguration().setUserId(this.fUserIdField.getText());
        this.determinePageCompletion();
    }

    private void createPasswordControl(Composite composite) {
        Label spacer = new Label(composite, 64);
        GridData gd = new GridData(768);
        gd.horizontalSpan = this.nColumns;
        spacer.setLayoutData((Object)gd);
        this.fPasswordField = new StringDialogField();
        this.fPasswordField.setLabelText(Messages.LabelPassword);
        this.fPasswordField.setText(this.getConfiguration().getPassword());
        this.createStringDialogField(composite, this.fPasswordField, new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                if (field == IBMiBindingWizardPage.this.fPasswordField) {
                    IBMiBindingWizardPage.this.HandlePasswordChanged();
                }
            }
        });
    }

    protected void HandlePasswordChanged() {
        this.getConfiguration().setPassword(this.fPasswordField.getText());
        this.determinePageCompletion();
    }

    private void createLibraryControl(Composite composite) {
        Label spacer = new Label(composite, 64);
        GridData gd = new GridData(768);
        gd.horizontalSpan = this.nColumns;
        spacer.setLayoutData((Object)gd);
        this.fLibraryField = new StringDialogField();
        this.fLibraryField.setLabelText(Messages.LabelLibrary);
        this.fLibraryField.setText(this.getConfiguration().getUserId());
        this.createStringDialogField(composite, this.fLibraryField, new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                if (field == IBMiBindingWizardPage.this.fLibraryField) {
                    IBMiBindingWizardPage.this.HandleLibraryChanged();
                }
            }
        });
    }

    protected void HandleLibraryChanged() {
        this.getConfiguration().setLibrary(this.fLibraryField.getText());
        this.determinePageCompletion();
    }

    protected void createComponentNameControl(Composite parent, String labelName, final BindingBaseConfiguration esConfig) {
        this.fNameField = new StringDialogField();
        this.fNameField.setLabelText(labelName);
        this.fNameField.setText(esConfig.getBindingName());
        this.createStringDialogField(parent, this.fNameField, new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                if (field == IBMiBindingWizardPage.this.fNameField) {
                    IBMiBindingWizardPage.this.HandleBindingNameChanged(esConfig);
                }
            }
        });
    }

    protected void HandleBindingNameChanged(BindingBaseConfiguration esConfig) {
        super.HandleBindingNameChanged(esConfig);
        this.determinePageCompletion();
    }

    protected boolean determinePageCompletion() {
        this.setErrorMessage(null);
        boolean result = true;
        String name = this.fNameField.getText();
        String systemName = this.fSystemField.getText();
        if (name == null || name.trim().length() == 0) {
            this.setErrorMessage(Messages.IBMiBindingBlankError);
            result = false;
        } else if (systemName == null || systemName.trim().length() == 0) {
            this.setErrorMessage(Messages.IBMiBindingSystemBlankError);
            result = false;
        }
        this.setPageComplete(result);
        return result;
    }
}

